/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vntemplate;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VirtualNetworkTemplate
extends PoolElement {
    private static final String METHOD_PREFIX = "vntemplate.";
    private static final String ALLOCATE = "vntemplate.allocate";
    private static final String INFO = "vntemplate.info";
    private static final String DELETE = "vntemplate.delete";
    private static final String UPDATE = "vntemplate.update";
    private static final String CHOWN = "vntemplate.chown";
    private static final String CHMOD = "vntemplate.chmod";
    private static final String INSTANTIATE = "vntemplate.instantiate";
    private static final String CLONE = "vntemplate.clone";
    private static final String RENAME = "vntemplate.rename";
    private static final String LOCK = "vntemplate.lock";
    private static final String UNLOCK = "vntemplate.unlock";

    public VirtualNetworkTemplate(int n, Client client) {
        super(n, client);
    }

    protected VirtualNetworkTemplate(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n, false);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n, false);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return VirtualNetworkTemplate.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return client.call(CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        int n2 = (Integer.parseInt(string.substring(0, 1)) & 4) != 0 ? 1 : 0;
        int n3 = (Integer.parseInt(string.substring(0, 1)) & 2) != 0 ? 1 : 0;
        int n4 = (Integer.parseInt(string.substring(0, 1)) & 1) != 0 ? 1 : 0;
        int n5 = (Integer.parseInt(string.substring(1, 2)) & 4) != 0 ? 1 : 0;
        int n6 = (Integer.parseInt(string.substring(1, 2)) & 2) != 0 ? 1 : 0;
        int n7 = (Integer.parseInt(string.substring(1, 2)) & 1) != 0 ? 1 : 0;
        int n8 = (Integer.parseInt(string.substring(2, 3)) & 4) != 0 ? 1 : 0;
        int n9 = (Integer.parseInt(string.substring(2, 3)) & 2) != 0 ? 1 : 0;
        int n10 = (Integer.parseInt(string.substring(2, 3)) & 1) != 0 ? 1 : 0;
        return VirtualNetworkTemplate.chmod(client, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VirtualNetworkTemplate.chmod(client, n, Integer.toString(n2));
    }

    public static OneResponse instantiate(Client client, int n, String string, String string2) {
        return client.call(INSTANTIATE, n, string, string2);
    }

    public static OneResponse clone(Client client, int n, String string) {
        return VirtualNetworkTemplate.clone(client, n, string);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public OneResponse info() {
        return this.info(false);
    }

    public OneResponse info(boolean bl) {
        OneResponse oneResponse = VirtualNetworkTemplate.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return VirtualNetworkTemplate.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VirtualNetworkTemplate.update(this.client, this.id, string, bl);
    }

    public OneResponse publish(boolean bl) {
        return VirtualNetworkTemplate.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n, int n2) {
        return VirtualNetworkTemplate.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.client.call(CHMOD, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VirtualNetworkTemplate.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VirtualNetworkTemplate.chmod(this.client, this.id, n);
    }

    public OneResponse instantiate(String string, String string2) {
        return VirtualNetworkTemplate.instantiate(this.client, this.id, string, string2);
    }

    public OneResponse instantiate(String string) {
        return VirtualNetworkTemplate.instantiate(this.client, this.id, string, "");
    }

    public OneResponse instantiate() {
        return VirtualNetworkTemplate.instantiate(this.client, this.id, "", "");
    }

    public OneResponse clone(String string) {
        return VirtualNetworkTemplate.clone(this.client, this.id, string);
    }

    public OneResponse rename(String string) {
        return VirtualNetworkTemplate.rename(this.client, this.id, string);
    }

    public OneResponse lock(int n) {
        return VirtualNetworkTemplate.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return VirtualNetworkTemplate.unlock(this.client, this.id);
    }
}

