/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.vrouter;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class VirtualRouter
extends PoolElement {
    private static final String METHOD_PREFIX = "vrouter.";
    private static final String ALLOCATE = "vrouter.allocate";
    private static final String INSTANTIATE = "vrouter.instantiate";
    private static final String INFO = "vrouter.info";
    private static final String UPDATE = "vrouter.update";
    private static final String DELETE = "vrouter.delete";
    private static final String CHOWN = "vrouter.chown";
    private static final String CHMOD = "vrouter.chmod";
    private static final String RENAME = "vrouter.rename";
    private static final String ATTACHNIC = "vrouter.attachnic";
    private static final String DETACHNIC = "vrouter.detachnic";
    private static final String LOCK = "vrouter.lock";
    private static final String UNLOCK = "vrouter.unlock";

    public VirtualRouter(int n, Client client) {
        super(n, client);
    }

    protected VirtualRouter(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse info(Client client, int n, boolean bl) {
        return client.call(INFO, n, bl);
    }

    public static OneResponse instantiate(Client client, int n, int n2, int n3, String string, boolean bl, String string2) {
        return client.call(INSTANTIATE, n, n2, n3, string, bl, string2);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return VirtualRouter.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return VirtualRouter.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return VirtualRouter.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return VirtualRouter.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public static OneResponse nicAttach(Client client, int n, String string) {
        return client.call(ATTACHNIC, n, string);
    }

    public static OneResponse nicDetach(Client client, int n, int n2) {
        return client.call(DETACHNIC, n, n2);
    }

    public static OneResponse lock(Client client, int n, int n2) {
        return client.call(LOCK, n, n2);
    }

    public static OneResponse unlock(Client client, int n) {
        return client.call(UNLOCK, n);
    }

    public OneResponse info() {
        OneResponse oneResponse = VirtualRouter.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return VirtualRouter.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return VirtualRouter.update(this.client, this.id, string, bl);
    }

    public OneResponse publish(boolean bl) {
        return VirtualRouter.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n, int n2) {
        return VirtualRouter.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return VirtualRouter.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return VirtualRouter.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return VirtualRouter.chmod(this.client, this.id, n);
    }

    public OneResponse instantiate(int n, int n2, String string, boolean bl, String string2) {
        return VirtualRouter.instantiate(this.client, this.id, n, n2, string, bl, string2);
    }

    public OneResponse instantiate(int n, int n2) {
        return VirtualRouter.instantiate(this.client, this.id, n, n2, "", false, "");
    }

    public OneResponse rename(String string) {
        return VirtualRouter.rename(this.client, this.id, string);
    }

    public OneResponse nicAttach(String string) {
        return VirtualRouter.nicAttach(this.client, this.id, string);
    }

    public OneResponse nicDetach(int n) {
        return VirtualRouter.nicDetach(this.client, this.id, n);
    }

    public OneResponse lock(int n) {
        return VirtualRouter.lock(this.client, this.id, n);
    }

    public OneResponse unlock() {
        return VirtualRouter.unlock(this.client, this.id);
    }
}

