/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */
import { ReactElement } from 'react'
import PropTypes from 'prop-types'
import { Box, Accordion, AccordionDetails } from '@mui/material'

import { DriverAPI } from '@FeaturesModule'

/**
 * Renders connection tab.
 *
 * @param {object} props - Props
 * @param {string} props.id - Driver name
 * @returns {ReactElement} JSON tab
 */
const ConnectionTab = ({ id: name }) => {
  const { data: driver = {} } = DriverAPI.useGetDriverQuery({
    name: name?.toLowerCase(),
  })

  return (
    <Accordion variant="outlined" expanded>
      <AccordionDetails>
        <Box component="pre">
          <Box
            component="code"
            sx={{ whiteSpace: 'break-spaces', wordBreak: 'break-all' }}
          >
            {JSON.stringify(driver?.connection ?? {}, null, 2)}
          </Box>
        </Box>
      </AccordionDetails>
    </Accordion>
  )
}

ConnectionTab.propTypes = {
  tabProps: PropTypes.object,
  id: PropTypes.string,
}

ConnectionTab.displayName = 'ConnectionTab'

export default ConnectionTab
