/// <reference types="node" />
import { EventEmitter } from "events";
import * as zmq from ".";
declare const shortOptions: {
    _fd: number;
    _ioevents: number;
    _receiveMore: number;
    _subscribe: number;
    _unsubscribe: number;
    affinity: number;
    backlog: number;
    identity: number;
    linger: number;
    rate: number;
    rcvbuf: number;
    last_endpoint: number;
    reconnect_ivl: number;
    recovery_ivl: number;
    sndbuf: number;
    mechanism: number;
    plain_server: number;
    plain_username: number;
    plain_password: number;
    curve_server: number;
    curve_publickey: number;
    curve_secretkey: number;
    curve_serverkey: number;
    zap_domain: number;
    heartbeat_ivl: number;
    heartbeat_ttl: number;
    heartbeat_timeout: number;
    connect_timeout: number;
};
export declare class Context {
    static setMaxThreads(value: number): void;
    static getMaxThreads(): number;
    static setMaxSockets(value: number): void;
    static getMaxSockets(): number;
    constructor();
}
/**
 * All the socket types available in the compatibility layer
 */
export type SocketType = "pair" | "req" | "rep" | "pub" | "sub" | "dealer" | "xreq" | "router" | "xrep" | "pull" | "push" | "xpub" | "xsub" | "stream";
type Callback = (err?: Error) => void;
export declare class Socket extends EventEmitter {
    [key: string]: any;
    type: SocketType;
    private _msg;
    private _recvQueue;
    private _sendQueue;
    private _paused;
    private _socket;
    private _count;
    constructor(type: SocketType);
    _recv(): Promise<void>;
    _send(): Promise<void>;
    bind(address: string, cb?: Callback): this;
    unbind(address: string, cb?: Callback): this;
    connect(address: string): this;
    disconnect(address: string): this;
    send(message: zmq.MessageLike[] | zmq.MessageLike, givenFlags?: number | undefined | null, cb?: Callback | undefined): this;
    read(): void;
    bindSync(address: string): void;
    unbindSync(address: string): void;
    pause(): void;
    resume(): void;
    close(): this;
    readonly closed: boolean;
    monitor(interval?: number, num?: number): this;
    unmonitor(): this;
    subscribe(filter: string): this;
    unsubscribe(filter: string): this;
    setsockopt(givenOption: number | keyof typeof shortOptions, value: any): this;
    getsockopt(givenOption: number | keyof typeof shortOptions): string | number | boolean | null;
}
/**
 * Create a new socket.
 *
 * @param type Type of socket to create.
 * @param options Options for the socket.
 *
 * @returns A new socket.
 *
 * @includeExample examples/v5-compat/index.js
 */
export declare function createSocket(type: SocketType, options?: {
    [key: string]: any;
}): Socket;
export declare function curveKeypair(): {
    public: string;
    secret: string;
};
export declare function proxy(frontend: Socket, backend: Socket, capture?: Socket): void;
export declare const version: string;
export { createSocket as socket, shortOptions as options };
export * from "./compat/long-options";
export * from "./compat/types";
export * from "./compat/poll-states";
export * from "./compat/send-options";
export * from "./compat/capabilities";
export * from "./compat/socket-states";
