import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import PropTypes from 'prop-types';
import clsx from 'clsx';
import Skeleton from '@mui/material/Skeleton';
import { styled, useThemeProps } from '@mui/material/styles';
import { unstable_composeClasses as composeClasses, generateUtilityClass, generateUtilityClasses } from '@mui/base';
import { DAY_SIZE, DAY_MARGIN } from '../internal/pickers/constants/dimensions';
import { jsx as _jsx } from "react/jsx-runtime";
export function getCalendarPickerSkeletonUtilityClass(slot) {
  return generateUtilityClass('MuiCalendarPickerSkeleton', slot);
}
export var calendarPickerSkeletonClasses = generateUtilityClasses('MuiCalendarPickerSkeleton', ['root', 'week', 'daySkeleton']);

var useUtilityClasses = function useUtilityClasses(ownerState) {
  var classes = ownerState.classes;
  var slots = {
    root: ['root'],
    week: ['week'],
    daySkeleton: ['daySkeleton']
  };
  return composeClasses(slots, getCalendarPickerSkeletonUtilityClass, classes);
};

var CalendarPickerSkeletonRoot = styled('div', {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Root',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.root;
  }
})({
  alignSelf: 'start'
});
var CalendarPickerSkeletonWeek = styled('div', {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Week',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.week;
  }
})({
  margin: "".concat(DAY_MARGIN, "px 0"),
  display: 'flex',
  justifyContent: 'center'
});
var CalendarPickerSkeletonDay = styled(Skeleton, {
  name: 'MuiCalendarPickerSkeleton',
  slot: 'Day',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.daySkeleton;
  }
})(function (_ref) {
  var ownerState = _ref.ownerState;
  return _extends({
    margin: "0 ".concat(DAY_MARGIN, "px")
  }, ownerState.day === 0 && {
    visibility: 'hidden'
  });
});
process.env.NODE_ENV !== "production" ? CalendarPickerSkeletonDay.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit TypeScript types and run "yarn proptypes"  |
  // ----------------------------------------------------------------------

  /**
   * Optional children to infer width and height from.
   */
  children: PropTypes.node,

  /**
   * @ignore
   */
  ownerState: PropTypes.object
} : void 0;
var monthMap = [[0, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 1, 1, 1], [1, 1, 1, 1, 0, 0, 0]];
/**
 *
 * Demos:
 *
 * - [Date Picker](https://mui.com/components/date-picker/)
 *
 * API:
 *
 * - [CalendarPickerSkeleton API](https://mui.com/api/calendar-picker-skeleton/)
 */

function CalendarPickerSkeleton(props) {
  var _useThemeProps = useThemeProps({
    props: props,
    name: 'MuiCalendarPickerSkeleton'
  }),
      className = _useThemeProps.className,
      other = _objectWithoutProperties(_useThemeProps, ["className"]);

  var classes = useUtilityClasses(props);
  return /*#__PURE__*/_jsx(CalendarPickerSkeletonRoot, _extends({
    className: clsx(classes.root, className)
  }, other, {
    children: monthMap.map(function (week, index) {
      return /*#__PURE__*/_jsx(CalendarPickerSkeletonWeek, {
        className: classes.week,
        children: week.map(function (day, index2) {
          return /*#__PURE__*/_jsx(CalendarPickerSkeletonDay, {
            variant: "circular",
            width: DAY_SIZE,
            height: DAY_SIZE,
            className: classes.daySkeleton,
            ownerState: {
              day: day
            }
          }, index2);
        })
      }, index);
    })
  }));
}
/**
 *
 * Demos:
 *
 * - [Date Picker](https://mui.com/components/date-picker/)
 *
 * API:
 *
 * - [CalendarPickerSkeleton API](https://mui.com/api/calendar-picker-skeleton/)
 */


process.env.NODE_ENV !== "production" ? CalendarPickerSkeleton.propTypes
/* remove-proptypes */
= {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // |     To update them edit TypeScript types and run "yarn proptypes"  |
  // ----------------------------------------------------------------------

  /**
   * @ignore
   */
  children: PropTypes.node,

  /**
   * Override or extend the styles applied to the component.
   */
  classes: PropTypes.object,

  /**
   * The system prop that allows defining system overrides as well as additional CSS styles.
   */
  sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
} : void 0;
export default CalendarPickerSkeleton;