import type { BuildCommandOptions, BuildConfiguration, BuildConfigurations, Options } from "./config-types.d";
export declare function parseBuildConfigs(opts: Options, configFile: Partial<BuildConfigurations>): Promise<BuildConfiguration[] | null>;
/**
 * Add the missing fields to the given build configuration.
 */
export declare function getBuildConfig(buildOptions: BuildCommandOptions, config: Partial<BuildConfiguration>, globalConfig: Partial<BuildConfigurations>): Promise<BuildConfiguration>;
export declare function detectCrossCompilation(globalConfig: Partial<BuildConfigurations>, config: Partial<BuildConfiguration>): boolean;
export declare function parseBuiltInConfigs(configName: string): {
    os: NodeJS.Platform | undefined;
    arch: NodeJS.Architecture | undefined;
    runtime: "node" | "electron" | "iojs" | undefined;
    buildType: "Release" | "Debug" | "RelWithDebInfo" | "MinSizeRel" | undefined;
    cross: boolean;
};
export declare function getConfigFile(packageJsonPath: string): Promise<Partial<BuildConfigurations>>;
