# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Break Versioning](https://www.taoensso.com/break-versioning).

## [Unreleased]

### Added

### Changed

### Deprecated

### Removed

### Fixed

### Security

[Unreleased]: https://github.com/dry-rb/dry-schema/compare/v1.15.0...main

## [1.15.0] - 2026-01-09

### Changed

- Set mimimum Ruby version to 3.2 (@timriley)
- Support UUID v6, v7 and v8 predicates (`:uuid_v6?`, `:uuid_v7?` and `:uuid_v8?`). (@illiatdesdindes in #509)
- Support `size?`, `format?`, `true?` and `false?` predicates when generating JSON schemas. (@cramt in #499)
- Allow symbols to be given for `top_namespace` setting. (@unused in #491)

### Fixed

- Support intersection types (created with `&` operator) in schema definitions. (@baweaver in #496)

  Now works without errors:
  ```ruby
  intersection_type =
    Types::Hash.schema(a: Types::String) & 
    (Types::Hash.schema(b: Types::String) | Types::Hash.schema(c: Types::String))
  
  schema = Dry::Schema.Params do
    required(:body).value(intersection_type)
  end
  
  schema.call(body: {a: "test", b: "value"}) # passes
  schema.call(body: {b: "value"})            # fails - missing 'a'
  ```
- JSON schema generation now properly handles `Dry::Struct` instances wrapped in constructors. (@baweaver in #497)

  Before, when generating JSON schema for a schema containing a Dry::Struct wrapped in a constructor (e.g., `Address.constructor(&:itself)`), all struct properties were omitted from the generated schema, returning only `{type: "object"}` instead of the full schema with properties.

  Before/after:
  ```ruby
  # Before: Missing struct properties
  Dry::Schema.Params do 
    required(:address).value(Address.constructor(&:itself)) 
  end.json_schema
  # => {:properties=>{:address=>{:type=>"object"}}} # No properties
  
  # After: Full struct schema included  
  Dry::Schema.Params do 
    required(:address).value(Address.constructor(&:itself)) 
  end.json_schema
  # => {:properties=>{:address=>{:type=>"object", :properties=>{:street=>{...}}}}} # Properties included
  ```
- JSON schema generation now correctly uses `minItems`/`maxItems` for array size predicates instead of `minLength`/`maxLength`. (@baweaver in #498)
- Show correct index in errors when validating unexpected keys in arrays. (@katafrakt in #510)
- Support validating nested arrays when using `config.validate_keys = true`. (@misdoro in #508)
- Fix handling of i18n messages from proc/lambda-produced hashes. (@rrothenberger in #493)
- Fix error arising when generating errors when a key is repeated in a nested schema. (@jacob-carlborg in #503)
- Fix method call typo in `Dry::Schema::Trace#respond_to_missing?`. (@flash-gordon in 13ddb51)

[1.15.0]: https://github.com/dry-rb/dry-schema/compare/v1.14.1...v1.15.0

## [1.14.1] - 2025-03-03

### Fixed

- Syntax errors on 3.3.0 (@flash-gordon, see #488)

[1.14.1]: https://github.com/dry-rb/dry-schema/compare/v1.14.0...v1.14.1

## [1.14.0] - 2025-01-06

### Added

- Better support for sets in `excluded_from?` and `included_in?` predicates (via #480) (@flash-gordon)

### Fixed

- Fix info extension for maybe macro (via #484) (@flash-gordon + @santiagodoldan)
- Missing message for :uri? predicate (via #477) (@timjnh)
- JSON schema output for `maybe(:array)` (via #463) (@tomgi)

### Changed

- Set minimum Ruby version to 3.1 (@flash-gordon)
- `KeyValidator` works faster for large schemas (via #461) (@radarek)

[1.14.0]: https://github.com/dry-rb/dry-schema/compare/v1.13.4...v1.14.0

## [1.13.4] - 2024-05-22

### Added

- Default error message for `:uri?` (issue #476 via #477) (@timjnh)

### Fixed

- Fix json-schema type of objects nested under arrays (issue #400 fixed via #462) (@tomgi)

### Changed

- i18n backend is no longer eager-loaded (via 85a9e0b) (@adam12)

[1.13.4]: https://github.com/dry-rb/dry-schema/compare/v1.13.3...v1.13.4

## [1.13.3] - 2023-08-26

### Fixed

- Fix struct extension for nested struct definitions (via #466) (@flash-gordon)

[1.13.3]: https://github.com/dry-rb/dry-schema/compare/v1.13.2...v1.13.3

## [1.13.2] - 2023-05-31

### Fixed

- Fix custom predicates setting (via #460) (@solnic)

[1.13.2]: https://github.com/dry-rb/dry-schema/compare/v1.13.1...v1.13.2

## [1.13.1] - 2023-04-07

### Fixed

- Support sum types of hashes (issue #446 fixed via #457) (@segiddins)

[1.13.1]: https://github.com/dry-rb/dry-schema/compare/v1.13.0...v1.13.1

## [1.13.0] - 2022-11-24

### Fixed

- Change required metadata back to true to fix regressions (issue #438 fixed via 439) (@robhanlon22)
- Compatibility with dry-configurable 1.0.1 (@flash-gordon)
- Warnings about using pattern matching on Ruby 2.7 (issue #441 fixed via #442) (@r7kamura)
- Make message cache fully thread-safe (via #440) (@mensfeld)

[1.13.0]: https://github.com/dry-rb/dry-schema/compare/v1.12.0...v1.13.0

## [1.12.0] - 2022-11-04

### Changed

- This version depends on dry-core 1.0 and dry-configurable 1.0 (@flash-gordon)

[1.12.0]: https://github.com/dry-rb/dry-schema/compare/v1.11.3...v1.12.0

## [1.11.3] - 2022-10-21

### Fixed

- Fixed `array(sum_type)` syntax which was a regression introduced in 1.10.0 (issue #436 fixed via #437) (@solnic)

[1.11.3]: https://github.com/dry-rb/dry-schema/compare/v1.11.2...v1.11.3

## [1.11.2] - 2022-10-16

### Fixed

- Setting up message backends with custom settings should work as before (see dry-rb/dry-validation#717 fixed via #435) (@solnic)

[1.11.2]: https://github.com/dry-rb/dry-schema/compare/v1.11.1...v1.11.2

## [1.11.1] - 2022-10-15

### Changed

- Depend on dry-configurable >= 0.16 - this was needed to play nice with Zeitwerk (@solnic)

[1.11.1]: https://github.com/dry-rb/dry-schema/compare/v1.11.0...v1.11.1

## [1.11.0] - 2022-10-15

### Changed

- Use zeitwerk for auto-loading which speeds up requires (via #427) (@flash-gordon + @solnic)

[1.11.0]: https://github.com/dry-rb/dry-schema/compare/v1.10.6...v1.11.0

## [1.10.6] - 2022-10-01

### Fixed

- Fix issues with rule name when top_namespace and namespace passed (issue #304 fixed via #432) (@RudskikhIvan)

[1.10.6]: https://github.com/dry-rb/dry-schema/compare/v1.10.5...v1.10.6

## [1.10.5] - 2022-09-21

### Fixed

- Key maps no longer include duped keys when using inheritance (issues #428 #372 fixed via #429) (@solnic)
- Key validator and coercer no longer include duped keys when using parent schemas (via #430) (@solnic)

[1.10.5]: https://github.com/dry-rb/dry-schema/compare/v1.10.4...v1.10.5

## [1.10.4] - 2022-09-13

### Fixed

- Once again reverting zeitwerk related changes that were included in 1.10.3 by an accident :( (@solnic)

[1.10.4]: https://github.com/dry-rb/dry-schema/compare/v1.10.3...v1.10.4

## [1.10.3] - 2022-09-10

### Fixed

- Addressed regressions causing issues with handling sum types (see #419 and #423 fixed via #425) (@robhanlon22)

[1.10.3]: https://github.com/dry-rb/dry-schema/compare/v1.10.2...v1.10.3

## [1.10.2] - 2022-08-23

### Fixed

- Fix value coercion for composed schemas (via #421) (@robhanlon22)

[1.10.2]: https://github.com/dry-rb/dry-schema/compare/v1.10.1...v1.10.2

## [1.10.1] - 2022-08-22

### Changed

- Reverted zeitwerk-related changes that were included in 1.10.0 by an accident (@solnic)

[1.10.1]: https://github.com/dry-rb/dry-schema/compare/v1.10.0...v1.10.1

## [1.10.0] - 2022-08-16

### Added

- Allow nested `filled` and `value` macro usage (via #412) (@robhanlon22)
- Support for more complex scenarios when composing schemas (via #420) (@robhanlon22)

### Fixed

- Fix `or` messages for complex schemas (via #413) (@robhanlon22)
- Using `filled` with a constrained constructor type works as expected (via #416) (@robhanlon22)
- Fix types and key maps for composed schemas (via #415) (@robhanlon22)

### Changed

- Freeze message hash (fixes #417 via #418) (@solnic)

[1.10.0]: https://github.com/dry-rb/dry-schema/compare/v1.9.3...v1.10.0

## [1.9.3] - 2022-06-23

### Added

- Support `anyOf` composition in JSON schema output (@robhanlon22)

### Fixed

- Allow composition of multiple ors (issue #307 fixed via #409) (@robhanlon22)

[1.9.3]: https://github.com/dry-rb/dry-schema/compare/v1.9.2...v1.9.3

## [1.9.2] - 2022-05-28

### Fixed

- Fix loose JSON schemas for nested hashes (via #401) (@tomdalling)
- Correct spelling error 'mininum' to 'minimum' in json-schema extension (via #404) (@svenanderzen)

### Changed

- [performance] YAML message backend allocates less strings (via #399) (@casperisfine)

[1.9.2]: https://github.com/dry-rb/dry-schema/compare/v1.9.1...v1.9.2

## [1.9.1] - 2022-02-17

### Fixed

- Namespaced messages no longer crashes in certain scenarios (see dry-rb/dry-validation#692 fixed via #398) (@krekoten)

[1.9.1]: https://github.com/dry-rb/dry-schema/compare/v1.9.0...v1.9.1

## [1.9.0] - 2022-02-15

### Added

- [EXPERIMENTAL] `json_schema` extension which allows you to convert a schema into a JSON schema (via #369) (@ianks)

### Fixed

- Composing schemas no longer crashes in certain scenarios (issue #342 fixed via #366) (@vsuhachev)
- Fix info extension for typed arrays (issue #394 fixed via #397) (@CandyFet)

[1.9.0]: https://github.com/dry-rb/dry-schema/compare/v1.8.0...v1.9.0

## [1.8.0] - 2021-09-12

### Changed

- [internal] Upgraded to new `setting` API provided in dry-configurable 0.13.0 (@timriley in #356)

[1.8.0]: https://github.com/dry-rb/dry-schema/compare/v1.7.1...v1.8.0

## [1.7.1] - 2021-08-29

### Changed

- [internal] Use explicit `#to_h` conversion of Dry::Configurable::Config, to ensure compatibility with upcoming dry-configurable 0.13.0 release (via #371) (@timriley)

[1.7.1]: https://github.com/dry-rb/dry-schema/compare/v1.7.0...v1.7.1

## [1.7.0] - 2021-06-29

This release ships with a bunch of internal refactorings that should improve performance but if you see any unexpected behavior please do report issues.

### Fixed

- Handle arrays of hashes where Array constructor coerces non-Hash input (#351 fixed via #354) (@ojab)
- Run outer schema processor steps before inner ones (issue #350 fixed via #361) (@ojab)
- Fix key validator false negatives on empty collections (see #363) (@Drenmi)
- Prevent error message YAML files from being parsed multiple times (issue #352 via #364) (@alassek)
- Using constructor types should work fine now ie `required(:foo).filled(Types::Params::Integer.constructor(&:succ))` (issue #280 fixed via #365) (@solnic)
- Handle non-Hash to Hash transformation in `before(:key_coercer)` (issue #350 fixed via #362) (@ojab)

### Changed

- [internal] `Dry::Schema::Path` clean up and performance improvements (via #358) (@ojab)
- [internal] simplify and speed up handling of steps in nested schemas (via #360) (@ojab)

[1.7.0]: https://github.com/dry-rb/dry-schema/compare/v1.6.2...v1.7.0

## [1.6.2] - 2021-04-15

### Added

- A default error message for `respond_to?` predicate (@rindek)

### Fixed

- Using `respond_to?` predicate in blocks works now (@rindek)

[1.6.2]: https://github.com/dry-rb/dry-schema/compare/v1.6.1...v1.6.2

## [1.6.1] - 2021-02-02

### Fixed

- Messages#[] handles meta/no meta cases more gracefully and has better interoperability with the I18n backend. This brings MessageCompiler#visit_unexpected_key up to parity with MessageCompiler#visit_predicate. Uses visit_predicate as basis for visit_unexpected_key. (@robhanlon22)

[1.6.1]: https://github.com/dry-rb/dry-schema/compare/v1.6.0...v1.6.1

## [1.6.0] - 2021-01-21

### Fixed

- Using sum types with a i18n backend no longer crashes (issue #328 fixes via #331) (@tylerhunt)

### Changed

- Inferring predicates from class names is deprecated. It's very unlikely your code depends on it,
  however, if it does, you'll get an exception with instructions. (@flash-gordon)

  If you see an exception and don't rely on inferring, just disable it with:

  ```ruby
  Dry::Schema::PredicateInferrer::Compiler.infer_predicate_by_class_name false
  ```

  Otherwise, enable it explicitly:

  ```ruby
  Dry::Schema::PredicateInferrer::Compiler.infer_predicate_by_class_name true
  ```

  See https://github.com/dry-rb/dry-schema/issues/335 for rationale.

[1.6.0]: https://github.com/dry-rb/dry-schema/compare/v1.5.6...v1.6.0

## [1.5.6] - 2020-10-21

### Fixed

- Fixed stack error which was a regression introduced in 1.5.5 (issue #322 fixed via #323) (@flash-gordon)

[1.5.6]: https://github.com/dry-rb/dry-schema/compare/v1.5.5...v1.5.6

## [1.5.5] - 2020-10-08

### Fixed

- Key validation works with messages that have meta-data (issue #310 fixed via #313) (@tadeusz-niemiec)
- Using an external schema along with a key specified as a `:hash` works as expected (issue #296 fixed via #315) (@tadeusz-niemiec + @solnic)
- `Result#error?(path)` works correctly when the path points to an array item (issue #317 fixed via #318) (@solnic)

[1.5.5]: https://github.com/dry-rb/dry-schema/compare/v1.5.4...v1.5.5

## [1.5.4] - 2020-09-03

### Fixed

- Key validation works correctly with a non-nested maybe hashes (issue #311 fixed via #312) (@svobom57)

## [1.5.3] - 2020-08-21

### Fixed

- Key validator works correctly with an array with maybe hash as its member (issue #308 fixed via #309) (@tadeusz-niemiec)

### Changed

- [info extension] small performance improvement in the set visitor (see #305 for more details) (@esparta)

[1.5.3]: https://github.com/dry-rb/dry-schema/compare/v1.5.2...v1.5.3

## [1.5.2] - 2020-06-26

### Fixed

- `Result#{success?,failure?}` work as expected when there are only key validation failures (issue #297 fixed via #298) (@adamransom)

### Changed

- Using `full` option no longer adds a space between the name of a key and the message in case of languages that have no spaces between words (ie Japanese) (issue #161 closed via #292 by @tadeusz-niemiec)

[1.5.2]: https://github.com/dry-rb/dry-schema/compare/v1.5.1...v1.5.2

## [1.5.1] - 2020-05-21

### Fixed

- Negated predicates support the logic operator API now (fixed via #276 by @solnic)
- Fixed circular require warning (issue #279 closed via #282 by @landongrindheim)
- Validating keys against an array with non-hash members no longer crashes (issue #283 fixed via #284 by @beechnut and issue #289 fixed via #288 by @tadeusz-niemiec)

[1.5.1]: https://github.com/dry-rb/dry-schema/compare/v1.5.0...v1.5.1

## [1.5.0] - 2020-03-11

### Added

- Support for complex sum types ie `value([:integer, array[:integer])` (issue #214) (@solnic)
- You can now set global config via `Dry::Schema.config` (issue #205) (@robhanlon22)
- Default error message for `:uuid_v4?` predicate (isssue #230) (@solnic)
- [experimental] you can compose schemas in the DSL using the standard logic operators (issue #231 closed via #245) (@solnic)
- Hash schema type can now be used with proper keys and predicates inferring. Constructor
and default types are explicitly not supported (@flash-gordon)
  ```ruby
  UserType = Dry::Types['hash'].schema(
    name: 'string',
    email: 'string'
  )

  Dry::Schema.define do
    require(:user).hash(UserType)
  end
  ```
- `:struct` extension which allows using dry-struct classes as source for hash schemas. Note that output will still be presented as plain hashes, returning structs from schemas will require more work, it's planned for next versions (@flash-gordon)
- `:info` extension which adds #info method to your schemas which produces a simple hash providing information about keys and types (issue #36 closed via #262) (@solnic)

### Fixed

- `maybe` macro in JSON schemas no longer converts empty strings to `nil`.
This was a bug in dry-types but your code may rely on this behavior. If you still
require this behavior, we recommend using a custom type (see Advanced -> Custom types in the docs) (@flash-gordon)
- YAML message backend no longer crashes when load_paths are empty (@robhanlon22)
- Callbacks can now be inherited from multiple parents (@skryukov)
- Callbacks work with nested schemas (issue #209) (@solnic)
- Custom type is respected when defining nested schemas (issue #174 closed via 263) (@solnic)
- Key map is properly inferred for maybe-hashes (issue #266 fixed via #269) (@solnic)

### Changed

- `:i18n` message backend delegates interpolation and caching to `I18n` (issue #211) (@robhanlon22)
- Raise ArgumentError in DSL if parent DSL configs differ (@robhanlon22)
- (internal) `PredicateInferrer` was removed. `Dry::Types::PredicateInferrer` is a drop-in replacement (@flash-gordon)

[1.5.0]: https://github.com/dry-rb/dry-schema/compare/v1.4.3...v1.5.0

## [1.4.3] - 2020-01-08

### Added

- Pattern matching for `Dry::Schema::Result` objects (@flash-gordon)
  ```ruby
  schema = Dry::Schema::Params { required(:name).filled }
  case schema.('name' => 'John')
  in name:
    name # => 'John'
  end
  ```
  Try it with monads!
- Shortcut for nested schemas in `value` and `maybe` macros (@waiting-for-dev)
  ```ruby
  Dry::Schema.Params do
    required(:address).value(:hash) do
      required(:city).filled
    end
  end
  ```

### Fixed

- Some keyword warnings that slipped into the previous release (@flash-gordon)

[1.4.3]: https://github.com/dry-rb/dry-schema/compare/v1.4.2...v1.4.3

## [1.4.2] - 2019-12-19

### Fixed

- `I18n` messages backend supports procs as text properly (issue #208) (@robhanlon22)
- `I18n` messages backend supports message meta-data (issue #210) (@robhanlon22)
- Fixed keyword warnings from MRI 2.7.0 (@flash-gordon)
- Array with a member works correctly with `maybe` (issue #206) (@solnic)

[1.4.2]: https://github.com/dry-rb/dry-schema/compare/v1.4.1...v1.4.2

## [1.4.1] - 2019-10-08

### Fixed

- Child schemas no longer mutate processing steps of their parent classes (@skryukov)

[1.4.1]: https://github.com/dry-rb/dry-schema/compare/v1.4.0...v1.4.1

## [1.4.0] - 2019-10-08

### Added

- Support for passing multiple parent schemas. They are inherited from left to right (@ianwhite)

  ```ruby
  Dry::Schema.define(parent: [parent_a, parent_b, parent_c]) do
    ...
  end
  ```
- Improved error messages about missing translations (@skryukov)
- [experimental] before/after callbacks for schema steps (@skryukov)

  ```ruby
  Dry::Schema.Params do
    required(:name).value(:string)
    optional(:age).value(:integer)

    before(:value_coercer) do |result|
      result.to_h.compact
    end
  end
  ```

### Fixed

- Added/fixed support for custom optional types (@flash-gordon)

[1.4.0]: https://github.com/dry-rb/dry-schema/compare/v1.3.4...v1.4.0

## [1.3.4] - 2019-09-11

### Fixed

- Fixed regression where using `array?` predicate within a block would crach (issue #186) (@skryukov)

[1.3.4]: https://github.com/dry-rb/dry-schema/compare/v1.3.3...v1.3.4

## [1.3.3] - 2019-08-14

### Fixed

- Reject attempts to build a nested schema for array types built on `Dry::Types::Nominal` (fixed #171) (@flash-gordon)
- Current `I18n.locale` is now properly handled when caching message templates (@flash-gordon)
- Default processor uses strict types by default, which fixes various cases when `maybe` is used with a constructor type (@flash-gordon)
- Namespaced messages no longer causes a crash when used with nested schemas (fixed #176) (@solnic)

[1.3.3]: https://github.com/dry-rb/dry-schema/compare/v1.3.2...v1.3.3

## [1.3.2] - 2019-08-01

### Added

- Support for new predicates: `bytesize?`, `min_bytesize?` and `max_bytesize?` (@bmalinconico)

[1.3.2]: https://github.com/dry-rb/dry-schema/compare/v1.3.1...v1.3.2

## [1.3.1] - 2019-07-08

### Fixed

- `Result#error?` works correctly with nested hashes and arrays (@solnic)
- `:hints` extension no longer causes a crash where base messages are generated too (issue #165) (@solnic)

[1.3.1]: https://github.com/dry-rb/dry-schema/compare/v1.3.0...v1.3.1

## [1.3.0] - 2019-07-06

### Added

- Automatic predicate inferring for constrained types! (@flash-gordon)

  ```ruby
  Types::Name = Types::String.constrained(min_size: 1)

  schema = Dry::Schema.define do
    required(:name).value(Types::Name)
  end

  schema.(name: '').errors.to_h # => { name: ["size cannot be less than 1"] }
  ```
- Support for redefining re-used schemas (issue #43) (@skryukov)

### Fixed

- Type container is passed down to nested schemas (@flash-gordon)

[1.3.0]: https://github.com/dry-rb/dry-schema/compare/v1.2.0...v1.3.0

## [1.2.0] - 2019-06-13

### Added

- Ability to configure your own type container (@Morozzzko)

  ```ruby
  types = Dry::Schema::TypeContainer.new
  types.register(
    'params.trimmed_string',
    Types::String.constructor(&:strip).constructor(&:downcase)
  )

  Dry::Schema.Params do
    config.types = types

    require(:name).value(:trimmed_string)
  end
  ```

### Fixed

- `filled` macro no longer generates incorrect messages for arrays (issue #151) (@solnic)
- `filled` macro works correctly with constructor types (@solnic)
- `filled` works correctly with nested schemas (#149) (@solnic + @timriley)
- Custom array constructors are no longer discredited by `array` macro (@solnic)
- `BigDecimal` type is correctly handled by predicate inference (@solnic)
- Works with latest `dry-logic` which provides the new `respond_to?` predicate (#153) (@flash-gordon)

### Changed

- Fixes related to `filled` restored pre-1.1.0 behavior of `:hints` which are again included (@solnic)
- `filled` no longer uses filter rules to handle empty strings in `Params` (@solnic)

[1.2.0]: https://github.com/dry-rb/dry-schema/compare/v1.1.0...v1.2.0

## [1.1.0] - 2019-05-30

### Added

- `config.messages.default_locale` for setting...default locale (surprise, surprise) (@solnic)
- `Config` exposes `predicates` setting too (@solnic)

### Fixed

- `filled` macro behavior results in `must be filled` error messages when appropriate - see PR #141 for more information (issue #134) (@solnic)
- Filter rules no longer cause keys to be added to input (issue #142) (@solnic)
- Filter rules work now with inheritance (@solnic)
- Inherited type schemas used by coercion are now properly configured as `lax` type (@solnic)
- `Config` is now finalized before instantiating schemas and properly dupped when its inherited (@flash-gordon + @solnic)
- `Config#eql?` works as expected (@solnic)
- Predicates are properly inferred from array with a member type spec, ie `array[:integer]` results in `array? + each(:integer?)` (issue #140) (@solnic)

[1.1.0]: https://github.com/dry-rb/dry-schema/compare/v1.0.3...v1.1.0

## [1.0.3] - 2019-05-21

### Fixed

- `Object#hash` is no longer used to calculate cache keys due to a potential risk of having hash collisions (@solnic)
- Predicate arguments are used again for template cache keys (@solnic)
- `I18n` messages backend no longer evaluates templates twice (@solnic)

[1.0.3]: https://github.com/dry-rb/dry-schema/compare/v1.0.2...v1.0.3

## [1.0.2] - 2019-05-12

### Fixed

- Caching message templates uses restricted set of known keys to calculate cache keys (issue #132) (@solnic)

[1.0.2]: https://github.com/dry-rb/dry-schema/compare/v1.0.1...v1.0.2

## [1.0.1] - 2019-05-08

### Fixed

- Applying `key?` predicate no longer causes recursive calls to `Result#errors` (issue #130) (@solnic)

[1.0.1]: https://github.com/dry-rb/dry-schema/compare/v1.0.0...v1.0.1

## [1.0.0] - 2019-05-03

### Fixed

- Setting `:any` as the type spec no longer crashes (@solnic)
- `Result#error?` handles paths to array elements correctly (@solnic)

### Changed

- [BREAKING] `Result#to_hash` was removed (@solnic)

[1.0.0]: https://github.com/dry-rb/dry-schema/compare/v0.6.0...v1.0.0

## [0.6.0] - 2019-04-24

### Changed

- Dependency on `dry-types` was bumped to `~> 1.0` (@solnic)
- Dependency on `dry-logic` was bumped to `~> 1.0` (@solnic)
- Dependency on `dry-initializer` was bumped to `~> 3.0` (@solnic)

[0.6.0]: https://github.com/dry-rb/dry-schema/compare/v0.5.1...v0.6.0

## [0.5.1] - 2019-04-17

### Fixed

- Key map no longer crashes on unexpected input (issue #118) (@solnic)

[0.5.1]: https://github.com/dry-rb/dry-schema/compare/v0.5.0...v0.5.1

## [0.5.0] - 2019-04-04

### Added

- Support for arbitrary meta-data in messages, ie:

  ```yaml
  en:
    dry_schema:
      errors:
        filled?:
          text: "cannot be blank"
          code: 123
  ```

  Now your error hash will include `{ foo: [{ text: 'cannot be blank', code: 123 }] }` (@solnic + @flash-gordon)
- Support for type specs in `array` macro, ie `required(:tags).array(:integer)` (@solnic)
- Support for type specs in `each` macro, ie `required(:tags).each(:integer)` (@solnic)
- Shortcut for defining an array with hash as its member, ie:

  ```ruby
  Dry::Schema.Params do
    required(:tags).array(:hash) do
      required(:name).filled(:string)
    end
  end
  ```

### Fixed

- Inferring predicates doesn't crash when `Any` type is used (@flash-gordon)
- Inferring type specs when type is already set works correctly (@solnic)

### Changed

- [BREAKING] `:monads` extension wraps entire result objects in `Success` or `Failure` (@flash-gordon)
- When `:hints` are disabled, result AST will not include hint nodes (@solnic)

[0.5.0]: https://github.com/dry-rb/dry-schema/compare/v0.4.0...v0.5.0

## [0.4.0] - 2019-03-26

### Added

- Schemas are now compatible with procs via `#to_proc` (issue #53) (@solnic)
- Support for configuring `top_namespace` for localized messages (@solnic)
- Support for configuring more than one load path for localized messages (@solnic)
- Support for inferring predicates from arbitrary types (issue #101) (@solnic)

### Fixed

- Handling of messages for `optional` keys without value rules works correctly (issue #87) (@solnic)
- Message structure for `optional` keys with an array of hashes no longer duplicates keys (issue #89) (@solnic)
- Inferring `:date_time?` predicate works correctly with `DateTime` types (issue #97) (@solnic)

### Changed

- [BREAKING] Updated to work with `dry-types 0.15.0` (@flash-gordon)
- [BREAKING] `Result#{errors,messages,hints}` returns `MessageSet` object now which is an enumerable coercible to a hash (@solnic)
- [BREAKING] `Messages` backend classes no longer use global configuration (@solnic)
- [BREAKING] Passing a non-symbol key name in the DSL will raise `ArgumentError` (issue #29) (@solnic)
- [BREAKING] Configuration for message backends is now nested under `messages` key with following settings:
  - `messages.backend` - previously `messages`
  - `messages.load_paths` - previously `messages_path`
  - `messages.namespace` - previously `namespace`
  - `messages.top_namespace` - **new setting** see above
- [BREAKING] `Messages::I18n` uses `I18.store_translations` instead of messing with `I18n.load_path` (@solnic)
- Schemas (`Params` and `JSON`) have nicer inspect (@solnic)

[0.4.0]: https://github.com/dry-rb/dry-schema/compare/v0.3.0...v0.4.0

## [0.3.0] - 2018-03-04

### Fixed

- Configuration is properly inherited from a parent schema (@skryukov)
- `Result#error?` returns `true` when a preceding key has errors (@solnic)
- Predicate inferrer no longer chokes on sum, constructor and enum types (@solnic)
- Predicate inferrer infers `:bool?` from boolean types (@solnic)
- Block-based definitions using `array` works correctly (@solnic)
- Using a disjunction with `array` and `hash` produces correct errors when element validation for array failed (@solnic)

### Changed

- Required ruby version was removed from gemspec for people who are stuck on MRI 2.3.x (@solnic)

[0.3.0]: https://github.com/dry-rb/dry-schema/compare/v0.2.0...v0.3.0

## [0.2.0] - 2019-02-26

### Added

- New `hash` macro which prepends `hash?` type-check and allows nested schema definition (@solnic)
- New `array` macro which works like `each` but prepends `array?` type-check (@solnic)

### Fixed

- Rule name translation works correctly with I18n (issue #52) (@solnic)
- Rule name translation works correctly with namespaced messages (both I18n and plain YAML) (issue #57) (@solnic)
- Error messages under namespaces are correctly resolved for overridden names (issue #53) (@solnic)
- Namespaced error messages work correctly when schemas are reused within other schemas (issue #49) (@solnic)
- Child schema can override inherited rules now (issue #66) (@skryukov)
- Hints are correctly generated for disjunction that use type-check predicates (issue #24) (@solnic)
- Hints are correctly generated for nested schemas (issue #26) (@solnic)
- `filled` macro respects inferred type-check predicates and puts them in front (@solnic)
- Value coercion works correctly with re-usable nested schemas (issue #25) (@solnic)

### Changed

- [BREAKING] **Messages are now configured under `dry_schema` namespace by default** (issue #38) (@solnic)
- [BREAKING] Hints are now an optional feature provided by `:hints` extension, to load it do `Dry::Schema.load_extensions(:hints)` (@solnic)
- [BREAKING] Hints generation was improved in general, output of `Result#messages` and `Result#hints` changed in some cases (@solnic)
- [BREAKING] `schema` macro no longer prepends `hash?` check, for this behavior use the new `hash` macro (see #31) (@solnic)
- [BREAKING] Support for MRI < 2.4 was dropped (@solnic)

[0.2.0]: https://github.com/dry-rb/dry-schema/compare/v0.1.1...v0.2.0

## [0.1.1] - 2019-02-17

### Added

- `Result#error?` supports checking nested errors too ie`result.error?('user.address')` (@solnic)

### Fixed

- Fix issues with templates and invalid tokens (issue #27) (@solnic)
- Fix Ruby warnings (@flash-gordon)

[0.1.1]: https://github.com/dry-rb/dry-schema/compare/v0.1.0...v0.1.1

## [0.1.0] - 2019-01-30

Initial release.
