/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */
import { INPUT_TYPES, T } from '@ConstantsModule'
import { Field, arrayToOptions, getValidationFromFields } from '@UtilsModule'
import { ObjectSchema, object, string } from 'yup'

export const ZONE_FIELD_NAME = 'ZONE_ID'

/** @type {Field} Zone Id field */
const ZONE = (zones) => ({
  name: ZONE_FIELD_NAME,
  label: T.Zone,
  type: INPUT_TYPES.AUTOCOMPLETE,
  optionsOnly: true,
  values: arrayToOptions(zones, {
    addEmpty: false,
    getText: (zone) => `Zone ${zone.ID} - ${zone.NAME}`,
    getValue: (zone) => zone.ID,
  }),
  validation: string().default(() => '0'),
  grid: { xs: 12, md: 12 },
})

/**
 * @param {Array[Object]} zones - zone objects
 * @returns {Field[]} Fields
 */
export const FIELDS = (zones = []) => [ZONE(zones)]

/**
 * @param {Array[Object]} zones - zone objects
 * @returns {ObjectSchema} Schema
 */
export const SCHEMA = (zones = []) =>
  object(getValidationFromFields(FIELDS(zones)))
