#!/usr/bin/make -f

export DH_VERBOSE=1

# Handle group assignment: libvirt (Debian) and libvirtd (Ubuntu)
ifeq ($(shell dpkg-vendor --derives-from Ubuntu && echo yes),yes)
	LIB_VIRT_GROUP = libvirt
else
	LIB_VIRT_GROUP = libvirt
endif

# Build arguments
ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
	ARGS_ENTERPRISE = yes
else
	ARGS_ENTERPRISE = no
endif

ifneq (,$(filter opennebula-fireedge, $(shell dh_listpackages)))
	ARGS_FIREEDGE = yes
else
	ARGS_FIREEDGE = no
endif

# distribution specific content
DIR_SUDOERS  = 'debian'
DIR_SERVICES = 'systemd'
DIR_TMPFILES = ''
GEMFILE_LOCK = 'Ubuntu2404'

# https://wiki.debian.org/HardeningWalkthrough#Selecting_security_hardening_options
export DEB_BUILD_MAINT_OPTIONS=hardening=+all

dpkg_buildflags = DEB_LDFLAGS_MAINT_APPEND="-Wl,--as-needed" dpkg-buildflags

# injecting CPPFLAGS to CFLAGS and CXXFLAGS
export CPPFLAGS:=$(shell $(dpkg_buildflags) --get CPPFLAGS)
export CFLAGS:=$(shell $(dpkg_buildflags) --get CFLAGS) $(CPPFLAGS)
export CXXFLAGS:=$(shell $(dpkg_buildflags) --get CXXFLAGS) $(CPPFLAGS)
export LDFLAGS:=$(shell $(dpkg_buildflags) --get LDFLAGS)
export MAKEFLAGS:=-j

%:
	dh $@ --with javahelper,bash-completion,systemd

override_dh_auto_build:
	tar xzvf build_opennebula.tar.gz

	# we take only prebuilt Java OCA + deps
	tar xzvf java-oca-*.tar.gz
	mv java-oca-*/jar/ src/oca/java/

	tar xzvf vendor.tar.gz
	for Z in *.zip; do unzip $Z; done
	mv xmlrpc-client-*.jar xmlrpc-common-*.jar ws-commons-util-*.jar src/oca/java/jar/

	tar xzvf one-deploy.tar.gz

ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
	tar xzvf opennebula-ee-tools-*.tar.gz
endif
ifneq (,$(filter opennebula-rubygems, $(shell dh_listpackages)))
	tar xzvf opennebula-rubygems-*.tar.gz

	cd opennebula-rubygems-* && \
		NOKOGIRI_USE_SYSTEM_LIBRARIES=yes \
		CPATH=/usr/include/libxml2 \
		GEM_PATH=$$PWD/gems-dist/ \
		GEM_HOME=$$PWD/gems-dist/ \
			gem install \
				--local \
				--ignore-dependencies \
				--no-document \
				--conservative \
				--install-dir $$PWD/gems-dist \
				--bindir $$PWD/gems-dist/bin/ \
				$$(cat manifest)

	# drop build artifacts
	rm -rf opennebula-rubygems-*/gems-dist/cache \
		opennebula-rubygems-*/gems-dist/gems/*/ext
endif
ifneq (,$(filter opennebula-guacd, $(shell dh_listpackages)))
	rm guacamole-server-1.4.0.zip
	unzip guacamole-server-*.zip

	cd guacamole-server-* && \
		autoreconf -i && \
		CFLAGS=-Wno-error ./configure \
			--prefix=/usr/share/one/guacd \
			--exec-prefix=/usr/share/one/guacd \
			--with-freerdp-plugin-dir=/usr/share/one/guacd \
			--disable-static \
			--without-pulse && \
		make
endif

ifneq (,$(filter opennebula-fireedge, $(shell dh_listpackages)))
	# build doesn't have set HOME, also we can't write into /etc
	echo 'cache=/tmp'        >> src/fireedge/.npmrc
	echo 'offline=true'      >> src/fireedge/.npmrc
	echo 'zmq_external=true' >> src/fireedge/.npmrc

	mkdir opennebula-fireedge-modules
	tar -xzvf opennebula-fireedge-modules*.tar.gz \
		-C opennebula-fireedge-modules/ \
		--strip-components=1

	# backup original package-lock.json and update dependencies locations
	# from remote https:// to local predownloaded files
	cd src/fireedge && \
		cp package-lock.json package-lock.json.bak && \
		sed -i -e 's/\(resolved": "\)https*:\/\//\1file:..\/..\/opennebula-fireedge-modules\//' package-lock.json
endif

	#XMLRPC_DIR="debian/" debian/build_opennebula.sh
	./build_opennebula.sh \
			systemd=yes \
			gitversion="$(shell cat debian/gitversion)" \
			enterprise="${ARGS_ENTERPRISE}" \
			fireedge="${ARGS_FIREEDGE}"

ifneq (,$(filter opennebula-fireedge, $(shell dh_listpackages)))
	mv -f src/fireedge/package-lock.json.bak src/fireedge/package-lock.json
	unlink src/fireedge/.npmrc
endif

override_dh_auto_install:
ifeq ($(DEB_TARGET_ARCH),amd64)
	DESTDIR=dist ./install.sh
else
ifeq ($(DEB_TARGET_ARCH),arm64)
	DESTDIR=dist ./install.sh -a arm64
else
	echo "ERROR: Unsupported architecture '$(DEB_TARGET_ARCH)'" >&2
	exit 1
endif
endif

# install one-deploy
	mkdir -p dist/usr/share/one/one-deploy
	cp -a one-deploy/* dist/usr/share/one/one-deploy/

ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
	(cd one-ee-tools && \
	DESTDIR=../dist ./install-ee-tools.sh -a /etc/apache2/sites-available -s /etc/systemd/system/apache2.service.d)
	dh_install -p opennebula one-ee-tools/src/onegather/* /usr/bin
	dh_install -p opennebula one-ee-tools/src/onefabric/front-end/onefabric /usr/bin
	dh_install -p opennebula one-ee-tools/src/onefabric/front-end/onefabric_helper.rb /usr/lib/one/ruby/cli/one_helper
endif
ifneq (,$(filter opennebula-guacd, $(shell dh_listpackages)))
	cd guacamole-server-* && \
		make install DESTDIR=$(shell readlink -f dist)

	rm -rf dist/usr/share/one/guacd/include

	dh_install -p opennebula-guacd share/pkgs/services/${DIR_SERVICES}/opennebula-guacd.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-rubygems, $(shell dh_listpackages)))
	cp -a opennebula-rubygems-*/gems-dist dist/usr/share/one/
endif
ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
	echo EE > dist/var/lib/one/remotes/EDITION
else
	echo CE > dist/var/lib/one/remotes/EDITION
endif
	dh_auto_install
ifneq (,$(filter opennebula-common, $(shell dh_listpackages)))
	dh_install -p opennebula-common share/pkgs/sudoers/${DIR_SUDOERS}/opennebula \
		/etc/sudoers.d
	dh_install -p opennebula-common share/pkgs/tmpfiles/${DIR_TMPFILES}/opennebula-common.conf \
		/usr/lib/tmpfiles.d/
	dh_install -p opennebula-common share/pkgs/tmpfiles/${DIR_TMPFILES}/opennebula-node.conf \
		/usr/lib/tmpfiles.d/
endif
ifneq (,$(filter opennebula, $(shell dh_listpackages)))
	dh_install -p opennebula share/pkgs/logrotate/opennebula /etc/logrotate.d/
	dh_install -p opennebula share/pkgs/logrotate/opennebula-hem /etc/logrotate.d/

	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula.service \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-ssh-agent.service \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-ssh-socks-cleaner.service \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-ssh-socks-cleaner.timer \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-showback.service \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-showback.timer \
		/lib/systemd/system/
	dh_install -p opennebula share/pkgs/services/${DIR_SERVICES}/opennebula-hem.service \
		/lib/systemd/system/
	dh_install -p opennebula share/augeas/oned.aug /usr/share/augeas/lenses/
	dh_install -p opennebula share/pkgs/sudoers/opennebula-server /etc/sudoers.d/
endif
ifneq (,$(filter opennebula-fireedge, $(shell dh_listpackages)))
	dh_install -p opennebula-fireedge share/pkgs/logrotate/opennebula-fireedge /etc/logrotate.d/

	dh_install -p opennebula-fireedge share/pkgs/services/${DIR_SERVICES}/opennebula-fireedge.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-gate, $(shell dh_listpackages)))
	dh_install -p opennebula-gate share/pkgs/logrotate/opennebula-gate /etc/logrotate.d/

	dh_install -p opennebula-gate share/pkgs/services/${DIR_SERVICES}/opennebula-gate.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-flow, $(shell dh_listpackages)))
	dh_install -p opennebula-flow share/pkgs/logrotate/opennebula-flow /etc/logrotate.d/

	dh_install -p opennebula-flow share/pkgs/services/${DIR_SERVICES}/opennebula-flow.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-form, $(shell dh_listpackages)))
	dh_install -p opennebula-form share/pkgs/services/${DIR_SERVICES}/opennebula-form.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-prometheus, $(shell dh_listpackages)))
	dh_install -p opennebula-prometheus src/oneprometheus/alertmanager/systemd/opennebula-alertmanager.service \
		/lib/systemd/system/
	dh_install -p opennebula-prometheus src/oneprometheus/prometheus/systemd/opennebula-prometheus.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-node-kvm, $(shell dh_listpackages)))
	dh_install -p opennebula-node-kvm share/pkgs/sudoers/opennebula-node-kvm /etc/sudoers.d/
	dh_install -p opennebula-node-kvm share/etc/sysctl.d/bridge-nf-call.conf /etc/sysctl.d/
	dh_install -p opennebula-node-kvm share/etc/cron.d/opennebula-node /etc/cron.d/

    ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
		dh_install -p opennebula-node-kvm one-ee-tools/src/onefabric/host/etc/fabricmanager.conf /etc/one/
		dh_install -p opennebula-node-kvm one-ee-tools/src/onefabric/host/etc/one-fabricmanager.xml /etc/one/
		dh_install -p opennebula-node-kvm one-ee-tools/src/onefabric/host/lib/opennebula-fabricmanager.service /lib/systemd/system/
		dh_install -p opennebula-node-kvm one-ee-tools/src/onefabric/host/src/service/* /usr/lib/one/
    endif
endif
ifneq (,$(filter opennebula-prometheus-kvm, $(shell dh_listpackages)))
	dh_install -p opennebula-prometheus-kvm src/oneprometheus/node_exporter/systemd/opennebula-node-exporter.service \
		/lib/systemd/system/
	dh_install -p opennebula-prometheus-kvm src/oneprometheus/opennebula-exporter/systemd/opennebula-exporter.service \
		/lib/systemd/system/
	dh_install -p opennebula-prometheus-kvm src/oneprometheus/opennebula-libvirt-exporter/systemd/opennebula-libvirt-exporter.service \
		/lib/systemd/system/
endif
ifneq (,$(filter opennebula-node-lxc, $(shell dh_listpackages)))
	dh_install -p opennebula-node-lxc share/pkgs/sudoers/opennebula-node-lxc /etc/sudoers.d/
	dh_install -p opennebula-node-lxc share/etc/sysctl.d/bridge-nf-call.conf /etc/sysctl.d/
	dh_install -p opennebula-node-lxc share/etc/cron.d/opennebula-node /etc/cron.d/
	dh_install -p opennebula-node-lxc share/etc/modprobe.d/opennebula-node-lxc.conf /etc/modprobe.d/
	dh_install -p opennebula-node-lxc share/etc/modules-load.d/opennebula-node-lxc.conf /etc/modules-load.d/
endif
ifneq (,$(filter opennebula-libs, $(shell dh_listpackages)))
	cp share/install_gems/${GEMFILE_LOCK}/Gemfile.lock dist/usr/share/one/
endif
ifneq (,$(filter opennebula-tools, $(shell dh_listpackages)))
	mkdir -p dist/usr/share/bash-completion/completions/opennebula
	cp share/shell/bash_completion dist/usr/share/bash-completion/completions/opennebula
endif
ifneq (,$(filter python3-pyone, $(shell dh_listpackages)))
	(cd src/oca/python/; make install ROOT=../../../dist)
endif
ifneq (,$(filter opennebula-swap, $(shell dh_listpackages)))
	tar xzvf opennebula-swap-*.tar.gz
	(cd one-swap; make)
	(cd one-swap; DESTDIR=../dist ./install.sh && gzip oneswap.1)
	dh_install -p opennebula-swap one-swap/vendor/exe/pnp_wait.exe /usr/share/virt-tools/
	dh_install -p opennebula-swap one-swap/vendor/exe/rhsrvany.exe /usr/share/virt-tools/
	dh_install -p opennebula-swap one-swap/oneswap.1.gz /usr/share/man/man1/
endif
ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
	dh_install -p opennebula-ovirtapi share/pkgs/sudoers/opennebula-ovirtapi /etc/sudoers.d/
endif

override_dh_installinit:
ifneq (,$(filter opennebula, $(shell dh_listpackages)))
	dh_installinit -p opennebula --name=opennebula --onlyscripts --no-start
	dh_installinit -p opennebula --name=opennebula-hem --onlyscripts --no-start
endif
ifneq (,$(filter opennebula-fireedge, $(shell dh_listpackages)))
	dh_installinit -p opennebula-fireedge --name=opennebula-fireedge --onlyscripts --no-start
endif
ifneq (,$(filter opennebula-gate, $(shell dh_listpackages)))
	dh_installinit -p opennebula-gate --name=opennebula-gate --onlyscripts --no-start
endif
ifneq (,$(filter opennebula-flow, $(shell dh_listpackages)))
	dh_installinit -p opennebula-flow --name=opennebula-flow --onlyscripts --no-start
endif
ifneq (,$(filter opennebula-node-kvm, $(shell dh_listpackages)))
    ifneq (,$(filter opennebula-ovirtapi, $(shell dh_listpackages)))
		dh_installinit -p opennebula-node-kvm --name=opennebula-fabricmanager --onlyscripts --no-start
    endif
endif
	dh_installinit

override_dh_installdeb:
ifneq (,$(filter opennebula-node-kvm, $(shell dh_listpackages)))
	sed "s/@LIBVIRTGRP@/${LIB_VIRT_GROUP}/g" debian/opennebula-node-kvm.postinst.in > debian/opennebula-node-kvm.postinst
endif
	dh_installdeb
ifneq (,$(filter opennebula, $(shell dh_listpackages)))
	# dynamically generate list of configuration files from remotes
	find debian/opennebula/var/lib/one/remotes/etc -type f -printf '/var/lib/one/remotes/etc/%P\n' >>debian/opennebula/DEBIAN/conffiles
endif

override_dh_fixperms:
	dh_fixperms
ifneq (,$(filter opennebula, $(shell dh_listpackages)))
	chmod 0440 debian/opennebula/etc/sudoers.d/opennebula-server
endif
ifneq (,$(filter opennebula-common, $(shell dh_listpackages)))
	chmod 0440 debian/opennebula-common/etc/sudoers.d/opennebula
endif
ifneq (,$(filter opennebula-node-kvm, $(shell dh_listpackages)))
	chmod 0440 debian/opennebula-node-kvm/etc/sudoers.d/opennebula-node-kvm
endif
ifneq (,$(filter opennebula-node-lxc, $(shell dh_listpackages)))
	chmod 0440 debian/opennebula-node-lxc/etc/sudoers.d/opennebula-node-lxc
endif

override_dh_systemd_start:
	dh_systemd_start --no-start

override_dh_systemd_enable:
	dh_systemd_enable --no-enable

override_dh_auto_clean:
	dh_auto_clean
	rm -rf dist/
	#scons --clean .
	-rm -Rf .scons_temp
	-rm -Rf share/scons/lex_bison.pyc \
		src/oca/java/org.opennebula.client.jar
	-rm -Rf debian/opennebula-node-kvm.postinst

get-orig-source:
	uscan --force-download --no-symlink

override_dh_strip:
	dh_strip -p opennebula --dbg-package=opennebula-dbgsym --exclude=cbc

override_dh_shlibdeps:
	dh_shlibdeps --exclude=cbc --exclude=node_modules
