define(["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.encodingName = encodingName;
    /*
     * noVNC: HTML5 VNC client
     * Copyright (C) 2018 The noVNC Authors
     * Licensed under MPL 2.0 (see LICENSE.txt)
     *
     * See README.md for usage and integration instructions.
     */

    var encodings = exports.encodings = {
        encodingRaw: 0,
        encodingCopyRect: 1,
        encodingRRE: 2,
        encodingHextile: 5,
        encodingTight: 7,
        encodingTightPNG: -260,

        pseudoEncodingQualityLevel9: -23,
        pseudoEncodingQualityLevel0: -32,
        pseudoEncodingDesktopSize: -223,
        pseudoEncodingLastRect: -224,
        pseudoEncodingCursor: -239,
        pseudoEncodingQEMUExtendedKeyEvent: -258,
        pseudoEncodingExtendedDesktopSize: -308,
        pseudoEncodingXvp: -309,
        pseudoEncodingFence: -312,
        pseudoEncodingContinuousUpdates: -313,
        pseudoEncodingCompressLevel9: -247,
        pseudoEncodingCompressLevel0: -256
    };

    function encodingName(num) {
        switch (num) {
            case encodings.encodingRaw:
                return "Raw";
            case encodings.encodingCopyRect:
                return "CopyRect";
            case encodings.encodingRRE:
                return "RRE";
            case encodings.encodingHextile:
                return "Hextile";
            case encodings.encodingTight:
                return "Tight";
            case encodings.encodingTightPNG:
                return "TightPNG";
            default:
                return "[unknown encoding " + num + "]";
        }
    }
});