"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.default = function (t, _ref, _ref2, _ref3) {
	var pathToMatch = _ref.pathToMatch,
	    pathToRemove = _ref.pathToRemove,
	    pathToReplace = _ref.pathToReplace,
	    replaceFn = _ref.replaceFn;
	var toMatch = _ref2.toMatch,
	    toRemove = _ref2.toRemove,
	    toReplace = _ref2.toReplace,
	    basedir = _ref2.basedir,
	    wrapReplacementInPromise = _ref2.wrapReplacementInPromise;
	var _ref3$opts = _ref3.opts,
	    root = _ref3$opts.root,
	    extensions = _ref3$opts.extensions,
	    suppressResolveWarning = _ref3$opts.suppressResolveWarning;

	var requiredFilename = (0, _resolveNode2.default)(basedir, pathToMatch.node.value, extensions, suppressResolveWarning);
	var matched = (0, _matchRedirect2.default)(requiredFilename, toMatch, root, extensions, suppressResolveWarning);

	if (matched !== null) {
		var redirect = matched.redirect,
		    redirected = matched.redirected;

		// path has a corresponing redirect

		if (redirected !== null) {
			if (redirected.includes("/node_modules/")) {
				var resolvedFromFile = (0, _resolveNode2.default)(basedir, redirect, extensions, suppressResolveWarning);

				// require(redirect) resolves to the same path from file source as require(redirected)
				if (resolvedFromFile === redirected) {
					pathToMatch.replaceWith(t.stringLiteral(redirect));
					return;
				} else {
					var modulePath = redirected.match("^.*/node_modules/([^/]+?)(?=/)");
					if (modulePath) {
						var _modulePath = _slicedToArray(modulePath, 2),
						    moduleDir = _modulePath[0],
						    moduleName = _modulePath[1];
						// require(modulePath) resolves to the same file as require(modulePath/file/path)
						// thanks to package.json


						if ((0, _resolveNode2.default)(moduleDir, moduleName, extensions, suppressResolveWarning) === redirected) {
							pathToMatch.replaceWith(t.stringLiteral((0, _path.relative)(basedir, moduleDir)));
							return;
						}
					}
				}
			}

			var relativeRedirect = (0, _path.relative)(basedir, redirected);
			if (!(relativeRedirect.startsWith("./") || relativeRedirect.startsWith("../"))) relativeRedirect = "./" + relativeRedirect;

			if (!(0, _path.extname)(redirect)) {
				var ext = (0, _path.extname)(relativeRedirect);
				if (ext) relativeRedirect = relativeRedirect.slice(0, -ext.length);
			}
			pathToMatch.replaceWith(t.stringLiteral(relativeRedirect));
		}
		// if can be removed
	} else if (pathToRemove) {
		if (toRemove.some(function (regexp) {
			return regexp.test(requiredFilename);
		}) || toReplace.find(function (_ref4) {
			var _ref5 = _slicedToArray(_ref4, 1),
			    regexp = _ref5[0];

			return regexp.test(requiredFilename);
		})) {
			pathToRemove.remove();
		}

		// if can be replaced
	} else if (pathToReplace) {
		var replacement = toReplace.find(function (_ref6) {
			var _ref7 = _slicedToArray(_ref6, 1),
			    regexp = _ref7[0];

			return regexp.test(requiredFilename);
		});

		if (replacement) {
			replaceFn(t, replacement[1], pathToReplace, wrapReplacementInPromise);
		}
	}
};

var _resolveNode = require("./resolveNode");

var _resolveNode2 = _interopRequireDefault(_resolveNode);

var _matchRedirect = require("./matchRedirect");

var _matchRedirect2 = _interopRequireDefault(_matchRedirect);

var _path = require("path");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }