"use strict";

Object.defineProperty(exports, "__esModule", {
	value: true
});

exports.default = function (basedir, filename, extensions, suppressResolveWarning) {
	if (!cache || cache[ext] !== extensions) {
		cache = _defineProperty({}, ext, extensions);
	}
	var cached = cache[basedir];

	if (cached) {
		return cached[filename] || (cached[filename] = getResolved());
	}

	var resolved = getResolved();
	cache[basedir] = _defineProperty({}, filename, resolved);

	return resolved;

	function getResolved() {
		try {
			return _resolve2.default.sync(filename, {
				basedir: basedir,
				extensions: extensions
			});
		} catch (err) {
			var _resolved = void 0,
			    errMessage = err.message + "\nMake sure it is available later";
			if (filename.startsWith("./") || filename.startsWith("../")) {
				_resolved = _path2.default.resolve(basedir, filename);
			} else {
				errMessage += " in node_modules";
				_resolved = "/node_modules/" + filename;
			}

			if (!suppressResolveWarning) console.warn(errMessage);
			return _resolved;
		}
	}
};

var _resolve = require("resolve");

var _resolve2 = _interopRequireDefault(_resolve);

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var cache = void 0;
var ext = Symbol("extensions");