'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _requireCall = require('./transformers/requireCall');

var _requireCall2 = _interopRequireDefault(_requireCall);

var _importExportDeclaration = require('./transformers/importExportDeclaration');

var _importExportDeclaration2 = _interopRequireDefault(_importExportDeclaration);

var _babylon = require('babylon');

var _path = require('path');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var defaultExtensions = [".js", ".jsx", ".es", "es6"];

exports.default = function (_ref) {
	var t = _ref.types;

	return {
		pre: function pre(state) {
			var opts = this.opts;
			if (!opts.root) opts.root = process.cwd();

			var filenameUnknown = state.opts.filename === "unknown";
			var basedir = filenameUnknown ? opts.root : (0, _path.dirname)(state.opts.filename);
			if (filenameUnknown && !opts.suppressResolveWarning) {
				console.warn("Source input isn't a file. Paths will be resolved relative to", opts.root);
			}

			if (!opts.extensions) opts.extensions = defaultExtensions;

			var toMatch = [],
			    toRemove = [],
			    toReplace = [],
			    redirect = opts.redirect;var _iteratorNormalCompletion = true;
			var _didIteratorError = false;
			var _iteratorError = undefined;

			try {
				for (var _iterator = Object.keys(redirect)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
					var pattern = _step.value;

					var regexp = new RegExp(pattern),
					    redirected = redirect[pattern];

					if (redirected === false) {
						toRemove.push(regexp);
					} else if (typeof redirected === "string") {
						toMatch.push([regexp, redirected]);
					} else {
						toReplace.push([regexp, (0, _babylon.parseExpression)(JSON.stringify(redirected))]);
					}
				}
			} catch (err) {
				_didIteratorError = true;
				_iteratorError = err;
			} finally {
				try {
					if (!_iteratorNormalCompletion && _iterator.return) {
						_iterator.return();
					}
				} finally {
					if (_didIteratorError) {
						throw _iteratorError;
					}
				}
			}

			var _opts = this.opts,
			    extraFunctions = _opts.extraFunctions,
			    promisifyReplacementFor = _opts.promisifyReplacementFor;


			var functionNames = new Set(extraFunctions && (Array.isArray(extraFunctions) ? extraFunctions : [extraFunctions])).add("require");
			var wrapReplacementInPromise = new Set(promisifyReplacementFor && (Array.isArray(promisifyReplacementFor) ? promisifyReplacementFor : [promisifyReplacementFor]));

			this.calculatedOpts = {
				basedir: basedir,
				toMatch: toMatch,
				functionNames: functionNames,
				wrapReplacementInPromise: wrapReplacementInPromise,
				toRemove: toRemove,
				toReplace: toReplace
			};
		},

		visitor: {
			CallExpression: function CallExpression(path, state) {
				(0, _requireCall2.default)(t, path, state, this.calculatedOpts);
			},
			ModuleDeclaration: function ModuleDeclaration(path, state) {
				(0, _importExportDeclaration2.default)(t, path, state, this.calculatedOpts);
			}
		}
	};
};