/**
 * @license almond 0.3.1 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*jslint sloppy: true */
/*global setTimeout: false */

var requirejs, require, define;
(function (undef) {
    var main, req, makeMap, handlers,
        defined = {},
        waiting = {},
        config = {},
        defining = {},
        hasOwn = Object.prototype.hasOwnProperty,
        aps = [].slice,
        jsSuffixRegExp = /\.js$/;

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    /**
     * Given a relative module name, like ./something, normalize it to
     * a real name that can be mapped to a path.
     * @param {String} name the relative name
     * @param {String} baseName a real name that the name arg is relative
     * to.
     * @returns {String} normalized name
     */
    function normalize(name, baseName) {
        var nameParts, nameSegment, mapValue, foundMap, lastIndex,
            foundI, foundStarMap, starI, i, j, part,
            baseParts = baseName && baseName.split("/"),
            map = config.map,
            starMap = (map && map['*']) || {};

        //Adjust any relative paths.
        if (name && name.charAt(0) === ".") {
            //If have a base name, try to normalize against it,
            //otherwise, assume it is a top-level require that will
            //be relative to baseUrl in the end.
            if (baseName) {
                name = name.split('/');
                lastIndex = name.length - 1;

                // Node .js allowance:
                if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                }

                //Lop off the last part of baseParts, so that . matches the
                //"directory" and not name of the baseName's module. For instance,
                //baseName of "one/two/three", maps to "one/two/three.js", but we
                //want the directory, "one/two" for this normalization.
                name = baseParts.slice(0, baseParts.length - 1).concat(name);

                //start trimDots
                for (i = 0; i < name.length; i += 1) {
                    part = name[i];
                    if (part === ".") {
                        name.splice(i, 1);
                        i -= 1;
                    } else if (part === "..") {
                        if (i === 1 && (name[2] === '..' || name[0] === '..')) {
                            //End of the line. Keep at least one non-dot
                            //path segment at the front so it can be mapped
                            //correctly to disk. Otherwise, there is likely
                            //no path mapping for a path starting with '..'.
                            //This can still fail, but catches the most reasonable
                            //uses of ..
                            break;
                        } else if (i > 0) {
                            name.splice(i - 1, 2);
                            i -= 2;
                        }
                    }
                }
                //end trimDots

                name = name.join("/");
            } else if (name.indexOf('./') === 0) {
                // No baseName, so this is ID is resolved relative
                // to baseUrl, pull off the leading dot.
                name = name.substring(2);
            }
        }

        //Apply map config if available.
        if ((baseParts || starMap) && map) {
            nameParts = name.split('/');

            for (i = nameParts.length; i > 0; i -= 1) {
                nameSegment = nameParts.slice(0, i).join("/");

                if (baseParts) {
                    //Find the longest baseName segment match in the config.
                    //So, do joins on the biggest to smallest lengths of baseParts.
                    for (j = baseParts.length; j > 0; j -= 1) {
                        mapValue = map[baseParts.slice(0, j).join('/')];

                        //baseName segment has  config, find if it has one for
                        //this name.
                        if (mapValue) {
                            mapValue = mapValue[nameSegment];
                            if (mapValue) {
                                //Match, update name to the new value.
                                foundMap = mapValue;
                                foundI = i;
                                break;
                            }
                        }
                    }
                }

                if (foundMap) {
                    break;
                }

                //Check for a star map match, but just hold on to it,
                //if there is a shorter segment match later in a matching
                //config, then favor over this star map.
                if (!foundStarMap && starMap && starMap[nameSegment]) {
                    foundStarMap = starMap[nameSegment];
                    starI = i;
                }
            }

            if (!foundMap && foundStarMap) {
                foundMap = foundStarMap;
                foundI = starI;
            }

            if (foundMap) {
                nameParts.splice(0, foundI, foundMap);
                name = nameParts.join('/');
            }
        }

        return name;
    }

    function makeRequire(relName, forceSync) {
        return function () {
            //A version of a require function that passes a moduleName
            //value for items that may need to
            //look up paths relative to the moduleName
            var args = aps.call(arguments, 0);

            //If first arg is not require('string'), and there is only
            //one arg, it is the array form without a callback. Insert
            //a null so that the following concat is correct.
            if (typeof args[0] !== 'string' && args.length === 1) {
                args.push(null);
            }
            return req.apply(undef, args.concat([relName, forceSync]));
        };
    }

    function makeNormalize(relName) {
        return function (name) {
            return normalize(name, relName);
        };
    }

    function makeLoad(depName) {
        return function (value) {
            defined[depName] = value;
        };
    }

    function callDep(name) {
        if (hasProp(waiting, name)) {
            var args = waiting[name];
            delete waiting[name];
            defining[name] = true;
            main.apply(undef, args);
        }

        if (!hasProp(defined, name) && !hasProp(defining, name)) {
            throw new Error('No ' + name);
        }
        return defined[name];
    }

    //Turns a plugin!resource to [plugin, resource]
    //with the plugin being undefined if the name
    //did not have a plugin prefix.
    function splitPrefix(name) {
        var prefix,
            index = name ? name.indexOf('!') : -1;
        if (index > -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1, name.length);
        }
        return [prefix, name];
    }

    /**
     * Makes a name map, normalizing the name, and using a plugin
     * for normalization if necessary. Grabs a ref to plugin
     * too, as an optimization.
     */
    makeMap = function (name, relName) {
        var plugin,
            parts = splitPrefix(name),
            prefix = parts[0];

        name = parts[1];

        if (prefix) {
            prefix = normalize(prefix, relName);
            plugin = callDep(prefix);
        }

        //Normalize according
        if (prefix) {
            if (plugin && plugin.normalize) {
                name = plugin.normalize(name, makeNormalize(relName));
            } else {
                name = normalize(name, relName);
            }
        } else {
            name = normalize(name, relName);
            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];
            if (prefix) {
                plugin = callDep(prefix);
            }
        }

        //Using ridiculous property names for space reasons
        return {
            f: prefix ? prefix + '!' + name : name, //fullName
            n: name,
            pr: prefix,
            p: plugin
        };
    };

    function makeConfig(name) {
        return function () {
            return (config && config.config && config.config[name]) || {};
        };
    }

    handlers = {
        require: function (name) {
            return makeRequire(name);
        },
        exports: function (name) {
            var e = defined[name];
            if (typeof e !== 'undefined') {
                return e;
            } else {
                return (defined[name] = {});
            }
        },
        module: function (name) {
            return {
                id: name,
                uri: '',
                exports: defined[name],
                config: makeConfig(name)
            };
        }
    };

    main = function (name, deps, callback, relName) {
        var cjsModule, depName, ret, map, i,
            args = [],
            callbackType = typeof callback,
            usingExports;

        //Use name if no relName
        relName = relName || name;

        //Call the callback to define the module, if necessary.
        if (callbackType === 'undefined' || callbackType === 'function') {
            //Pull out the defined dependencies and pass the ordered
            //values to the callback.
            //Default to [require, exports, module] if no deps
            deps = !deps.length && callback.length ? ['require', 'exports', 'module'] : deps;
            for (i = 0; i < deps.length; i += 1) {
                map = makeMap(deps[i], relName);
                depName = map.f;

                //Fast path CommonJS standard dependencies.
                if (depName === "require") {
                    args[i] = handlers.require(name);
                } else if (depName === "exports") {
                    //CommonJS module spec 1.1
                    args[i] = handlers.exports(name);
                    usingExports = true;
                } else if (depName === "module") {
                    //CommonJS module spec 1.1
                    cjsModule = args[i] = handlers.module(name);
                } else if (hasProp(defined, depName) ||
                           hasProp(waiting, depName) ||
                           hasProp(defining, depName)) {
                    args[i] = callDep(depName);
                } else if (map.p) {
                    map.p.load(map.n, makeRequire(relName, true), makeLoad(depName), {});
                    args[i] = defined[depName];
                } else {
                    throw new Error(name + ' missing ' + depName);
                }
            }

            ret = callback ? callback.apply(defined[name], args) : undefined;

            if (name) {
                //If setting exports via "module" is in play,
                //favor that over return value and exports. After that,
                //favor a non-undefined return value over exports use.
                if (cjsModule && cjsModule.exports !== undef &&
                        cjsModule.exports !== defined[name]) {
                    defined[name] = cjsModule.exports;
                } else if (ret !== undef || !usingExports) {
                    //Use the return value from the function.
                    defined[name] = ret;
                }
            }
        } else if (name) {
            //May just be an object definition for the module. Only
            //worry about defining if have a module name.
            defined[name] = callback;
        }
    };

    requirejs = require = req = function (deps, callback, relName, forceSync, alt) {
        if (typeof deps === "string") {
            if (handlers[deps]) {
                //callback in this case is really relName
                return handlers[deps](callback);
            }
            //Just return the module wanted. In this scenario, the
            //deps arg is the module name, and second arg (if passed)
            //is just the relName.
            //Normalize module name, if it contains . or ..
            return callDep(makeMap(deps, callback).f);
        } else if (!deps.splice) {
            //deps is a config object, not an array.
            config = deps;
            if (config.deps) {
                req(config.deps, config.callback);
            }
            if (!callback) {
                return;
            }

            if (callback.splice) {
                //callback is an array, which means it is a dependency list.
                //Adjust args if there are dependencies
                deps = callback;
                callback = relName;
                relName = null;
            } else {
                deps = undef;
            }
        }

        //Support require(['a'])
        callback = callback || function () {};

        //If relName is a function, it is an errback handler,
        //so remove it.
        if (typeof relName === 'function') {
            relName = forceSync;
            forceSync = alt;
        }

        //Simulate async callback;
        if (forceSync) {
            main(undef, deps, callback, relName);
        } else {
            //Using a non-zero value because of concern for what old browsers
            //do, and latest browsers "upgrade" to 4 if lower value is used:
            //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:
            //If want a value immediately, use require('id') instead -- something
            //that works in almond on the global level, but not guaranteed and
            //unlikely to work in other AMD implementations.
            setTimeout(function () {
                main(undef, deps, callback, relName);
            }, 4);
        }

        return req;
    };

    /**
     * Just drops the config on the floor, but returns req in case
     * the config return value is used.
     */
    req.config = function (cfg) {
        return req(cfg);
    };

    /**
     * Expose module registry for debugging and tooling
     */
    requirejs._defined = defined;

    define = function (name, deps, callback) {
        if (typeof name !== 'string') {
            throw new Error('See almond README: incorrect module build, no module name');
        }

        //This module may not have dependencies
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        if (!hasProp(defined, name) && !hasProp(waiting, name)) {
            waiting[name] = [name, deps, callback];
        }
    };

    define.amd = {
        jQuery: true
    };
}());

define("almond", function(){});

/*!
 * jQuery JavaScript Library v2.2.3
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2016-04-05T19:26Z
 */

(function( global, factory ) {

	if ( typeof module === "object" && typeof module.exports === "object" ) {
		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
}(typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Support: Firefox 18+
// Can't be in strict mode, several libs including ASP.NET trace
// the stack via arguments.caller.callee and Firefox dies if
// you try to trace through "use strict" call chains. (#13335)
//"use strict";
var arr = [];

var document = window.document;

var slice = arr.slice;

var concat = arr.concat;

var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var support = {};



var
	version = "2.2.3",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	},

	// Support: Android<4.1
	// Make sure we trim BOM and NBSP
	rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

	// Matches dashed string for camelizing
	rmsPrefix = /^-ms-/,
	rdashAlpha = /-([\da-z])/gi,

	// Used by jQuery.camelCase as callback to replace()
	fcamelCase = function( all, letter ) {
		return letter.toUpperCase();
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// Start with an empty selector
	selector: "",

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {
		return num != null ?

			// Return just the one element from the set
			( num < 0 ? this[ num + this.length ] : this[ num ] ) :

			// Return all the elements in a clean array
			slice.call( this );
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;
		ret.context = this.context;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !jQuery.isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = jQuery.isArray( copy ) ) ) ) {

					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && jQuery.isArray( src ) ? src : [];

					} else {
						clone = src && jQuery.isPlainObject( src ) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isFunction: function( obj ) {
		return jQuery.type( obj ) === "function";
	},

	isArray: Array.isArray,

	isWindow: function( obj ) {
		return obj != null && obj === obj.window;
	},

	isNumeric: function( obj ) {

		// parseFloat NaNs numeric-cast false positives (null|true|false|"")
		// ...but misinterprets leading-number strings, particularly hex literals ("0x...")
		// subtraction forces infinities to NaN
		// adding 1 corrects loss of precision from parseFloat (#15100)
		var realStringObj = obj && obj.toString();
		return !jQuery.isArray( obj ) && ( realStringObj - parseFloat( realStringObj ) + 1 ) >= 0;
	},

	isPlainObject: function( obj ) {
		var key;

		// Not plain objects:
		// - Any object or value whose internal [[Class]] property is not "[object Object]"
		// - DOM nodes
		// - window
		if ( jQuery.type( obj ) !== "object" || obj.nodeType || jQuery.isWindow( obj ) ) {
			return false;
		}

		// Not own constructor property must be Object
		if ( obj.constructor &&
				!hasOwn.call( obj, "constructor" ) &&
				!hasOwn.call( obj.constructor.prototype || {}, "isPrototypeOf" ) ) {
			return false;
		}

		// Own properties are enumerated firstly, so to speed up,
		// if last one is own, then all properties are own
		for ( key in obj ) {}

		return key === undefined || hasOwn.call( obj, key );
	},

	isEmptyObject: function( obj ) {
		var name;
		for ( name in obj ) {
			return false;
		}
		return true;
	},

	type: function( obj ) {
		if ( obj == null ) {
			return obj + "";
		}

		// Support: Android<4.0, iOS<6 (functionish RegExp)
		return typeof obj === "object" || typeof obj === "function" ?
			class2type[ toString.call( obj ) ] || "object" :
			typeof obj;
	},

	// Evaluates a script in a global context
	globalEval: function( code ) {
		var script,
			indirect = eval;

		code = jQuery.trim( code );

		if ( code ) {

			// If the code includes a valid, prologue position
			// strict mode pragma, execute code by injecting a
			// script tag into the document.
			if ( code.indexOf( "use strict" ) === 1 ) {
				script = document.createElement( "script" );
				script.text = code;
				document.head.appendChild( script ).parentNode.removeChild( script );
			} else {

				// Otherwise, avoid the DOM node creation, insertion
				// and removal by using an indirect global eval

				indirect( code );
			}
		}
	},

	// Convert dashed to camelCase; used by the css and data modules
	// Support: IE9-11+
	// Microsoft forgot to hump their vendor prefix (#9572)
	camelCase: function( string ) {
		return string.replace( rmsPrefix, "ms-" ).replace( rdashAlpha, fcamelCase );
	},

	nodeName: function( elem, name ) {
		return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// Support: Android<4.1
	trim: function( text ) {
		return text == null ?
			"" :
			( text + "" ).replace( rtrim, "" );
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
					[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return concat.apply( [], ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// Bind a function to a context, optionally partially applying any
	// arguments.
	proxy: function( fn, context ) {
		var tmp, args, proxy;

		if ( typeof context === "string" ) {
			tmp = fn[ context ];
			context = fn;
			fn = tmp;
		}

		// Quick check to determine if target is callable, in the spec
		// this throws a TypeError, but we will just return undefined.
		if ( !jQuery.isFunction( fn ) ) {
			return undefined;
		}

		// Simulated bind
		args = slice.call( arguments, 2 );
		proxy = function() {
			return fn.apply( context || this, args.concat( slice.call( arguments ) ) );
		};

		// Set the guid of unique handler to the same of original handler, so it can be removed
		proxy.guid = fn.guid = fn.guid || jQuery.guid++;

		return proxy;
	},

	now: Date.now,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

// JSHint would error on this code due to the Symbol not being defined in ES5.
// Defining this global in .jshintrc would create a danger of using the global
// unguarded in another place, it seems safer to just disable JSHint for these
// three lines.
/* jshint ignore: start */
if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}
/* jshint ignore: end */

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
function( i, name ) {
	class2type[ "[object " + name + "]" ] = name.toLowerCase();
} );

function isArrayLike( obj ) {

	// Support: iOS 8.2 (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = jQuery.type( obj );

	if ( type === "function" || jQuery.isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.2.1
 * http://sizzlejs.com/
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2015-10-17
 */
(function( window ) {

var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// General-purpose constants
	MAX_NEGATIVE = 1 << 31,

	// Instance methods
	hasOwn = ({}).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	push_native = arr.push,
	push = arr.push,
	slice = arr.slice,
	// Use a stripped-down indexOf as it's faster than native
	// http://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[i] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
	identifier = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +
		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +
		// "Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" + whitespace +
		"*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +
		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +
		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*" ),

	rattributeQuotes = new RegExp( "=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace +
			"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
			"*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),
		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
			whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,
	rescape = /'|\\/g,

	// CSS escapes http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig" ),
	funescape = function( _, escaped, escapedWhitespace ) {
		var high = "0x" + escaped - 0x10000;
		// NaN means non-codepoint
		// Support: Firefox<24
		// Workaround erroneous numeric interpretation of +"0x"
		return high !== high || escapedWhitespace ?
			escaped :
			high < 0 ?
				// BMP codepoint
				String.fromCharCode( high + 0x10000 ) :
				// Supplemental Plane codepoint (surrogate pair)
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	};

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		(arr = slice.call( preferredDoc.childNodes )),
		preferredDoc.childNodes
	);
	// Support: Android<4.0
	// Detect silently failing push.apply
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			push_native.apply( target, slice.call(els) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;
			// Can't trust NodeList.length
			while ( (target[j++] = els[i++]) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, nidselect, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {

		if ( ( context ? context.ownerDocument || context : preferredDoc ) !== document ) {
			setDocument( context );
		}
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && (match = rquickExpr.exec( selector )) ) {

				// ID selector
				if ( (m = match[1]) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( (elem = context.getElementById( m )) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && (elem = newContext.getElementById( m )) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[2] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( (m = match[3]) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!compilerCache[ selector + " " ] &&
				(!rbuggyQSA || !rbuggyQSA.test( selector )) ) {

				if ( nodeType !== 1 ) {
					newContext = context;
					newSelector = selector;

				// qSA looks outside Element context, which is not what we want
				// Thanks to Andrew Dupont for this workaround technique
				// Support: IE <=8
				// Exclude object elements
				} else if ( context.nodeName.toLowerCase() !== "object" ) {

					// Capture the context ID, setting it first if necessary
					if ( (nid = context.getAttribute( "id" )) ) {
						nid = nid.replace( rescape, "\\$&" );
					} else {
						context.setAttribute( "id", (nid = expando) );
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					nidselect = ridentifier.test( nid ) ? "#" + nid : "[id='" + nid + "']";
					while ( i-- ) {
						groups[i] = nidselect + " " + toSelector( groups[i] );
					}
					newSelector = groups.join( "," );

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;
				}

				if ( newSelector ) {
					try {
						push.apply( results,
							newContext.querySelectorAll( newSelector )
						);
						return results;
					} catch ( qsaError ) {
					} finally {
						if ( nid === expando ) {
							context.removeAttribute( "id" );
						}
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {
		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {
			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return (cache[ key + " " ] = value);
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created div and expects a boolean result
 */
function assert( fn ) {
	var div = document.createElement("div");

	try {
		return !!fn( div );
	} catch (e) {
		return false;
	} finally {
		// Remove from its parent by default
		if ( div.parentNode ) {
			div.parentNode.removeChild( div );
		}
		// release memory in IE
		div = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split("|"),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[i] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			( ~b.sourceIndex || MAX_NEGATIVE ) -
			( ~a.sourceIndex || MAX_NEGATIVE );

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( (cur = cur.nextSibling) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return (name === "input" || name === "button") && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction(function( argument ) {
		argument = +argument;
		return markFunction(function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ (j = matchIndexes[i]) ] ) {
					seed[j] = !(matches[j] = seed[j]);
				}
			}
		});
	});
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	// documentElement is verified for cases where it doesn't yet exist
	// (such as loading iframes in IE - #4833)
	var documentElement = elem && (elem.ownerDocument || elem).documentElement;
	return documentElement ? documentElement.nodeName !== "HTML" : false;
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, parent,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	if ( doc === document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9-11, Edge
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	if ( (parent = document.defaultView) && parent.top !== parent ) {
		// Support: IE 11
		if ( parent.addEventListener ) {
			parent.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( parent.attachEvent ) {
			parent.attachEvent( "onunload", unloadHandler );
		}
	}

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert(function( div ) {
		div.className = "i";
		return !div.getAttribute("className");
	});

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert(function( div ) {
		div.appendChild( document.createComment("") );
		return !div.getElementsByTagName("*").length;
	});

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert(function( div ) {
		docElem.appendChild( div ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	});

	// ID find and filter
	if ( support.getById ) {
		Expr.find["ID"] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var m = context.getElementById( id );
				return m ? [ m ] : [];
			}
		};
		Expr.filter["ID"] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute("id") === attrId;
			};
		};
	} else {
		// Support: IE6/7
		// getElementById is not reliable as a find shortcut
		delete Expr.find["ID"];

		Expr.filter["ID"] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode("id");
				return node && node.value === attrId;
			};
		};
	}

	// Tag
	Expr.find["TAG"] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,
				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( (elem = results[i++]) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find["CLASS"] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See http://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( (support.qsa = rnative.test( document.querySelectorAll )) ) {
		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert(function( div ) {
			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// http://bugs.jquery.com/ticket/12359
			docElem.appendChild( div ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// http://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( div.querySelectorAll("[msallowcapture^='']").length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !div.querySelectorAll("[selected]").length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !div.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push("~=");
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":checked").length ) {
				rbuggyQSA.push(":checked");
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibing-combinator selector` fails
			if ( !div.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push(".#.+[+~]");
			}
		});

		assert(function( div ) {
			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement("input");
			input.setAttribute( "type", "hidden" );
			div.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( div.querySelectorAll("[name=d]").length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( !div.querySelectorAll(":enabled").length ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Opera 10-11 does not throw on post-comma invalid pseudos
			div.querySelectorAll("*,:x");
			rbuggyQSA.push(",.*:");
		});
	}

	if ( (support.matchesSelector = rnative.test( (matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector) )) ) {

		assert(function( div ) {
			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( div, "div" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( div, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		});
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join("|") );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join("|") );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			));
		} :
		function( a, b ) {
			if ( b ) {
				while ( (b = b.parentNode) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		compare = ( a.ownerDocument || a ) === ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			(!support.sortDetached && b.compareDocumentPosition( a ) === compare) ) {

			// Choose the first element that is related to our preferred document
			if ( a === document || a.ownerDocument === preferredDoc && contains(preferredDoc, a) ) {
				return -1;
			}
			if ( b === document || b.ownerDocument === preferredDoc && contains(preferredDoc, b) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {
		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {
			return a === document ? -1 :
				b === document ? 1 :
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( (cur = cur.parentNode) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( (cur = cur.parentNode) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[i] === bp[i] ) {
			i++;
		}

		return i ?
			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[i], bp[i] ) :

			// Otherwise nodes in our document sort first
			ap[i] === preferredDoc ? -1 :
			bp[i] === preferredDoc ? 1 :
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	// Make sure that attribute selectors are quoted
	expr = expr.replace( rattributeQuotes, "='$1']" );

	if ( support.matchesSelector && documentIsHTML &&
		!compilerCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||
					// As well, disconnected nodes are said to be in a document
					// fragment in IE 9
					elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch (e) {}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {
	// Set document vars if needed
	if ( ( context.ownerDocument || context ) !== document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {
	// Set document vars if needed
	if ( ( elem.ownerDocument || elem ) !== document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],
		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			(val = elem.getAttributeNode(name)) && val.specified ?
				val.value :
				null;
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( (elem = results[i++]) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {
		// If no nodeType, this is expected to be an array
		while ( (node = elem[i++]) ) {
			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {
		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {
			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}
	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[1] = match[1].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[3] = ( match[3] || match[4] || match[5] || "" ).replace( runescape, funescape );

			if ( match[2] === "~=" ) {
				match[3] = " " + match[3] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {
			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[1] = match[1].toLowerCase();

			if ( match[1].slice( 0, 3 ) === "nth" ) {
				// nth-* requires argument
				if ( !match[3] ) {
					Sizzle.error( match[0] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[4] = +( match[4] ? match[5] + (match[6] || 1) : 2 * ( match[3] === "even" || match[3] === "odd" ) );
				match[5] = +( ( match[7] + match[8] ) || match[3] === "odd" );

			// other types prohibit arguments
			} else if ( match[3] ) {
				Sizzle.error( match[0] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[6] && match[2];

			if ( matchExpr["CHILD"].test( match[0] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[3] ) {
				match[2] = match[4] || match[5] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&
				// Get excess from tokenize (recursively)
				(excess = tokenize( unquoted, true )) &&
				// advance to the next closing parenthesis
				(excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length) ) {

				// excess is a negative index
				match[0] = match[0].slice( 0, excess );
				match[2] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() { return true; } :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				(pattern = new RegExp( "(^|" + whitespace + ")" + className + "(" + whitespace + "|$)" )) &&
				classCache( className, function( elem ) {
					return pattern.test( typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== "undefined" && elem.getAttribute("class") || "" );
				});
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
			};
		},

		"CHILD": function( type, what, argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( (node = node[ dir ]) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}
								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || (node[ expando ] = {});

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								(outerCache[ node.uniqueID ] = {});

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( (node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								(diff = nodeIndex = 0) || start.pop()) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {
							// Use previously-cached element index if available
							if ( useCache ) {
								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || (node[ expando ] = {});

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									(outerCache[ node.uniqueID ] = {});

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {
								// Use the same loop as above to seek `elem` from the start
								while ( (node = ++nodeIndex && node && node[ dir ] ||
									(diff = nodeIndex = 0) || start.pop()) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] || (node[ expando ] = {});

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												(outerCache[ node.uniqueID ] = {});

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {
			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction(function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[i] );
							seed[ idx ] = !( matches[ idx ] = matched[i] );
						}
					}) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {
		// Potentially complex pseudos
		"not": markFunction(function( selector ) {
			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction(function( seed, matches, context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( (elem = unmatched[i]) ) {
							seed[i] = !(matches[i] = elem);
						}
					}
				}) :
				function( elem, context, xml ) {
					input[0] = elem;
					matcher( input, null, xml, results );
					// Don't keep the element (issue #299)
					input[0] = null;
					return !results.pop();
				};
		}),

		"has": markFunction(function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		}),

		"contains": markFunction(function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || elem.innerText || getText( elem ) ).indexOf( text ) > -1;
			};
		}),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {
			// lang value must be a valid identifier
			if ( !ridentifier.test(lang || "") ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( (elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute("xml:lang") || elem.getAttribute("lang")) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( (elem = elem.parentNode) && elem.nodeType === 1 );
				return false;
			};
		}),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
		},

		// Boolean properties
		"enabled": function( elem ) {
			return elem.disabled === false;
		},

		"disabled": function( elem ) {
			return elem.disabled === true;
		},

		"checked": function( elem ) {
			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
		},

		"selected": function( elem ) {
			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {
			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos["empty"]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( (attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo(function() {
			return [ 0 ];
		}),

		"last": createPositionalPseudo(function( matchIndexes, length ) {
			return [ length - 1 ];
		}),

		"eq": createPositionalPseudo(function( matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		}),

		"even": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"odd": createPositionalPseudo(function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"lt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		}),

		"gt": createPositionalPseudo(function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		})
	}
};

Expr.pseudos["nth"] = Expr.pseudos["eq"];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || (match = rcomma.exec( soFar )) ) {
			if ( match ) {
				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[0].length ) || soFar;
			}
			groups.push( (tokens = []) );
		}

		matched = false;

		// Combinators
		if ( (match = rcombinators.exec( soFar )) ) {
			matched = match.shift();
			tokens.push({
				value: matched,
				// Cast descendant combinators to space
				type: match[0].replace( rtrim, " " )
			});
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( (match = matchExpr[ type ].exec( soFar )) && (!preFilters[ type ] ||
				(match = preFilters[ type ]( match ))) ) {
				matched = match.shift();
				tokens.push({
					value: matched,
					type: type,
					matches: match
				});
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :
			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[i].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		checkNonElements = base && dir === "parentNode",
		doneName = done++;

	return combinator.first ?
		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( (elem = elem[ dir ]) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( (elem = elem[ dir ]) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || (elem[ expando ] = {});

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] || (outerCache[ elem.uniqueID ] = {});

						if ( (oldCache = uniqueCache[ dir ]) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return (newCache[ 2 ] = oldCache[ 2 ]);
						} else {
							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ dir ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( (newCache[ 2 ] = matcher( elem, context, xml )) ) {
								return true;
							}
						}
					}
				}
			}
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[i]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[0];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[i], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( (elem = unmatched[i]) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction(function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts( selector || "*", context.nodeType ? [ context ] : context, [] ),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?
				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( (elem = temp[i]) ) {
					matcherOut[ postMap[i] ] = !(matcherIn[ postMap[i] ] = elem);
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {
					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( (elem = matcherOut[i]) ) {
							// Restore matcherIn since elem is not yet a final match
							temp.push( (matcherIn[i] = elem) );
						}
					}
					postFinder( null, (matcherOut = []), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( (elem = matcherOut[i]) &&
						(temp = postFinder ? indexOf( seed, elem ) : preMap[i]) > -1 ) {

						seed[temp] = !(results[temp] = elem);
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	});
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[0].type ],
		implicitRelative = leadingRelative || Expr.relative[" "],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				(checkContext = context).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );
			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( (matcher = Expr.relative[ tokens[i].type ]) ) {
			matchers = [ addCombinator(elementMatcher( matchers ), matcher) ];
		} else {
			matcher = Expr.filter[ tokens[i].type ].apply( null, tokens[i].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {
				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[j].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(
						// If the preceding token was a descendant combinator, insert an implicit any-element `*`
						tokens.slice( 0, i - 1 ).concat({ value: tokens[ i - 2 ].type === " " ? "*" : "" })
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( (tokens = tokens.slice( j )) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,
				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find["TAG"]( "*", outermost ),
				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.random() || 0.1),
				len = elems.length;

			if ( outermost ) {
				outermostContext = context === document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && (elem = elems[i]) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;
					if ( !context && elem.ownerDocument !== document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( (matcher = elementMatchers[j++]) ) {
						if ( matcher( elem, context || document, xml) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {
					// They will have gone through all possible matchers
					if ( (elem = !matcher && elem) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( (matcher = setMatchers[j++]) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {
					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !(unmatched[i] || setMatched[i]) ) {
								setMatched[i] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {
		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[i] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache( selector, matcherFromGroupMatchers( elementMatchers, setMatchers ) );

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( (selector = compiled.selector || selector) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[0] = match[0].slice( 0 );
		if ( tokens.length > 2 && (token = tokens[0]).type === "ID" &&
				support.getById && context.nodeType === 9 && documentIsHTML &&
				Expr.relative[ tokens[1].type ] ) {

			context = ( Expr.find["ID"]( token.matches[0].replace(runescape, funescape), context ) || [] )[0];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr["needsContext"].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[i];

			// Abort if we hit a combinator
			if ( Expr.relative[ (type = token.type) ] ) {
				break;
			}
			if ( (find = Expr.find[ type ]) ) {
				// Search, expanding context for leading sibling combinators
				if ( (seed = find(
					token.matches[0].replace( runescape, funescape ),
					rsibling.test( tokens[0].type ) && testContext( context.parentNode ) || context
				)) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split("").sort( sortOrder ).join("") === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert(function( div1 ) {
	// Should return 1, but returns 4 (following)
	return div1.compareDocumentPosition( document.createElement("div") ) & 1;
});

// Support: IE<8
// Prevent attribute/property "interpolation"
// http://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert(function( div ) {
	div.innerHTML = "<a href='#'></a>";
	return div.firstChild.getAttribute("href") === "#" ;
}) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	});
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert(function( div ) {
	div.innerHTML = "<input/>";
	div.firstChild.setAttribute( "value", "" );
	return div.firstChild.getAttribute( "value" ) === "";
}) ) {
	addHandle( "value", function( elem, name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	});
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert(function( div ) {
	return div.getAttribute("disabled") == null;
}) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
					(val = elem.getAttributeNode( name )) && val.specified ?
					val.value :
				null;
		}
	});
}

return Sizzle;

})( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;



var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;

var rsingleTag = ( /^<([\w-]+)\s*\/?>(?:<\/\1>|)$/ );



var risSimple = /^.[^:#\[\.,]*$/;

// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( jQuery.isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			/* jshint -W018 */
			return !!qualifier.call( elem, i, elem ) !== not;
		} );

	}

	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );

	}

	if ( typeof qualifier === "string" ) {
		if ( risSimple.test( qualifier ) ) {
			return jQuery.filter( qualifier, elements, not );
		}

		qualifier = jQuery.filter( qualifier, elements );
	}

	return jQuery.grep( elements, function( elem ) {
		return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
	} );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	return elems.length === 1 && elem.nodeType === 1 ?
		jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [] :
		jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
			return elem.nodeType === 1;
		} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i,
			len = this.length,
			ret = [],
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		// Needed because $( selector, context ) becomes $( context ).find( selector )
		ret = this.pushStack( len > 1 ? jQuery.unique( ret ) : ret );
		ret.selector = this.selector ? this.selector + " " + selector : selector;
		return ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( jQuery.isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					// Support: Blackberry 4.6
					// gEBID returns nodes no longer in the document (#6963)
					if ( elem && elem.parentNode ) {

						// Inject the element directly into the jQuery object
						this.length = 1;
						this[ 0 ] = elem;
					}

					this.context = document;
					this.selector = selector;
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this.context = this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( jQuery.isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		if ( selector.selector !== undefined ) {
			this.selector = selector.selector;
			this.context = selector.context;
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			pos = rneedsContext.test( selectors ) || typeof selectors !== "string" ?
				jQuery( selectors, context || this.context ) :
				0;

		for ( ; i < l; i++ ) {
			for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

				// Always skip document fragments
				if ( cur.nodeType < 11 && ( pos ?
					pos.index( cur ) > -1 :

					// Don't pass non-elements to Sizzle
					cur.nodeType === 1 &&
						jQuery.find.matchesSelector( cur, selectors ) ) ) {

					matched.push( cur );
					break;
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		return elem.contentDocument || jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnotwhite = ( /\S+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnotwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( jQuery.isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && jQuery.type( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


jQuery.extend( {

	Deferred: function( func ) {
		var tuples = [

				// action, add listener, listener list, final state
				[ "resolve", "done", jQuery.Callbacks( "once memory" ), "resolved" ],
				[ "reject", "fail", jQuery.Callbacks( "once memory" ), "rejected" ],
				[ "notify", "progress", jQuery.Callbacks( "memory" ) ]
			],
			state = "pending",
			promise = {
				state: function() {
					return state;
				},
				always: function() {
					deferred.done( arguments ).fail( arguments );
					return this;
				},
				then: function( /* fnDone, fnFail, fnProgress */ ) {
					var fns = arguments;
					return jQuery.Deferred( function( newDefer ) {
						jQuery.each( tuples, function( i, tuple ) {
							var fn = jQuery.isFunction( fns[ i ] ) && fns[ i ];

							// deferred[ done | fail | progress ] for forwarding actions to newDefer
							deferred[ tuple[ 1 ] ]( function() {
								var returned = fn && fn.apply( this, arguments );
								if ( returned && jQuery.isFunction( returned.promise ) ) {
									returned.promise()
										.progress( newDefer.notify )
										.done( newDefer.resolve )
										.fail( newDefer.reject );
								} else {
									newDefer[ tuple[ 0 ] + "With" ](
										this === promise ? newDefer.promise() : this,
										fn ? [ returned ] : arguments
									);
								}
							} );
						} );
						fns = null;
					} ).promise();
				},

				// Get a promise for this deferred
				// If obj is provided, the promise aspect is added to the object
				promise: function( obj ) {
					return obj != null ? jQuery.extend( obj, promise ) : promise;
				}
			},
			deferred = {};

		// Keep pipe for back-compat
		promise.pipe = promise.then;

		// Add list-specific methods
		jQuery.each( tuples, function( i, tuple ) {
			var list = tuple[ 2 ],
				stateString = tuple[ 3 ];

			// promise[ done | fail | progress ] = list.add
			promise[ tuple[ 1 ] ] = list.add;

			// Handle state
			if ( stateString ) {
				list.add( function() {

					// state = [ resolved | rejected ]
					state = stateString;

				// [ reject_list | resolve_list ].disable; progress_list.lock
				}, tuples[ i ^ 1 ][ 2 ].disable, tuples[ 2 ][ 2 ].lock );
			}

			// deferred[ resolve | reject | notify ]
			deferred[ tuple[ 0 ] ] = function() {
				deferred[ tuple[ 0 ] + "With" ]( this === deferred ? promise : this, arguments );
				return this;
			};
			deferred[ tuple[ 0 ] + "With" ] = list.fireWith;
		} );

		// Make the deferred a promise
		promise.promise( deferred );

		// Call given func if any
		if ( func ) {
			func.call( deferred, deferred );
		}

		// All done!
		return deferred;
	},

	// Deferred helper
	when: function( subordinate /* , ..., subordinateN */ ) {
		var i = 0,
			resolveValues = slice.call( arguments ),
			length = resolveValues.length,

			// the count of uncompleted subordinates
			remaining = length !== 1 ||
				( subordinate && jQuery.isFunction( subordinate.promise ) ) ? length : 0,

			// the master Deferred.
			// If resolveValues consist of only a single Deferred, just use that.
			deferred = remaining === 1 ? subordinate : jQuery.Deferred(),

			// Update function for both resolve and progress values
			updateFunc = function( i, contexts, values ) {
				return function( value ) {
					contexts[ i ] = this;
					values[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;
					if ( values === progressValues ) {
						deferred.notifyWith( contexts, values );
					} else if ( !( --remaining ) ) {
						deferred.resolveWith( contexts, values );
					}
				};
			},

			progressValues, progressContexts, resolveContexts;

		// Add listeners to Deferred subordinates; treat others as resolved
		if ( length > 1 ) {
			progressValues = new Array( length );
			progressContexts = new Array( length );
			resolveContexts = new Array( length );
			for ( ; i < length; i++ ) {
				if ( resolveValues[ i ] && jQuery.isFunction( resolveValues[ i ].promise ) ) {
					resolveValues[ i ].promise()
						.progress( updateFunc( i, progressContexts, progressValues ) )
						.done( updateFunc( i, resolveContexts, resolveValues ) )
						.fail( deferred.reject );
				} else {
					--remaining;
				}
			}
		}

		// If we're not waiting on anything, resolve the master
		if ( !remaining ) {
			deferred.resolveWith( resolveContexts, resolveValues );
		}

		return deferred.promise();
	}
} );


// The deferred used on DOM ready
var readyList;

jQuery.fn.ready = function( fn ) {

	// Add the callback
	jQuery.ready.promise().done( fn );

	return this;
};

jQuery.extend( {

	// Is the DOM ready to be used? Set to true once it occurs.
	isReady: false,

	// A counter to track how many items to wait for before
	// the ready event fires. See #6781
	readyWait: 1,

	// Hold (or release) the ready event
	holdReady: function( hold ) {
		if ( hold ) {
			jQuery.readyWait++;
		} else {
			jQuery.ready( true );
		}
	},

	// Handle when the DOM is ready
	ready: function( wait ) {

		// Abort if there are pending holds or we're already ready
		if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {
			return;
		}

		// Remember that the DOM is ready
		jQuery.isReady = true;

		// If a normal DOM Ready event fired, decrement, and wait if need be
		if ( wait !== true && --jQuery.readyWait > 0 ) {
			return;
		}

		// If there are functions bound, to execute
		readyList.resolveWith( document, [ jQuery ] );

		// Trigger any bound ready events
		if ( jQuery.fn.triggerHandler ) {
			jQuery( document ).triggerHandler( "ready" );
			jQuery( document ).off( "ready" );
		}
	}
} );

/**
 * The ready event handler and self cleanup method
 */
function completed() {
	document.removeEventListener( "DOMContentLoaded", completed );
	window.removeEventListener( "load", completed );
	jQuery.ready();
}

jQuery.ready.promise = function( obj ) {
	if ( !readyList ) {

		readyList = jQuery.Deferred();

		// Catch cases where $(document).ready() is called
		// after the browser event has already occurred.
		// Support: IE9-10 only
		// Older IE sometimes signals "interactive" too soon
		if ( document.readyState === "complete" ||
			( document.readyState !== "loading" && !document.documentElement.doScroll ) ) {

			// Handle it asynchronously to allow scripts the opportunity to delay ready
			window.setTimeout( jQuery.ready );

		} else {

			// Use the handy event callback
			document.addEventListener( "DOMContentLoaded", completed );

			// A fallback to window.onload, that will always work
			window.addEventListener( "load", completed );
		}
	}
	return readyList.promise( obj );
};

// Kick off the DOM ready check even if the user does not
jQuery.ready.promise();




// Multifunctional method to get and set values of a collection
// The value/s can optionally be executed if it's a function
var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {
	var i = 0,
		len = elems.length,
		bulk = key == null;

	// Sets many values
	if ( jQuery.type( key ) === "object" ) {
		chainable = true;
		for ( i in key ) {
			access( elems, fn, i, key[ i ], true, emptyGet, raw );
		}

	// Sets one value
	} else if ( value !== undefined ) {
		chainable = true;

		if ( !jQuery.isFunction( value ) ) {
			raw = true;
		}

		if ( bulk ) {

			// Bulk operations run against the entire set
			if ( raw ) {
				fn.call( elems, value );
				fn = null;

			// ...except when executing function values
			} else {
				bulk = fn;
				fn = function( elem, key, value ) {
					return bulk.call( jQuery( elem ), value );
				};
			}
		}

		if ( fn ) {
			for ( ; i < len; i++ ) {
				fn(
					elems[ i ], key, raw ?
					value :
					value.call( elems[ i ], i, fn( elems[ i ], key ) )
				);
			}
		}
	}

	return chainable ?
		elems :

		// Gets
		bulk ?
			fn.call( elems ) :
			len ? fn( elems[ 0 ], key ) : emptyGet;
};
var acceptData = function( owner ) {

	// Accepts only:
	//  - Node
	//    - Node.ELEMENT_NODE
	//    - Node.DOCUMENT_NODE
	//  - Object
	//    - Any
	/* jshint -W018 */
	return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );
};




function Data() {
	this.expando = jQuery.expando + Data.uid++;
}

Data.uid = 1;

Data.prototype = {

	register: function( owner, initial ) {
		var value = initial || {};

		// If it is a node unlikely to be stringify-ed or looped over
		// use plain assignment
		if ( owner.nodeType ) {
			owner[ this.expando ] = value;

		// Otherwise secure it in a non-enumerable, non-writable property
		// configurability must be true to allow the property to be
		// deleted with the delete operator
		} else {
			Object.defineProperty( owner, this.expando, {
				value: value,
				writable: true,
				configurable: true
			} );
		}
		return owner[ this.expando ];
	},
	cache: function( owner ) {

		// We can accept data for non-element nodes in modern browsers,
		// but we should not, see #8335.
		// Always return an empty object.
		if ( !acceptData( owner ) ) {
			return {};
		}

		// Check if the owner object already has a cache
		var value = owner[ this.expando ];

		// If not, create one
		if ( !value ) {
			value = {};

			// We can accept data for non-element nodes in modern browsers,
			// but we should not, see #8335.
			// Always return an empty object.
			if ( acceptData( owner ) ) {

				// If it is a node unlikely to be stringify-ed or looped over
				// use plain assignment
				if ( owner.nodeType ) {
					owner[ this.expando ] = value;

				// Otherwise secure it in a non-enumerable property
				// configurable must be true to allow the property to be
				// deleted when data is removed
				} else {
					Object.defineProperty( owner, this.expando, {
						value: value,
						configurable: true
					} );
				}
			}
		}

		return value;
	},
	set: function( owner, data, value ) {
		var prop,
			cache = this.cache( owner );

		// Handle: [ owner, key, value ] args
		if ( typeof data === "string" ) {
			cache[ data ] = value;

		// Handle: [ owner, { properties } ] args
		} else {

			// Copy the properties one-by-one to the cache object
			for ( prop in data ) {
				cache[ prop ] = data[ prop ];
			}
		}
		return cache;
	},
	get: function( owner, key ) {
		return key === undefined ?
			this.cache( owner ) :
			owner[ this.expando ] && owner[ this.expando ][ key ];
	},
	access: function( owner, key, value ) {
		var stored;

		// In cases where either:
		//
		//   1. No key was specified
		//   2. A string key was specified, but no value provided
		//
		// Take the "read" path and allow the get method to determine
		// which value to return, respectively either:
		//
		//   1. The entire cache object
		//   2. The data stored at the key
		//
		if ( key === undefined ||
				( ( key && typeof key === "string" ) && value === undefined ) ) {

			stored = this.get( owner, key );

			return stored !== undefined ?
				stored : this.get( owner, jQuery.camelCase( key ) );
		}

		// When the key is not a string, or both a key and value
		// are specified, set or extend (existing objects) with either:
		//
		//   1. An object of properties
		//   2. A key and value
		//
		this.set( owner, key, value );

		// Since the "set" path can have two possible entry points
		// return the expected data based on which path was taken[*]
		return value !== undefined ? value : key;
	},
	remove: function( owner, key ) {
		var i, name, camel,
			cache = owner[ this.expando ];

		if ( cache === undefined ) {
			return;
		}

		if ( key === undefined ) {
			this.register( owner );

		} else {

			// Support array or space separated string of keys
			if ( jQuery.isArray( key ) ) {

				// If "name" is an array of keys...
				// When data is initially created, via ("key", "val") signature,
				// keys will be converted to camelCase.
				// Since there is no way to tell _how_ a key was added, remove
				// both plain key and camelCase key. #12786
				// This will only penalize the array argument path.
				name = key.concat( key.map( jQuery.camelCase ) );
			} else {
				camel = jQuery.camelCase( key );

				// Try the string as a key before any manipulation
				if ( key in cache ) {
					name = [ key, camel ];
				} else {

					// If a key with the spaces exists, use it.
					// Otherwise, create an array by matching non-whitespace
					name = camel;
					name = name in cache ?
						[ name ] : ( name.match( rnotwhite ) || [] );
				}
			}

			i = name.length;

			while ( i-- ) {
				delete cache[ name[ i ] ];
			}
		}

		// Remove the expando if there's no more data
		if ( key === undefined || jQuery.isEmptyObject( cache ) ) {

			// Support: Chrome <= 35-45+
			// Webkit & Blink performance suffers when deleting properties
			// from DOM nodes, so set to undefined instead
			// https://code.google.com/p/chromium/issues/detail?id=378607
			if ( owner.nodeType ) {
				owner[ this.expando ] = undefined;
			} else {
				delete owner[ this.expando ];
			}
		}
	},
	hasData: function( owner ) {
		var cache = owner[ this.expando ];
		return cache !== undefined && !jQuery.isEmptyObject( cache );
	}
};
var dataPriv = new Data();

var dataUser = new Data();



//	Implementation Summary
//
//	1. Enforce API surface and semantic compatibility with 1.9.x branch
//	2. Improve the module's maintainability by reducing the storage
//		paths to a single mechanism.
//	3. Use the same single mechanism to support "private" and "user" data.
//	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
//	5. Avoid exposing implementation details on user objects (eg. expando properties)
//	6. Provide a clear path for implementation upgrade to WeakMap in 2014

var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
	rmultiDash = /[A-Z]/g;

function dataAttr( elem, key, data ) {
	var name;

	// If nothing was found internally, try to fetch any
	// data from the HTML5 data-* attribute
	if ( data === undefined && elem.nodeType === 1 ) {
		name = "data-" + key.replace( rmultiDash, "-$&" ).toLowerCase();
		data = elem.getAttribute( name );

		if ( typeof data === "string" ) {
			try {
				data = data === "true" ? true :
					data === "false" ? false :
					data === "null" ? null :

					// Only convert to a number if it doesn't change the string
					+data + "" === data ? +data :
					rbrace.test( data ) ? jQuery.parseJSON( data ) :
					data;
			} catch ( e ) {}

			// Make sure we set the data so it isn't changed later
			dataUser.set( elem, key, data );
		} else {
			data = undefined;
		}
	}
	return data;
}

jQuery.extend( {
	hasData: function( elem ) {
		return dataUser.hasData( elem ) || dataPriv.hasData( elem );
	},

	data: function( elem, name, data ) {
		return dataUser.access( elem, name, data );
	},

	removeData: function( elem, name ) {
		dataUser.remove( elem, name );
	},

	// TODO: Now that all calls to _data and _removeData have been replaced
	// with direct calls to dataPriv methods, these can be deprecated.
	_data: function( elem, name, data ) {
		return dataPriv.access( elem, name, data );
	},

	_removeData: function( elem, name ) {
		dataPriv.remove( elem, name );
	}
} );

jQuery.fn.extend( {
	data: function( key, value ) {
		var i, name, data,
			elem = this[ 0 ],
			attrs = elem && elem.attributes;

		// Gets all values
		if ( key === undefined ) {
			if ( this.length ) {
				data = dataUser.get( elem );

				if ( elem.nodeType === 1 && !dataPriv.get( elem, "hasDataAttrs" ) ) {
					i = attrs.length;
					while ( i-- ) {

						// Support: IE11+
						// The attrs elements can be null (#14894)
						if ( attrs[ i ] ) {
							name = attrs[ i ].name;
							if ( name.indexOf( "data-" ) === 0 ) {
								name = jQuery.camelCase( name.slice( 5 ) );
								dataAttr( elem, name, data[ name ] );
							}
						}
					}
					dataPriv.set( elem, "hasDataAttrs", true );
				}
			}

			return data;
		}

		// Sets multiple values
		if ( typeof key === "object" ) {
			return this.each( function() {
				dataUser.set( this, key );
			} );
		}

		return access( this, function( value ) {
			var data, camelKey;

			// The calling jQuery object (element matches) is not empty
			// (and therefore has an element appears at this[ 0 ]) and the
			// `value` parameter was not undefined. An empty jQuery object
			// will result in `undefined` for elem = this[ 0 ] which will
			// throw an exception if an attempt to read a data cache is made.
			if ( elem && value === undefined ) {

				// Attempt to get data from the cache
				// with the key as-is
				data = dataUser.get( elem, key ) ||

					// Try to find dashed key if it exists (gh-2779)
					// This is for 2.2.x only
					dataUser.get( elem, key.replace( rmultiDash, "-$&" ).toLowerCase() );

				if ( data !== undefined ) {
					return data;
				}

				camelKey = jQuery.camelCase( key );

				// Attempt to get data from the cache
				// with the key camelized
				data = dataUser.get( elem, camelKey );
				if ( data !== undefined ) {
					return data;
				}

				// Attempt to "discover" the data in
				// HTML5 custom data-* attrs
				data = dataAttr( elem, camelKey, undefined );
				if ( data !== undefined ) {
					return data;
				}

				// We tried really hard, but the data doesn't exist.
				return;
			}

			// Set the data...
			camelKey = jQuery.camelCase( key );
			this.each( function() {

				// First, attempt to store a copy or reference of any
				// data that might've been store with a camelCased key.
				var data = dataUser.get( this, camelKey );

				// For HTML5 data-* attribute interop, we have to
				// store property names with dashes in a camelCase form.
				// This might not apply to all properties...*
				dataUser.set( this, camelKey, value );

				// *... In the case of properties that might _actually_
				// have dashes, we need to also store a copy of that
				// unchanged property.
				if ( key.indexOf( "-" ) > -1 && data !== undefined ) {
					dataUser.set( this, key, value );
				}
			} );
		}, null, value, arguments.length > 1, null, true );
	},

	removeData: function( key ) {
		return this.each( function() {
			dataUser.remove( this, key );
		} );
	}
} );


jQuery.extend( {
	queue: function( elem, type, data ) {
		var queue;

		if ( elem ) {
			type = ( type || "fx" ) + "queue";
			queue = dataPriv.get( elem, type );

			// Speed up dequeue by getting out quickly if this is just a lookup
			if ( data ) {
				if ( !queue || jQuery.isArray( data ) ) {
					queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );
				} else {
					queue.push( data );
				}
			}
			return queue || [];
		}
	},

	dequeue: function( elem, type ) {
		type = type || "fx";

		var queue = jQuery.queue( elem, type ),
			startLength = queue.length,
			fn = queue.shift(),
			hooks = jQuery._queueHooks( elem, type ),
			next = function() {
				jQuery.dequeue( elem, type );
			};

		// If the fx queue is dequeued, always remove the progress sentinel
		if ( fn === "inprogress" ) {
			fn = queue.shift();
			startLength--;
		}

		if ( fn ) {

			// Add a progress sentinel to prevent the fx queue from being
			// automatically dequeued
			if ( type === "fx" ) {
				queue.unshift( "inprogress" );
			}

			// Clear up the last queue stop function
			delete hooks.stop;
			fn.call( elem, next, hooks );
		}

		if ( !startLength && hooks ) {
			hooks.empty.fire();
		}
	},

	// Not public - generate a queueHooks object, or return the current one
	_queueHooks: function( elem, type ) {
		var key = type + "queueHooks";
		return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {
			empty: jQuery.Callbacks( "once memory" ).add( function() {
				dataPriv.remove( elem, [ type + "queue", key ] );
			} )
		} );
	}
} );

jQuery.fn.extend( {
	queue: function( type, data ) {
		var setter = 2;

		if ( typeof type !== "string" ) {
			data = type;
			type = "fx";
			setter--;
		}

		if ( arguments.length < setter ) {
			return jQuery.queue( this[ 0 ], type );
		}

		return data === undefined ?
			this :
			this.each( function() {
				var queue = jQuery.queue( this, type, data );

				// Ensure a hooks for this queue
				jQuery._queueHooks( this, type );

				if ( type === "fx" && queue[ 0 ] !== "inprogress" ) {
					jQuery.dequeue( this, type );
				}
			} );
	},
	dequeue: function( type ) {
		return this.each( function() {
			jQuery.dequeue( this, type );
		} );
	},
	clearQueue: function( type ) {
		return this.queue( type || "fx", [] );
	},

	// Get a promise resolved when queues of a certain type
	// are emptied (fx is the type by default)
	promise: function( type, obj ) {
		var tmp,
			count = 1,
			defer = jQuery.Deferred(),
			elements = this,
			i = this.length,
			resolve = function() {
				if ( !( --count ) ) {
					defer.resolveWith( elements, [ elements ] );
				}
			};

		if ( typeof type !== "string" ) {
			obj = type;
			type = undefined;
		}
		type = type || "fx";

		while ( i-- ) {
			tmp = dataPriv.get( elements[ i ], type + "queueHooks" );
			if ( tmp && tmp.empty ) {
				count++;
				tmp.empty.add( resolve );
			}
		}
		resolve();
		return defer.promise( obj );
	}
} );
var pnum = ( /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/ ).source;

var rcssNum = new RegExp( "^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i" );


var cssExpand = [ "Top", "Right", "Bottom", "Left" ];

var isHidden = function( elem, el ) {

		// isHidden might be called from jQuery#filter function;
		// in that case, element will be second argument
		elem = el || elem;
		return jQuery.css( elem, "display" ) === "none" ||
			!jQuery.contains( elem.ownerDocument, elem );
	};



function adjustCSS( elem, prop, valueParts, tween ) {
	var adjusted,
		scale = 1,
		maxIterations = 20,
		currentValue = tween ?
			function() { return tween.cur(); } :
			function() { return jQuery.css( elem, prop, "" ); },
		initial = currentValue(),
		unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? "" : "px" ),

		// Starting value computation is required for potential unit mismatches
		initialInUnit = ( jQuery.cssNumber[ prop ] || unit !== "px" && +initial ) &&
			rcssNum.exec( jQuery.css( elem, prop ) );

	if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {

		// Trust units reported by jQuery.css
		unit = unit || initialInUnit[ 3 ];

		// Make sure we update the tween properties later on
		valueParts = valueParts || [];

		// Iteratively approximate from a nonzero starting point
		initialInUnit = +initial || 1;

		do {

			// If previous iteration zeroed out, double until we get *something*.
			// Use string for doubling so we don't accidentally see scale as unchanged below
			scale = scale || ".5";

			// Adjust and apply
			initialInUnit = initialInUnit / scale;
			jQuery.style( elem, prop, initialInUnit + unit );

		// Update scale, tolerating zero or NaN from tween.cur()
		// Break the loop if scale is unchanged or perfect, or if we've just had enough.
		} while (
			scale !== ( scale = currentValue() / initial ) && scale !== 1 && --maxIterations
		);
	}

	if ( valueParts ) {
		initialInUnit = +initialInUnit || +initial || 0;

		// Apply relative offset (+=/-=) if specified
		adjusted = valueParts[ 1 ] ?
			initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :
			+valueParts[ 2 ];
		if ( tween ) {
			tween.unit = unit;
			tween.start = initialInUnit;
			tween.end = adjusted;
		}
	}
	return adjusted;
}
var rcheckableType = ( /^(?:checkbox|radio)$/i );

var rtagName = ( /<([\w:-]+)/ );

var rscriptType = ( /^$|\/(?:java|ecma)script/i );



// We have to close these tags to support XHTML (#13200)
var wrapMap = {

	// Support: IE9
	option: [ 1, "<select multiple='multiple'>", "</select>" ],

	// XHTML parsers do not magically insert elements in the
	// same way that tag soup parsers do. So we cannot shorten
	// this by omitting <tbody> or other required elements.
	thead: [ 1, "<table>", "</table>" ],
	col: [ 2, "<table><colgroup>", "</colgroup></table>" ],
	tr: [ 2, "<table><tbody>", "</tbody></table>" ],
	td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],

	_default: [ 0, "", "" ]
};

// Support: IE9
wrapMap.optgroup = wrapMap.option;

wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
wrapMap.th = wrapMap.td;


function getAll( context, tag ) {

	// Support: IE9-11+
	// Use typeof to avoid zero-argument method invocation on host objects (#15151)
	var ret = typeof context.getElementsByTagName !== "undefined" ?
			context.getElementsByTagName( tag || "*" ) :
			typeof context.querySelectorAll !== "undefined" ?
				context.querySelectorAll( tag || "*" ) :
			[];

	return tag === undefined || tag && jQuery.nodeName( context, tag ) ?
		jQuery.merge( [ context ], ret ) :
		ret;
}


// Mark scripts as having already been evaluated
function setGlobalEval( elems, refElements ) {
	var i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		dataPriv.set(
			elems[ i ],
			"globalEval",
			!refElements || dataPriv.get( refElements[ i ], "globalEval" )
		);
	}
}


var rhtml = /<|&#?\w+;/;

function buildFragment( elems, context, scripts, selection, ignored ) {
	var elem, tmp, tag, wrap, contains, j,
		fragment = context.createDocumentFragment(),
		nodes = [],
		i = 0,
		l = elems.length;

	for ( ; i < l; i++ ) {
		elem = elems[ i ];

		if ( elem || elem === 0 ) {

			// Add nodes directly
			if ( jQuery.type( elem ) === "object" ) {

				// Support: Android<4.1, PhantomJS<2
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );

			// Convert non-html into a text node
			} else if ( !rhtml.test( elem ) ) {
				nodes.push( context.createTextNode( elem ) );

			// Convert html into DOM nodes
			} else {
				tmp = tmp || fragment.appendChild( context.createElement( "div" ) );

				// Deserialize a standard representation
				tag = ( rtagName.exec( elem ) || [ "", "" ] )[ 1 ].toLowerCase();
				wrap = wrapMap[ tag ] || wrapMap._default;
				tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];

				// Descend through wrappers to the right content
				j = wrap[ 0 ];
				while ( j-- ) {
					tmp = tmp.lastChild;
				}

				// Support: Android<4.1, PhantomJS<2
				// push.apply(_, arraylike) throws on ancient WebKit
				jQuery.merge( nodes, tmp.childNodes );

				// Remember the top-level container
				tmp = fragment.firstChild;

				// Ensure the created nodes are orphaned (#12392)
				tmp.textContent = "";
			}
		}
	}

	// Remove wrapper from fragment
	fragment.textContent = "";

	i = 0;
	while ( ( elem = nodes[ i++ ] ) ) {

		// Skip elements already in the context collection (trac-4087)
		if ( selection && jQuery.inArray( elem, selection ) > -1 ) {
			if ( ignored ) {
				ignored.push( elem );
			}
			continue;
		}

		contains = jQuery.contains( elem.ownerDocument, elem );

		// Append to fragment
		tmp = getAll( fragment.appendChild( elem ), "script" );

		// Preserve script evaluation history
		if ( contains ) {
			setGlobalEval( tmp );
		}

		// Capture executables
		if ( scripts ) {
			j = 0;
			while ( ( elem = tmp[ j++ ] ) ) {
				if ( rscriptType.test( elem.type || "" ) ) {
					scripts.push( elem );
				}
			}
		}
	}

	return fragment;
}


( function() {
	var fragment = document.createDocumentFragment(),
		div = fragment.appendChild( document.createElement( "div" ) ),
		input = document.createElement( "input" );

	// Support: Android 4.0-4.3, Safari<=5.1
	// Check state lost if the name is set (#11217)
	// Support: Windows Web Apps (WWA)
	// `name` and `type` must use .setAttribute for WWA (#14901)
	input.setAttribute( "type", "radio" );
	input.setAttribute( "checked", "checked" );
	input.setAttribute( "name", "t" );

	div.appendChild( input );

	// Support: Safari<=5.1, Android<4.2
	// Older WebKit doesn't clone checked state correctly in fragments
	support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;

	// Support: IE<=11+
	// Make sure textarea (and checkbox) defaultValue is properly cloned
	div.innerHTML = "<textarea>x</textarea>";
	support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;
} )();


var
	rkeyEvent = /^key/,
	rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/,
	rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

function returnTrue() {
	return true;
}

function returnFalse() {
	return false;
}

// Support: IE9
// See #13393 for more info
function safeActiveElement() {
	try {
		return document.activeElement;
	} catch ( err ) { }
}

function on( elem, types, selector, data, fn, one ) {
	var origFn, type;

	// Types can be a map of types/handlers
	if ( typeof types === "object" ) {

		// ( types-Object, selector, data )
		if ( typeof selector !== "string" ) {

			// ( types-Object, data )
			data = data || selector;
			selector = undefined;
		}
		for ( type in types ) {
			on( elem, type, selector, data, types[ type ], one );
		}
		return elem;
	}

	if ( data == null && fn == null ) {

		// ( types, fn )
		fn = selector;
		data = selector = undefined;
	} else if ( fn == null ) {
		if ( typeof selector === "string" ) {

			// ( types, selector, fn )
			fn = data;
			data = undefined;
		} else {

			// ( types, data, fn )
			fn = data;
			data = selector;
			selector = undefined;
		}
	}
	if ( fn === false ) {
		fn = returnFalse;
	} else if ( !fn ) {
		return elem;
	}

	if ( one === 1 ) {
		origFn = fn;
		fn = function( event ) {

			// Can use an empty set, since event contains the info
			jQuery().off( event );
			return origFn.apply( this, arguments );
		};

		// Use same guid so caller can remove using origFn
		fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );
	}
	return elem.each( function() {
		jQuery.event.add( this, types, fn, data, selector );
	} );
}

/*
 * Helper functions for managing events -- not part of the public interface.
 * Props to Dean Edwards' addEvent library for many of the ideas.
 */
jQuery.event = {

	global: {},

	add: function( elem, types, handler, data, selector ) {

		var handleObjIn, eventHandle, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.get( elem );

		// Don't attach events to noData or text/comment nodes (but allow plain objects)
		if ( !elemData ) {
			return;
		}

		// Caller can pass in an object of custom data in lieu of the handler
		if ( handler.handler ) {
			handleObjIn = handler;
			handler = handleObjIn.handler;
			selector = handleObjIn.selector;
		}

		// Make sure that the handler has a unique ID, used to find/remove it later
		if ( !handler.guid ) {
			handler.guid = jQuery.guid++;
		}

		// Init the element's event structure and main handler, if this is the first
		if ( !( events = elemData.events ) ) {
			events = elemData.events = {};
		}
		if ( !( eventHandle = elemData.handle ) ) {
			eventHandle = elemData.handle = function( e ) {

				// Discard the second event of a jQuery.event.trigger() and
				// when an event is called after a page has unloaded
				return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ?
					jQuery.event.dispatch.apply( elem, arguments ) : undefined;
			};
		}

		// Handle multiple events separated by a space
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// There *must* be a type, no attaching namespace-only handlers
			if ( !type ) {
				continue;
			}

			// If event changes its type, use the special event handlers for the changed type
			special = jQuery.event.special[ type ] || {};

			// If selector defined, determine special event api type, otherwise given type
			type = ( selector ? special.delegateType : special.bindType ) || type;

			// Update special based on newly reset type
			special = jQuery.event.special[ type ] || {};

			// handleObj is passed to all event handlers
			handleObj = jQuery.extend( {
				type: type,
				origType: origType,
				data: data,
				handler: handler,
				guid: handler.guid,
				selector: selector,
				needsContext: selector && jQuery.expr.match.needsContext.test( selector ),
				namespace: namespaces.join( "." )
			}, handleObjIn );

			// Init the event handler queue if we're the first
			if ( !( handlers = events[ type ] ) ) {
				handlers = events[ type ] = [];
				handlers.delegateCount = 0;

				// Only use addEventListener if the special events handler returns false
				if ( !special.setup ||
					special.setup.call( elem, data, namespaces, eventHandle ) === false ) {

					if ( elem.addEventListener ) {
						elem.addEventListener( type, eventHandle );
					}
				}
			}

			if ( special.add ) {
				special.add.call( elem, handleObj );

				if ( !handleObj.handler.guid ) {
					handleObj.handler.guid = handler.guid;
				}
			}

			// Add to the element's handler list, delegates in front
			if ( selector ) {
				handlers.splice( handlers.delegateCount++, 0, handleObj );
			} else {
				handlers.push( handleObj );
			}

			// Keep track of which events have ever been used, for event optimization
			jQuery.event.global[ type ] = true;
		}

	},

	// Detach an event or set of events from an element
	remove: function( elem, types, handler, selector, mappedTypes ) {

		var j, origCount, tmp,
			events, t, handleObj,
			special, handlers, type, namespaces, origType,
			elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );

		if ( !elemData || !( events = elemData.events ) ) {
			return;
		}

		// Once for each type.namespace in types; type may be omitted
		types = ( types || "" ).match( rnotwhite ) || [ "" ];
		t = types.length;
		while ( t-- ) {
			tmp = rtypenamespace.exec( types[ t ] ) || [];
			type = origType = tmp[ 1 ];
			namespaces = ( tmp[ 2 ] || "" ).split( "." ).sort();

			// Unbind all events (on this namespace, if provided) for the element
			if ( !type ) {
				for ( type in events ) {
					jQuery.event.remove( elem, type + types[ t ], handler, selector, true );
				}
				continue;
			}

			special = jQuery.event.special[ type ] || {};
			type = ( selector ? special.delegateType : special.bindType ) || type;
			handlers = events[ type ] || [];
			tmp = tmp[ 2 ] &&
				new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" );

			// Remove matching events
			origCount = j = handlers.length;
			while ( j-- ) {
				handleObj = handlers[ j ];

				if ( ( mappedTypes || origType === handleObj.origType ) &&
					( !handler || handler.guid === handleObj.guid ) &&
					( !tmp || tmp.test( handleObj.namespace ) ) &&
					( !selector || selector === handleObj.selector ||
						selector === "**" && handleObj.selector ) ) {
					handlers.splice( j, 1 );

					if ( handleObj.selector ) {
						handlers.delegateCount--;
					}
					if ( special.remove ) {
						special.remove.call( elem, handleObj );
					}
				}
			}

			// Remove generic event handler if we removed something and no more handlers exist
			// (avoids potential for endless recursion during removal of special event handlers)
			if ( origCount && !handlers.length ) {
				if ( !special.teardown ||
					special.teardown.call( elem, namespaces, elemData.handle ) === false ) {

					jQuery.removeEvent( elem, type, elemData.handle );
				}

				delete events[ type ];
			}
		}

		// Remove data and the expando if it's no longer used
		if ( jQuery.isEmptyObject( events ) ) {
			dataPriv.remove( elem, "handle events" );
		}
	},

	dispatch: function( event ) {

		// Make a writable jQuery.Event from the native event object
		event = jQuery.event.fix( event );

		var i, j, ret, matched, handleObj,
			handlerQueue = [],
			args = slice.call( arguments ),
			handlers = ( dataPriv.get( this, "events" ) || {} )[ event.type ] || [],
			special = jQuery.event.special[ event.type ] || {};

		// Use the fix-ed jQuery.Event rather than the (read-only) native event
		args[ 0 ] = event;
		event.delegateTarget = this;

		// Call the preDispatch hook for the mapped type, and let it bail if desired
		if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {
			return;
		}

		// Determine handlers
		handlerQueue = jQuery.event.handlers.call( this, event, handlers );

		// Run delegates first; they may want to stop propagation beneath us
		i = 0;
		while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {
			event.currentTarget = matched.elem;

			j = 0;
			while ( ( handleObj = matched.handlers[ j++ ] ) &&
				!event.isImmediatePropagationStopped() ) {

				// Triggered event must either 1) have no namespace, or 2) have namespace(s)
				// a subset or equal to those in the bound event (both can have no namespace).
				if ( !event.rnamespace || event.rnamespace.test( handleObj.namespace ) ) {

					event.handleObj = handleObj;
					event.data = handleObj.data;

					ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||
						handleObj.handler ).apply( matched.elem, args );

					if ( ret !== undefined ) {
						if ( ( event.result = ret ) === false ) {
							event.preventDefault();
							event.stopPropagation();
						}
					}
				}
			}
		}

		// Call the postDispatch hook for the mapped type
		if ( special.postDispatch ) {
			special.postDispatch.call( this, event );
		}

		return event.result;
	},

	handlers: function( event, handlers ) {
		var i, matches, sel, handleObj,
			handlerQueue = [],
			delegateCount = handlers.delegateCount,
			cur = event.target;

		// Support (at least): Chrome, IE9
		// Find delegate handlers
		// Black-hole SVG <use> instance trees (#13180)
		//
		// Support: Firefox<=42+
		// Avoid non-left-click in FF but don't block IE radio events (#3861, gh-2343)
		if ( delegateCount && cur.nodeType &&
			( event.type !== "click" || isNaN( event.button ) || event.button < 1 ) ) {

			for ( ; cur !== this; cur = cur.parentNode || this ) {

				// Don't check non-elements (#13208)
				// Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
				if ( cur.nodeType === 1 && ( cur.disabled !== true || event.type !== "click" ) ) {
					matches = [];
					for ( i = 0; i < delegateCount; i++ ) {
						handleObj = handlers[ i ];

						// Don't conflict with Object.prototype properties (#13203)
						sel = handleObj.selector + " ";

						if ( matches[ sel ] === undefined ) {
							matches[ sel ] = handleObj.needsContext ?
								jQuery( sel, this ).index( cur ) > -1 :
								jQuery.find( sel, this, null, [ cur ] ).length;
						}
						if ( matches[ sel ] ) {
							matches.push( handleObj );
						}
					}
					if ( matches.length ) {
						handlerQueue.push( { elem: cur, handlers: matches } );
					}
				}
			}
		}

		// Add the remaining (directly-bound) handlers
		if ( delegateCount < handlers.length ) {
			handlerQueue.push( { elem: this, handlers: handlers.slice( delegateCount ) } );
		}

		return handlerQueue;
	},

	// Includes some event props shared by KeyEvent and MouseEvent
	props: ( "altKey bubbles cancelable ctrlKey currentTarget detail eventPhase " +
		"metaKey relatedTarget shiftKey target timeStamp view which" ).split( " " ),

	fixHooks: {},

	keyHooks: {
		props: "char charCode key keyCode".split( " " ),
		filter: function( event, original ) {

			// Add which for key events
			if ( event.which == null ) {
				event.which = original.charCode != null ? original.charCode : original.keyCode;
			}

			return event;
		}
	},

	mouseHooks: {
		props: ( "button buttons clientX clientY offsetX offsetY pageX pageY " +
			"screenX screenY toElement" ).split( " " ),
		filter: function( event, original ) {
			var eventDoc, doc, body,
				button = original.button;

			// Calculate pageX/Y if missing and clientX/Y available
			if ( event.pageX == null && original.clientX != null ) {
				eventDoc = event.target.ownerDocument || document;
				doc = eventDoc.documentElement;
				body = eventDoc.body;

				event.pageX = original.clientX +
					( doc && doc.scrollLeft || body && body.scrollLeft || 0 ) -
					( doc && doc.clientLeft || body && body.clientLeft || 0 );
				event.pageY = original.clientY +
					( doc && doc.scrollTop  || body && body.scrollTop  || 0 ) -
					( doc && doc.clientTop  || body && body.clientTop  || 0 );
			}

			// Add which for click: 1 === left; 2 === middle; 3 === right
			// Note: button is not normalized, so don't use it
			if ( !event.which && button !== undefined ) {
				event.which = ( button & 1 ? 1 : ( button & 2 ? 3 : ( button & 4 ? 2 : 0 ) ) );
			}

			return event;
		}
	},

	fix: function( event ) {
		if ( event[ jQuery.expando ] ) {
			return event;
		}

		// Create a writable copy of the event object and normalize some properties
		var i, prop, copy,
			type = event.type,
			originalEvent = event,
			fixHook = this.fixHooks[ type ];

		if ( !fixHook ) {
			this.fixHooks[ type ] = fixHook =
				rmouseEvent.test( type ) ? this.mouseHooks :
				rkeyEvent.test( type ) ? this.keyHooks :
				{};
		}
		copy = fixHook.props ? this.props.concat( fixHook.props ) : this.props;

		event = new jQuery.Event( originalEvent );

		i = copy.length;
		while ( i-- ) {
			prop = copy[ i ];
			event[ prop ] = originalEvent[ prop ];
		}

		// Support: Cordova 2.5 (WebKit) (#13255)
		// All events should have a target; Cordova deviceready doesn't
		if ( !event.target ) {
			event.target = document;
		}

		// Support: Safari 6.0+, Chrome<28
		// Target should not be a text node (#504, #13143)
		if ( event.target.nodeType === 3 ) {
			event.target = event.target.parentNode;
		}

		return fixHook.filter ? fixHook.filter( event, originalEvent ) : event;
	},

	special: {
		load: {

			// Prevent triggered image.load events from bubbling to window.load
			noBubble: true
		},
		focus: {

			// Fire native event if possible so blur/focus sequence is correct
			trigger: function() {
				if ( this !== safeActiveElement() && this.focus ) {
					this.focus();
					return false;
				}
			},
			delegateType: "focusin"
		},
		blur: {
			trigger: function() {
				if ( this === safeActiveElement() && this.blur ) {
					this.blur();
					return false;
				}
			},
			delegateType: "focusout"
		},
		click: {

			// For checkbox, fire native event so checked state will be right
			trigger: function() {
				if ( this.type === "checkbox" && this.click && jQuery.nodeName( this, "input" ) ) {
					this.click();
					return false;
				}
			},

			// For cross-browser consistency, don't fire native .click() on links
			_default: function( event ) {
				return jQuery.nodeName( event.target, "a" );
			}
		},

		beforeunload: {
			postDispatch: function( event ) {

				// Support: Firefox 20+
				// Firefox doesn't alert if the returnValue field is not set.
				if ( event.result !== undefined && event.originalEvent ) {
					event.originalEvent.returnValue = event.result;
				}
			}
		}
	}
};

jQuery.removeEvent = function( elem, type, handle ) {

	// This "if" is needed for plain objects
	if ( elem.removeEventListener ) {
		elem.removeEventListener( type, handle );
	}
};

jQuery.Event = function( src, props ) {

	// Allow instantiation without the 'new' keyword
	if ( !( this instanceof jQuery.Event ) ) {
		return new jQuery.Event( src, props );
	}

	// Event object
	if ( src && src.type ) {
		this.originalEvent = src;
		this.type = src.type;

		// Events bubbling up the document may have been marked as prevented
		// by a handler lower down the tree; reflect the correct value.
		this.isDefaultPrevented = src.defaultPrevented ||
				src.defaultPrevented === undefined &&

				// Support: Android<4.0
				src.returnValue === false ?
			returnTrue :
			returnFalse;

	// Event type
	} else {
		this.type = src;
	}

	// Put explicitly provided properties onto the event object
	if ( props ) {
		jQuery.extend( this, props );
	}

	// Create a timestamp if incoming event doesn't have one
	this.timeStamp = src && src.timeStamp || jQuery.now();

	// Mark it as fixed
	this[ jQuery.expando ] = true;
};

// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
jQuery.Event.prototype = {
	constructor: jQuery.Event,
	isDefaultPrevented: returnFalse,
	isPropagationStopped: returnFalse,
	isImmediatePropagationStopped: returnFalse,

	preventDefault: function() {
		var e = this.originalEvent;

		this.isDefaultPrevented = returnTrue;

		if ( e ) {
			e.preventDefault();
		}
	},
	stopPropagation: function() {
		var e = this.originalEvent;

		this.isPropagationStopped = returnTrue;

		if ( e ) {
			e.stopPropagation();
		}
	},
	stopImmediatePropagation: function() {
		var e = this.originalEvent;

		this.isImmediatePropagationStopped = returnTrue;

		if ( e ) {
			e.stopImmediatePropagation();
		}

		this.stopPropagation();
	}
};

// Create mouseenter/leave events using mouseover/out and event-time checks
// so that event delegation works in jQuery.
// Do the same for pointerenter/pointerleave and pointerover/pointerout
//
// Support: Safari 7 only
// Safari sends mouseenter too often; see:
// https://code.google.com/p/chromium/issues/detail?id=470258
// for the description of the bug (it existed in older Chrome versions as well).
jQuery.each( {
	mouseenter: "mouseover",
	mouseleave: "mouseout",
	pointerenter: "pointerover",
	pointerleave: "pointerout"
}, function( orig, fix ) {
	jQuery.event.special[ orig ] = {
		delegateType: fix,
		bindType: fix,

		handle: function( event ) {
			var ret,
				target = this,
				related = event.relatedTarget,
				handleObj = event.handleObj;

			// For mouseenter/leave call the handler if related is outside the target.
			// NB: No relatedTarget if the mouse left/entered the browser window
			if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {
				event.type = handleObj.origType;
				ret = handleObj.handler.apply( this, arguments );
				event.type = fix;
			}
			return ret;
		}
	};
} );

jQuery.fn.extend( {
	on: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn );
	},
	one: function( types, selector, data, fn ) {
		return on( this, types, selector, data, fn, 1 );
	},
	off: function( types, selector, fn ) {
		var handleObj, type;
		if ( types && types.preventDefault && types.handleObj ) {

			// ( event )  dispatched jQuery.Event
			handleObj = types.handleObj;
			jQuery( types.delegateTarget ).off(
				handleObj.namespace ?
					handleObj.origType + "." + handleObj.namespace :
					handleObj.origType,
				handleObj.selector,
				handleObj.handler
			);
			return this;
		}
		if ( typeof types === "object" ) {

			// ( types-object [, selector] )
			for ( type in types ) {
				this.off( type, selector, types[ type ] );
			}
			return this;
		}
		if ( selector === false || typeof selector === "function" ) {

			// ( types [, fn] )
			fn = selector;
			selector = undefined;
		}
		if ( fn === false ) {
			fn = returnFalse;
		}
		return this.each( function() {
			jQuery.event.remove( this, types, fn, selector );
		} );
	}
} );


var
	rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:-]+)[^>]*)\/>/gi,

	// Support: IE 10-11, Edge 10240+
	// In IE/Edge using regex groups here causes severe slowdowns.
	// See https://connect.microsoft.com/IE/feedback/details/1736512/
	rnoInnerhtml = /<script|<style|<link/i,

	// checked="checked" or checked
	rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
	rscriptTypeMasked = /^true\/(.*)/,
	rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

// Manipulating tables requires a tbody
function manipulationTarget( elem, content ) {
	return jQuery.nodeName( elem, "table" ) &&
		jQuery.nodeName( content.nodeType !== 11 ? content : content.firstChild, "tr" ) ?

		elem.getElementsByTagName( "tbody" )[ 0 ] ||
			elem.appendChild( elem.ownerDocument.createElement( "tbody" ) ) :
		elem;
}

// Replace/restore the type attribute of script elements for safe DOM manipulation
function disableScript( elem ) {
	elem.type = ( elem.getAttribute( "type" ) !== null ) + "/" + elem.type;
	return elem;
}
function restoreScript( elem ) {
	var match = rscriptTypeMasked.exec( elem.type );

	if ( match ) {
		elem.type = match[ 1 ];
	} else {
		elem.removeAttribute( "type" );
	}

	return elem;
}

function cloneCopyEvent( src, dest ) {
	var i, l, type, pdataOld, pdataCur, udataOld, udataCur, events;

	if ( dest.nodeType !== 1 ) {
		return;
	}

	// 1. Copy private data: events, handlers, etc.
	if ( dataPriv.hasData( src ) ) {
		pdataOld = dataPriv.access( src );
		pdataCur = dataPriv.set( dest, pdataOld );
		events = pdataOld.events;

		if ( events ) {
			delete pdataCur.handle;
			pdataCur.events = {};

			for ( type in events ) {
				for ( i = 0, l = events[ type ].length; i < l; i++ ) {
					jQuery.event.add( dest, type, events[ type ][ i ] );
				}
			}
		}
	}

	// 2. Copy user data
	if ( dataUser.hasData( src ) ) {
		udataOld = dataUser.access( src );
		udataCur = jQuery.extend( {}, udataOld );

		dataUser.set( dest, udataCur );
	}
}

// Fix IE bugs, see support tests
function fixInput( src, dest ) {
	var nodeName = dest.nodeName.toLowerCase();

	// Fails to persist the checked state of a cloned checkbox or radio button.
	if ( nodeName === "input" && rcheckableType.test( src.type ) ) {
		dest.checked = src.checked;

	// Fails to return the selected option to the default selected state when cloning options
	} else if ( nodeName === "input" || nodeName === "textarea" ) {
		dest.defaultValue = src.defaultValue;
	}
}

function domManip( collection, args, callback, ignored ) {

	// Flatten any nested arrays
	args = concat.apply( [], args );

	var fragment, first, scripts, hasScripts, node, doc,
		i = 0,
		l = collection.length,
		iNoClone = l - 1,
		value = args[ 0 ],
		isFunction = jQuery.isFunction( value );

	// We can't cloneNode fragments that contain checked, in WebKit
	if ( isFunction ||
			( l > 1 && typeof value === "string" &&
				!support.checkClone && rchecked.test( value ) ) ) {
		return collection.each( function( index ) {
			var self = collection.eq( index );
			if ( isFunction ) {
				args[ 0 ] = value.call( this, index, self.html() );
			}
			domManip( self, args, callback, ignored );
		} );
	}

	if ( l ) {
		fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );
		first = fragment.firstChild;

		if ( fragment.childNodes.length === 1 ) {
			fragment = first;
		}

		// Require either new content or an interest in ignored elements to invoke the callback
		if ( first || ignored ) {
			scripts = jQuery.map( getAll( fragment, "script" ), disableScript );
			hasScripts = scripts.length;

			// Use the original fragment for the last item
			// instead of the first because it can end up
			// being emptied incorrectly in certain situations (#8070).
			for ( ; i < l; i++ ) {
				node = fragment;

				if ( i !== iNoClone ) {
					node = jQuery.clone( node, true, true );

					// Keep references to cloned scripts for later restoration
					if ( hasScripts ) {

						// Support: Android<4.1, PhantomJS<2
						// push.apply(_, arraylike) throws on ancient WebKit
						jQuery.merge( scripts, getAll( node, "script" ) );
					}
				}

				callback.call( collection[ i ], node, i );
			}

			if ( hasScripts ) {
				doc = scripts[ scripts.length - 1 ].ownerDocument;

				// Reenable scripts
				jQuery.map( scripts, restoreScript );

				// Evaluate executable scripts on first document insertion
				for ( i = 0; i < hasScripts; i++ ) {
					node = scripts[ i ];
					if ( rscriptType.test( node.type || "" ) &&
						!dataPriv.access( node, "globalEval" ) &&
						jQuery.contains( doc, node ) ) {

						if ( node.src ) {

							// Optional AJAX dependency, but won't run scripts if not present
							if ( jQuery._evalUrl ) {
								jQuery._evalUrl( node.src );
							}
						} else {
							jQuery.globalEval( node.textContent.replace( rcleanScript, "" ) );
						}
					}
				}
			}
		}
	}

	return collection;
}

function remove( elem, selector, keepData ) {
	var node,
		nodes = selector ? jQuery.filter( selector, elem ) : elem,
		i = 0;

	for ( ; ( node = nodes[ i ] ) != null; i++ ) {
		if ( !keepData && node.nodeType === 1 ) {
			jQuery.cleanData( getAll( node ) );
		}

		if ( node.parentNode ) {
			if ( keepData && jQuery.contains( node.ownerDocument, node ) ) {
				setGlobalEval( getAll( node, "script" ) );
			}
			node.parentNode.removeChild( node );
		}
	}

	return elem;
}

jQuery.extend( {
	htmlPrefilter: function( html ) {
		return html.replace( rxhtmlTag, "<$1></$2>" );
	},

	clone: function( elem, dataAndEvents, deepDataAndEvents ) {
		var i, l, srcElements, destElements,
			clone = elem.cloneNode( true ),
			inPage = jQuery.contains( elem.ownerDocument, elem );

		// Fix IE cloning issues
		if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&
				!jQuery.isXMLDoc( elem ) ) {

			// We eschew Sizzle here for performance reasons: http://jsperf.com/getall-vs-sizzle/2
			destElements = getAll( clone );
			srcElements = getAll( elem );

			for ( i = 0, l = srcElements.length; i < l; i++ ) {
				fixInput( srcElements[ i ], destElements[ i ] );
			}
		}

		// Copy the events from the original to the clone
		if ( dataAndEvents ) {
			if ( deepDataAndEvents ) {
				srcElements = srcElements || getAll( elem );
				destElements = destElements || getAll( clone );

				for ( i = 0, l = srcElements.length; i < l; i++ ) {
					cloneCopyEvent( srcElements[ i ], destElements[ i ] );
				}
			} else {
				cloneCopyEvent( elem, clone );
			}
		}

		// Preserve script evaluation history
		destElements = getAll( clone, "script" );
		if ( destElements.length > 0 ) {
			setGlobalEval( destElements, !inPage && getAll( elem, "script" ) );
		}

		// Return the cloned set
		return clone;
	},

	cleanData: function( elems ) {
		var data, elem, type,
			special = jQuery.event.special,
			i = 0;

		for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {
			if ( acceptData( elem ) ) {
				if ( ( data = elem[ dataPriv.expando ] ) ) {
					if ( data.events ) {
						for ( type in data.events ) {
							if ( special[ type ] ) {
								jQuery.event.remove( elem, type );

							// This is a shortcut to avoid jQuery.event.remove's overhead
							} else {
								jQuery.removeEvent( elem, type, data.handle );
							}
						}
					}

					// Support: Chrome <= 35-45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataPriv.expando ] = undefined;
				}
				if ( elem[ dataUser.expando ] ) {

					// Support: Chrome <= 35-45+
					// Assign undefined instead of using delete, see Data#remove
					elem[ dataUser.expando ] = undefined;
				}
			}
		}
	}
} );

jQuery.fn.extend( {

	// Keep domManip exposed until 3.0 (gh-2225)
	domManip: domManip,

	detach: function( selector ) {
		return remove( this, selector, true );
	},

	remove: function( selector ) {
		return remove( this, selector );
	},

	text: function( value ) {
		return access( this, function( value ) {
			return value === undefined ?
				jQuery.text( this ) :
				this.empty().each( function() {
					if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
						this.textContent = value;
					}
				} );
		}, null, value, arguments.length );
	},

	append: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.appendChild( elem );
			}
		} );
	},

	prepend: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {
				var target = manipulationTarget( this, elem );
				target.insertBefore( elem, target.firstChild );
			}
		} );
	},

	before: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this );
			}
		} );
	},

	after: function() {
		return domManip( this, arguments, function( elem ) {
			if ( this.parentNode ) {
				this.parentNode.insertBefore( elem, this.nextSibling );
			}
		} );
	},

	empty: function() {
		var elem,
			i = 0;

		for ( ; ( elem = this[ i ] ) != null; i++ ) {
			if ( elem.nodeType === 1 ) {

				// Prevent memory leaks
				jQuery.cleanData( getAll( elem, false ) );

				// Remove any remaining nodes
				elem.textContent = "";
			}
		}

		return this;
	},

	clone: function( dataAndEvents, deepDataAndEvents ) {
		dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
		deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

		return this.map( function() {
			return jQuery.clone( this, dataAndEvents, deepDataAndEvents );
		} );
	},

	html: function( value ) {
		return access( this, function( value ) {
			var elem = this[ 0 ] || {},
				i = 0,
				l = this.length;

			if ( value === undefined && elem.nodeType === 1 ) {
				return elem.innerHTML;
			}

			// See if we can take a shortcut and just use innerHTML
			if ( typeof value === "string" && !rnoInnerhtml.test( value ) &&
				!wrapMap[ ( rtagName.exec( value ) || [ "", "" ] )[ 1 ].toLowerCase() ] ) {

				value = jQuery.htmlPrefilter( value );

				try {
					for ( ; i < l; i++ ) {
						elem = this[ i ] || {};

						// Remove element nodes and prevent memory leaks
						if ( elem.nodeType === 1 ) {
							jQuery.cleanData( getAll( elem, false ) );
							elem.innerHTML = value;
						}
					}

					elem = 0;

				// If using innerHTML throws an exception, use the fallback method
				} catch ( e ) {}
			}

			if ( elem ) {
				this.empty().append( value );
			}
		}, null, value, arguments.length );
	},

	replaceWith: function() {
		var ignored = [];

		// Make the changes, replacing each non-ignored context element with the new content
		return domManip( this, arguments, function( elem ) {
			var parent = this.parentNode;

			if ( jQuery.inArray( this, ignored ) < 0 ) {
				jQuery.cleanData( getAll( this ) );
				if ( parent ) {
					parent.replaceChild( elem, this );
				}
			}

		// Force callback invocation
		}, ignored );
	}
} );

jQuery.each( {
	appendTo: "append",
	prependTo: "prepend",
	insertBefore: "before",
	insertAfter: "after",
	replaceAll: "replaceWith"
}, function( name, original ) {
	jQuery.fn[ name ] = function( selector ) {
		var elems,
			ret = [],
			insert = jQuery( selector ),
			last = insert.length - 1,
			i = 0;

		for ( ; i <= last; i++ ) {
			elems = i === last ? this : this.clone( true );
			jQuery( insert[ i ] )[ original ]( elems );

			// Support: QtWebKit
			// .get() because push.apply(_, arraylike) throws
			push.apply( ret, elems.get() );
		}

		return this.pushStack( ret );
	};
} );


var iframe,
	elemdisplay = {

		// Support: Firefox
		// We have to pre-define these values for FF (#10227)
		HTML: "block",
		BODY: "block"
	};

/**
 * Retrieve the actual display of a element
 * @param {String} name nodeName of the element
 * @param {Object} doc Document object
 */

// Called only from within defaultDisplay
function actualDisplay( name, doc ) {
	var elem = jQuery( doc.createElement( name ) ).appendTo( doc.body ),

		display = jQuery.css( elem[ 0 ], "display" );

	// We don't have any data stored on the element,
	// so use "detach" method as fast way to get rid of the element
	elem.detach();

	return display;
}

/**
 * Try to determine the default display value of an element
 * @param {String} nodeName
 */
function defaultDisplay( nodeName ) {
	var doc = document,
		display = elemdisplay[ nodeName ];

	if ( !display ) {
		display = actualDisplay( nodeName, doc );

		// If the simple way fails, read from inside an iframe
		if ( display === "none" || !display ) {

			// Use the already-created iframe if possible
			iframe = ( iframe || jQuery( "<iframe frameborder='0' width='0' height='0'/>" ) )
				.appendTo( doc.documentElement );

			// Always write a new HTML skeleton so Webkit and Firefox don't choke on reuse
			doc = iframe[ 0 ].contentDocument;

			// Support: IE
			doc.write();
			doc.close();

			display = actualDisplay( nodeName, doc );
			iframe.detach();
		}

		// Store the correct default display
		elemdisplay[ nodeName ] = display;
	}

	return display;
}
var rmargin = ( /^margin/ );

var rnumnonpx = new RegExp( "^(" + pnum + ")(?!px)[a-z%]+$", "i" );

var getStyles = function( elem ) {

		// Support: IE<=11+, Firefox<=30+ (#15098, #14150)
		// IE throws on elements created in popups
		// FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
		var view = elem.ownerDocument.defaultView;

		if ( !view || !view.opener ) {
			view = window;
		}

		return view.getComputedStyle( elem );
	};

var swap = function( elem, options, callback, args ) {
	var ret, name,
		old = {};

	// Remember the old values, and insert the new ones
	for ( name in options ) {
		old[ name ] = elem.style[ name ];
		elem.style[ name ] = options[ name ];
	}

	ret = callback.apply( elem, args || [] );

	// Revert the old values
	for ( name in options ) {
		elem.style[ name ] = old[ name ];
	}

	return ret;
};


var documentElement = document.documentElement;



( function() {
	var pixelPositionVal, boxSizingReliableVal, pixelMarginRightVal, reliableMarginLeftVal,
		container = document.createElement( "div" ),
		div = document.createElement( "div" );

	// Finish early in limited (non-browser) environments
	if ( !div.style ) {
		return;
	}

	// Support: IE9-11+
	// Style of cloned element affects source element cloned (#8908)
	div.style.backgroundClip = "content-box";
	div.cloneNode( true ).style.backgroundClip = "";
	support.clearCloneStyle = div.style.backgroundClip === "content-box";

	container.style.cssText = "border:0;width:8px;height:0;top:0;left:-9999px;" +
		"padding:0;margin-top:1px;position:absolute";
	container.appendChild( div );

	// Executing both pixelPosition & boxSizingReliable tests require only one layout
	// so they're executed at the same time to save the second computation.
	function computeStyleTests() {
		div.style.cssText =

			// Support: Firefox<29, Android 2.3
			// Vendor-prefix box-sizing
			"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;" +
			"position:relative;display:block;" +
			"margin:auto;border:1px;padding:1px;" +
			"top:1%;width:50%";
		div.innerHTML = "";
		documentElement.appendChild( container );

		var divStyle = window.getComputedStyle( div );
		pixelPositionVal = divStyle.top !== "1%";
		reliableMarginLeftVal = divStyle.marginLeft === "2px";
		boxSizingReliableVal = divStyle.width === "4px";

		// Support: Android 4.0 - 4.3 only
		// Some styles come back with percentage values, even though they shouldn't
		div.style.marginRight = "50%";
		pixelMarginRightVal = divStyle.marginRight === "4px";

		documentElement.removeChild( container );
	}

	jQuery.extend( support, {
		pixelPosition: function() {

			// This test is executed only once but we still do memoizing
			// since we can use the boxSizingReliable pre-computing.
			// No need to check if the test was already performed, though.
			computeStyleTests();
			return pixelPositionVal;
		},
		boxSizingReliable: function() {
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return boxSizingReliableVal;
		},
		pixelMarginRight: function() {

			// Support: Android 4.0-4.3
			// We're checking for boxSizingReliableVal here instead of pixelMarginRightVal
			// since that compresses better and they're computed together anyway.
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return pixelMarginRightVal;
		},
		reliableMarginLeft: function() {

			// Support: IE <=8 only, Android 4.0 - 4.3 only, Firefox <=3 - 37
			if ( boxSizingReliableVal == null ) {
				computeStyleTests();
			}
			return reliableMarginLeftVal;
		},
		reliableMarginRight: function() {

			// Support: Android 2.3
			// Check if div with explicit width and no margin-right incorrectly
			// gets computed margin-right based on width of container. (#3333)
			// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
			// This support function is only executed once so no memoizing is needed.
			var ret,
				marginDiv = div.appendChild( document.createElement( "div" ) );

			// Reset CSS: box-sizing; display; margin; border; padding
			marginDiv.style.cssText = div.style.cssText =

				// Support: Android 2.3
				// Vendor-prefix box-sizing
				"-webkit-box-sizing:content-box;box-sizing:content-box;" +
				"display:block;margin:0;border:0;padding:0";
			marginDiv.style.marginRight = marginDiv.style.width = "0";
			div.style.width = "1px";
			documentElement.appendChild( container );

			ret = !parseFloat( window.getComputedStyle( marginDiv ).marginRight );

			documentElement.removeChild( container );
			div.removeChild( marginDiv );

			return ret;
		}
	} );
} )();


function curCSS( elem, name, computed ) {
	var width, minWidth, maxWidth, ret,
		style = elem.style;

	computed = computed || getStyles( elem );
	ret = computed ? computed.getPropertyValue( name ) || computed[ name ] : undefined;

	// Support: Opera 12.1x only
	// Fall back to style even without computed
	// computed is undefined for elems on document fragments
	if ( ( ret === "" || ret === undefined ) && !jQuery.contains( elem.ownerDocument, elem ) ) {
		ret = jQuery.style( elem, name );
	}

	// Support: IE9
	// getPropertyValue is only needed for .css('filter') (#12537)
	if ( computed ) {

		// A tribute to the "awesome hack by Dean Edwards"
		// Android Browser returns percentage for some values,
		// but width seems to be reliably pixels.
		// This is against the CSSOM draft spec:
		// http://dev.w3.org/csswg/cssom/#resolved-values
		if ( !support.pixelMarginRight() && rnumnonpx.test( ret ) && rmargin.test( name ) ) {

			// Remember the original values
			width = style.width;
			minWidth = style.minWidth;
			maxWidth = style.maxWidth;

			// Put in the new values to get a computed value out
			style.minWidth = style.maxWidth = style.width = ret;
			ret = computed.width;

			// Revert the changed values
			style.width = width;
			style.minWidth = minWidth;
			style.maxWidth = maxWidth;
		}
	}

	return ret !== undefined ?

		// Support: IE9-11+
		// IE returns zIndex value as an integer.
		ret + "" :
		ret;
}


function addGetHookIf( conditionFn, hookFn ) {

	// Define the hook, we'll check on the first run if it's really needed.
	return {
		get: function() {
			if ( conditionFn() ) {

				// Hook not needed (or it's not possible to use it due
				// to missing dependency), remove it.
				delete this.get;
				return;
			}

			// Hook needed; redefine it so that the support test is not executed again.
			return ( this.get = hookFn ).apply( this, arguments );
		}
	};
}


var

	// Swappable if display is none or starts with table
	// except "table", "table-cell", or "table-caption"
	// See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
	rdisplayswap = /^(none|table(?!-c[ea]).+)/,

	cssShow = { position: "absolute", visibility: "hidden", display: "block" },
	cssNormalTransform = {
		letterSpacing: "0",
		fontWeight: "400"
	},

	cssPrefixes = [ "Webkit", "O", "Moz", "ms" ],
	emptyStyle = document.createElement( "div" ).style;

// Return a css property mapped to a potentially vendor prefixed property
function vendorPropName( name ) {

	// Shortcut for names that are not vendor prefixed
	if ( name in emptyStyle ) {
		return name;
	}

	// Check for vendor prefixed names
	var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),
		i = cssPrefixes.length;

	while ( i-- ) {
		name = cssPrefixes[ i ] + capName;
		if ( name in emptyStyle ) {
			return name;
		}
	}
}

function setPositiveNumber( elem, value, subtract ) {

	// Any relative (+/-) values have already been
	// normalized at this point
	var matches = rcssNum.exec( value );
	return matches ?

		// Guard against undefined "subtract", e.g., when used as in cssHooks
		Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || "px" ) :
		value;
}

function augmentWidthOrHeight( elem, name, extra, isBorderBox, styles ) {
	var i = extra === ( isBorderBox ? "border" : "content" ) ?

		// If we already have the right measurement, avoid augmentation
		4 :

		// Otherwise initialize for horizontal or vertical properties
		name === "width" ? 1 : 0,

		val = 0;

	for ( ; i < 4; i += 2 ) {

		// Both box models exclude margin, so add it if we want it
		if ( extra === "margin" ) {
			val += jQuery.css( elem, extra + cssExpand[ i ], true, styles );
		}

		if ( isBorderBox ) {

			// border-box includes padding, so remove it if we want content
			if ( extra === "content" ) {
				val -= jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );
			}

			// At this point, extra isn't border nor margin, so remove border
			if ( extra !== "margin" ) {
				val -= jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		} else {

			// At this point, extra isn't content, so add padding
			val += jQuery.css( elem, "padding" + cssExpand[ i ], true, styles );

			// At this point, extra isn't content nor padding, so add border
			if ( extra !== "padding" ) {
				val += jQuery.css( elem, "border" + cssExpand[ i ] + "Width", true, styles );
			}
		}
	}

	return val;
}

function getWidthOrHeight( elem, name, extra ) {

	// Start with offset property, which is equivalent to the border-box value
	var valueIsBorderBox = true,
		val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
		styles = getStyles( elem ),
		isBorderBox = jQuery.css( elem, "boxSizing", false, styles ) === "border-box";

	// Support: IE11 only
	// In IE 11 fullscreen elements inside of an iframe have
	// 100x too small dimensions (gh-1764).
	if ( document.msFullscreenElement && window.top !== window ) {

		// Support: IE11 only
		// Running getBoundingClientRect on a disconnected node
		// in IE throws an error.
		if ( elem.getClientRects().length ) {
			val = Math.round( elem.getBoundingClientRect()[ name ] * 100 );
		}
	}

	// Some non-html elements return undefined for offsetWidth, so check for null/undefined
	// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
	// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
	if ( val <= 0 || val == null ) {

		// Fall back to computed then uncomputed css if necessary
		val = curCSS( elem, name, styles );
		if ( val < 0 || val == null ) {
			val = elem.style[ name ];
		}

		// Computed unit is not pixels. Stop here and return.
		if ( rnumnonpx.test( val ) ) {
			return val;
		}

		// Check for style in case a browser which returns unreliable values
		// for getComputedStyle silently falls back to the reliable elem.style
		valueIsBorderBox = isBorderBox &&
			( support.boxSizingReliable() || val === elem.style[ name ] );

		// Normalize "", auto, and prepare for extra
		val = parseFloat( val ) || 0;
	}

	// Use the active box-sizing model to add/subtract irrelevant styles
	return ( val +
		augmentWidthOrHeight(
			elem,
			name,
			extra || ( isBorderBox ? "border" : "content" ),
			valueIsBorderBox,
			styles
		)
	) + "px";
}

function showHide( elements, show ) {
	var display, elem, hidden,
		values = [],
		index = 0,
		length = elements.length;

	for ( ; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}

		values[ index ] = dataPriv.get( elem, "olddisplay" );
		display = elem.style.display;
		if ( show ) {

			// Reset the inline display of this element to learn if it is
			// being hidden by cascaded rules or not
			if ( !values[ index ] && display === "none" ) {
				elem.style.display = "";
			}

			// Set elements which have been overridden with display: none
			// in a stylesheet to whatever the default browser style is
			// for such an element
			if ( elem.style.display === "" && isHidden( elem ) ) {
				values[ index ] = dataPriv.access(
					elem,
					"olddisplay",
					defaultDisplay( elem.nodeName )
				);
			}
		} else {
			hidden = isHidden( elem );

			if ( display !== "none" || !hidden ) {
				dataPriv.set(
					elem,
					"olddisplay",
					hidden ? display : jQuery.css( elem, "display" )
				);
			}
		}
	}

	// Set the display of most of the elements in a second loop
	// to avoid the constant reflow
	for ( index = 0; index < length; index++ ) {
		elem = elements[ index ];
		if ( !elem.style ) {
			continue;
		}
		if ( !show || elem.style.display === "none" || elem.style.display === "" ) {
			elem.style.display = show ? values[ index ] || "" : "none";
		}
	}

	return elements;
}

jQuery.extend( {

	// Add in style property hooks for overriding the default
	// behavior of getting and setting a style property
	cssHooks: {
		opacity: {
			get: function( elem, computed ) {
				if ( computed ) {

					// We should always get a number back from opacity
					var ret = curCSS( elem, "opacity" );
					return ret === "" ? "1" : ret;
				}
			}
		}
	},

	// Don't automatically add "px" to these possibly-unitless properties
	cssNumber: {
		"animationIterationCount": true,
		"columnCount": true,
		"fillOpacity": true,
		"flexGrow": true,
		"flexShrink": true,
		"fontWeight": true,
		"lineHeight": true,
		"opacity": true,
		"order": true,
		"orphans": true,
		"widows": true,
		"zIndex": true,
		"zoom": true
	},

	// Add in properties whose names you wish to fix before
	// setting or getting the value
	cssProps: {
		"float": "cssFloat"
	},

	// Get and set the style property on a DOM Node
	style: function( elem, name, value, extra ) {

		// Don't set styles on text and comment nodes
		if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {
			return;
		}

		// Make sure that we're working with the right name
		var ret, type, hooks,
			origName = jQuery.camelCase( name ),
			style = elem.style;

		name = jQuery.cssProps[ origName ] ||
			( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

		// Gets hook for the prefixed version, then unprefixed version
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// Check if we're setting a value
		if ( value !== undefined ) {
			type = typeof value;

			// Convert "+=" or "-=" to relative numbers (#7345)
			if ( type === "string" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {
				value = adjustCSS( elem, name, ret );

				// Fixes bug #9237
				type = "number";
			}

			// Make sure that null and NaN values aren't set (#7116)
			if ( value == null || value !== value ) {
				return;
			}

			// If a number was passed in, add the unit (except for certain CSS properties)
			if ( type === "number" ) {
				value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? "" : "px" );
			}

			// Support: IE9-11+
			// background-* props affect original clone's values
			if ( !support.clearCloneStyle && value === "" && name.indexOf( "background" ) === 0 ) {
				style[ name ] = "inherit";
			}

			// If a hook was provided, use that value, otherwise just set the specified value
			if ( !hooks || !( "set" in hooks ) ||
				( value = hooks.set( elem, value, extra ) ) !== undefined ) {

				style[ name ] = value;
			}

		} else {

			// If a hook was provided get the non-computed value from there
			if ( hooks && "get" in hooks &&
				( ret = hooks.get( elem, false, extra ) ) !== undefined ) {

				return ret;
			}

			// Otherwise just get the value from the style object
			return style[ name ];
		}
	},

	css: function( elem, name, extra, styles ) {
		var val, num, hooks,
			origName = jQuery.camelCase( name );

		// Make sure that we're working with the right name
		name = jQuery.cssProps[ origName ] ||
			( jQuery.cssProps[ origName ] = vendorPropName( origName ) || origName );

		// Try prefixed name followed by the unprefixed name
		hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];

		// If a hook was provided get the computed value from there
		if ( hooks && "get" in hooks ) {
			val = hooks.get( elem, true, extra );
		}

		// Otherwise, if a way to get the computed value exists, use that
		if ( val === undefined ) {
			val = curCSS( elem, name, styles );
		}

		// Convert "normal" to computed value
		if ( val === "normal" && name in cssNormalTransform ) {
			val = cssNormalTransform[ name ];
		}

		// Make numeric if forced or a qualifier was provided and val looks numeric
		if ( extra === "" || extra ) {
			num = parseFloat( val );
			return extra === true || isFinite( num ) ? num || 0 : val;
		}
		return val;
	}
} );

jQuery.each( [ "height", "width" ], function( i, name ) {
	jQuery.cssHooks[ name ] = {
		get: function( elem, computed, extra ) {
			if ( computed ) {

				// Certain elements can have dimension info if we invisibly show them
				// but it must have a current display style that would benefit
				return rdisplayswap.test( jQuery.css( elem, "display" ) ) &&
					elem.offsetWidth === 0 ?
						swap( elem, cssShow, function() {
							return getWidthOrHeight( elem, name, extra );
						} ) :
						getWidthOrHeight( elem, name, extra );
			}
		},

		set: function( elem, value, extra ) {
			var matches,
				styles = extra && getStyles( elem ),
				subtract = extra && augmentWidthOrHeight(
					elem,
					name,
					extra,
					jQuery.css( elem, "boxSizing", false, styles ) === "border-box",
					styles
				);

			// Convert to pixels if value adjustment is needed
			if ( subtract && ( matches = rcssNum.exec( value ) ) &&
				( matches[ 3 ] || "px" ) !== "px" ) {

				elem.style[ name ] = value;
				value = jQuery.css( elem, name );
			}

			return setPositiveNumber( elem, value, subtract );
		}
	};
} );

jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,
	function( elem, computed ) {
		if ( computed ) {
			return ( parseFloat( curCSS( elem, "marginLeft" ) ) ||
				elem.getBoundingClientRect().left -
					swap( elem, { marginLeft: 0 }, function() {
						return elem.getBoundingClientRect().left;
					} )
				) + "px";
		}
	}
);

// Support: Android 2.3
jQuery.cssHooks.marginRight = addGetHookIf( support.reliableMarginRight,
	function( elem, computed ) {
		if ( computed ) {
			return swap( elem, { "display": "inline-block" },
				curCSS, [ elem, "marginRight" ] );
		}
	}
);

// These hooks are used by animate to expand properties
jQuery.each( {
	margin: "",
	padding: "",
	border: "Width"
}, function( prefix, suffix ) {
	jQuery.cssHooks[ prefix + suffix ] = {
		expand: function( value ) {
			var i = 0,
				expanded = {},

				// Assumes a single number if not a string
				parts = typeof value === "string" ? value.split( " " ) : [ value ];

			for ( ; i < 4; i++ ) {
				expanded[ prefix + cssExpand[ i ] + suffix ] =
					parts[ i ] || parts[ i - 2 ] || parts[ 0 ];
			}

			return expanded;
		}
	};

	if ( !rmargin.test( prefix ) ) {
		jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;
	}
} );

jQuery.fn.extend( {
	css: function( name, value ) {
		return access( this, function( elem, name, value ) {
			var styles, len,
				map = {},
				i = 0;

			if ( jQuery.isArray( name ) ) {
				styles = getStyles( elem );
				len = name.length;

				for ( ; i < len; i++ ) {
					map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );
				}

				return map;
			}

			return value !== undefined ?
				jQuery.style( elem, name, value ) :
				jQuery.css( elem, name );
		}, name, value, arguments.length > 1 );
	},
	show: function() {
		return showHide( this, true );
	},
	hide: function() {
		return showHide( this );
	},
	toggle: function( state ) {
		if ( typeof state === "boolean" ) {
			return state ? this.show() : this.hide();
		}

		return this.each( function() {
			if ( isHidden( this ) ) {
				jQuery( this ).show();
			} else {
				jQuery( this ).hide();
			}
		} );
	}
} );


function Tween( elem, options, prop, end, easing ) {
	return new Tween.prototype.init( elem, options, prop, end, easing );
}
jQuery.Tween = Tween;

Tween.prototype = {
	constructor: Tween,
	init: function( elem, options, prop, end, easing, unit ) {
		this.elem = elem;
		this.prop = prop;
		this.easing = easing || jQuery.easing._default;
		this.options = options;
		this.start = this.now = this.cur();
		this.end = end;
		this.unit = unit || ( jQuery.cssNumber[ prop ] ? "" : "px" );
	},
	cur: function() {
		var hooks = Tween.propHooks[ this.prop ];

		return hooks && hooks.get ?
			hooks.get( this ) :
			Tween.propHooks._default.get( this );
	},
	run: function( percent ) {
		var eased,
			hooks = Tween.propHooks[ this.prop ];

		if ( this.options.duration ) {
			this.pos = eased = jQuery.easing[ this.easing ](
				percent, this.options.duration * percent, 0, 1, this.options.duration
			);
		} else {
			this.pos = eased = percent;
		}
		this.now = ( this.end - this.start ) * eased + this.start;

		if ( this.options.step ) {
			this.options.step.call( this.elem, this.now, this );
		}

		if ( hooks && hooks.set ) {
			hooks.set( this );
		} else {
			Tween.propHooks._default.set( this );
		}
		return this;
	}
};

Tween.prototype.init.prototype = Tween.prototype;

Tween.propHooks = {
	_default: {
		get: function( tween ) {
			var result;

			// Use a property on the element directly when it is not a DOM element,
			// or when there is no matching style property that exists.
			if ( tween.elem.nodeType !== 1 ||
				tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {
				return tween.elem[ tween.prop ];
			}

			// Passing an empty string as a 3rd parameter to .css will automatically
			// attempt a parseFloat and fallback to a string if the parse fails.
			// Simple values such as "10px" are parsed to Float;
			// complex values such as "rotate(1rad)" are returned as-is.
			result = jQuery.css( tween.elem, tween.prop, "" );

			// Empty strings, null, undefined and "auto" are converted to 0.
			return !result || result === "auto" ? 0 : result;
		},
		set: function( tween ) {

			// Use step hook for back compat.
			// Use cssHook if its there.
			// Use .style if available and use plain properties where available.
			if ( jQuery.fx.step[ tween.prop ] ) {
				jQuery.fx.step[ tween.prop ]( tween );
			} else if ( tween.elem.nodeType === 1 &&
				( tween.elem.style[ jQuery.cssProps[ tween.prop ] ] != null ||
					jQuery.cssHooks[ tween.prop ] ) ) {
				jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );
			} else {
				tween.elem[ tween.prop ] = tween.now;
			}
		}
	}
};

// Support: IE9
// Panic based approach to setting things on disconnected nodes
Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
	set: function( tween ) {
		if ( tween.elem.nodeType && tween.elem.parentNode ) {
			tween.elem[ tween.prop ] = tween.now;
		}
	}
};

jQuery.easing = {
	linear: function( p ) {
		return p;
	},
	swing: function( p ) {
		return 0.5 - Math.cos( p * Math.PI ) / 2;
	},
	_default: "swing"
};

jQuery.fx = Tween.prototype.init;

// Back Compat <1.8 extension point
jQuery.fx.step = {};




var
	fxNow, timerId,
	rfxtypes = /^(?:toggle|show|hide)$/,
	rrun = /queueHooks$/;

// Animations created synchronously will run synchronously
function createFxNow() {
	window.setTimeout( function() {
		fxNow = undefined;
	} );
	return ( fxNow = jQuery.now() );
}

// Generate parameters to create a standard animation
function genFx( type, includeWidth ) {
	var which,
		i = 0,
		attrs = { height: type };

	// If we include width, step value is 1 to do all cssExpand values,
	// otherwise step value is 2 to skip over Left and Right
	includeWidth = includeWidth ? 1 : 0;
	for ( ; i < 4 ; i += 2 - includeWidth ) {
		which = cssExpand[ i ];
		attrs[ "margin" + which ] = attrs[ "padding" + which ] = type;
	}

	if ( includeWidth ) {
		attrs.opacity = attrs.width = type;
	}

	return attrs;
}

function createTween( value, prop, animation ) {
	var tween,
		collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ "*" ] ),
		index = 0,
		length = collection.length;
	for ( ; index < length; index++ ) {
		if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {

			// We're done with this property
			return tween;
		}
	}
}

function defaultPrefilter( elem, props, opts ) {
	/* jshint validthis: true */
	var prop, value, toggle, tween, hooks, oldfire, display, checkDisplay,
		anim = this,
		orig = {},
		style = elem.style,
		hidden = elem.nodeType && isHidden( elem ),
		dataShow = dataPriv.get( elem, "fxshow" );

	// Handle queue: false promises
	if ( !opts.queue ) {
		hooks = jQuery._queueHooks( elem, "fx" );
		if ( hooks.unqueued == null ) {
			hooks.unqueued = 0;
			oldfire = hooks.empty.fire;
			hooks.empty.fire = function() {
				if ( !hooks.unqueued ) {
					oldfire();
				}
			};
		}
		hooks.unqueued++;

		anim.always( function() {

			// Ensure the complete handler is called before this completes
			anim.always( function() {
				hooks.unqueued--;
				if ( !jQuery.queue( elem, "fx" ).length ) {
					hooks.empty.fire();
				}
			} );
		} );
	}

	// Height/width overflow pass
	if ( elem.nodeType === 1 && ( "height" in props || "width" in props ) ) {

		// Make sure that nothing sneaks out
		// Record all 3 overflow attributes because IE9-10 do not
		// change the overflow attribute when overflowX and
		// overflowY are set to the same value
		opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];

		// Set display property to inline-block for height/width
		// animations on inline elements that are having width/height animated
		display = jQuery.css( elem, "display" );

		// Test default display if display is currently "none"
		checkDisplay = display === "none" ?
			dataPriv.get( elem, "olddisplay" ) || defaultDisplay( elem.nodeName ) : display;

		if ( checkDisplay === "inline" && jQuery.css( elem, "float" ) === "none" ) {
			style.display = "inline-block";
		}
	}

	if ( opts.overflow ) {
		style.overflow = "hidden";
		anim.always( function() {
			style.overflow = opts.overflow[ 0 ];
			style.overflowX = opts.overflow[ 1 ];
			style.overflowY = opts.overflow[ 2 ];
		} );
	}

	// show/hide pass
	for ( prop in props ) {
		value = props[ prop ];
		if ( rfxtypes.exec( value ) ) {
			delete props[ prop ];
			toggle = toggle || value === "toggle";
			if ( value === ( hidden ? "hide" : "show" ) ) {

				// If there is dataShow left over from a stopped hide or show
				// and we are going to proceed with show, we should pretend to be hidden
				if ( value === "show" && dataShow && dataShow[ prop ] !== undefined ) {
					hidden = true;
				} else {
					continue;
				}
			}
			orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );

		// Any non-fx value stops us from restoring the original display value
		} else {
			display = undefined;
		}
	}

	if ( !jQuery.isEmptyObject( orig ) ) {
		if ( dataShow ) {
			if ( "hidden" in dataShow ) {
				hidden = dataShow.hidden;
			}
		} else {
			dataShow = dataPriv.access( elem, "fxshow", {} );
		}

		// Store state if its toggle - enables .stop().toggle() to "reverse"
		if ( toggle ) {
			dataShow.hidden = !hidden;
		}
		if ( hidden ) {
			jQuery( elem ).show();
		} else {
			anim.done( function() {
				jQuery( elem ).hide();
			} );
		}
		anim.done( function() {
			var prop;

			dataPriv.remove( elem, "fxshow" );
			for ( prop in orig ) {
				jQuery.style( elem, prop, orig[ prop ] );
			}
		} );
		for ( prop in orig ) {
			tween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );

			if ( !( prop in dataShow ) ) {
				dataShow[ prop ] = tween.start;
				if ( hidden ) {
					tween.end = tween.start;
					tween.start = prop === "width" || prop === "height" ? 1 : 0;
				}
			}
		}

	// If this is a noop like .hide().hide(), restore an overwritten display value
	} else if ( ( display === "none" ? defaultDisplay( elem.nodeName ) : display ) === "inline" ) {
		style.display = display;
	}
}

function propFilter( props, specialEasing ) {
	var index, name, easing, value, hooks;

	// camelCase, specialEasing and expand cssHook pass
	for ( index in props ) {
		name = jQuery.camelCase( index );
		easing = specialEasing[ name ];
		value = props[ index ];
		if ( jQuery.isArray( value ) ) {
			easing = value[ 1 ];
			value = props[ index ] = value[ 0 ];
		}

		if ( index !== name ) {
			props[ name ] = value;
			delete props[ index ];
		}

		hooks = jQuery.cssHooks[ name ];
		if ( hooks && "expand" in hooks ) {
			value = hooks.expand( value );
			delete props[ name ];

			// Not quite $.extend, this won't overwrite existing keys.
			// Reusing 'index' because we have the correct "name"
			for ( index in value ) {
				if ( !( index in props ) ) {
					props[ index ] = value[ index ];
					specialEasing[ index ] = easing;
				}
			}
		} else {
			specialEasing[ name ] = easing;
		}
	}
}

function Animation( elem, properties, options ) {
	var result,
		stopped,
		index = 0,
		length = Animation.prefilters.length,
		deferred = jQuery.Deferred().always( function() {

			// Don't match elem in the :animated selector
			delete tick.elem;
		} ),
		tick = function() {
			if ( stopped ) {
				return false;
			}
			var currentTime = fxNow || createFxNow(),
				remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),

				// Support: Android 2.3
				// Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
				temp = remaining / animation.duration || 0,
				percent = 1 - temp,
				index = 0,
				length = animation.tweens.length;

			for ( ; index < length ; index++ ) {
				animation.tweens[ index ].run( percent );
			}

			deferred.notifyWith( elem, [ animation, percent, remaining ] );

			if ( percent < 1 && length ) {
				return remaining;
			} else {
				deferred.resolveWith( elem, [ animation ] );
				return false;
			}
		},
		animation = deferred.promise( {
			elem: elem,
			props: jQuery.extend( {}, properties ),
			opts: jQuery.extend( true, {
				specialEasing: {},
				easing: jQuery.easing._default
			}, options ),
			originalProperties: properties,
			originalOptions: options,
			startTime: fxNow || createFxNow(),
			duration: options.duration,
			tweens: [],
			createTween: function( prop, end ) {
				var tween = jQuery.Tween( elem, animation.opts, prop, end,
						animation.opts.specialEasing[ prop ] || animation.opts.easing );
				animation.tweens.push( tween );
				return tween;
			},
			stop: function( gotoEnd ) {
				var index = 0,

					// If we are going to the end, we want to run all the tweens
					// otherwise we skip this part
					length = gotoEnd ? animation.tweens.length : 0;
				if ( stopped ) {
					return this;
				}
				stopped = true;
				for ( ; index < length ; index++ ) {
					animation.tweens[ index ].run( 1 );
				}

				// Resolve when we played the last frame; otherwise, reject
				if ( gotoEnd ) {
					deferred.notifyWith( elem, [ animation, 1, 0 ] );
					deferred.resolveWith( elem, [ animation, gotoEnd ] );
				} else {
					deferred.rejectWith( elem, [ animation, gotoEnd ] );
				}
				return this;
			}
		} ),
		props = animation.props;

	propFilter( props, animation.opts.specialEasing );

	for ( ; index < length ; index++ ) {
		result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );
		if ( result ) {
			if ( jQuery.isFunction( result.stop ) ) {
				jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =
					jQuery.proxy( result.stop, result );
			}
			return result;
		}
	}

	jQuery.map( props, createTween, animation );

	if ( jQuery.isFunction( animation.opts.start ) ) {
		animation.opts.start.call( elem, animation );
	}

	jQuery.fx.timer(
		jQuery.extend( tick, {
			elem: elem,
			anim: animation,
			queue: animation.opts.queue
		} )
	);

	// attach callbacks from options
	return animation.progress( animation.opts.progress )
		.done( animation.opts.done, animation.opts.complete )
		.fail( animation.opts.fail )
		.always( animation.opts.always );
}

jQuery.Animation = jQuery.extend( Animation, {
	tweeners: {
		"*": [ function( prop, value ) {
			var tween = this.createTween( prop, value );
			adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );
			return tween;
		} ]
	},

	tweener: function( props, callback ) {
		if ( jQuery.isFunction( props ) ) {
			callback = props;
			props = [ "*" ];
		} else {
			props = props.match( rnotwhite );
		}

		var prop,
			index = 0,
			length = props.length;

		for ( ; index < length ; index++ ) {
			prop = props[ index ];
			Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];
			Animation.tweeners[ prop ].unshift( callback );
		}
	},

	prefilters: [ defaultPrefilter ],

	prefilter: function( callback, prepend ) {
		if ( prepend ) {
			Animation.prefilters.unshift( callback );
		} else {
			Animation.prefilters.push( callback );
		}
	}
} );

jQuery.speed = function( speed, easing, fn ) {
	var opt = speed && typeof speed === "object" ? jQuery.extend( {}, speed ) : {
		complete: fn || !fn && easing ||
			jQuery.isFunction( speed ) && speed,
		duration: speed,
		easing: fn && easing || easing && !jQuery.isFunction( easing ) && easing
	};

	opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ?
		opt.duration : opt.duration in jQuery.fx.speeds ?
			jQuery.fx.speeds[ opt.duration ] : jQuery.fx.speeds._default;

	// Normalize opt.queue - true/undefined/null -> "fx"
	if ( opt.queue == null || opt.queue === true ) {
		opt.queue = "fx";
	}

	// Queueing
	opt.old = opt.complete;

	opt.complete = function() {
		if ( jQuery.isFunction( opt.old ) ) {
			opt.old.call( this );
		}

		if ( opt.queue ) {
			jQuery.dequeue( this, opt.queue );
		}
	};

	return opt;
};

jQuery.fn.extend( {
	fadeTo: function( speed, to, easing, callback ) {

		// Show any hidden elements after setting opacity to 0
		return this.filter( isHidden ).css( "opacity", 0 ).show()

			// Animate to the value specified
			.end().animate( { opacity: to }, speed, easing, callback );
	},
	animate: function( prop, speed, easing, callback ) {
		var empty = jQuery.isEmptyObject( prop ),
			optall = jQuery.speed( speed, easing, callback ),
			doAnimation = function() {

				// Operate on a copy of prop so per-property easing won't be lost
				var anim = Animation( this, jQuery.extend( {}, prop ), optall );

				// Empty animations, or finishing resolves immediately
				if ( empty || dataPriv.get( this, "finish" ) ) {
					anim.stop( true );
				}
			};
			doAnimation.finish = doAnimation;

		return empty || optall.queue === false ?
			this.each( doAnimation ) :
			this.queue( optall.queue, doAnimation );
	},
	stop: function( type, clearQueue, gotoEnd ) {
		var stopQueue = function( hooks ) {
			var stop = hooks.stop;
			delete hooks.stop;
			stop( gotoEnd );
		};

		if ( typeof type !== "string" ) {
			gotoEnd = clearQueue;
			clearQueue = type;
			type = undefined;
		}
		if ( clearQueue && type !== false ) {
			this.queue( type || "fx", [] );
		}

		return this.each( function() {
			var dequeue = true,
				index = type != null && type + "queueHooks",
				timers = jQuery.timers,
				data = dataPriv.get( this );

			if ( index ) {
				if ( data[ index ] && data[ index ].stop ) {
					stopQueue( data[ index ] );
				}
			} else {
				for ( index in data ) {
					if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {
						stopQueue( data[ index ] );
					}
				}
			}

			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this &&
					( type == null || timers[ index ].queue === type ) ) {

					timers[ index ].anim.stop( gotoEnd );
					dequeue = false;
					timers.splice( index, 1 );
				}
			}

			// Start the next in the queue if the last step wasn't forced.
			// Timers currently will call their complete callbacks, which
			// will dequeue but only if they were gotoEnd.
			if ( dequeue || !gotoEnd ) {
				jQuery.dequeue( this, type );
			}
		} );
	},
	finish: function( type ) {
		if ( type !== false ) {
			type = type || "fx";
		}
		return this.each( function() {
			var index,
				data = dataPriv.get( this ),
				queue = data[ type + "queue" ],
				hooks = data[ type + "queueHooks" ],
				timers = jQuery.timers,
				length = queue ? queue.length : 0;

			// Enable finishing flag on private data
			data.finish = true;

			// Empty the queue first
			jQuery.queue( this, type, [] );

			if ( hooks && hooks.stop ) {
				hooks.stop.call( this, true );
			}

			// Look for any active animations, and finish them
			for ( index = timers.length; index--; ) {
				if ( timers[ index ].elem === this && timers[ index ].queue === type ) {
					timers[ index ].anim.stop( true );
					timers.splice( index, 1 );
				}
			}

			// Look for any animations in the old queue and finish them
			for ( index = 0; index < length; index++ ) {
				if ( queue[ index ] && queue[ index ].finish ) {
					queue[ index ].finish.call( this );
				}
			}

			// Turn off finishing flag
			delete data.finish;
		} );
	}
} );

jQuery.each( [ "toggle", "show", "hide" ], function( i, name ) {
	var cssFn = jQuery.fn[ name ];
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return speed == null || typeof speed === "boolean" ?
			cssFn.apply( this, arguments ) :
			this.animate( genFx( name, true ), speed, easing, callback );
	};
} );

// Generate shortcuts for custom animations
jQuery.each( {
	slideDown: genFx( "show" ),
	slideUp: genFx( "hide" ),
	slideToggle: genFx( "toggle" ),
	fadeIn: { opacity: "show" },
	fadeOut: { opacity: "hide" },
	fadeToggle: { opacity: "toggle" }
}, function( name, props ) {
	jQuery.fn[ name ] = function( speed, easing, callback ) {
		return this.animate( props, speed, easing, callback );
	};
} );

jQuery.timers = [];
jQuery.fx.tick = function() {
	var timer,
		i = 0,
		timers = jQuery.timers;

	fxNow = jQuery.now();

	for ( ; i < timers.length; i++ ) {
		timer = timers[ i ];

		// Checks the timer has not already been removed
		if ( !timer() && timers[ i ] === timer ) {
			timers.splice( i--, 1 );
		}
	}

	if ( !timers.length ) {
		jQuery.fx.stop();
	}
	fxNow = undefined;
};

jQuery.fx.timer = function( timer ) {
	jQuery.timers.push( timer );
	if ( timer() ) {
		jQuery.fx.start();
	} else {
		jQuery.timers.pop();
	}
};

jQuery.fx.interval = 13;
jQuery.fx.start = function() {
	if ( !timerId ) {
		timerId = window.setInterval( jQuery.fx.tick, jQuery.fx.interval );
	}
};

jQuery.fx.stop = function() {
	window.clearInterval( timerId );

	timerId = null;
};

jQuery.fx.speeds = {
	slow: 600,
	fast: 200,

	// Default speed
	_default: 400
};


// Based off of the plugin by Clint Helfers, with permission.
// http://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
jQuery.fn.delay = function( time, type ) {
	time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;
	type = type || "fx";

	return this.queue( type, function( next, hooks ) {
		var timeout = window.setTimeout( next, time );
		hooks.stop = function() {
			window.clearTimeout( timeout );
		};
	} );
};


( function() {
	var input = document.createElement( "input" ),
		select = document.createElement( "select" ),
		opt = select.appendChild( document.createElement( "option" ) );

	input.type = "checkbox";

	// Support: iOS<=5.1, Android<=4.2+
	// Default value for a checkbox should be "on"
	support.checkOn = input.value !== "";

	// Support: IE<=11+
	// Must access selectedIndex to make default options select
	support.optSelected = opt.selected;

	// Support: Android<=2.3
	// Options inside disabled selects are incorrectly marked as disabled
	select.disabled = true;
	support.optDisabled = !opt.disabled;

	// Support: IE<=11+
	// An input loses its value after becoming a radio
	input = document.createElement( "input" );
	input.value = "t";
	input.type = "radio";
	support.radioValue = input.value === "t";
} )();


var boolHook,
	attrHandle = jQuery.expr.attrHandle;

jQuery.fn.extend( {
	attr: function( name, value ) {
		return access( this, jQuery.attr, name, value, arguments.length > 1 );
	},

	removeAttr: function( name ) {
		return this.each( function() {
			jQuery.removeAttr( this, name );
		} );
	}
} );

jQuery.extend( {
	attr: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set attributes on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		// Fallback to prop when attributes are not supported
		if ( typeof elem.getAttribute === "undefined" ) {
			return jQuery.prop( elem, name, value );
		}

		// All attributes are lowercase
		// Grab necessary hook if one is defined
		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {
			name = name.toLowerCase();
			hooks = jQuery.attrHooks[ name ] ||
				( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );
		}

		if ( value !== undefined ) {
			if ( value === null ) {
				jQuery.removeAttr( elem, name );
				return;
			}

			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			elem.setAttribute( name, value + "" );
			return value;
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		ret = jQuery.find.attr( elem, name );

		// Non-existent attributes return null, we normalize to undefined
		return ret == null ? undefined : ret;
	},

	attrHooks: {
		type: {
			set: function( elem, value ) {
				if ( !support.radioValue && value === "radio" &&
					jQuery.nodeName( elem, "input" ) ) {
					var val = elem.value;
					elem.setAttribute( "type", value );
					if ( val ) {
						elem.value = val;
					}
					return value;
				}
			}
		}
	},

	removeAttr: function( elem, value ) {
		var name, propName,
			i = 0,
			attrNames = value && value.match( rnotwhite );

		if ( attrNames && elem.nodeType === 1 ) {
			while ( ( name = attrNames[ i++ ] ) ) {
				propName = jQuery.propFix[ name ] || name;

				// Boolean attributes get special treatment (#10870)
				if ( jQuery.expr.match.bool.test( name ) ) {

					// Set corresponding property to false
					elem[ propName ] = false;
				}

				elem.removeAttribute( name );
			}
		}
	}
} );

// Hooks for boolean attributes
boolHook = {
	set: function( elem, value, name ) {
		if ( value === false ) {

			// Remove boolean attributes when set to false
			jQuery.removeAttr( elem, name );
		} else {
			elem.setAttribute( name, name );
		}
		return name;
	}
};
jQuery.each( jQuery.expr.match.bool.source.match( /\w+/g ), function( i, name ) {
	var getter = attrHandle[ name ] || jQuery.find.attr;

	attrHandle[ name ] = function( elem, name, isXML ) {
		var ret, handle;
		if ( !isXML ) {

			// Avoid an infinite loop by temporarily removing this function from the getter
			handle = attrHandle[ name ];
			attrHandle[ name ] = ret;
			ret = getter( elem, name, isXML ) != null ?
				name.toLowerCase() :
				null;
			attrHandle[ name ] = handle;
		}
		return ret;
	};
} );




var rfocusable = /^(?:input|select|textarea|button)$/i,
	rclickable = /^(?:a|area)$/i;

jQuery.fn.extend( {
	prop: function( name, value ) {
		return access( this, jQuery.prop, name, value, arguments.length > 1 );
	},

	removeProp: function( name ) {
		return this.each( function() {
			delete this[ jQuery.propFix[ name ] || name ];
		} );
	}
} );

jQuery.extend( {
	prop: function( elem, name, value ) {
		var ret, hooks,
			nType = elem.nodeType;

		// Don't get/set properties on text, comment and attribute nodes
		if ( nType === 3 || nType === 8 || nType === 2 ) {
			return;
		}

		if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {

			// Fix name and attach hooks
			name = jQuery.propFix[ name ] || name;
			hooks = jQuery.propHooks[ name ];
		}

		if ( value !== undefined ) {
			if ( hooks && "set" in hooks &&
				( ret = hooks.set( elem, value, name ) ) !== undefined ) {
				return ret;
			}

			return ( elem[ name ] = value );
		}

		if ( hooks && "get" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {
			return ret;
		}

		return elem[ name ];
	},

	propHooks: {
		tabIndex: {
			get: function( elem ) {

				// elem.tabIndex doesn't always return the
				// correct value when it hasn't been explicitly set
				// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
				// Use proper attribute retrieval(#12072)
				var tabindex = jQuery.find.attr( elem, "tabindex" );

				return tabindex ?
					parseInt( tabindex, 10 ) :
					rfocusable.test( elem.nodeName ) ||
						rclickable.test( elem.nodeName ) && elem.href ?
							0 :
							-1;
			}
		}
	},

	propFix: {
		"for": "htmlFor",
		"class": "className"
	}
} );

// Support: IE <=11 only
// Accessing the selectedIndex property
// forces the browser to respect setting selected
// on the option
// The getter ensures a default option is selected
// when in an optgroup
if ( !support.optSelected ) {
	jQuery.propHooks.selected = {
		get: function( elem ) {
			var parent = elem.parentNode;
			if ( parent && parent.parentNode ) {
				parent.parentNode.selectedIndex;
			}
			return null;
		},
		set: function( elem ) {
			var parent = elem.parentNode;
			if ( parent ) {
				parent.selectedIndex;

				if ( parent.parentNode ) {
					parent.parentNode.selectedIndex;
				}
			}
		}
	};
}

jQuery.each( [
	"tabIndex",
	"readOnly",
	"maxLength",
	"cellSpacing",
	"cellPadding",
	"rowSpan",
	"colSpan",
	"useMap",
	"frameBorder",
	"contentEditable"
], function() {
	jQuery.propFix[ this.toLowerCase() ] = this;
} );




var rclass = /[\t\r\n\f]/g;

function getClass( elem ) {
	return elem.getAttribute && elem.getAttribute( "class" ) || "";
}

jQuery.fn.extend( {
	addClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( typeof value === "string" && value ) {
			classes = value.match( rnotwhite ) || [];

			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );
				cur = elem.nodeType === 1 &&
					( " " + curValue + " " ).replace( rclass, " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {
						if ( cur.indexOf( " " + clazz + " " ) < 0 ) {
							cur += clazz + " ";
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = jQuery.trim( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	removeClass: function( value ) {
		var classes, elem, cur, curValue, clazz, j, finalValue,
			i = 0;

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( j ) {
				jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );
			} );
		}

		if ( !arguments.length ) {
			return this.attr( "class", "" );
		}

		if ( typeof value === "string" && value ) {
			classes = value.match( rnotwhite ) || [];

			while ( ( elem = this[ i++ ] ) ) {
				curValue = getClass( elem );

				// This expression is here for better compressibility (see addClass)
				cur = elem.nodeType === 1 &&
					( " " + curValue + " " ).replace( rclass, " " );

				if ( cur ) {
					j = 0;
					while ( ( clazz = classes[ j++ ] ) ) {

						// Remove *all* instances
						while ( cur.indexOf( " " + clazz + " " ) > -1 ) {
							cur = cur.replace( " " + clazz + " ", " " );
						}
					}

					// Only assign if different to avoid unneeded rendering.
					finalValue = jQuery.trim( cur );
					if ( curValue !== finalValue ) {
						elem.setAttribute( "class", finalValue );
					}
				}
			}
		}

		return this;
	},

	toggleClass: function( value, stateVal ) {
		var type = typeof value;

		if ( typeof stateVal === "boolean" && type === "string" ) {
			return stateVal ? this.addClass( value ) : this.removeClass( value );
		}

		if ( jQuery.isFunction( value ) ) {
			return this.each( function( i ) {
				jQuery( this ).toggleClass(
					value.call( this, i, getClass( this ), stateVal ),
					stateVal
				);
			} );
		}

		return this.each( function() {
			var className, i, self, classNames;

			if ( type === "string" ) {

				// Toggle individual class names
				i = 0;
				self = jQuery( this );
				classNames = value.match( rnotwhite ) || [];

				while ( ( className = classNames[ i++ ] ) ) {

					// Check each className given, space separated list
					if ( self.hasClass( className ) ) {
						self.removeClass( className );
					} else {
						self.addClass( className );
					}
				}

			// Toggle whole class name
			} else if ( value === undefined || type === "boolean" ) {
				className = getClass( this );
				if ( className ) {

					// Store className if set
					dataPriv.set( this, "__className__", className );
				}

				// If the element has a class name or if we're passed `false`,
				// then remove the whole classname (if there was one, the above saved it).
				// Otherwise bring back whatever was previously saved (if anything),
				// falling back to the empty string if nothing was stored.
				if ( this.setAttribute ) {
					this.setAttribute( "class",
						className || value === false ?
						"" :
						dataPriv.get( this, "__className__" ) || ""
					);
				}
			}
		} );
	},

	hasClass: function( selector ) {
		var className, elem,
			i = 0;

		className = " " + selector + " ";
		while ( ( elem = this[ i++ ] ) ) {
			if ( elem.nodeType === 1 &&
				( " " + getClass( elem ) + " " ).replace( rclass, " " )
					.indexOf( className ) > -1
			) {
				return true;
			}
		}

		return false;
	}
} );




var rreturn = /\r/g,
	rspaces = /[\x20\t\r\n\f]+/g;

jQuery.fn.extend( {
	val: function( value ) {
		var hooks, ret, isFunction,
			elem = this[ 0 ];

		if ( !arguments.length ) {
			if ( elem ) {
				hooks = jQuery.valHooks[ elem.type ] ||
					jQuery.valHooks[ elem.nodeName.toLowerCase() ];

				if ( hooks &&
					"get" in hooks &&
					( ret = hooks.get( elem, "value" ) ) !== undefined
				) {
					return ret;
				}

				ret = elem.value;

				return typeof ret === "string" ?

					// Handle most common string cases
					ret.replace( rreturn, "" ) :

					// Handle cases where value is null/undef or number
					ret == null ? "" : ret;
			}

			return;
		}

		isFunction = jQuery.isFunction( value );

		return this.each( function( i ) {
			var val;

			if ( this.nodeType !== 1 ) {
				return;
			}

			if ( isFunction ) {
				val = value.call( this, i, jQuery( this ).val() );
			} else {
				val = value;
			}

			// Treat null/undefined as ""; convert numbers to string
			if ( val == null ) {
				val = "";

			} else if ( typeof val === "number" ) {
				val += "";

			} else if ( jQuery.isArray( val ) ) {
				val = jQuery.map( val, function( value ) {
					return value == null ? "" : value + "";
				} );
			}

			hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];

			// If set returns undefined, fall back to normal setting
			if ( !hooks || !( "set" in hooks ) || hooks.set( this, val, "value" ) === undefined ) {
				this.value = val;
			}
		} );
	}
} );

jQuery.extend( {
	valHooks: {
		option: {
			get: function( elem ) {

				var val = jQuery.find.attr( elem, "value" );
				return val != null ?
					val :

					// Support: IE10-11+
					// option.text throws exceptions (#14686, #14858)
					// Strip and collapse whitespace
					// https://html.spec.whatwg.org/#strip-and-collapse-whitespace
					jQuery.trim( jQuery.text( elem ) ).replace( rspaces, " " );
			}
		},
		select: {
			get: function( elem ) {
				var value, option,
					options = elem.options,
					index = elem.selectedIndex,
					one = elem.type === "select-one" || index < 0,
					values = one ? null : [],
					max = one ? index + 1 : options.length,
					i = index < 0 ?
						max :
						one ? index : 0;

				// Loop through all the selected options
				for ( ; i < max; i++ ) {
					option = options[ i ];

					// IE8-9 doesn't update selected after form reset (#2551)
					if ( ( option.selected || i === index ) &&

							// Don't return options that are disabled or in a disabled optgroup
							( support.optDisabled ?
								!option.disabled : option.getAttribute( "disabled" ) === null ) &&
							( !option.parentNode.disabled ||
								!jQuery.nodeName( option.parentNode, "optgroup" ) ) ) {

						// Get the specific value for the option
						value = jQuery( option ).val();

						// We don't need an array for one selects
						if ( one ) {
							return value;
						}

						// Multi-Selects return an array
						values.push( value );
					}
				}

				return values;
			},

			set: function( elem, value ) {
				var optionSet, option,
					options = elem.options,
					values = jQuery.makeArray( value ),
					i = options.length;

				while ( i-- ) {
					option = options[ i ];
					if ( option.selected =
						jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1
					) {
						optionSet = true;
					}
				}

				// Force browsers to behave consistently when non-matching value is set
				if ( !optionSet ) {
					elem.selectedIndex = -1;
				}
				return values;
			}
		}
	}
} );

// Radios and checkboxes getter/setter
jQuery.each( [ "radio", "checkbox" ], function() {
	jQuery.valHooks[ this ] = {
		set: function( elem, value ) {
			if ( jQuery.isArray( value ) ) {
				return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );
			}
		}
	};
	if ( !support.checkOn ) {
		jQuery.valHooks[ this ].get = function( elem ) {
			return elem.getAttribute( "value" ) === null ? "on" : elem.value;
		};
	}
} );




// Return jQuery for attributes-only inclusion


var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/;

jQuery.extend( jQuery.event, {

	trigger: function( event, data, elem, onlyHandlers ) {

		var i, cur, tmp, bubbleType, ontype, handle, special,
			eventPath = [ elem || document ],
			type = hasOwn.call( event, "type" ) ? event.type : event,
			namespaces = hasOwn.call( event, "namespace" ) ? event.namespace.split( "." ) : [];

		cur = tmp = elem = elem || document;

		// Don't do events on text and comment nodes
		if ( elem.nodeType === 3 || elem.nodeType === 8 ) {
			return;
		}

		// focus/blur morphs to focusin/out; ensure we're not firing them right now
		if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {
			return;
		}

		if ( type.indexOf( "." ) > -1 ) {

			// Namespaced trigger; create a regexp to match event type in handle()
			namespaces = type.split( "." );
			type = namespaces.shift();
			namespaces.sort();
		}
		ontype = type.indexOf( ":" ) < 0 && "on" + type;

		// Caller can pass in a jQuery.Event object, Object, or just an event type string
		event = event[ jQuery.expando ] ?
			event :
			new jQuery.Event( type, typeof event === "object" && event );

		// Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
		event.isTrigger = onlyHandlers ? 2 : 3;
		event.namespace = namespaces.join( "." );
		event.rnamespace = event.namespace ?
			new RegExp( "(^|\\.)" + namespaces.join( "\\.(?:.*\\.|)" ) + "(\\.|$)" ) :
			null;

		// Clean up the event in case it is being reused
		event.result = undefined;
		if ( !event.target ) {
			event.target = elem;
		}

		// Clone any incoming data and prepend the event, creating the handler arg list
		data = data == null ?
			[ event ] :
			jQuery.makeArray( data, [ event ] );

		// Allow special events to draw outside the lines
		special = jQuery.event.special[ type ] || {};
		if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {
			return;
		}

		// Determine event propagation path in advance, per W3C events spec (#9951)
		// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
		if ( !onlyHandlers && !special.noBubble && !jQuery.isWindow( elem ) ) {

			bubbleType = special.delegateType || type;
			if ( !rfocusMorph.test( bubbleType + type ) ) {
				cur = cur.parentNode;
			}
			for ( ; cur; cur = cur.parentNode ) {
				eventPath.push( cur );
				tmp = cur;
			}

			// Only add window if we got to document (e.g., not plain obj or detached DOM)
			if ( tmp === ( elem.ownerDocument || document ) ) {
				eventPath.push( tmp.defaultView || tmp.parentWindow || window );
			}
		}

		// Fire handlers on the event path
		i = 0;
		while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {

			event.type = i > 1 ?
				bubbleType :
				special.bindType || type;

			// jQuery handler
			handle = ( dataPriv.get( cur, "events" ) || {} )[ event.type ] &&
				dataPriv.get( cur, "handle" );
			if ( handle ) {
				handle.apply( cur, data );
			}

			// Native handler
			handle = ontype && cur[ ontype ];
			if ( handle && handle.apply && acceptData( cur ) ) {
				event.result = handle.apply( cur, data );
				if ( event.result === false ) {
					event.preventDefault();
				}
			}
		}
		event.type = type;

		// If nobody prevented the default action, do it now
		if ( !onlyHandlers && !event.isDefaultPrevented() ) {

			if ( ( !special._default ||
				special._default.apply( eventPath.pop(), data ) === false ) &&
				acceptData( elem ) ) {

				// Call a native DOM method on the target with the same name name as the event.
				// Don't do default actions on window, that's where global variables be (#6170)
				if ( ontype && jQuery.isFunction( elem[ type ] ) && !jQuery.isWindow( elem ) ) {

					// Don't re-trigger an onFOO event when we call its FOO() method
					tmp = elem[ ontype ];

					if ( tmp ) {
						elem[ ontype ] = null;
					}

					// Prevent re-triggering of the same event, since we already bubbled it above
					jQuery.event.triggered = type;
					elem[ type ]();
					jQuery.event.triggered = undefined;

					if ( tmp ) {
						elem[ ontype ] = tmp;
					}
				}
			}
		}

		return event.result;
	},

	// Piggyback on a donor event to simulate a different one
	simulate: function( type, elem, event ) {
		var e = jQuery.extend(
			new jQuery.Event(),
			event,
			{
				type: type,
				isSimulated: true

				// Previously, `originalEvent: {}` was set here, so stopPropagation call
				// would not be triggered on donor event, since in our own
				// jQuery.event.stopPropagation function we had a check for existence of
				// originalEvent.stopPropagation method, so, consequently it would be a noop.
				//
				// But now, this "simulate" function is used only for events
				// for which stopPropagation() is noop, so there is no need for that anymore.
				//
				// For the 1.x branch though, guard for "click" and "submit"
				// events is still used, but was moved to jQuery.event.stopPropagation function
				// because `originalEvent` should point to the original event for the constancy
				// with other events and for more focused logic
			}
		);

		jQuery.event.trigger( e, null, elem );

		if ( e.isDefaultPrevented() ) {
			event.preventDefault();
		}
	}

} );

jQuery.fn.extend( {

	trigger: function( type, data ) {
		return this.each( function() {
			jQuery.event.trigger( type, data, this );
		} );
	},
	triggerHandler: function( type, data ) {
		var elem = this[ 0 ];
		if ( elem ) {
			return jQuery.event.trigger( type, data, elem, true );
		}
	}
} );


jQuery.each( ( "blur focus focusin focusout load resize scroll unload click dblclick " +
	"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
	"change select submit keydown keypress keyup error contextmenu" ).split( " " ),
	function( i, name ) {

	// Handle event binding
	jQuery.fn[ name ] = function( data, fn ) {
		return arguments.length > 0 ?
			this.on( name, null, data, fn ) :
			this.trigger( name );
	};
} );

jQuery.fn.extend( {
	hover: function( fnOver, fnOut ) {
		return this.mouseenter( fnOver ).mouseleave( fnOut || fnOver );
	}
} );




support.focusin = "onfocusin" in window;


// Support: Firefox
// Firefox doesn't have focus(in | out) events
// Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
//
// Support: Chrome, Safari
// focus(in | out) events fire after focus & blur events,
// which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
// Related ticket - https://code.google.com/p/chromium/issues/detail?id=449857
if ( !support.focusin ) {
	jQuery.each( { focus: "focusin", blur: "focusout" }, function( orig, fix ) {

		// Attach a single capturing handler on the document while someone wants focusin/focusout
		var handler = function( event ) {
			jQuery.event.simulate( fix, event.target, jQuery.event.fix( event ) );
		};

		jQuery.event.special[ fix ] = {
			setup: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix );

				if ( !attaches ) {
					doc.addEventListener( orig, handler, true );
				}
				dataPriv.access( doc, fix, ( attaches || 0 ) + 1 );
			},
			teardown: function() {
				var doc = this.ownerDocument || this,
					attaches = dataPriv.access( doc, fix ) - 1;

				if ( !attaches ) {
					doc.removeEventListener( orig, handler, true );
					dataPriv.remove( doc, fix );

				} else {
					dataPriv.access( doc, fix, attaches );
				}
			}
		};
	} );
}
var location = window.location;

var nonce = jQuery.now();

var rquery = ( /\?/ );



// Support: Android 2.3
// Workaround failure to string-cast null input
jQuery.parseJSON = function( data ) {
	return JSON.parse( data + "" );
};


// Cross-browser xml parsing
jQuery.parseXML = function( data ) {
	var xml;
	if ( !data || typeof data !== "string" ) {
		return null;
	}

	// Support: IE9
	try {
		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );
	} catch ( e ) {
		xml = undefined;
	}

	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {
		jQuery.error( "Invalid XML: " + data );
	}
	return xml;
};


var
	rhash = /#.*$/,
	rts = /([?&])_=[^&]*/,
	rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg,

	// #7653, #8125, #8152: local protocol detection
	rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
	rnoContent = /^(?:GET|HEAD)$/,
	rprotocol = /^\/\//,

	/* Prefilters
	 * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
	 * 2) These are called:
	 *    - BEFORE asking for a transport
	 *    - AFTER param serialization (s.data is a string if s.processData is true)
	 * 3) key is the dataType
	 * 4) the catchall symbol "*" can be used
	 * 5) execution will start with transport dataType and THEN continue down to "*" if needed
	 */
	prefilters = {},

	/* Transports bindings
	 * 1) key is the dataType
	 * 2) the catchall symbol "*" can be used
	 * 3) selection will start with transport dataType and THEN go to "*" if needed
	 */
	transports = {},

	// Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
	allTypes = "*/".concat( "*" ),

	// Anchor tag for parsing the document origin
	originAnchor = document.createElement( "a" );
	originAnchor.href = location.href;

// Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
function addToPrefiltersOrTransports( structure ) {

	// dataTypeExpression is optional and defaults to "*"
	return function( dataTypeExpression, func ) {

		if ( typeof dataTypeExpression !== "string" ) {
			func = dataTypeExpression;
			dataTypeExpression = "*";
		}

		var dataType,
			i = 0,
			dataTypes = dataTypeExpression.toLowerCase().match( rnotwhite ) || [];

		if ( jQuery.isFunction( func ) ) {

			// For each dataType in the dataTypeExpression
			while ( ( dataType = dataTypes[ i++ ] ) ) {

				// Prepend if requested
				if ( dataType[ 0 ] === "+" ) {
					dataType = dataType.slice( 1 ) || "*";
					( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );

				// Otherwise append
				} else {
					( structure[ dataType ] = structure[ dataType ] || [] ).push( func );
				}
			}
		}
	};
}

// Base inspection function for prefilters and transports
function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {

	var inspected = {},
		seekingTransport = ( structure === transports );

	function inspect( dataType ) {
		var selected;
		inspected[ dataType ] = true;
		jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {
			var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );
			if ( typeof dataTypeOrTransport === "string" &&
				!seekingTransport && !inspected[ dataTypeOrTransport ] ) {

				options.dataTypes.unshift( dataTypeOrTransport );
				inspect( dataTypeOrTransport );
				return false;
			} else if ( seekingTransport ) {
				return !( selected = dataTypeOrTransport );
			}
		} );
		return selected;
	}

	return inspect( options.dataTypes[ 0 ] ) || !inspected[ "*" ] && inspect( "*" );
}

// A special extend for ajax options
// that takes "flat" options (not to be deep extended)
// Fixes #9887
function ajaxExtend( target, src ) {
	var key, deep,
		flatOptions = jQuery.ajaxSettings.flatOptions || {};

	for ( key in src ) {
		if ( src[ key ] !== undefined ) {
			( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
		}
	}
	if ( deep ) {
		jQuery.extend( true, target, deep );
	}

	return target;
}

/* Handles responses to an ajax request:
 * - finds the right dataType (mediates between content-type and expected dataType)
 * - returns the corresponding response
 */
function ajaxHandleResponses( s, jqXHR, responses ) {

	var ct, type, finalDataType, firstDataType,
		contents = s.contents,
		dataTypes = s.dataTypes;

	// Remove auto dataType and get content-type in the process
	while ( dataTypes[ 0 ] === "*" ) {
		dataTypes.shift();
		if ( ct === undefined ) {
			ct = s.mimeType || jqXHR.getResponseHeader( "Content-Type" );
		}
	}

	// Check if we're dealing with a known content-type
	if ( ct ) {
		for ( type in contents ) {
			if ( contents[ type ] && contents[ type ].test( ct ) ) {
				dataTypes.unshift( type );
				break;
			}
		}
	}

	// Check to see if we have a response for the expected dataType
	if ( dataTypes[ 0 ] in responses ) {
		finalDataType = dataTypes[ 0 ];
	} else {

		// Try convertible dataTypes
		for ( type in responses ) {
			if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
				finalDataType = type;
				break;
			}
			if ( !firstDataType ) {
				firstDataType = type;
			}
		}

		// Or just use first one
		finalDataType = finalDataType || firstDataType;
	}

	// If we found a dataType
	// We add the dataType to the list if needed
	// and return the corresponding response
	if ( finalDataType ) {
		if ( finalDataType !== dataTypes[ 0 ] ) {
			dataTypes.unshift( finalDataType );
		}
		return responses[ finalDataType ];
	}
}

/* Chain conversions given the request and the original response
 * Also sets the responseXXX fields on the jqXHR instance
 */
function ajaxConvert( s, response, jqXHR, isSuccess ) {
	var conv2, current, conv, tmp, prev,
		converters = {},

		// Work with a copy of dataTypes in case we need to modify it for conversion
		dataTypes = s.dataTypes.slice();

	// Create converters map with lowercased keys
	if ( dataTypes[ 1 ] ) {
		for ( conv in s.converters ) {
			converters[ conv.toLowerCase() ] = s.converters[ conv ];
		}
	}

	current = dataTypes.shift();

	// Convert to each sequential dataType
	while ( current ) {

		if ( s.responseFields[ current ] ) {
			jqXHR[ s.responseFields[ current ] ] = response;
		}

		// Apply the dataFilter if provided
		if ( !prev && isSuccess && s.dataFilter ) {
			response = s.dataFilter( response, s.dataType );
		}

		prev = current;
		current = dataTypes.shift();

		if ( current ) {

		// There's only work to do if current dataType is non-auto
			if ( current === "*" ) {

				current = prev;

			// Convert response if prev dataType is non-auto and differs from current
			} else if ( prev !== "*" && prev !== current ) {

				// Seek a direct converter
				conv = converters[ prev + " " + current ] || converters[ "* " + current ];

				// If none found, seek a pair
				if ( !conv ) {
					for ( conv2 in converters ) {

						// If conv2 outputs current
						tmp = conv2.split( " " );
						if ( tmp[ 1 ] === current ) {

							// If prev can be converted to accepted input
							conv = converters[ prev + " " + tmp[ 0 ] ] ||
								converters[ "* " + tmp[ 0 ] ];
							if ( conv ) {

								// Condense equivalence converters
								if ( conv === true ) {
									conv = converters[ conv2 ];

								// Otherwise, insert the intermediate dataType
								} else if ( converters[ conv2 ] !== true ) {
									current = tmp[ 0 ];
									dataTypes.unshift( tmp[ 1 ] );
								}
								break;
							}
						}
					}
				}

				// Apply converter (if not an equivalence)
				if ( conv !== true ) {

					// Unless errors are allowed to bubble, catch and return them
					if ( conv && s.throws ) {
						response = conv( response );
					} else {
						try {
							response = conv( response );
						} catch ( e ) {
							return {
								state: "parsererror",
								error: conv ? e : "No conversion from " + prev + " to " + current
							};
						}
					}
				}
			}
		}
	}

	return { state: "success", data: response };
}

jQuery.extend( {

	// Counter for holding the number of active queries
	active: 0,

	// Last-Modified header cache for next request
	lastModified: {},
	etag: {},

	ajaxSettings: {
		url: location.href,
		type: "GET",
		isLocal: rlocalProtocol.test( location.protocol ),
		global: true,
		processData: true,
		async: true,
		contentType: "application/x-www-form-urlencoded; charset=UTF-8",
		/*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

		accepts: {
			"*": allTypes,
			text: "text/plain",
			html: "text/html",
			xml: "application/xml, text/xml",
			json: "application/json, text/javascript"
		},

		contents: {
			xml: /\bxml\b/,
			html: /\bhtml/,
			json: /\bjson\b/
		},

		responseFields: {
			xml: "responseXML",
			text: "responseText",
			json: "responseJSON"
		},

		// Data converters
		// Keys separate source (or catchall "*") and destination types with a single space
		converters: {

			// Convert anything to text
			"* text": String,

			// Text to html (true = no transformation)
			"text html": true,

			// Evaluate text as a json expression
			"text json": jQuery.parseJSON,

			// Parse text as xml
			"text xml": jQuery.parseXML
		},

		// For options that shouldn't be deep extended:
		// you can add your own custom options here if
		// and when you create one that shouldn't be
		// deep extended (see ajaxExtend)
		flatOptions: {
			url: true,
			context: true
		}
	},

	// Creates a full fledged settings object into target
	// with both ajaxSettings and settings fields.
	// If target is omitted, writes into ajaxSettings.
	ajaxSetup: function( target, settings ) {
		return settings ?

			// Building a settings object
			ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :

			// Extending ajaxSettings
			ajaxExtend( jQuery.ajaxSettings, target );
	},

	ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
	ajaxTransport: addToPrefiltersOrTransports( transports ),

	// Main method
	ajax: function( url, options ) {

		// If url is an object, simulate pre-1.5 signature
		if ( typeof url === "object" ) {
			options = url;
			url = undefined;
		}

		// Force options to be an object
		options = options || {};

		var transport,

			// URL without anti-cache param
			cacheURL,

			// Response headers
			responseHeadersString,
			responseHeaders,

			// timeout handle
			timeoutTimer,

			// Url cleanup var
			urlAnchor,

			// To know if global events are to be dispatched
			fireGlobals,

			// Loop variable
			i,

			// Create the final options object
			s = jQuery.ajaxSetup( {}, options ),

			// Callbacks context
			callbackContext = s.context || s,

			// Context for global events is callbackContext if it is a DOM node or jQuery collection
			globalEventContext = s.context &&
				( callbackContext.nodeType || callbackContext.jquery ) ?
					jQuery( callbackContext ) :
					jQuery.event,

			// Deferreds
			deferred = jQuery.Deferred(),
			completeDeferred = jQuery.Callbacks( "once memory" ),

			// Status-dependent callbacks
			statusCode = s.statusCode || {},

			// Headers (they are sent all at once)
			requestHeaders = {},
			requestHeadersNames = {},

			// The jqXHR state
			state = 0,

			// Default abort message
			strAbort = "canceled",

			// Fake xhr
			jqXHR = {
				readyState: 0,

				// Builds headers hashtable if needed
				getResponseHeader: function( key ) {
					var match;
					if ( state === 2 ) {
						if ( !responseHeaders ) {
							responseHeaders = {};
							while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
								responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
							}
						}
						match = responseHeaders[ key.toLowerCase() ];
					}
					return match == null ? null : match;
				},

				// Raw string
				getAllResponseHeaders: function() {
					return state === 2 ? responseHeadersString : null;
				},

				// Caches the header
				setRequestHeader: function( name, value ) {
					var lname = name.toLowerCase();
					if ( !state ) {
						name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
						requestHeaders[ name ] = value;
					}
					return this;
				},

				// Overrides response content-type header
				overrideMimeType: function( type ) {
					if ( !state ) {
						s.mimeType = type;
					}
					return this;
				},

				// Status-dependent callbacks
				statusCode: function( map ) {
					var code;
					if ( map ) {
						if ( state < 2 ) {
							for ( code in map ) {

								// Lazy-add the new callback in a way that preserves old ones
								statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
							}
						} else {

							// Execute the appropriate callbacks
							jqXHR.always( map[ jqXHR.status ] );
						}
					}
					return this;
				},

				// Cancel the request
				abort: function( statusText ) {
					var finalText = statusText || strAbort;
					if ( transport ) {
						transport.abort( finalText );
					}
					done( 0, finalText );
					return this;
				}
			};

		// Attach deferreds
		deferred.promise( jqXHR ).complete = completeDeferred.add;
		jqXHR.success = jqXHR.done;
		jqXHR.error = jqXHR.fail;

		// Remove hash character (#7531: and string promotion)
		// Add protocol if not provided (prefilters might expect it)
		// Handle falsy url in the settings object (#10093: consistency with old signature)
		// We also use the url parameter if available
		s.url = ( ( url || s.url || location.href ) + "" ).replace( rhash, "" )
			.replace( rprotocol, location.protocol + "//" );

		// Alias method option to type as per ticket #12004
		s.type = options.method || options.type || s.method || s.type;

		// Extract dataTypes list
		s.dataTypes = jQuery.trim( s.dataType || "*" ).toLowerCase().match( rnotwhite ) || [ "" ];

		// A cross-domain request is in order when the origin doesn't match the current origin.
		if ( s.crossDomain == null ) {
			urlAnchor = document.createElement( "a" );

			// Support: IE8-11+
			// IE throws exception if url is malformed, e.g. http://example.com:80x/
			try {
				urlAnchor.href = s.url;

				// Support: IE8-11+
				// Anchor's host property isn't correctly set when s.url is relative
				urlAnchor.href = urlAnchor.href;
				s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !==
					urlAnchor.protocol + "//" + urlAnchor.host;
			} catch ( e ) {

				// If there is an error parsing the URL, assume it is crossDomain,
				// it can be rejected by the transport if it is invalid
				s.crossDomain = true;
			}
		}

		// Convert data if not already a string
		if ( s.data && s.processData && typeof s.data !== "string" ) {
			s.data = jQuery.param( s.data, s.traditional );
		}

		// Apply prefilters
		inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

		// If request was aborted inside a prefilter, stop there
		if ( state === 2 ) {
			return jqXHR;
		}

		// We can fire global events as of now if asked to
		// Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
		fireGlobals = jQuery.event && s.global;

		// Watch for a new set of requests
		if ( fireGlobals && jQuery.active++ === 0 ) {
			jQuery.event.trigger( "ajaxStart" );
		}

		// Uppercase the type
		s.type = s.type.toUpperCase();

		// Determine if request has content
		s.hasContent = !rnoContent.test( s.type );

		// Save the URL in case we're toying with the If-Modified-Since
		// and/or If-None-Match header later on
		cacheURL = s.url;

		// More options handling for requests with no content
		if ( !s.hasContent ) {

			// If data is available, append data to url
			if ( s.data ) {
				cacheURL = ( s.url += ( rquery.test( cacheURL ) ? "&" : "?" ) + s.data );

				// #9682: remove data so that it's not used in an eventual retry
				delete s.data;
			}

			// Add anti-cache in url if needed
			if ( s.cache === false ) {
				s.url = rts.test( cacheURL ) ?

					// If there is already a '_' parameter, set its value
					cacheURL.replace( rts, "$1_=" + nonce++ ) :

					// Otherwise add one to the end
					cacheURL + ( rquery.test( cacheURL ) ? "&" : "?" ) + "_=" + nonce++;
			}
		}

		// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
		if ( s.ifModified ) {
			if ( jQuery.lastModified[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-Modified-Since", jQuery.lastModified[ cacheURL ] );
			}
			if ( jQuery.etag[ cacheURL ] ) {
				jqXHR.setRequestHeader( "If-None-Match", jQuery.etag[ cacheURL ] );
			}
		}

		// Set the correct header, if data is being sent
		if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
			jqXHR.setRequestHeader( "Content-Type", s.contentType );
		}

		// Set the Accepts header for the server, depending on the dataType
		jqXHR.setRequestHeader(
			"Accept",
			s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
				s.accepts[ s.dataTypes[ 0 ] ] +
					( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
				s.accepts[ "*" ]
		);

		// Check for headers option
		for ( i in s.headers ) {
			jqXHR.setRequestHeader( i, s.headers[ i ] );
		}

		// Allow custom headers/mimetypes and early abort
		if ( s.beforeSend &&
			( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {

			// Abort if not done already and return
			return jqXHR.abort();
		}

		// Aborting is no longer a cancellation
		strAbort = "abort";

		// Install callbacks on deferreds
		for ( i in { success: 1, error: 1, complete: 1 } ) {
			jqXHR[ i ]( s[ i ] );
		}

		// Get transport
		transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

		// If no transport, we auto-abort
		if ( !transport ) {
			done( -1, "No Transport" );
		} else {
			jqXHR.readyState = 1;

			// Send global event
			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
			}

			// If request was aborted inside ajaxSend, stop there
			if ( state === 2 ) {
				return jqXHR;
			}

			// Timeout
			if ( s.async && s.timeout > 0 ) {
				timeoutTimer = window.setTimeout( function() {
					jqXHR.abort( "timeout" );
				}, s.timeout );
			}

			try {
				state = 1;
				transport.send( requestHeaders, done );
			} catch ( e ) {

				// Propagate exception as error if not done
				if ( state < 2 ) {
					done( -1, e );

				// Simply rethrow otherwise
				} else {
					throw e;
				}
			}
		}

		// Callback for when everything is done
		function done( status, nativeStatusText, responses, headers ) {
			var isSuccess, success, error, response, modified,
				statusText = nativeStatusText;

			// Called once
			if ( state === 2 ) {
				return;
			}

			// State is "done" now
			state = 2;

			// Clear timeout if it exists
			if ( timeoutTimer ) {
				window.clearTimeout( timeoutTimer );
			}

			// Dereference transport for early garbage collection
			// (no matter how long the jqXHR object will be used)
			transport = undefined;

			// Cache response headers
			responseHeadersString = headers || "";

			// Set readyState
			jqXHR.readyState = status > 0 ? 4 : 0;

			// Determine if successful
			isSuccess = status >= 200 && status < 300 || status === 304;

			// Get response data
			if ( responses ) {
				response = ajaxHandleResponses( s, jqXHR, responses );
			}

			// Convert no matter what (that way responseXXX fields are always set)
			response = ajaxConvert( s, response, jqXHR, isSuccess );

			// If successful, handle type chaining
			if ( isSuccess ) {

				// Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
				if ( s.ifModified ) {
					modified = jqXHR.getResponseHeader( "Last-Modified" );
					if ( modified ) {
						jQuery.lastModified[ cacheURL ] = modified;
					}
					modified = jqXHR.getResponseHeader( "etag" );
					if ( modified ) {
						jQuery.etag[ cacheURL ] = modified;
					}
				}

				// if no content
				if ( status === 204 || s.type === "HEAD" ) {
					statusText = "nocontent";

				// if not modified
				} else if ( status === 304 ) {
					statusText = "notmodified";

				// If we have data, let's convert it
				} else {
					statusText = response.state;
					success = response.data;
					error = response.error;
					isSuccess = !error;
				}
			} else {

				// Extract error from statusText and normalize for non-aborts
				error = statusText;
				if ( status || !statusText ) {
					statusText = "error";
					if ( status < 0 ) {
						status = 0;
					}
				}
			}

			// Set data for the fake xhr object
			jqXHR.status = status;
			jqXHR.statusText = ( nativeStatusText || statusText ) + "";

			// Success/Error
			if ( isSuccess ) {
				deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
			} else {
				deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
			}

			// Status-dependent callbacks
			jqXHR.statusCode( statusCode );
			statusCode = undefined;

			if ( fireGlobals ) {
				globalEventContext.trigger( isSuccess ? "ajaxSuccess" : "ajaxError",
					[ jqXHR, s, isSuccess ? success : error ] );
			}

			// Complete
			completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

			if ( fireGlobals ) {
				globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );

				// Handle the global AJAX counter
				if ( !( --jQuery.active ) ) {
					jQuery.event.trigger( "ajaxStop" );
				}
			}
		}

		return jqXHR;
	},

	getJSON: function( url, data, callback ) {
		return jQuery.get( url, data, callback, "json" );
	},

	getScript: function( url, callback ) {
		return jQuery.get( url, undefined, callback, "script" );
	}
} );

jQuery.each( [ "get", "post" ], function( i, method ) {
	jQuery[ method ] = function( url, data, callback, type ) {

		// Shift arguments if data argument was omitted
		if ( jQuery.isFunction( data ) ) {
			type = type || callback;
			callback = data;
			data = undefined;
		}

		// The url can be an options object (which then must have .url)
		return jQuery.ajax( jQuery.extend( {
			url: url,
			type: method,
			dataType: type,
			data: data,
			success: callback
		}, jQuery.isPlainObject( url ) && url ) );
	};
} );


jQuery._evalUrl = function( url ) {
	return jQuery.ajax( {
		url: url,

		// Make this explicit, since user can override this through ajaxSetup (#11264)
		type: "GET",
		dataType: "script",
		async: false,
		global: false,
		"throws": true
	} );
};


jQuery.fn.extend( {
	wrapAll: function( html ) {
		var wrap;

		if ( jQuery.isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapAll( html.call( this, i ) );
			} );
		}

		if ( this[ 0 ] ) {

			// The elements to wrap the target around
			wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );

			if ( this[ 0 ].parentNode ) {
				wrap.insertBefore( this[ 0 ] );
			}

			wrap.map( function() {
				var elem = this;

				while ( elem.firstElementChild ) {
					elem = elem.firstElementChild;
				}

				return elem;
			} ).append( this );
		}

		return this;
	},

	wrapInner: function( html ) {
		if ( jQuery.isFunction( html ) ) {
			return this.each( function( i ) {
				jQuery( this ).wrapInner( html.call( this, i ) );
			} );
		}

		return this.each( function() {
			var self = jQuery( this ),
				contents = self.contents();

			if ( contents.length ) {
				contents.wrapAll( html );

			} else {
				self.append( html );
			}
		} );
	},

	wrap: function( html ) {
		var isFunction = jQuery.isFunction( html );

		return this.each( function( i ) {
			jQuery( this ).wrapAll( isFunction ? html.call( this, i ) : html );
		} );
	},

	unwrap: function() {
		return this.parent().each( function() {
			if ( !jQuery.nodeName( this, "body" ) ) {
				jQuery( this ).replaceWith( this.childNodes );
			}
		} ).end();
	}
} );


jQuery.expr.filters.hidden = function( elem ) {
	return !jQuery.expr.filters.visible( elem );
};
jQuery.expr.filters.visible = function( elem ) {

	// Support: Opera <= 12.12
	// Opera reports offsetWidths and offsetHeights less than zero on some elements
	// Use OR instead of AND as the element is not visible if either is true
	// See tickets #10406 and #13132
	return elem.offsetWidth > 0 || elem.offsetHeight > 0 || elem.getClientRects().length > 0;
};




var r20 = /%20/g,
	rbracket = /\[\]$/,
	rCRLF = /\r?\n/g,
	rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
	rsubmittable = /^(?:input|select|textarea|keygen)/i;

function buildParams( prefix, obj, traditional, add ) {
	var name;

	if ( jQuery.isArray( obj ) ) {

		// Serialize array item.
		jQuery.each( obj, function( i, v ) {
			if ( traditional || rbracket.test( prefix ) ) {

				// Treat each array item as a scalar.
				add( prefix, v );

			} else {

				// Item is non-scalar (array or object), encode its numeric index.
				buildParams(
					prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]",
					v,
					traditional,
					add
				);
			}
		} );

	} else if ( !traditional && jQuery.type( obj ) === "object" ) {

		// Serialize object item.
		for ( name in obj ) {
			buildParams( prefix + "[" + name + "]", obj[ name ], traditional, add );
		}

	} else {

		// Serialize scalar item.
		add( prefix, obj );
	}
}

// Serialize an array of form elements or a set of
// key/values into a query string
jQuery.param = function( a, traditional ) {
	var prefix,
		s = [],
		add = function( key, value ) {

			// If value is a function, invoke it and return its value
			value = jQuery.isFunction( value ) ? value() : ( value == null ? "" : value );
			s[ s.length ] = encodeURIComponent( key ) + "=" + encodeURIComponent( value );
		};

	// Set traditional to true for jQuery <= 1.3.2 behavior.
	if ( traditional === undefined ) {
		traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
	}

	// If an array was passed in, assume that it is an array of form elements.
	if ( jQuery.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {

		// Serialize the form elements
		jQuery.each( a, function() {
			add( this.name, this.value );
		} );

	} else {

		// If traditional, encode the "old" way (the way 1.3.2 or older
		// did it), otherwise encode params recursively.
		for ( prefix in a ) {
			buildParams( prefix, a[ prefix ], traditional, add );
		}
	}

	// Return the resulting serialization
	return s.join( "&" ).replace( r20, "+" );
};

jQuery.fn.extend( {
	serialize: function() {
		return jQuery.param( this.serializeArray() );
	},
	serializeArray: function() {
		return this.map( function() {

			// Can add propHook for "elements" to filter or add form elements
			var elements = jQuery.prop( this, "elements" );
			return elements ? jQuery.makeArray( elements ) : this;
		} )
		.filter( function() {
			var type = this.type;

			// Use .is( ":disabled" ) so that fieldset[disabled] works
			return this.name && !jQuery( this ).is( ":disabled" ) &&
				rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&
				( this.checked || !rcheckableType.test( type ) );
		} )
		.map( function( i, elem ) {
			var val = jQuery( this ).val();

			return val == null ?
				null :
				jQuery.isArray( val ) ?
					jQuery.map( val, function( val ) {
						return { name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
					} ) :
					{ name: elem.name, value: val.replace( rCRLF, "\r\n" ) };
		} ).get();
	}
} );


jQuery.ajaxSettings.xhr = function() {
	try {
		return new window.XMLHttpRequest();
	} catch ( e ) {}
};

var xhrSuccessStatus = {

		// File protocol always yields status code 0, assume 200
		0: 200,

		// Support: IE9
		// #1450: sometimes IE returns 1223 when it should be 204
		1223: 204
	},
	xhrSupported = jQuery.ajaxSettings.xhr();

support.cors = !!xhrSupported && ( "withCredentials" in xhrSupported );
support.ajax = xhrSupported = !!xhrSupported;

jQuery.ajaxTransport( function( options ) {
	var callback, errorCallback;

	// Cross domain only allowed if supported through XMLHttpRequest
	if ( support.cors || xhrSupported && !options.crossDomain ) {
		return {
			send: function( headers, complete ) {
				var i,
					xhr = options.xhr();

				xhr.open(
					options.type,
					options.url,
					options.async,
					options.username,
					options.password
				);

				// Apply custom fields if provided
				if ( options.xhrFields ) {
					for ( i in options.xhrFields ) {
						xhr[ i ] = options.xhrFields[ i ];
					}
				}

				// Override mime type if needed
				if ( options.mimeType && xhr.overrideMimeType ) {
					xhr.overrideMimeType( options.mimeType );
				}

				// X-Requested-With header
				// For cross-domain requests, seeing as conditions for a preflight are
				// akin to a jigsaw puzzle, we simply never set it to be sure.
				// (it can always be set on a per-request basis or even using ajaxSetup)
				// For same-domain requests, won't change header if already provided.
				if ( !options.crossDomain && !headers[ "X-Requested-With" ] ) {
					headers[ "X-Requested-With" ] = "XMLHttpRequest";
				}

				// Set headers
				for ( i in headers ) {
					xhr.setRequestHeader( i, headers[ i ] );
				}

				// Callback
				callback = function( type ) {
					return function() {
						if ( callback ) {
							callback = errorCallback = xhr.onload =
								xhr.onerror = xhr.onabort = xhr.onreadystatechange = null;

							if ( type === "abort" ) {
								xhr.abort();
							} else if ( type === "error" ) {

								// Support: IE9
								// On a manual native abort, IE9 throws
								// errors on any property access that is not readyState
								if ( typeof xhr.status !== "number" ) {
									complete( 0, "error" );
								} else {
									complete(

										// File: protocol always yields status 0; see #8605, #14207
										xhr.status,
										xhr.statusText
									);
								}
							} else {
								complete(
									xhrSuccessStatus[ xhr.status ] || xhr.status,
									xhr.statusText,

									// Support: IE9 only
									// IE9 has no XHR2 but throws on binary (trac-11426)
									// For XHR2 non-text, let the caller handle it (gh-2498)
									( xhr.responseType || "text" ) !== "text"  ||
									typeof xhr.responseText !== "string" ?
										{ binary: xhr.response } :
										{ text: xhr.responseText },
									xhr.getAllResponseHeaders()
								);
							}
						}
					};
				};

				// Listen to events
				xhr.onload = callback();
				errorCallback = xhr.onerror = callback( "error" );

				// Support: IE9
				// Use onreadystatechange to replace onabort
				// to handle uncaught aborts
				if ( xhr.onabort !== undefined ) {
					xhr.onabort = errorCallback;
				} else {
					xhr.onreadystatechange = function() {

						// Check readyState before timeout as it changes
						if ( xhr.readyState === 4 ) {

							// Allow onerror to be called first,
							// but that will not handle a native abort
							// Also, save errorCallback to a variable
							// as xhr.onerror cannot be accessed
							window.setTimeout( function() {
								if ( callback ) {
									errorCallback();
								}
							} );
						}
					};
				}

				// Create the abort callback
				callback = callback( "abort" );

				try {

					// Do send the request (this may raise an exception)
					xhr.send( options.hasContent && options.data || null );
				} catch ( e ) {

					// #14683: Only rethrow if this hasn't been notified as an error yet
					if ( callback ) {
						throw e;
					}
				}
			},

			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




// Install script dataType
jQuery.ajaxSetup( {
	accepts: {
		script: "text/javascript, application/javascript, " +
			"application/ecmascript, application/x-ecmascript"
	},
	contents: {
		script: /\b(?:java|ecma)script\b/
	},
	converters: {
		"text script": function( text ) {
			jQuery.globalEval( text );
			return text;
		}
	}
} );

// Handle cache's special case and crossDomain
jQuery.ajaxPrefilter( "script", function( s ) {
	if ( s.cache === undefined ) {
		s.cache = false;
	}
	if ( s.crossDomain ) {
		s.type = "GET";
	}
} );

// Bind script tag hack transport
jQuery.ajaxTransport( "script", function( s ) {

	// This transport only deals with cross domain requests
	if ( s.crossDomain ) {
		var script, callback;
		return {
			send: function( _, complete ) {
				script = jQuery( "<script>" ).prop( {
					charset: s.scriptCharset,
					src: s.url
				} ).on(
					"load error",
					callback = function( evt ) {
						script.remove();
						callback = null;
						if ( evt ) {
							complete( evt.type === "error" ? 404 : 200, evt.type );
						}
					}
				);

				// Use native DOM manipulation to avoid our domManip AJAX trickery
				document.head.appendChild( script[ 0 ] );
			},
			abort: function() {
				if ( callback ) {
					callback();
				}
			}
		};
	}
} );




var oldCallbacks = [],
	rjsonp = /(=)\?(?=&|$)|\?\?/;

// Default jsonp settings
jQuery.ajaxSetup( {
	jsonp: "callback",
	jsonpCallback: function() {
		var callback = oldCallbacks.pop() || ( jQuery.expando + "_" + ( nonce++ ) );
		this[ callback ] = true;
		return callback;
	}
} );

// Detect, normalize options and install callbacks for jsonp requests
jQuery.ajaxPrefilter( "json jsonp", function( s, originalSettings, jqXHR ) {

	var callbackName, overwritten, responseContainer,
		jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?
			"url" :
			typeof s.data === "string" &&
				( s.contentType || "" )
					.indexOf( "application/x-www-form-urlencoded" ) === 0 &&
				rjsonp.test( s.data ) && "data"
		);

	// Handle iff the expected data type is "jsonp" or we have a parameter to set
	if ( jsonProp || s.dataTypes[ 0 ] === "jsonp" ) {

		// Get callback name, remembering preexisting value associated with it
		callbackName = s.jsonpCallback = jQuery.isFunction( s.jsonpCallback ) ?
			s.jsonpCallback() :
			s.jsonpCallback;

		// Insert callback into url or form data
		if ( jsonProp ) {
			s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, "$1" + callbackName );
		} else if ( s.jsonp !== false ) {
			s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
		}

		// Use data converter to retrieve json after script execution
		s.converters[ "script json" ] = function() {
			if ( !responseContainer ) {
				jQuery.error( callbackName + " was not called" );
			}
			return responseContainer[ 0 ];
		};

		// Force json dataType
		s.dataTypes[ 0 ] = "json";

		// Install callback
		overwritten = window[ callbackName ];
		window[ callbackName ] = function() {
			responseContainer = arguments;
		};

		// Clean-up function (fires after converters)
		jqXHR.always( function() {

			// If previous value didn't exist - remove it
			if ( overwritten === undefined ) {
				jQuery( window ).removeProp( callbackName );

			// Otherwise restore preexisting value
			} else {
				window[ callbackName ] = overwritten;
			}

			// Save back as free
			if ( s[ callbackName ] ) {

				// Make sure that re-using the options doesn't screw things around
				s.jsonpCallback = originalSettings.jsonpCallback;

				// Save the callback name for future use
				oldCallbacks.push( callbackName );
			}

			// Call if it was a function and we have a response
			if ( responseContainer && jQuery.isFunction( overwritten ) ) {
				overwritten( responseContainer[ 0 ] );
			}

			responseContainer = overwritten = undefined;
		} );

		// Delegate to script
		return "script";
	}
} );




// Argument "data" should be string of html
// context (optional): If specified, the fragment will be created in this context,
// defaults to document
// keepScripts (optional): If true, will include scripts passed in the html string
jQuery.parseHTML = function( data, context, keepScripts ) {
	if ( !data || typeof data !== "string" ) {
		return null;
	}
	if ( typeof context === "boolean" ) {
		keepScripts = context;
		context = false;
	}
	context = context || document;

	var parsed = rsingleTag.exec( data ),
		scripts = !keepScripts && [];

	// Single tag
	if ( parsed ) {
		return [ context.createElement( parsed[ 1 ] ) ];
	}

	parsed = buildFragment( [ data ], context, scripts );

	if ( scripts && scripts.length ) {
		jQuery( scripts ).remove();
	}

	return jQuery.merge( [], parsed.childNodes );
};


// Keep a copy of the old load method
var _load = jQuery.fn.load;

/**
 * Load a url into a page
 */
jQuery.fn.load = function( url, params, callback ) {
	if ( typeof url !== "string" && _load ) {
		return _load.apply( this, arguments );
	}

	var selector, type, response,
		self = this,
		off = url.indexOf( " " );

	if ( off > -1 ) {
		selector = jQuery.trim( url.slice( off ) );
		url = url.slice( 0, off );
	}

	// If it's a function
	if ( jQuery.isFunction( params ) ) {

		// We assume that it's the callback
		callback = params;
		params = undefined;

	// Otherwise, build a param string
	} else if ( params && typeof params === "object" ) {
		type = "POST";
	}

	// If we have elements to modify, make the request
	if ( self.length > 0 ) {
		jQuery.ajax( {
			url: url,

			// If "type" variable is undefined, then "GET" method will be used.
			// Make value of this field explicit since
			// user can override it through ajaxSetup method
			type: type || "GET",
			dataType: "html",
			data: params
		} ).done( function( responseText ) {

			// Save response for use in complete callback
			response = arguments;

			self.html( selector ?

				// If a selector was specified, locate the right elements in a dummy div
				// Exclude scripts to avoid IE 'Permission Denied' errors
				jQuery( "<div>" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :

				// Otherwise use the full result
				responseText );

		// If the request succeeds, this function gets "data", "status", "jqXHR"
		// but they are ignored because response was set above.
		// If it fails, this function gets "jqXHR", "status", "error"
		} ).always( callback && function( jqXHR, status ) {
			self.each( function() {
				callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );
			} );
		} );
	}

	return this;
};




// Attach a bunch of functions for handling common AJAX events
jQuery.each( [
	"ajaxStart",
	"ajaxStop",
	"ajaxComplete",
	"ajaxError",
	"ajaxSuccess",
	"ajaxSend"
], function( i, type ) {
	jQuery.fn[ type ] = function( fn ) {
		return this.on( type, fn );
	};
} );




jQuery.expr.filters.animated = function( elem ) {
	return jQuery.grep( jQuery.timers, function( fn ) {
		return elem === fn.elem;
	} ).length;
};




/**
 * Gets a window from an element
 */
function getWindow( elem ) {
	return jQuery.isWindow( elem ) ? elem : elem.nodeType === 9 && elem.defaultView;
}

jQuery.offset = {
	setOffset: function( elem, options, i ) {
		var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,
			position = jQuery.css( elem, "position" ),
			curElem = jQuery( elem ),
			props = {};

		// Set position first, in-case top/left are set even on static elem
		if ( position === "static" ) {
			elem.style.position = "relative";
		}

		curOffset = curElem.offset();
		curCSSTop = jQuery.css( elem, "top" );
		curCSSLeft = jQuery.css( elem, "left" );
		calculatePosition = ( position === "absolute" || position === "fixed" ) &&
			( curCSSTop + curCSSLeft ).indexOf( "auto" ) > -1;

		// Need to be able to calculate position if either
		// top or left is auto and position is either absolute or fixed
		if ( calculatePosition ) {
			curPosition = curElem.position();
			curTop = curPosition.top;
			curLeft = curPosition.left;

		} else {
			curTop = parseFloat( curCSSTop ) || 0;
			curLeft = parseFloat( curCSSLeft ) || 0;
		}

		if ( jQuery.isFunction( options ) ) {

			// Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
			options = options.call( elem, i, jQuery.extend( {}, curOffset ) );
		}

		if ( options.top != null ) {
			props.top = ( options.top - curOffset.top ) + curTop;
		}
		if ( options.left != null ) {
			props.left = ( options.left - curOffset.left ) + curLeft;
		}

		if ( "using" in options ) {
			options.using.call( elem, props );

		} else {
			curElem.css( props );
		}
	}
};

jQuery.fn.extend( {
	offset: function( options ) {
		if ( arguments.length ) {
			return options === undefined ?
				this :
				this.each( function( i ) {
					jQuery.offset.setOffset( this, options, i );
				} );
		}

		var docElem, win,
			elem = this[ 0 ],
			box = { top: 0, left: 0 },
			doc = elem && elem.ownerDocument;

		if ( !doc ) {
			return;
		}

		docElem = doc.documentElement;

		// Make sure it's not a disconnected DOM node
		if ( !jQuery.contains( docElem, elem ) ) {
			return box;
		}

		box = elem.getBoundingClientRect();
		win = getWindow( doc );
		return {
			top: box.top + win.pageYOffset - docElem.clientTop,
			left: box.left + win.pageXOffset - docElem.clientLeft
		};
	},

	position: function() {
		if ( !this[ 0 ] ) {
			return;
		}

		var offsetParent, offset,
			elem = this[ 0 ],
			parentOffset = { top: 0, left: 0 };

		// Fixed elements are offset from window (parentOffset = {top:0, left: 0},
		// because it is its only offset parent
		if ( jQuery.css( elem, "position" ) === "fixed" ) {

			// Assume getBoundingClientRect is there when computed position is fixed
			offset = elem.getBoundingClientRect();

		} else {

			// Get *real* offsetParent
			offsetParent = this.offsetParent();

			// Get correct offsets
			offset = this.offset();
			if ( !jQuery.nodeName( offsetParent[ 0 ], "html" ) ) {
				parentOffset = offsetParent.offset();
			}

			// Add offsetParent borders
			parentOffset.top += jQuery.css( offsetParent[ 0 ], "borderTopWidth", true );
			parentOffset.left += jQuery.css( offsetParent[ 0 ], "borderLeftWidth", true );
		}

		// Subtract parent offsets and element margins
		return {
			top: offset.top - parentOffset.top - jQuery.css( elem, "marginTop", true ),
			left: offset.left - parentOffset.left - jQuery.css( elem, "marginLeft", true )
		};
	},

	// This method will return documentElement in the following cases:
	// 1) For the element inside the iframe without offsetParent, this method will return
	//    documentElement of the parent window
	// 2) For the hidden or detached element
	// 3) For body or html element, i.e. in case of the html node - it will return itself
	//
	// but those exceptions were never presented as a real life use-cases
	// and might be considered as more preferable results.
	//
	// This logic, however, is not guaranteed and can change at any point in the future
	offsetParent: function() {
		return this.map( function() {
			var offsetParent = this.offsetParent;

			while ( offsetParent && jQuery.css( offsetParent, "position" ) === "static" ) {
				offsetParent = offsetParent.offsetParent;
			}

			return offsetParent || documentElement;
		} );
	}
} );

// Create scrollLeft and scrollTop methods
jQuery.each( { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function( method, prop ) {
	var top = "pageYOffset" === prop;

	jQuery.fn[ method ] = function( val ) {
		return access( this, function( elem, method, val ) {
			var win = getWindow( elem );

			if ( val === undefined ) {
				return win ? win[ prop ] : elem[ method ];
			}

			if ( win ) {
				win.scrollTo(
					!top ? val : win.pageXOffset,
					top ? val : win.pageYOffset
				);

			} else {
				elem[ method ] = val;
			}
		}, method, val, arguments.length );
	};
} );

// Support: Safari<7-8+, Chrome<37-44+
// Add the top/left cssHooks using jQuery.fn.position
// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
// Blink bug: https://code.google.com/p/chromium/issues/detail?id=229280
// getComputedStyle returns percent when specified for top/left/bottom/right;
// rather than make the css module depend on the offset module, just check for it here
jQuery.each( [ "top", "left" ], function( i, prop ) {
	jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,
		function( elem, computed ) {
			if ( computed ) {
				computed = curCSS( elem, prop );

				// If curCSS returns percentage, fallback to offset
				return rnumnonpx.test( computed ) ?
					jQuery( elem ).position()[ prop ] + "px" :
					computed;
			}
		}
	);
} );


// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
jQuery.each( { Height: "height", Width: "width" }, function( name, type ) {
	jQuery.each( { padding: "inner" + name, content: type, "": "outer" + name },
		function( defaultExtra, funcName ) {

		// Margin is only for outerHeight, outerWidth
		jQuery.fn[ funcName ] = function( margin, value ) {
			var chainable = arguments.length && ( defaultExtra || typeof margin !== "boolean" ),
				extra = defaultExtra || ( margin === true || value === true ? "margin" : "border" );

			return access( this, function( elem, type, value ) {
				var doc;

				if ( jQuery.isWindow( elem ) ) {

					// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
					// isn't a whole lot we can do. See pull request at this URL for discussion:
					// https://github.com/jquery/jquery/pull/764
					return elem.document.documentElement[ "client" + name ];
				}

				// Get document width or height
				if ( elem.nodeType === 9 ) {
					doc = elem.documentElement;

					// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
					// whichever is greatest
					return Math.max(
						elem.body[ "scroll" + name ], doc[ "scroll" + name ],
						elem.body[ "offset" + name ], doc[ "offset" + name ],
						doc[ "client" + name ]
					);
				}

				return value === undefined ?

					// Get width or height on the element, requesting but not forcing parseFloat
					jQuery.css( elem, type, extra ) :

					// Set width or height on the element
					jQuery.style( elem, type, value, extra );
			}, type, chainable ? margin : undefined, chainable, null );
		};
	} );
} );


jQuery.fn.extend( {

	bind: function( types, data, fn ) {
		return this.on( types, null, data, fn );
	},
	unbind: function( types, fn ) {
		return this.off( types, null, fn );
	},

	delegate: function( selector, types, data, fn ) {
		return this.on( types, selector, data, fn );
	},
	undelegate: function( selector, types, fn ) {

		// ( namespace ) or ( selector, types [, fn] )
		return arguments.length === 1 ?
			this.off( selector, "**" ) :
			this.off( types, selector || "**", fn );
	},
	size: function() {
		return this.length;
	}
} );

jQuery.fn.andSelf = jQuery.fn.addBack;




// Register as a named AMD module, since jQuery can be concatenated with other
// files that may use define, but not via a proper concatenation script that
// understands anonymous AMD modules. A named AMD is safest and most robust
// way to register. Lowercase jquery is used because AMD module names are
// derived from file names, and jQuery is normally delivered in a lowercase
// file name. Do this after creating the global so that if an AMD module wants
// to call noConflict to hide this version of jQuery, it will work.

// Note that for maximum portability, libraries that are not jQuery should
// declare themselves as anonymous modules, and avoid setting a global if an
// AMD loader is present. jQuery is a special case. For more information, see
// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

if ( typeof define === "function" && define.amd ) {
	define( "jquery", [], function() {
		return jQuery;
	} );
}



var

	// Map over jQuery in case of overwrite
	_jQuery = window.jQuery,

	// Map over the $ in case of overwrite
	_$ = window.$;

jQuery.noConflict = function( deep ) {
	if ( window.$ === jQuery ) {
		window.$ = _$;
	}

	if ( deep && window.jQuery === jQuery ) {
		window.jQuery = _jQuery;
	}

	return jQuery;
};

// Expose jQuery and $ identifiers, even in AMD
// (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
// and CommonJS for browser emulators (#13566)
if ( !noGlobal ) {
	window.jQuery = window.$ = jQuery;
}

return jQuery;
}));

/* -------------------------------------------------------------------------- */
/* Copyright 2002-2019, OpenNebula Project, OpenNebula Systems                */
/*                                                                            */
/* Licensed under the Apache License, Version 2.0 (the "License"); you may    */
/* not use this file except in compliance with the License. You may obtain    */
/* a copy of the License at                                                   */
/*                                                                            */
/* http://www.apache.org/licenses/LICENSE-2.0                                 */
/*                                                                            */
/* Unless required by applicable law or agreed to in writing, software        */
/* distributed under the License is distributed on an "AS IS" BASIS,          */
/* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   */
/* See the License for the specific language governing permissions and        */
/* limitations under the License.                                             */
/* -------------------------------------------------------------------------- */

define('sunstone-config',['require','jquery'],function(require) {
  require("jquery");
  // Clone the local config object in a private var
  var _config = $.extend(true, {}, config);
  var Config = {
    "isTabEnabled": function(tabName) {
      var enabled = _config["view"]["enabled_tabs"].indexOf(tabName) != -1;
      return enabled;
    },

    "changeFilter": function(bool) {
      _config["pool_filter"] = bool;
    },

    "isChangedFilter": function(){
      return _config["pool_filter"];
    },

    "isTabActionEnabled": function(tabName, actionName, panelName) {
      var enabled = false;
      var configTab = _config["view"]["tabs"][tabName];

      if (configTab != undefined) {
        if (panelName) {
          enabled = configTab["panel_tabs_actions"][panelName][actionName];
        } else {
          enabled = configTab["actions"][actionName];
        }
      }

      return enabled;
    },

    "isTabPanelEnabled": function(tabName, panelTabName) {
      if (_config["view"]["tabs"][tabName]) {
        var enabled = _config["view"]["tabs"][tabName]["panel_tabs"][panelTabName];
        return enabled;
      } else {
        return false;
      }
    },

    "isProvisionTabEnabled": function(tabName, panelTabName) {
      if (_config["view"]["tabs"][tabName]) {
        if (_config["view"]["tabs"][tabName]["provision_tabs"]) {
          return _config["view"]["tabs"][tabName]["provision_tabs"][panelTabName];
        } else {
          // if provision_tabs is not defined use panel_tabs.
          // This attribute was used in before 4.14, provision_tabs was include in 4.14.2
          return _config["view"]["tabs"][tabName]["panel_tabs"][panelTabName];
        }
      } else {
        return false;
      }
    },

    "isFeatureEnabled": function(featureName) {
      if (_config["view"]["features"] && _config["view"]["features"][featureName]) {
        return true;
      } else {
        return false;
      }
    },

    "isAdvancedEnabled": function(featureName) {
      if (_config["view"]["features"] && featureName in _config["view"]["features"]) {
        return _config["view"]["features"][featureName];
      } else {
        return true;
      }
    },

    "tabTableColumns": function(tabName) {
      if (!_config["view"]["tabs"][tabName]) {
        return [];
      }

      var columns = _config["view"]["tabs"][tabName]["table_columns"];

      if (columns) {
        return columns;
      } else {
        return [];
      }
    },

    "isTemplateCreationTabEnabled": function(tabName, wizardTabName) {
      var enabled = false;

      if (_config["view"]["tabs"][tabName] && _config["view"]["tabs"][tabName]["template_creation_tabs"]) {
        enabled = _config["view"]["tabs"][tabName]["template_creation_tabs"][wizardTabName];
      }

      return (enabled == true);
    },

    "dashboardWidgets": function(perRow) {
      if (!_config["view"]["tabs"]["dashboard-tab"]) {
        return [];
      }

      var widgets = _config["view"]["tabs"]["dashboard-tab"][perRow];

      if (widgets) {
        return widgets;
      } else {
        return [];
      }
    },

    "tableOrder": function() {
      return _config["user_config"]["table_order"];
    },

    "provision": {
      "dashboard": {
        "isEnabled": function(widget) {
          if (_config["view"]["tabs"]["provision-tab"]) {
            var enabled = _config["view"]["tabs"]["provision-tab"]["dashboard"][widget];
            return enabled;
          } else {
            return false;
          }
        }
      },
      "create_vm": {
        "isEnabled": function(widget) {
          if (_config["view"]["tabs"]["provision-tab"] && _config["view"]["tabs"]["provision-tab"]["create_vm"]) {
            return _config["view"]["tabs"]["provision-tab"]["create_vm"][widget];
          } else {
            return false;
          }
        }
      },
      "logo": (_config["view"]["provision_logo"] || "images/one_small_logo.png"),
    },

    "tableOrder": _config["user_config"]["table_order"],
    "vncProxyPort": _config["system_config"]["vnc_client_port"] || _config["system_config"]["vnc_proxy_port"].split(":")[1] || _config["system_config"]["vnc_proxy_port"],
    "vncWSS": _config["user_config"]["vnc_wss"],
    "requestVNCPassword": _config["system_config"]["vnc_request_password"],
    "logo": (_config["view"]["small_logo"] || "images/one_small_logo.png"),
    "link_logo": (_config["view"]["link_logo"] || false),
    "text_link_logo": (_config["view"]["text_link_logo"] || false),
    "vmLogos": (_config["vm_logos"]),
    "enabledTabs": _config["view"]["enabled_tabs"],
    "onedConf": _config["oned_conf"],
    "confirmVMActions": _config["view"]["confirm_vms"],
    "scaleFactor": _config["view"]["features"]["instantiate_cpu_factor"],
    "filterView": _config["view"]["filter-view"],
    "doCountAnimation": _config["view"]["do_count_animation"],

    "allTabs": function() {
      return Object.keys(_config["view"]["tabs"]);
    }
  };

  return Config;
});

define('../bower_components/no-vnc/lib/util/logging.js',['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init_logging = init_logging;
    exports.get_logging = get_logging;
    /*
     * noVNC: HTML5 VNC client
     * Copyright (C) 2018 The noVNC Authors
     * Licensed under MPL 2.0 (see LICENSE.txt)
     *
     * See README.md for usage and integration instructions.
     */

    /*
     * Logging/debug routines
     */

    var _log_level = 'warn';

    var Debug = function Debug() {};
    var Info = function Info() {};
    var Warn = function Warn() {};
    var Error = function Error() {};

    function init_logging(level) {
        if (typeof level === 'undefined') {
            level = _log_level;
        } else {
            _log_level = level;
        }

        exports.Debug = Debug = exports.Info = Info = exports.Warn = Warn = exports.Error = Error = function Error() {};

        if (typeof window.console !== "undefined") {
            /* eslint-disable no-console, no-fallthrough */
            switch (level) {
                case 'debug':
                    exports.Debug = Debug = console.debug.bind(window.console);
                case 'info':
                    exports.Info = Info = console.info.bind(window.console);
                case 'warn':
                    exports.Warn = Warn = console.warn.bind(window.console);
                case 'error':
                    exports.Error = Error = console.error.bind(window.console);
                case 'none':
                    break;
                default:
                    throw new window.Error("invalid logging type '" + level + "'");
            }
            /* eslint-enable no-console, no-fallthrough */
        }
    }

    function get_logging() {
        return _log_level;
    }

    exports.Debug = Debug;
    exports.Info = Info;
    exports.Warn = Warn;
    exports.Error = Error;


    // Initialize logging level
    init_logging();
});
define('../bower_components/no-vnc/lib/util/strings.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.decodeUTF8 = decodeUTF8;
  /*
   * noVNC: HTML5 VNC client
   * Copyright (C) 2018 The noVNC Authors
   * Licensed under MPL 2.0 (see LICENSE.txt)
   *
   * See README.md for usage and integration instructions.
   */

  /*
   * Decode from UTF-8
   */
  function decodeUTF8(utf8string) {
    return decodeURIComponent(escape(utf8string));
  }
});
define('../bower_components/no-vnc/lib/util/browser.js',['exports', './logging.js'], function (exports, _logging) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.supportsImageMetadata = exports.supportsCursorURIs = exports.dragThreshold = exports.isTouchDevice = undefined;
    exports.isMac = isMac;
    exports.isWindows = isWindows;
    exports.isIOS = isIOS;
    exports.isAndroid = isAndroid;
    exports.isSafari = isSafari;
    exports.isIE = isIE;
    exports.isEdge = isEdge;
    exports.isFirefox = isFirefox;

    var Log = _interopRequireWildcard(_logging);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    // Touch detection
    var isTouchDevice = exports.isTouchDevice = 'ontouchstart' in document.documentElement ||
    // requried for Chrome debugger
    document.ontouchstart !== undefined ||
    // required for MS Surface
    navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0; /*
                                                                     * noVNC: HTML5 VNC client
                                                                     * Copyright (C) 2018 The noVNC Authors
                                                                     * Licensed under MPL 2.0 (see LICENSE.txt)
                                                                     *
                                                                     * See README.md for usage and integration instructions.
                                                                     */

    window.addEventListener('touchstart', function onFirstTouch() {
        exports.isTouchDevice = isTouchDevice = true;
        window.removeEventListener('touchstart', onFirstTouch, false);
    }, false);

    // The goal is to find a certain physical width, the devicePixelRatio
    // brings us a bit closer but is not optimal.
    var dragThreshold = exports.dragThreshold = 10 * (window.devicePixelRatio || 1);

    var _supportsCursorURIs = false;

    try {
        var target = document.createElement('canvas');
        target.style.cursor = 'url("data:image/x-icon;base64,AAACAAEACAgAAAIAAgA4AQAAFgAAACgAAAAIAAAAEAAAAAEAIAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAD/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////AAAAAAAAAAAAAAAAAAAAAA==") 2 2, default';

        if (target.style.cursor) {
            Log.Info("Data URI scheme cursor supported");
            _supportsCursorURIs = true;
        } else {
            Log.Warn("Data URI scheme cursor not supported");
        }
    } catch (exc) {
        Log.Error("Data URI scheme cursor test exception: " + exc);
    }

    var supportsCursorURIs = exports.supportsCursorURIs = _supportsCursorURIs;

    var _supportsImageMetadata = false;
    try {
        new ImageData(new Uint8ClampedArray(4), 1, 1);
        _supportsImageMetadata = true;
    } catch (ex) {
        // ignore failure
    }
    var supportsImageMetadata = exports.supportsImageMetadata = _supportsImageMetadata;

    function isMac() {
        return navigator && !!/mac/i.exec(navigator.platform);
    }

    function isWindows() {
        return navigator && !!/win/i.exec(navigator.platform);
    }

    function isIOS() {
        return navigator && (!!/ipad/i.exec(navigator.platform) || !!/iphone/i.exec(navigator.platform) || !!/ipod/i.exec(navigator.platform));
    }

    function isAndroid() {
        return navigator && !!/android/i.exec(navigator.userAgent);
    }

    function isSafari() {
        return navigator && navigator.userAgent.indexOf('Safari') !== -1 && navigator.userAgent.indexOf('Chrome') === -1;
    }

    function isIE() {
        return navigator && !!/trident/i.exec(navigator.userAgent);
    }

    function isEdge() {
        return navigator && !!/edge/i.exec(navigator.userAgent);
    }

    function isFirefox() {
        return navigator && !!/firefox/i.exec(navigator.userAgent);
    }
});
define('../bower_components/no-vnc/lib/util/eventtarget.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var EventTargetMixin = function () {
        function EventTargetMixin() {
            _classCallCheck(this, EventTargetMixin);

            this._listeners = new Map();
        }

        _createClass(EventTargetMixin, [{
            key: "addEventListener",
            value: function addEventListener(type, callback) {
                if (!this._listeners.has(type)) {
                    this._listeners.set(type, new Set());
                }
                this._listeners.get(type).add(callback);
            }
        }, {
            key: "removeEventListener",
            value: function removeEventListener(type, callback) {
                if (this._listeners.has(type)) {
                    this._listeners.get(type).delete(callback);
                }
            }
        }, {
            key: "dispatchEvent",
            value: function dispatchEvent(event) {
                var _this = this;

                if (!this._listeners.has(event.type)) {
                    return true;
                }
                this._listeners.get(event.type).forEach(function (callback) {
                    return callback.call(_this, event);
                });
                return !event.defaultPrevented;
            }
        }]);

        return EventTargetMixin;
    }();

    exports.default = EventTargetMixin;
});
define('../bower_components/no-vnc/lib/base64.js',['exports', './util/logging.js'], function (exports, _logging) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    exports.default = {
        /* Convert data (an array of integers) to a Base64 string. */
        toBase64Table: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/='.split(''),
        base64Pad: '=',

        encode: function encode(data) {
            "use strict";

            var result = '';
            var length = data.length;
            var lengthpad = length % 3;
            // Convert every three bytes to 4 ascii characters.

            for (var i = 0; i < length - 2; i += 3) {
                result += this.toBase64Table[data[i] >> 2];
                result += this.toBase64Table[((data[i] & 0x03) << 4) + (data[i + 1] >> 4)];
                result += this.toBase64Table[((data[i + 1] & 0x0f) << 2) + (data[i + 2] >> 6)];
                result += this.toBase64Table[data[i + 2] & 0x3f];
            }

            // Convert the remaining 1 or 2 bytes, pad out to 4 characters.
            var j = length - lengthpad;
            if (lengthpad === 2) {
                result += this.toBase64Table[data[j] >> 2];
                result += this.toBase64Table[((data[j] & 0x03) << 4) + (data[j + 1] >> 4)];
                result += this.toBase64Table[(data[j + 1] & 0x0f) << 2];
                result += this.toBase64Table[64];
            } else if (lengthpad === 1) {
                result += this.toBase64Table[data[j] >> 2];
                result += this.toBase64Table[(data[j] & 0x03) << 4];
                result += this.toBase64Table[64];
                result += this.toBase64Table[64];
            }

            return result;
        },


        /* Convert Base64 data to a string */
        /* eslint-disable comma-spacing */
        toBinaryTable: [-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1],
        /* eslint-enable comma-spacing */

        decode: function decode(data) {
            var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            var data_length = data.indexOf('=') - offset;
            if (data_length < 0) {
                data_length = data.length - offset;
            }

            /* Every four characters is 3 resulting numbers */
            var result_length = (data_length >> 2) * 3 + Math.floor(data_length % 4 / 1.5);
            var result = new Array(result_length);

            // Convert one by one.

            var leftbits = 0; // number of bits decoded, but yet to be appended
            var leftdata = 0; // bits decoded, but yet to be appended
            for (var idx = 0, i = offset; i < data.length; i++) {
                var c = this.toBinaryTable[data.charCodeAt(i) & 0x7f];
                var padding = data.charAt(i) === this.base64Pad;
                // Skip illegal characters and whitespace
                if (c === -1) {
                    Log.Error("Illegal character code " + data.charCodeAt(i) + " at position " + i);
                    continue;
                }

                // Collect data into leftdata, update bitcount
                leftdata = leftdata << 6 | c;
                leftbits += 6;

                // If we have 8 or more bits, append 8 bits to the result
                if (leftbits >= 8) {
                    leftbits -= 8;
                    // Append if not padding.
                    if (!padding) {
                        result[idx++] = leftdata >> leftbits & 0xff;
                    }
                    leftdata &= (1 << leftbits) - 1;
                }
            }

            // If there are any bits left, the base64 string was corrupted
            if (leftbits) {
                var err = new Error('Corrupted base64 string');
                err.name = 'Base64-Error';
                throw err;
            }

            return result;
        }
    };
});
define('../bower_components/no-vnc/lib/display.js',['exports', './util/logging.js', './base64.js', './util/browser.js'], function (exports, _logging, _base, _browser) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    var _base2 = _interopRequireDefault(_base);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var Display = function () {
        function Display(target) {
            _classCallCheck(this, Display);

            this._drawCtx = null;
            this._c_forceCanvas = false;

            this._renderQ = []; // queue drawing actions for in-oder rendering
            this._flushing = false;

            // the full frame buffer (logical canvas) size
            this._fb_width = 0;
            this._fb_height = 0;

            this._prevDrawStyle = "";
            this._tile = null;
            this._tile16x16 = null;
            this._tile_x = 0;
            this._tile_y = 0;

            Log.Debug(">> Display.constructor");

            // The visible canvas
            this._target = target;

            if (!this._target) {
                throw new Error("Target must be set");
            }

            if (typeof this._target === 'string') {
                throw new Error('target must be a DOM element');
            }

            if (!this._target.getContext) {
                throw new Error("no getContext method");
            }

            this._targetCtx = this._target.getContext('2d');

            // the visible canvas viewport (i.e. what actually gets seen)
            this._viewportLoc = { 'x': 0, 'y': 0, 'w': this._target.width, 'h': this._target.height };

            // The hidden canvas, where we do the actual rendering
            this._backbuffer = document.createElement('canvas');
            this._drawCtx = this._backbuffer.getContext('2d');

            this._damageBounds = { left: 0, top: 0,
                right: this._backbuffer.width,
                bottom: this._backbuffer.height };

            Log.Debug("User Agent: " + navigator.userAgent);

            this.clear();

            // Check canvas features
            if (!('createImageData' in this._drawCtx)) {
                throw new Error("Canvas does not support createImageData");
            }

            this._tile16x16 = this._drawCtx.createImageData(16, 16);
            Log.Debug("<< Display.constructor");

            // ===== PROPERTIES =====

            this._scale = 1.0;
            this._clipViewport = false;
            this.logo = null;

            // ===== EVENT HANDLERS =====

            this.onflush = function () {}; // A flush request has finished
        }

        // ===== PROPERTIES =====

        _createClass(Display, [{
            key: 'viewportChangePos',
            value: function viewportChangePos(deltaX, deltaY) {
                var vp = this._viewportLoc;
                deltaX = Math.floor(deltaX);
                deltaY = Math.floor(deltaY);

                if (!this._clipViewport) {
                    deltaX = -vp.w; // clamped later of out of bounds
                    deltaY = -vp.h;
                }

                var vx2 = vp.x + vp.w - 1;
                var vy2 = vp.y + vp.h - 1;

                // Position change

                if (deltaX < 0 && vp.x + deltaX < 0) {
                    deltaX = -vp.x;
                }
                if (vx2 + deltaX >= this._fb_width) {
                    deltaX -= vx2 + deltaX - this._fb_width + 1;
                }

                if (vp.y + deltaY < 0) {
                    deltaY = -vp.y;
                }
                if (vy2 + deltaY >= this._fb_height) {
                    deltaY -= vy2 + deltaY - this._fb_height + 1;
                }

                if (deltaX === 0 && deltaY === 0) {
                    return;
                }
                Log.Debug("viewportChange deltaX: " + deltaX + ", deltaY: " + deltaY);

                vp.x += deltaX;
                vp.y += deltaY;

                this._damage(vp.x, vp.y, vp.w, vp.h);

                this.flip();
            }
        }, {
            key: 'viewportChangeSize',
            value: function viewportChangeSize(width, height) {

                if (!this._clipViewport || typeof width === "undefined" || typeof height === "undefined") {

                    Log.Debug("Setting viewport to full display region");
                    width = this._fb_width;
                    height = this._fb_height;
                }

                width = Math.floor(width);
                height = Math.floor(height);

                if (width > this._fb_width) {
                    width = this._fb_width;
                }
                if (height > this._fb_height) {
                    height = this._fb_height;
                }

                var vp = this._viewportLoc;
                if (vp.w !== width || vp.h !== height) {
                    vp.w = width;
                    vp.h = height;

                    var canvas = this._target;
                    canvas.width = width;
                    canvas.height = height;

                    // The position might need to be updated if we've grown
                    this.viewportChangePos(0, 0);

                    this._damage(vp.x, vp.y, vp.w, vp.h);
                    this.flip();

                    // Update the visible size of the target canvas
                    this._rescale(this._scale);
                }
            }
        }, {
            key: 'absX',
            value: function absX(x) {
                if (this._scale === 0) {
                    return 0;
                }
                return x / this._scale + this._viewportLoc.x;
            }
        }, {
            key: 'absY',
            value: function absY(y) {
                if (this._scale === 0) {
                    return 0;
                }
                return y / this._scale + this._viewportLoc.y;
            }
        }, {
            key: 'resize',
            value: function resize(width, height) {
                this._prevDrawStyle = "";

                this._fb_width = width;
                this._fb_height = height;

                var canvas = this._backbuffer;
                if (canvas.width !== width || canvas.height !== height) {

                    // We have to save the canvas data since changing the size will clear it
                    var saveImg = null;
                    if (canvas.width > 0 && canvas.height > 0) {
                        saveImg = this._drawCtx.getImageData(0, 0, canvas.width, canvas.height);
                    }

                    if (canvas.width !== width) {
                        canvas.width = width;
                    }
                    if (canvas.height !== height) {
                        canvas.height = height;
                    }

                    if (saveImg) {
                        this._drawCtx.putImageData(saveImg, 0, 0);
                    }
                }

                // Readjust the viewport as it may be incorrectly sized
                // and positioned
                var vp = this._viewportLoc;
                this.viewportChangeSize(vp.w, vp.h);
                this.viewportChangePos(0, 0);
            }
        }, {
            key: '_damage',
            value: function _damage(x, y, w, h) {
                if (x < this._damageBounds.left) {
                    this._damageBounds.left = x;
                }
                if (y < this._damageBounds.top) {
                    this._damageBounds.top = y;
                }
                if (x + w > this._damageBounds.right) {
                    this._damageBounds.right = x + w;
                }
                if (y + h > this._damageBounds.bottom) {
                    this._damageBounds.bottom = y + h;
                }
            }
        }, {
            key: 'flip',
            value: function flip(from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    this._renderQ_push({
                        'type': 'flip'
                    });
                } else {
                    var x = this._damageBounds.left;
                    var y = this._damageBounds.top;
                    var w = this._damageBounds.right - x;
                    var h = this._damageBounds.bottom - y;

                    var vx = x - this._viewportLoc.x;
                    var vy = y - this._viewportLoc.y;

                    if (vx < 0) {
                        w += vx;
                        x -= vx;
                        vx = 0;
                    }
                    if (vy < 0) {
                        h += vy;
                        y -= vy;
                        vy = 0;
                    }

                    if (vx + w > this._viewportLoc.w) {
                        w = this._viewportLoc.w - vx;
                    }
                    if (vy + h > this._viewportLoc.h) {
                        h = this._viewportLoc.h - vy;
                    }

                    if (w > 0 && h > 0) {
                        // FIXME: We may need to disable image smoothing here
                        //        as well (see copyImage()), but we haven't
                        //        noticed any problem yet.
                        this._targetCtx.drawImage(this._backbuffer, x, y, w, h, vx, vy, w, h);
                    }

                    this._damageBounds.left = this._damageBounds.top = 65535;
                    this._damageBounds.right = this._damageBounds.bottom = 0;
                }
            }
        }, {
            key: 'clear',
            value: function clear() {
                if (this._logo) {
                    this.resize(this._logo.width, this._logo.height);
                    this.imageRect(0, 0, this._logo.type, this._logo.data);
                } else {
                    this.resize(240, 20);
                    this._drawCtx.clearRect(0, 0, this._fb_width, this._fb_height);
                }
                this.flip();
            }
        }, {
            key: 'pending',
            value: function pending() {
                return this._renderQ.length > 0;
            }
        }, {
            key: 'flush',
            value: function flush() {
                if (this._renderQ.length === 0) {
                    this.onflush();
                } else {
                    this._flushing = true;
                }
            }
        }, {
            key: 'fillRect',
            value: function fillRect(x, y, width, height, color, from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    this._renderQ_push({
                        'type': 'fill',
                        'x': x,
                        'y': y,
                        'width': width,
                        'height': height,
                        'color': color
                    });
                } else {
                    this._setFillColor(color);
                    this._drawCtx.fillRect(x, y, width, height);
                    this._damage(x, y, width, height);
                }
            }
        }, {
            key: 'copyImage',
            value: function copyImage(old_x, old_y, new_x, new_y, w, h, from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    this._renderQ_push({
                        'type': 'copy',
                        'old_x': old_x,
                        'old_y': old_y,
                        'x': new_x,
                        'y': new_y,
                        'width': w,
                        'height': h
                    });
                } else {
                    // Due to this bug among others [1] we need to disable the image-smoothing to
                    // avoid getting a blur effect when copying data.
                    //
                    // 1. https://bugzilla.mozilla.org/show_bug.cgi?id=1194719
                    //
                    // We need to set these every time since all properties are reset
                    // when the the size is changed
                    this._drawCtx.mozImageSmoothingEnabled = false;
                    this._drawCtx.webkitImageSmoothingEnabled = false;
                    this._drawCtx.msImageSmoothingEnabled = false;
                    this._drawCtx.imageSmoothingEnabled = false;

                    this._drawCtx.drawImage(this._backbuffer, old_x, old_y, w, h, new_x, new_y, w, h);
                    this._damage(new_x, new_y, w, h);
                }
            }
        }, {
            key: 'imageRect',
            value: function imageRect(x, y, mime, arr) {
                var img = new Image();
                img.src = "data: " + mime + ";base64," + _base2.default.encode(arr);
                this._renderQ_push({
                    'type': 'img',
                    'img': img,
                    'x': x,
                    'y': y
                });
            }
        }, {
            key: 'startTile',
            value: function startTile(x, y, width, height, color) {
                this._tile_x = x;
                this._tile_y = y;
                if (width === 16 && height === 16) {
                    this._tile = this._tile16x16;
                } else {
                    this._tile = this._drawCtx.createImageData(width, height);
                }

                var red = color[2];
                var green = color[1];
                var blue = color[0];

                var data = this._tile.data;
                for (var i = 0; i < width * height * 4; i += 4) {
                    data[i] = red;
                    data[i + 1] = green;
                    data[i + 2] = blue;
                    data[i + 3] = 255;
                }
            }
        }, {
            key: 'subTile',
            value: function subTile(x, y, w, h, color) {
                var red = color[2];
                var green = color[1];
                var blue = color[0];
                var xend = x + w;
                var yend = y + h;

                var data = this._tile.data;
                var width = this._tile.width;
                for (var j = y; j < yend; j++) {
                    for (var i = x; i < xend; i++) {
                        var p = (i + j * width) * 4;
                        data[p] = red;
                        data[p + 1] = green;
                        data[p + 2] = blue;
                        data[p + 3] = 255;
                    }
                }
            }
        }, {
            key: 'finishTile',
            value: function finishTile() {
                this._drawCtx.putImageData(this._tile, this._tile_x, this._tile_y);
                this._damage(this._tile_x, this._tile_y, this._tile.width, this._tile.height);
            }
        }, {
            key: 'blitImage',
            value: function blitImage(x, y, width, height, arr, offset, from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    // NB(directxman12): it's technically more performant here to use preallocated arrays,
                    // but it's a lot of extra work for not a lot of payoff -- if we're using the render queue,
                    // this probably isn't getting called *nearly* as much
                    var new_arr = new Uint8Array(width * height * 4);
                    new_arr.set(new Uint8Array(arr.buffer, 0, new_arr.length));
                    this._renderQ_push({
                        'type': 'blit',
                        'data': new_arr,
                        'x': x,
                        'y': y,
                        'width': width,
                        'height': height
                    });
                } else {
                    this._bgrxImageData(x, y, width, height, arr, offset);
                }
            }
        }, {
            key: 'blitRgbImage',
            value: function blitRgbImage(x, y, width, height, arr, offset, from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    // NB(directxman12): it's technically more performant here to use preallocated arrays,
                    // but it's a lot of extra work for not a lot of payoff -- if we're using the render queue,
                    // this probably isn't getting called *nearly* as much
                    var new_arr = new Uint8Array(width * height * 3);
                    new_arr.set(new Uint8Array(arr.buffer, 0, new_arr.length));
                    this._renderQ_push({
                        'type': 'blitRgb',
                        'data': new_arr,
                        'x': x,
                        'y': y,
                        'width': width,
                        'height': height
                    });
                } else {
                    this._rgbImageData(x, y, width, height, arr, offset);
                }
            }
        }, {
            key: 'blitRgbxImage',
            value: function blitRgbxImage(x, y, width, height, arr, offset, from_queue) {
                if (this._renderQ.length !== 0 && !from_queue) {
                    // NB(directxman12): it's technically more performant here to use preallocated arrays,
                    // but it's a lot of extra work for not a lot of payoff -- if we're using the render queue,
                    // this probably isn't getting called *nearly* as much
                    var new_arr = new Uint8Array(width * height * 4);
                    new_arr.set(new Uint8Array(arr.buffer, 0, new_arr.length));
                    this._renderQ_push({
                        'type': 'blitRgbx',
                        'data': new_arr,
                        'x': x,
                        'y': y,
                        'width': width,
                        'height': height
                    });
                } else {
                    this._rgbxImageData(x, y, width, height, arr, offset);
                }
            }
        }, {
            key: 'drawImage',
            value: function drawImage(img, x, y) {
                this._drawCtx.drawImage(img, x, y);
                this._damage(x, y, img.width, img.height);
            }
        }, {
            key: 'autoscale',
            value: function autoscale(containerWidth, containerHeight) {
                var scaleRatio = void 0;

                if (containerWidth === 0 || containerHeight === 0) {
                    scaleRatio = 0;
                } else {

                    var vp = this._viewportLoc;
                    var targetAspectRatio = containerWidth / containerHeight;
                    var fbAspectRatio = vp.w / vp.h;

                    if (fbAspectRatio >= targetAspectRatio) {
                        scaleRatio = containerWidth / vp.w;
                    } else {
                        scaleRatio = containerHeight / vp.h;
                    }
                }

                this._rescale(scaleRatio);
            }
        }, {
            key: '_rescale',
            value: function _rescale(factor) {
                this._scale = factor;
                var vp = this._viewportLoc;

                // NB(directxman12): If you set the width directly, or set the
                //                   style width to a number, the canvas is cleared.
                //                   However, if you set the style width to a string
                //                   ('NNNpx'), the canvas is scaled without clearing.
                var width = factor * vp.w + 'px';
                var height = factor * vp.h + 'px';

                if (this._target.style.width !== width || this._target.style.height !== height) {
                    this._target.style.width = width;
                    this._target.style.height = height;
                }
            }
        }, {
            key: '_setFillColor',
            value: function _setFillColor(color) {
                var newStyle = 'rgb(' + color[2] + ',' + color[1] + ',' + color[0] + ')';
                if (newStyle !== this._prevDrawStyle) {
                    this._drawCtx.fillStyle = newStyle;
                    this._prevDrawStyle = newStyle;
                }
            }
        }, {
            key: '_rgbImageData',
            value: function _rgbImageData(x, y, width, height, arr, offset) {
                var img = this._drawCtx.createImageData(width, height);
                var data = img.data;
                for (var i = 0, j = offset; i < width * height * 4; i += 4, j += 3) {
                    data[i] = arr[j];
                    data[i + 1] = arr[j + 1];
                    data[i + 2] = arr[j + 2];
                    data[i + 3] = 255; // Alpha
                }
                this._drawCtx.putImageData(img, x, y);
                this._damage(x, y, img.width, img.height);
            }
        }, {
            key: '_bgrxImageData',
            value: function _bgrxImageData(x, y, width, height, arr, offset) {
                var img = this._drawCtx.createImageData(width, height);
                var data = img.data;
                for (var i = 0, j = offset; i < width * height * 4; i += 4, j += 4) {
                    data[i] = arr[j + 2];
                    data[i + 1] = arr[j + 1];
                    data[i + 2] = arr[j];
                    data[i + 3] = 255; // Alpha
                }
                this._drawCtx.putImageData(img, x, y);
                this._damage(x, y, img.width, img.height);
            }
        }, {
            key: '_rgbxImageData',
            value: function _rgbxImageData(x, y, width, height, arr, offset) {
                // NB(directxman12): arr must be an Type Array view
                var img = void 0;
                if (_browser.supportsImageMetadata) {
                    img = new ImageData(new Uint8ClampedArray(arr.buffer, arr.byteOffset, width * height * 4), width, height);
                } else {
                    img = this._drawCtx.createImageData(width, height);
                    img.data.set(new Uint8ClampedArray(arr.buffer, arr.byteOffset, width * height * 4));
                }
                this._drawCtx.putImageData(img, x, y);
                this._damage(x, y, img.width, img.height);
            }
        }, {
            key: '_renderQ_push',
            value: function _renderQ_push(action) {
                this._renderQ.push(action);
                if (this._renderQ.length === 1) {
                    // If this can be rendered immediately it will be, otherwise
                    // the scanner will wait for the relevant event
                    this._scan_renderQ();
                }
            }
        }, {
            key: '_resume_renderQ',
            value: function _resume_renderQ() {
                // "this" is the object that is ready, not the
                // display object
                this.removeEventListener('load', this._noVNC_display._resume_renderQ);
                this._noVNC_display._scan_renderQ();
            }
        }, {
            key: '_scan_renderQ',
            value: function _scan_renderQ() {
                var ready = true;
                while (ready && this._renderQ.length > 0) {
                    var a = this._renderQ[0];
                    switch (a.type) {
                        case 'flip':
                            this.flip(true);
                            break;
                        case 'copy':
                            this.copyImage(a.old_x, a.old_y, a.x, a.y, a.width, a.height, true);
                            break;
                        case 'fill':
                            this.fillRect(a.x, a.y, a.width, a.height, a.color, true);
                            break;
                        case 'blit':
                            this.blitImage(a.x, a.y, a.width, a.height, a.data, 0, true);
                            break;
                        case 'blitRgb':
                            this.blitRgbImage(a.x, a.y, a.width, a.height, a.data, 0, true);
                            break;
                        case 'blitRgbx':
                            this.blitRgbxImage(a.x, a.y, a.width, a.height, a.data, 0, true);
                            break;
                        case 'img':
                            if (a.img.complete) {
                                this.drawImage(a.img, a.x, a.y);
                            } else {
                                a.img._noVNC_display = this;
                                a.img.addEventListener('load', this._resume_renderQ);
                                // We need to wait for this image to 'load'
                                // to keep things in-order
                                ready = false;
                            }
                            break;
                    }

                    if (ready) {
                        this._renderQ.shift();
                    }
                }

                if (this._renderQ.length === 0 && this._flushing) {
                    this._flushing = false;
                    this.onflush();
                }
            }
        }, {
            key: 'scale',
            get: function get() {
                return this._scale;
            },
            set: function set(scale) {
                this._rescale(scale);
            }
        }, {
            key: 'clipViewport',
            get: function get() {
                return this._clipViewport;
            },
            set: function set(viewport) {
                this._clipViewport = viewport;
                // May need to readjust the viewport dimensions
                var vp = this._viewportLoc;
                this.viewportChangeSize(vp.w, vp.h);
                this.viewportChangePos(0, 0);
            }
        }, {
            key: 'width',
            get: function get() {
                return this._fb_width;
            }
        }, {
            key: 'height',
            get: function get() {
                return this._fb_height;
            }
        }]);

        return Display;
    }();

    exports.default = Display;
});
define('../bower_components/no-vnc/lib/util/events.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getPointerEvent = getPointerEvent;
    exports.stopEvent = stopEvent;
    exports.setCapture = setCapture;
    exports.releaseCapture = releaseCapture;
    /*
     * noVNC: HTML5 VNC client
     * Copyright (C) 2018 The noVNC Authors
     * Licensed under MPL 2.0 (see LICENSE.txt)
     *
     * See README.md for usage and integration instructions.
     */

    /*
     * Cross-browser event and position routines
     */

    function getPointerEvent(e) {
        return e.changedTouches ? e.changedTouches[0] : e.touches ? e.touches[0] : e;
    }

    function stopEvent(e) {
        e.stopPropagation();
        e.preventDefault();
    }

    // Emulate Element.setCapture() when not supported
    var _captureRecursion = false;
    var _captureElem = null;
    function _captureProxy(e) {
        // Recursion protection as we'll see our own event
        if (_captureRecursion) return;

        // Clone the event as we cannot dispatch an already dispatched event
        var newEv = new e.constructor(e.type, e);

        _captureRecursion = true;
        _captureElem.dispatchEvent(newEv);
        _captureRecursion = false;

        // Avoid double events
        e.stopPropagation();

        // Respect the wishes of the redirected event handlers
        if (newEv.defaultPrevented) {
            e.preventDefault();
        }

        // Implicitly release the capture on button release
        if (e.type === "mouseup") {
            releaseCapture();
        }
    }

    // Follow cursor style of target element
    function _captureElemChanged() {
        var captureElem = document.getElementById("noVNC_mouse_capture_elem");
        captureElem.style.cursor = window.getComputedStyle(_captureElem).cursor;
    }

    var _captureObserver = new MutationObserver(_captureElemChanged);

    var _captureIndex = 0;

    function setCapture(elem) {
        if (elem.setCapture) {

            elem.setCapture();

            // IE releases capture on 'click' events which might not trigger
            elem.addEventListener('mouseup', releaseCapture);
        } else {
            // Release any existing capture in case this method is
            // called multiple times without coordination
            releaseCapture();

            var captureElem = document.getElementById("noVNC_mouse_capture_elem");

            if (captureElem === null) {
                captureElem = document.createElement("div");
                captureElem.id = "noVNC_mouse_capture_elem";
                captureElem.style.position = "fixed";
                captureElem.style.top = "0px";
                captureElem.style.left = "0px";
                captureElem.style.width = "100%";
                captureElem.style.height = "100%";
                captureElem.style.zIndex = 10000;
                captureElem.style.display = "none";
                document.body.appendChild(captureElem);

                // This is to make sure callers don't get confused by having
                // our blocking element as the target
                captureElem.addEventListener('contextmenu', _captureProxy);

                captureElem.addEventListener('mousemove', _captureProxy);
                captureElem.addEventListener('mouseup', _captureProxy);
            }

            _captureElem = elem;
            _captureIndex++;

            // Track cursor and get initial cursor
            _captureObserver.observe(elem, { attributes: true });
            _captureElemChanged();

            captureElem.style.display = "";

            // We listen to events on window in order to keep tracking if it
            // happens to leave the viewport
            window.addEventListener('mousemove', _captureProxy);
            window.addEventListener('mouseup', _captureProxy);
        }
    }

    function releaseCapture() {
        if (document.releaseCapture) {

            document.releaseCapture();
        } else {
            if (!_captureElem) {
                return;
            }

            // There might be events already queued, so we need to wait for
            // them to flush. E.g. contextmenu in Microsoft Edge
            window.setTimeout(function (expected) {
                // Only clear it if it's the expected grab (i.e. no one
                // else has initiated a new grab)
                if (_captureIndex === expected) {
                    _captureElem = null;
                }
            }, 0, _captureIndex);

            _captureObserver.disconnect();

            var captureElem = document.getElementById("noVNC_mouse_capture_elem");
            captureElem.style.display = "none";

            window.removeEventListener('mousemove', _captureProxy);
            window.removeEventListener('mouseup', _captureProxy);
        }
    }
});
define('../bower_components/no-vnc/lib/input/keysymdef.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    /*
     * Mapping from Unicode codepoints to X11/RFB keysyms
     *
     * This file was automatically generated from keysymdef.h
     * DO NOT EDIT!
     */

    /* Functions at the bottom */

    var codepoints = {
        0x0100: 0x03c0, // XK_Amacron
        0x0101: 0x03e0, // XK_amacron
        0x0102: 0x01c3, // XK_Abreve
        0x0103: 0x01e3, // XK_abreve
        0x0104: 0x01a1, // XK_Aogonek
        0x0105: 0x01b1, // XK_aogonek
        0x0106: 0x01c6, // XK_Cacute
        0x0107: 0x01e6, // XK_cacute
        0x0108: 0x02c6, // XK_Ccircumflex
        0x0109: 0x02e6, // XK_ccircumflex
        0x010a: 0x02c5, // XK_Cabovedot
        0x010b: 0x02e5, // XK_cabovedot
        0x010c: 0x01c8, // XK_Ccaron
        0x010d: 0x01e8, // XK_ccaron
        0x010e: 0x01cf, // XK_Dcaron
        0x010f: 0x01ef, // XK_dcaron
        0x0110: 0x01d0, // XK_Dstroke
        0x0111: 0x01f0, // XK_dstroke
        0x0112: 0x03aa, // XK_Emacron
        0x0113: 0x03ba, // XK_emacron
        0x0116: 0x03cc, // XK_Eabovedot
        0x0117: 0x03ec, // XK_eabovedot
        0x0118: 0x01ca, // XK_Eogonek
        0x0119: 0x01ea, // XK_eogonek
        0x011a: 0x01cc, // XK_Ecaron
        0x011b: 0x01ec, // XK_ecaron
        0x011c: 0x02d8, // XK_Gcircumflex
        0x011d: 0x02f8, // XK_gcircumflex
        0x011e: 0x02ab, // XK_Gbreve
        0x011f: 0x02bb, // XK_gbreve
        0x0120: 0x02d5, // XK_Gabovedot
        0x0121: 0x02f5, // XK_gabovedot
        0x0122: 0x03ab, // XK_Gcedilla
        0x0123: 0x03bb, // XK_gcedilla
        0x0124: 0x02a6, // XK_Hcircumflex
        0x0125: 0x02b6, // XK_hcircumflex
        0x0126: 0x02a1, // XK_Hstroke
        0x0127: 0x02b1, // XK_hstroke
        0x0128: 0x03a5, // XK_Itilde
        0x0129: 0x03b5, // XK_itilde
        0x012a: 0x03cf, // XK_Imacron
        0x012b: 0x03ef, // XK_imacron
        0x012e: 0x03c7, // XK_Iogonek
        0x012f: 0x03e7, // XK_iogonek
        0x0130: 0x02a9, // XK_Iabovedot
        0x0131: 0x02b9, // XK_idotless
        0x0134: 0x02ac, // XK_Jcircumflex
        0x0135: 0x02bc, // XK_jcircumflex
        0x0136: 0x03d3, // XK_Kcedilla
        0x0137: 0x03f3, // XK_kcedilla
        0x0138: 0x03a2, // XK_kra
        0x0139: 0x01c5, // XK_Lacute
        0x013a: 0x01e5, // XK_lacute
        0x013b: 0x03a6, // XK_Lcedilla
        0x013c: 0x03b6, // XK_lcedilla
        0x013d: 0x01a5, // XK_Lcaron
        0x013e: 0x01b5, // XK_lcaron
        0x0141: 0x01a3, // XK_Lstroke
        0x0142: 0x01b3, // XK_lstroke
        0x0143: 0x01d1, // XK_Nacute
        0x0144: 0x01f1, // XK_nacute
        0x0145: 0x03d1, // XK_Ncedilla
        0x0146: 0x03f1, // XK_ncedilla
        0x0147: 0x01d2, // XK_Ncaron
        0x0148: 0x01f2, // XK_ncaron
        0x014a: 0x03bd, // XK_ENG
        0x014b: 0x03bf, // XK_eng
        0x014c: 0x03d2, // XK_Omacron
        0x014d: 0x03f2, // XK_omacron
        0x0150: 0x01d5, // XK_Odoubleacute
        0x0151: 0x01f5, // XK_odoubleacute
        0x0152: 0x13bc, // XK_OE
        0x0153: 0x13bd, // XK_oe
        0x0154: 0x01c0, // XK_Racute
        0x0155: 0x01e0, // XK_racute
        0x0156: 0x03a3, // XK_Rcedilla
        0x0157: 0x03b3, // XK_rcedilla
        0x0158: 0x01d8, // XK_Rcaron
        0x0159: 0x01f8, // XK_rcaron
        0x015a: 0x01a6, // XK_Sacute
        0x015b: 0x01b6, // XK_sacute
        0x015c: 0x02de, // XK_Scircumflex
        0x015d: 0x02fe, // XK_scircumflex
        0x015e: 0x01aa, // XK_Scedilla
        0x015f: 0x01ba, // XK_scedilla
        0x0160: 0x01a9, // XK_Scaron
        0x0161: 0x01b9, // XK_scaron
        0x0162: 0x01de, // XK_Tcedilla
        0x0163: 0x01fe, // XK_tcedilla
        0x0164: 0x01ab, // XK_Tcaron
        0x0165: 0x01bb, // XK_tcaron
        0x0166: 0x03ac, // XK_Tslash
        0x0167: 0x03bc, // XK_tslash
        0x0168: 0x03dd, // XK_Utilde
        0x0169: 0x03fd, // XK_utilde
        0x016a: 0x03de, // XK_Umacron
        0x016b: 0x03fe, // XK_umacron
        0x016c: 0x02dd, // XK_Ubreve
        0x016d: 0x02fd, // XK_ubreve
        0x016e: 0x01d9, // XK_Uring
        0x016f: 0x01f9, // XK_uring
        0x0170: 0x01db, // XK_Udoubleacute
        0x0171: 0x01fb, // XK_udoubleacute
        0x0172: 0x03d9, // XK_Uogonek
        0x0173: 0x03f9, // XK_uogonek
        0x0178: 0x13be, // XK_Ydiaeresis
        0x0179: 0x01ac, // XK_Zacute
        0x017a: 0x01bc, // XK_zacute
        0x017b: 0x01af, // XK_Zabovedot
        0x017c: 0x01bf, // XK_zabovedot
        0x017d: 0x01ae, // XK_Zcaron
        0x017e: 0x01be, // XK_zcaron
        0x0192: 0x08f6, // XK_function
        0x01d2: 0x10001d1, // XK_Ocaron
        0x02c7: 0x01b7, // XK_caron
        0x02d8: 0x01a2, // XK_breve
        0x02d9: 0x01ff, // XK_abovedot
        0x02db: 0x01b2, // XK_ogonek
        0x02dd: 0x01bd, // XK_doubleacute
        0x0385: 0x07ae, // XK_Greek_accentdieresis
        0x0386: 0x07a1, // XK_Greek_ALPHAaccent
        0x0388: 0x07a2, // XK_Greek_EPSILONaccent
        0x0389: 0x07a3, // XK_Greek_ETAaccent
        0x038a: 0x07a4, // XK_Greek_IOTAaccent
        0x038c: 0x07a7, // XK_Greek_OMICRONaccent
        0x038e: 0x07a8, // XK_Greek_UPSILONaccent
        0x038f: 0x07ab, // XK_Greek_OMEGAaccent
        0x0390: 0x07b6, // XK_Greek_iotaaccentdieresis
        0x0391: 0x07c1, // XK_Greek_ALPHA
        0x0392: 0x07c2, // XK_Greek_BETA
        0x0393: 0x07c3, // XK_Greek_GAMMA
        0x0394: 0x07c4, // XK_Greek_DELTA
        0x0395: 0x07c5, // XK_Greek_EPSILON
        0x0396: 0x07c6, // XK_Greek_ZETA
        0x0397: 0x07c7, // XK_Greek_ETA
        0x0398: 0x07c8, // XK_Greek_THETA
        0x0399: 0x07c9, // XK_Greek_IOTA
        0x039a: 0x07ca, // XK_Greek_KAPPA
        0x039b: 0x07cb, // XK_Greek_LAMDA
        0x039c: 0x07cc, // XK_Greek_MU
        0x039d: 0x07cd, // XK_Greek_NU
        0x039e: 0x07ce, // XK_Greek_XI
        0x039f: 0x07cf, // XK_Greek_OMICRON
        0x03a0: 0x07d0, // XK_Greek_PI
        0x03a1: 0x07d1, // XK_Greek_RHO
        0x03a3: 0x07d2, // XK_Greek_SIGMA
        0x03a4: 0x07d4, // XK_Greek_TAU
        0x03a5: 0x07d5, // XK_Greek_UPSILON
        0x03a6: 0x07d6, // XK_Greek_PHI
        0x03a7: 0x07d7, // XK_Greek_CHI
        0x03a8: 0x07d8, // XK_Greek_PSI
        0x03a9: 0x07d9, // XK_Greek_OMEGA
        0x03aa: 0x07a5, // XK_Greek_IOTAdieresis
        0x03ab: 0x07a9, // XK_Greek_UPSILONdieresis
        0x03ac: 0x07b1, // XK_Greek_alphaaccent
        0x03ad: 0x07b2, // XK_Greek_epsilonaccent
        0x03ae: 0x07b3, // XK_Greek_etaaccent
        0x03af: 0x07b4, // XK_Greek_iotaaccent
        0x03b0: 0x07ba, // XK_Greek_upsilonaccentdieresis
        0x03b1: 0x07e1, // XK_Greek_alpha
        0x03b2: 0x07e2, // XK_Greek_beta
        0x03b3: 0x07e3, // XK_Greek_gamma
        0x03b4: 0x07e4, // XK_Greek_delta
        0x03b5: 0x07e5, // XK_Greek_epsilon
        0x03b6: 0x07e6, // XK_Greek_zeta
        0x03b7: 0x07e7, // XK_Greek_eta
        0x03b8: 0x07e8, // XK_Greek_theta
        0x03b9: 0x07e9, // XK_Greek_iota
        0x03ba: 0x07ea, // XK_Greek_kappa
        0x03bb: 0x07eb, // XK_Greek_lamda
        0x03bc: 0x07ec, // XK_Greek_mu
        0x03bd: 0x07ed, // XK_Greek_nu
        0x03be: 0x07ee, // XK_Greek_xi
        0x03bf: 0x07ef, // XK_Greek_omicron
        0x03c0: 0x07f0, // XK_Greek_pi
        0x03c1: 0x07f1, // XK_Greek_rho
        0x03c2: 0x07f3, // XK_Greek_finalsmallsigma
        0x03c3: 0x07f2, // XK_Greek_sigma
        0x03c4: 0x07f4, // XK_Greek_tau
        0x03c5: 0x07f5, // XK_Greek_upsilon
        0x03c6: 0x07f6, // XK_Greek_phi
        0x03c7: 0x07f7, // XK_Greek_chi
        0x03c8: 0x07f8, // XK_Greek_psi
        0x03c9: 0x07f9, // XK_Greek_omega
        0x03ca: 0x07b5, // XK_Greek_iotadieresis
        0x03cb: 0x07b9, // XK_Greek_upsilondieresis
        0x03cc: 0x07b7, // XK_Greek_omicronaccent
        0x03cd: 0x07b8, // XK_Greek_upsilonaccent
        0x03ce: 0x07bb, // XK_Greek_omegaaccent
        0x0401: 0x06b3, // XK_Cyrillic_IO
        0x0402: 0x06b1, // XK_Serbian_DJE
        0x0403: 0x06b2, // XK_Macedonia_GJE
        0x0404: 0x06b4, // XK_Ukrainian_IE
        0x0405: 0x06b5, // XK_Macedonia_DSE
        0x0406: 0x06b6, // XK_Ukrainian_I
        0x0407: 0x06b7, // XK_Ukrainian_YI
        0x0408: 0x06b8, // XK_Cyrillic_JE
        0x0409: 0x06b9, // XK_Cyrillic_LJE
        0x040a: 0x06ba, // XK_Cyrillic_NJE
        0x040b: 0x06bb, // XK_Serbian_TSHE
        0x040c: 0x06bc, // XK_Macedonia_KJE
        0x040e: 0x06be, // XK_Byelorussian_SHORTU
        0x040f: 0x06bf, // XK_Cyrillic_DZHE
        0x0410: 0x06e1, // XK_Cyrillic_A
        0x0411: 0x06e2, // XK_Cyrillic_BE
        0x0412: 0x06f7, // XK_Cyrillic_VE
        0x0413: 0x06e7, // XK_Cyrillic_GHE
        0x0414: 0x06e4, // XK_Cyrillic_DE
        0x0415: 0x06e5, // XK_Cyrillic_IE
        0x0416: 0x06f6, // XK_Cyrillic_ZHE
        0x0417: 0x06fa, // XK_Cyrillic_ZE
        0x0418: 0x06e9, // XK_Cyrillic_I
        0x0419: 0x06ea, // XK_Cyrillic_SHORTI
        0x041a: 0x06eb, // XK_Cyrillic_KA
        0x041b: 0x06ec, // XK_Cyrillic_EL
        0x041c: 0x06ed, // XK_Cyrillic_EM
        0x041d: 0x06ee, // XK_Cyrillic_EN
        0x041e: 0x06ef, // XK_Cyrillic_O
        0x041f: 0x06f0, // XK_Cyrillic_PE
        0x0420: 0x06f2, // XK_Cyrillic_ER
        0x0421: 0x06f3, // XK_Cyrillic_ES
        0x0422: 0x06f4, // XK_Cyrillic_TE
        0x0423: 0x06f5, // XK_Cyrillic_U
        0x0424: 0x06e6, // XK_Cyrillic_EF
        0x0425: 0x06e8, // XK_Cyrillic_HA
        0x0426: 0x06e3, // XK_Cyrillic_TSE
        0x0427: 0x06fe, // XK_Cyrillic_CHE
        0x0428: 0x06fb, // XK_Cyrillic_SHA
        0x0429: 0x06fd, // XK_Cyrillic_SHCHA
        0x042a: 0x06ff, // XK_Cyrillic_HARDSIGN
        0x042b: 0x06f9, // XK_Cyrillic_YERU
        0x042c: 0x06f8, // XK_Cyrillic_SOFTSIGN
        0x042d: 0x06fc, // XK_Cyrillic_E
        0x042e: 0x06e0, // XK_Cyrillic_YU
        0x042f: 0x06f1, // XK_Cyrillic_YA
        0x0430: 0x06c1, // XK_Cyrillic_a
        0x0431: 0x06c2, // XK_Cyrillic_be
        0x0432: 0x06d7, // XK_Cyrillic_ve
        0x0433: 0x06c7, // XK_Cyrillic_ghe
        0x0434: 0x06c4, // XK_Cyrillic_de
        0x0435: 0x06c5, // XK_Cyrillic_ie
        0x0436: 0x06d6, // XK_Cyrillic_zhe
        0x0437: 0x06da, // XK_Cyrillic_ze
        0x0438: 0x06c9, // XK_Cyrillic_i
        0x0439: 0x06ca, // XK_Cyrillic_shorti
        0x043a: 0x06cb, // XK_Cyrillic_ka
        0x043b: 0x06cc, // XK_Cyrillic_el
        0x043c: 0x06cd, // XK_Cyrillic_em
        0x043d: 0x06ce, // XK_Cyrillic_en
        0x043e: 0x06cf, // XK_Cyrillic_o
        0x043f: 0x06d0, // XK_Cyrillic_pe
        0x0440: 0x06d2, // XK_Cyrillic_er
        0x0441: 0x06d3, // XK_Cyrillic_es
        0x0442: 0x06d4, // XK_Cyrillic_te
        0x0443: 0x06d5, // XK_Cyrillic_u
        0x0444: 0x06c6, // XK_Cyrillic_ef
        0x0445: 0x06c8, // XK_Cyrillic_ha
        0x0446: 0x06c3, // XK_Cyrillic_tse
        0x0447: 0x06de, // XK_Cyrillic_che
        0x0448: 0x06db, // XK_Cyrillic_sha
        0x0449: 0x06dd, // XK_Cyrillic_shcha
        0x044a: 0x06df, // XK_Cyrillic_hardsign
        0x044b: 0x06d9, // XK_Cyrillic_yeru
        0x044c: 0x06d8, // XK_Cyrillic_softsign
        0x044d: 0x06dc, // XK_Cyrillic_e
        0x044e: 0x06c0, // XK_Cyrillic_yu
        0x044f: 0x06d1, // XK_Cyrillic_ya
        0x0451: 0x06a3, // XK_Cyrillic_io
        0x0452: 0x06a1, // XK_Serbian_dje
        0x0453: 0x06a2, // XK_Macedonia_gje
        0x0454: 0x06a4, // XK_Ukrainian_ie
        0x0455: 0x06a5, // XK_Macedonia_dse
        0x0456: 0x06a6, // XK_Ukrainian_i
        0x0457: 0x06a7, // XK_Ukrainian_yi
        0x0458: 0x06a8, // XK_Cyrillic_je
        0x0459: 0x06a9, // XK_Cyrillic_lje
        0x045a: 0x06aa, // XK_Cyrillic_nje
        0x045b: 0x06ab, // XK_Serbian_tshe
        0x045c: 0x06ac, // XK_Macedonia_kje
        0x045e: 0x06ae, // XK_Byelorussian_shortu
        0x045f: 0x06af, // XK_Cyrillic_dzhe
        0x0490: 0x06bd, // XK_Ukrainian_GHE_WITH_UPTURN
        0x0491: 0x06ad, // XK_Ukrainian_ghe_with_upturn
        0x05d0: 0x0ce0, // XK_hebrew_aleph
        0x05d1: 0x0ce1, // XK_hebrew_bet
        0x05d2: 0x0ce2, // XK_hebrew_gimel
        0x05d3: 0x0ce3, // XK_hebrew_dalet
        0x05d4: 0x0ce4, // XK_hebrew_he
        0x05d5: 0x0ce5, // XK_hebrew_waw
        0x05d6: 0x0ce6, // XK_hebrew_zain
        0x05d7: 0x0ce7, // XK_hebrew_chet
        0x05d8: 0x0ce8, // XK_hebrew_tet
        0x05d9: 0x0ce9, // XK_hebrew_yod
        0x05da: 0x0cea, // XK_hebrew_finalkaph
        0x05db: 0x0ceb, // XK_hebrew_kaph
        0x05dc: 0x0cec, // XK_hebrew_lamed
        0x05dd: 0x0ced, // XK_hebrew_finalmem
        0x05de: 0x0cee, // XK_hebrew_mem
        0x05df: 0x0cef, // XK_hebrew_finalnun
        0x05e0: 0x0cf0, // XK_hebrew_nun
        0x05e1: 0x0cf1, // XK_hebrew_samech
        0x05e2: 0x0cf2, // XK_hebrew_ayin
        0x05e3: 0x0cf3, // XK_hebrew_finalpe
        0x05e4: 0x0cf4, // XK_hebrew_pe
        0x05e5: 0x0cf5, // XK_hebrew_finalzade
        0x05e6: 0x0cf6, // XK_hebrew_zade
        0x05e7: 0x0cf7, // XK_hebrew_qoph
        0x05e8: 0x0cf8, // XK_hebrew_resh
        0x05e9: 0x0cf9, // XK_hebrew_shin
        0x05ea: 0x0cfa, // XK_hebrew_taw
        0x060c: 0x05ac, // XK_Arabic_comma
        0x061b: 0x05bb, // XK_Arabic_semicolon
        0x061f: 0x05bf, // XK_Arabic_question_mark
        0x0621: 0x05c1, // XK_Arabic_hamza
        0x0622: 0x05c2, // XK_Arabic_maddaonalef
        0x0623: 0x05c3, // XK_Arabic_hamzaonalef
        0x0624: 0x05c4, // XK_Arabic_hamzaonwaw
        0x0625: 0x05c5, // XK_Arabic_hamzaunderalef
        0x0626: 0x05c6, // XK_Arabic_hamzaonyeh
        0x0627: 0x05c7, // XK_Arabic_alef
        0x0628: 0x05c8, // XK_Arabic_beh
        0x0629: 0x05c9, // XK_Arabic_tehmarbuta
        0x062a: 0x05ca, // XK_Arabic_teh
        0x062b: 0x05cb, // XK_Arabic_theh
        0x062c: 0x05cc, // XK_Arabic_jeem
        0x062d: 0x05cd, // XK_Arabic_hah
        0x062e: 0x05ce, // XK_Arabic_khah
        0x062f: 0x05cf, // XK_Arabic_dal
        0x0630: 0x05d0, // XK_Arabic_thal
        0x0631: 0x05d1, // XK_Arabic_ra
        0x0632: 0x05d2, // XK_Arabic_zain
        0x0633: 0x05d3, // XK_Arabic_seen
        0x0634: 0x05d4, // XK_Arabic_sheen
        0x0635: 0x05d5, // XK_Arabic_sad
        0x0636: 0x05d6, // XK_Arabic_dad
        0x0637: 0x05d7, // XK_Arabic_tah
        0x0638: 0x05d8, // XK_Arabic_zah
        0x0639: 0x05d9, // XK_Arabic_ain
        0x063a: 0x05da, // XK_Arabic_ghain
        0x0640: 0x05e0, // XK_Arabic_tatweel
        0x0641: 0x05e1, // XK_Arabic_feh
        0x0642: 0x05e2, // XK_Arabic_qaf
        0x0643: 0x05e3, // XK_Arabic_kaf
        0x0644: 0x05e4, // XK_Arabic_lam
        0x0645: 0x05e5, // XK_Arabic_meem
        0x0646: 0x05e6, // XK_Arabic_noon
        0x0647: 0x05e7, // XK_Arabic_ha
        0x0648: 0x05e8, // XK_Arabic_waw
        0x0649: 0x05e9, // XK_Arabic_alefmaksura
        0x064a: 0x05ea, // XK_Arabic_yeh
        0x064b: 0x05eb, // XK_Arabic_fathatan
        0x064c: 0x05ec, // XK_Arabic_dammatan
        0x064d: 0x05ed, // XK_Arabic_kasratan
        0x064e: 0x05ee, // XK_Arabic_fatha
        0x064f: 0x05ef, // XK_Arabic_damma
        0x0650: 0x05f0, // XK_Arabic_kasra
        0x0651: 0x05f1, // XK_Arabic_shadda
        0x0652: 0x05f2, // XK_Arabic_sukun
        0x0e01: 0x0da1, // XK_Thai_kokai
        0x0e02: 0x0da2, // XK_Thai_khokhai
        0x0e03: 0x0da3, // XK_Thai_khokhuat
        0x0e04: 0x0da4, // XK_Thai_khokhwai
        0x0e05: 0x0da5, // XK_Thai_khokhon
        0x0e06: 0x0da6, // XK_Thai_khorakhang
        0x0e07: 0x0da7, // XK_Thai_ngongu
        0x0e08: 0x0da8, // XK_Thai_chochan
        0x0e09: 0x0da9, // XK_Thai_choching
        0x0e0a: 0x0daa, // XK_Thai_chochang
        0x0e0b: 0x0dab, // XK_Thai_soso
        0x0e0c: 0x0dac, // XK_Thai_chochoe
        0x0e0d: 0x0dad, // XK_Thai_yoying
        0x0e0e: 0x0dae, // XK_Thai_dochada
        0x0e0f: 0x0daf, // XK_Thai_topatak
        0x0e10: 0x0db0, // XK_Thai_thothan
        0x0e11: 0x0db1, // XK_Thai_thonangmontho
        0x0e12: 0x0db2, // XK_Thai_thophuthao
        0x0e13: 0x0db3, // XK_Thai_nonen
        0x0e14: 0x0db4, // XK_Thai_dodek
        0x0e15: 0x0db5, // XK_Thai_totao
        0x0e16: 0x0db6, // XK_Thai_thothung
        0x0e17: 0x0db7, // XK_Thai_thothahan
        0x0e18: 0x0db8, // XK_Thai_thothong
        0x0e19: 0x0db9, // XK_Thai_nonu
        0x0e1a: 0x0dba, // XK_Thai_bobaimai
        0x0e1b: 0x0dbb, // XK_Thai_popla
        0x0e1c: 0x0dbc, // XK_Thai_phophung
        0x0e1d: 0x0dbd, // XK_Thai_fofa
        0x0e1e: 0x0dbe, // XK_Thai_phophan
        0x0e1f: 0x0dbf, // XK_Thai_fofan
        0x0e20: 0x0dc0, // XK_Thai_phosamphao
        0x0e21: 0x0dc1, // XK_Thai_moma
        0x0e22: 0x0dc2, // XK_Thai_yoyak
        0x0e23: 0x0dc3, // XK_Thai_rorua
        0x0e24: 0x0dc4, // XK_Thai_ru
        0x0e25: 0x0dc5, // XK_Thai_loling
        0x0e26: 0x0dc6, // XK_Thai_lu
        0x0e27: 0x0dc7, // XK_Thai_wowaen
        0x0e28: 0x0dc8, // XK_Thai_sosala
        0x0e29: 0x0dc9, // XK_Thai_sorusi
        0x0e2a: 0x0dca, // XK_Thai_sosua
        0x0e2b: 0x0dcb, // XK_Thai_hohip
        0x0e2c: 0x0dcc, // XK_Thai_lochula
        0x0e2d: 0x0dcd, // XK_Thai_oang
        0x0e2e: 0x0dce, // XK_Thai_honokhuk
        0x0e2f: 0x0dcf, // XK_Thai_paiyannoi
        0x0e30: 0x0dd0, // XK_Thai_saraa
        0x0e31: 0x0dd1, // XK_Thai_maihanakat
        0x0e32: 0x0dd2, // XK_Thai_saraaa
        0x0e33: 0x0dd3, // XK_Thai_saraam
        0x0e34: 0x0dd4, // XK_Thai_sarai
        0x0e35: 0x0dd5, // XK_Thai_saraii
        0x0e36: 0x0dd6, // XK_Thai_saraue
        0x0e37: 0x0dd7, // XK_Thai_sarauee
        0x0e38: 0x0dd8, // XK_Thai_sarau
        0x0e39: 0x0dd9, // XK_Thai_sarauu
        0x0e3a: 0x0dda, // XK_Thai_phinthu
        0x0e3f: 0x0ddf, // XK_Thai_baht
        0x0e40: 0x0de0, // XK_Thai_sarae
        0x0e41: 0x0de1, // XK_Thai_saraae
        0x0e42: 0x0de2, // XK_Thai_sarao
        0x0e43: 0x0de3, // XK_Thai_saraaimaimuan
        0x0e44: 0x0de4, // XK_Thai_saraaimaimalai
        0x0e45: 0x0de5, // XK_Thai_lakkhangyao
        0x0e46: 0x0de6, // XK_Thai_maiyamok
        0x0e47: 0x0de7, // XK_Thai_maitaikhu
        0x0e48: 0x0de8, // XK_Thai_maiek
        0x0e49: 0x0de9, // XK_Thai_maitho
        0x0e4a: 0x0dea, // XK_Thai_maitri
        0x0e4b: 0x0deb, // XK_Thai_maichattawa
        0x0e4c: 0x0dec, // XK_Thai_thanthakhat
        0x0e4d: 0x0ded, // XK_Thai_nikhahit
        0x0e50: 0x0df0, // XK_Thai_leksun
        0x0e51: 0x0df1, // XK_Thai_leknung
        0x0e52: 0x0df2, // XK_Thai_leksong
        0x0e53: 0x0df3, // XK_Thai_leksam
        0x0e54: 0x0df4, // XK_Thai_leksi
        0x0e55: 0x0df5, // XK_Thai_lekha
        0x0e56: 0x0df6, // XK_Thai_lekhok
        0x0e57: 0x0df7, // XK_Thai_lekchet
        0x0e58: 0x0df8, // XK_Thai_lekpaet
        0x0e59: 0x0df9, // XK_Thai_lekkao
        0x2002: 0x0aa2, // XK_enspace
        0x2003: 0x0aa1, // XK_emspace
        0x2004: 0x0aa3, // XK_em3space
        0x2005: 0x0aa4, // XK_em4space
        0x2007: 0x0aa5, // XK_digitspace
        0x2008: 0x0aa6, // XK_punctspace
        0x2009: 0x0aa7, // XK_thinspace
        0x200a: 0x0aa8, // XK_hairspace
        0x2012: 0x0abb, // XK_figdash
        0x2013: 0x0aaa, // XK_endash
        0x2014: 0x0aa9, // XK_emdash
        0x2015: 0x07af, // XK_Greek_horizbar
        0x2017: 0x0cdf, // XK_hebrew_doublelowline
        0x2018: 0x0ad0, // XK_leftsinglequotemark
        0x2019: 0x0ad1, // XK_rightsinglequotemark
        0x201a: 0x0afd, // XK_singlelowquotemark
        0x201c: 0x0ad2, // XK_leftdoublequotemark
        0x201d: 0x0ad3, // XK_rightdoublequotemark
        0x201e: 0x0afe, // XK_doublelowquotemark
        0x2020: 0x0af1, // XK_dagger
        0x2021: 0x0af2, // XK_doubledagger
        0x2022: 0x0ae6, // XK_enfilledcircbullet
        0x2025: 0x0aaf, // XK_doubbaselinedot
        0x2026: 0x0aae, // XK_ellipsis
        0x2030: 0x0ad5, // XK_permille
        0x2032: 0x0ad6, // XK_minutes
        0x2033: 0x0ad7, // XK_seconds
        0x2038: 0x0afc, // XK_caret
        0x203e: 0x047e, // XK_overline
        0x20a9: 0x0eff, // XK_Korean_Won
        0x20ac: 0x20ac, // XK_EuroSign
        0x2105: 0x0ab8, // XK_careof
        0x2116: 0x06b0, // XK_numerosign
        0x2117: 0x0afb, // XK_phonographcopyright
        0x211e: 0x0ad4, // XK_prescription
        0x2122: 0x0ac9, // XK_trademark
        0x2153: 0x0ab0, // XK_onethird
        0x2154: 0x0ab1, // XK_twothirds
        0x2155: 0x0ab2, // XK_onefifth
        0x2156: 0x0ab3, // XK_twofifths
        0x2157: 0x0ab4, // XK_threefifths
        0x2158: 0x0ab5, // XK_fourfifths
        0x2159: 0x0ab6, // XK_onesixth
        0x215a: 0x0ab7, // XK_fivesixths
        0x215b: 0x0ac3, // XK_oneeighth
        0x215c: 0x0ac4, // XK_threeeighths
        0x215d: 0x0ac5, // XK_fiveeighths
        0x215e: 0x0ac6, // XK_seveneighths
        0x2190: 0x08fb, // XK_leftarrow
        0x2191: 0x08fc, // XK_uparrow
        0x2192: 0x08fd, // XK_rightarrow
        0x2193: 0x08fe, // XK_downarrow
        0x21d2: 0x08ce, // XK_implies
        0x21d4: 0x08cd, // XK_ifonlyif
        0x2202: 0x08ef, // XK_partialderivative
        0x2207: 0x08c5, // XK_nabla
        0x2218: 0x0bca, // XK_jot
        0x221a: 0x08d6, // XK_radical
        0x221d: 0x08c1, // XK_variation
        0x221e: 0x08c2, // XK_infinity
        0x2227: 0x08de, // XK_logicaland
        0x2228: 0x08df, // XK_logicalor
        0x2229: 0x08dc, // XK_intersection
        0x222a: 0x08dd, // XK_union
        0x222b: 0x08bf, // XK_integral
        0x2234: 0x08c0, // XK_therefore
        0x223c: 0x08c8, // XK_approximate
        0x2243: 0x08c9, // XK_similarequal
        0x2245: 0x1002248, // XK_approxeq
        0x2260: 0x08bd, // XK_notequal
        0x2261: 0x08cf, // XK_identical
        0x2264: 0x08bc, // XK_lessthanequal
        0x2265: 0x08be, // XK_greaterthanequal
        0x2282: 0x08da, // XK_includedin
        0x2283: 0x08db, // XK_includes
        0x22a2: 0x0bfc, // XK_righttack
        0x22a3: 0x0bdc, // XK_lefttack
        0x22a4: 0x0bc2, // XK_downtack
        0x22a5: 0x0bce, // XK_uptack
        0x2308: 0x0bd3, // XK_upstile
        0x230a: 0x0bc4, // XK_downstile
        0x2315: 0x0afa, // XK_telephonerecorder
        0x2320: 0x08a4, // XK_topintegral
        0x2321: 0x08a5, // XK_botintegral
        0x2395: 0x0bcc, // XK_quad
        0x239b: 0x08ab, // XK_topleftparens
        0x239d: 0x08ac, // XK_botleftparens
        0x239e: 0x08ad, // XK_toprightparens
        0x23a0: 0x08ae, // XK_botrightparens
        0x23a1: 0x08a7, // XK_topleftsqbracket
        0x23a3: 0x08a8, // XK_botleftsqbracket
        0x23a4: 0x08a9, // XK_toprightsqbracket
        0x23a6: 0x08aa, // XK_botrightsqbracket
        0x23a8: 0x08af, // XK_leftmiddlecurlybrace
        0x23ac: 0x08b0, // XK_rightmiddlecurlybrace
        0x23b7: 0x08a1, // XK_leftradical
        0x23ba: 0x09ef, // XK_horizlinescan1
        0x23bb: 0x09f0, // XK_horizlinescan3
        0x23bc: 0x09f2, // XK_horizlinescan7
        0x23bd: 0x09f3, // XK_horizlinescan9
        0x2409: 0x09e2, // XK_ht
        0x240a: 0x09e5, // XK_lf
        0x240b: 0x09e9, // XK_vt
        0x240c: 0x09e3, // XK_ff
        0x240d: 0x09e4, // XK_cr
        0x2423: 0x0aac, // XK_signifblank
        0x2424: 0x09e8, // XK_nl
        0x2500: 0x08a3, // XK_horizconnector
        0x2502: 0x08a6, // XK_vertconnector
        0x250c: 0x08a2, // XK_topleftradical
        0x2510: 0x09eb, // XK_uprightcorner
        0x2514: 0x09ed, // XK_lowleftcorner
        0x2518: 0x09ea, // XK_lowrightcorner
        0x251c: 0x09f4, // XK_leftt
        0x2524: 0x09f5, // XK_rightt
        0x252c: 0x09f7, // XK_topt
        0x2534: 0x09f6, // XK_bott
        0x253c: 0x09ee, // XK_crossinglines
        0x2592: 0x09e1, // XK_checkerboard
        0x25aa: 0x0ae7, // XK_enfilledsqbullet
        0x25ab: 0x0ae1, // XK_enopensquarebullet
        0x25ac: 0x0adb, // XK_filledrectbullet
        0x25ad: 0x0ae2, // XK_openrectbullet
        0x25ae: 0x0adf, // XK_emfilledrect
        0x25af: 0x0acf, // XK_emopenrectangle
        0x25b2: 0x0ae8, // XK_filledtribulletup
        0x25b3: 0x0ae3, // XK_opentribulletup
        0x25b6: 0x0add, // XK_filledrighttribullet
        0x25b7: 0x0acd, // XK_rightopentriangle
        0x25bc: 0x0ae9, // XK_filledtribulletdown
        0x25bd: 0x0ae4, // XK_opentribulletdown
        0x25c0: 0x0adc, // XK_filledlefttribullet
        0x25c1: 0x0acc, // XK_leftopentriangle
        0x25c6: 0x09e0, // XK_soliddiamond
        0x25cb: 0x0ace, // XK_emopencircle
        0x25cf: 0x0ade, // XK_emfilledcircle
        0x25e6: 0x0ae0, // XK_enopencircbullet
        0x2606: 0x0ae5, // XK_openstar
        0x260e: 0x0af9, // XK_telephone
        0x2613: 0x0aca, // XK_signaturemark
        0x261c: 0x0aea, // XK_leftpointer
        0x261e: 0x0aeb, // XK_rightpointer
        0x2640: 0x0af8, // XK_femalesymbol
        0x2642: 0x0af7, // XK_malesymbol
        0x2663: 0x0aec, // XK_club
        0x2665: 0x0aee, // XK_heart
        0x2666: 0x0aed, // XK_diamond
        0x266d: 0x0af6, // XK_musicalflat
        0x266f: 0x0af5, // XK_musicalsharp
        0x2713: 0x0af3, // XK_checkmark
        0x2717: 0x0af4, // XK_ballotcross
        0x271d: 0x0ad9, // XK_latincross
        0x2720: 0x0af0, // XK_maltesecross
        0x27e8: 0x0abc, // XK_leftanglebracket
        0x27e9: 0x0abe, // XK_rightanglebracket
        0x3001: 0x04a4, // XK_kana_comma
        0x3002: 0x04a1, // XK_kana_fullstop
        0x300c: 0x04a2, // XK_kana_openingbracket
        0x300d: 0x04a3, // XK_kana_closingbracket
        0x309b: 0x04de, // XK_voicedsound
        0x309c: 0x04df, // XK_semivoicedsound
        0x30a1: 0x04a7, // XK_kana_a
        0x30a2: 0x04b1, // XK_kana_A
        0x30a3: 0x04a8, // XK_kana_i
        0x30a4: 0x04b2, // XK_kana_I
        0x30a5: 0x04a9, // XK_kana_u
        0x30a6: 0x04b3, // XK_kana_U
        0x30a7: 0x04aa, // XK_kana_e
        0x30a8: 0x04b4, // XK_kana_E
        0x30a9: 0x04ab, // XK_kana_o
        0x30aa: 0x04b5, // XK_kana_O
        0x30ab: 0x04b6, // XK_kana_KA
        0x30ad: 0x04b7, // XK_kana_KI
        0x30af: 0x04b8, // XK_kana_KU
        0x30b1: 0x04b9, // XK_kana_KE
        0x30b3: 0x04ba, // XK_kana_KO
        0x30b5: 0x04bb, // XK_kana_SA
        0x30b7: 0x04bc, // XK_kana_SHI
        0x30b9: 0x04bd, // XK_kana_SU
        0x30bb: 0x04be, // XK_kana_SE
        0x30bd: 0x04bf, // XK_kana_SO
        0x30bf: 0x04c0, // XK_kana_TA
        0x30c1: 0x04c1, // XK_kana_CHI
        0x30c3: 0x04af, // XK_kana_tsu
        0x30c4: 0x04c2, // XK_kana_TSU
        0x30c6: 0x04c3, // XK_kana_TE
        0x30c8: 0x04c4, // XK_kana_TO
        0x30ca: 0x04c5, // XK_kana_NA
        0x30cb: 0x04c6, // XK_kana_NI
        0x30cc: 0x04c7, // XK_kana_NU
        0x30cd: 0x04c8, // XK_kana_NE
        0x30ce: 0x04c9, // XK_kana_NO
        0x30cf: 0x04ca, // XK_kana_HA
        0x30d2: 0x04cb, // XK_kana_HI
        0x30d5: 0x04cc, // XK_kana_FU
        0x30d8: 0x04cd, // XK_kana_HE
        0x30db: 0x04ce, // XK_kana_HO
        0x30de: 0x04cf, // XK_kana_MA
        0x30df: 0x04d0, // XK_kana_MI
        0x30e0: 0x04d1, // XK_kana_MU
        0x30e1: 0x04d2, // XK_kana_ME
        0x30e2: 0x04d3, // XK_kana_MO
        0x30e3: 0x04ac, // XK_kana_ya
        0x30e4: 0x04d4, // XK_kana_YA
        0x30e5: 0x04ad, // XK_kana_yu
        0x30e6: 0x04d5, // XK_kana_YU
        0x30e7: 0x04ae, // XK_kana_yo
        0x30e8: 0x04d6, // XK_kana_YO
        0x30e9: 0x04d7, // XK_kana_RA
        0x30ea: 0x04d8, // XK_kana_RI
        0x30eb: 0x04d9, // XK_kana_RU
        0x30ec: 0x04da, // XK_kana_RE
        0x30ed: 0x04db, // XK_kana_RO
        0x30ef: 0x04dc, // XK_kana_WA
        0x30f2: 0x04a6, // XK_kana_WO
        0x30f3: 0x04dd, // XK_kana_N
        0x30fb: 0x04a5, // XK_kana_conjunctive
        0x30fc: 0x04b0 // XK_prolongedsound
    };

    exports.default = {
        lookup: function lookup(u) {
            // Latin-1 is one-to-one mapping
            if (u >= 0x20 && u <= 0xff) {
                return u;
            }

            // Lookup table (fairly random)
            var keysym = codepoints[u];
            if (keysym !== undefined) {
                return keysym;
            }

            // General mapping as final fallback
            return 0x01000000 | u;
        }
    };
});
define('../bower_components/no-vnc/lib/input/vkeys.js',['exports'], function (exports) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = {
    0x08: 'Backspace',
    0x09: 'Tab',
    0x0a: 'NumpadClear',
    0x0c: 'Numpad5', // IE11 sends evt.keyCode: 12 when numlock is off
    0x0d: 'Enter',
    0x10: 'ShiftLeft',
    0x11: 'ControlLeft',
    0x12: 'AltLeft',
    0x13: 'Pause',
    0x14: 'CapsLock',
    0x15: 'Lang1',
    0x19: 'Lang2',
    0x1b: 'Escape',
    0x1c: 'Convert',
    0x1d: 'NonConvert',
    0x20: 'Space',
    0x21: 'PageUp',
    0x22: 'PageDown',
    0x23: 'End',
    0x24: 'Home',
    0x25: 'ArrowLeft',
    0x26: 'ArrowUp',
    0x27: 'ArrowRight',
    0x28: 'ArrowDown',
    0x29: 'Select',
    0x2c: 'PrintScreen',
    0x2d: 'Insert',
    0x2e: 'Delete',
    0x2f: 'Help',
    0x30: 'Digit0',
    0x31: 'Digit1',
    0x32: 'Digit2',
    0x33: 'Digit3',
    0x34: 'Digit4',
    0x35: 'Digit5',
    0x36: 'Digit6',
    0x37: 'Digit7',
    0x38: 'Digit8',
    0x39: 'Digit9',
    0x5b: 'MetaLeft',
    0x5c: 'MetaRight',
    0x5d: 'ContextMenu',
    0x5f: 'Sleep',
    0x60: 'Numpad0',
    0x61: 'Numpad1',
    0x62: 'Numpad2',
    0x63: 'Numpad3',
    0x64: 'Numpad4',
    0x65: 'Numpad5',
    0x66: 'Numpad6',
    0x67: 'Numpad7',
    0x68: 'Numpad8',
    0x69: 'Numpad9',
    0x6a: 'NumpadMultiply',
    0x6b: 'NumpadAdd',
    0x6c: 'NumpadDecimal',
    0x6d: 'NumpadSubtract',
    0x6e: 'NumpadDecimal', // Duplicate, because buggy on Windows
    0x6f: 'NumpadDivide',
    0x70: 'F1',
    0x71: 'F2',
    0x72: 'F3',
    0x73: 'F4',
    0x74: 'F5',
    0x75: 'F6',
    0x76: 'F7',
    0x77: 'F8',
    0x78: 'F9',
    0x79: 'F10',
    0x7a: 'F11',
    0x7b: 'F12',
    0x7c: 'F13',
    0x7d: 'F14',
    0x7e: 'F15',
    0x7f: 'F16',
    0x80: 'F17',
    0x81: 'F18',
    0x82: 'F19',
    0x83: 'F20',
    0x84: 'F21',
    0x85: 'F22',
    0x86: 'F23',
    0x87: 'F24',
    0x90: 'NumLock',
    0x91: 'ScrollLock',
    0xa6: 'BrowserBack',
    0xa7: 'BrowserForward',
    0xa8: 'BrowserRefresh',
    0xa9: 'BrowserStop',
    0xaa: 'BrowserSearch',
    0xab: 'BrowserFavorites',
    0xac: 'BrowserHome',
    0xad: 'AudioVolumeMute',
    0xae: 'AudioVolumeDown',
    0xaf: 'AudioVolumeUp',
    0xb0: 'MediaTrackNext',
    0xb1: 'MediaTrackPrevious',
    0xb2: 'MediaStop',
    0xb3: 'MediaPlayPause',
    0xb4: 'LaunchMail',
    0xb5: 'MediaSelect',
    0xb6: 'LaunchApp1',
    0xb7: 'LaunchApp2',
    0xe1: 'AltRight' // Only when it is AltGraph
  };
});
define('../bower_components/no-vnc/lib/input/fixedkeys.js',['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = {

        // 3.1.1.1. Writing System Keys

        'Backspace': 'Backspace',

        // 3.1.1.2. Functional Keys

        'AltLeft': 'Alt',
        'AltRight': 'Alt', // This could also be 'AltGraph'
        'CapsLock': 'CapsLock',
        'ContextMenu': 'ContextMenu',
        'ControlLeft': 'Control',
        'ControlRight': 'Control',
        'Enter': 'Enter',
        'MetaLeft': 'Meta',
        'MetaRight': 'Meta',
        'ShiftLeft': 'Shift',
        'ShiftRight': 'Shift',
        'Tab': 'Tab',
        // FIXME: Japanese/Korean keys

        // 3.1.2. Control Pad Section

        'Delete': 'Delete',
        'End': 'End',
        'Help': 'Help',
        'Home': 'Home',
        'Insert': 'Insert',
        'PageDown': 'PageDown',
        'PageUp': 'PageUp',

        // 3.1.3. Arrow Pad Section

        'ArrowDown': 'ArrowDown',
        'ArrowLeft': 'ArrowLeft',
        'ArrowRight': 'ArrowRight',
        'ArrowUp': 'ArrowUp',

        // 3.1.4. Numpad Section

        'NumLock': 'NumLock',
        'NumpadBackspace': 'Backspace',
        'NumpadClear': 'Clear',

        // 3.1.5. Function Section

        'Escape': 'Escape',
        'F1': 'F1',
        'F2': 'F2',
        'F3': 'F3',
        'F4': 'F4',
        'F5': 'F5',
        'F6': 'F6',
        'F7': 'F7',
        'F8': 'F8',
        'F9': 'F9',
        'F10': 'F10',
        'F11': 'F11',
        'F12': 'F12',
        'F13': 'F13',
        'F14': 'F14',
        'F15': 'F15',
        'F16': 'F16',
        'F17': 'F17',
        'F18': 'F18',
        'F19': 'F19',
        'F20': 'F20',
        'F21': 'F21',
        'F22': 'F22',
        'F23': 'F23',
        'F24': 'F24',
        'F25': 'F25',
        'F26': 'F26',
        'F27': 'F27',
        'F28': 'F28',
        'F29': 'F29',
        'F30': 'F30',
        'F31': 'F31',
        'F32': 'F32',
        'F33': 'F33',
        'F34': 'F34',
        'F35': 'F35',
        'PrintScreen': 'PrintScreen',
        'ScrollLock': 'ScrollLock',
        'Pause': 'Pause',

        // 3.1.6. Media Keys

        'BrowserBack': 'BrowserBack',
        'BrowserFavorites': 'BrowserFavorites',
        'BrowserForward': 'BrowserForward',
        'BrowserHome': 'BrowserHome',
        'BrowserRefresh': 'BrowserRefresh',
        'BrowserSearch': 'BrowserSearch',
        'BrowserStop': 'BrowserStop',
        'Eject': 'Eject',
        'LaunchApp1': 'LaunchMyComputer',
        'LaunchApp2': 'LaunchCalendar',
        'LaunchMail': 'LaunchMail',
        'MediaPlayPause': 'MediaPlay',
        'MediaStop': 'MediaStop',
        'MediaTrackNext': 'MediaTrackNext',
        'MediaTrackPrevious': 'MediaTrackPrevious',
        'Power': 'Power',
        'Sleep': 'Sleep',
        'AudioVolumeDown': 'AudioVolumeDown',
        'AudioVolumeMute': 'AudioVolumeMute',
        'AudioVolumeUp': 'AudioVolumeUp',
        'WakeUp': 'WakeUp'
    };
});
define('../bower_components/no-vnc/lib/input/keysym.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = {
    XK_VoidSymbol: 0xffffff, /* Void symbol */

    XK_BackSpace: 0xff08, /* Back space, back char */
    XK_Tab: 0xff09,
    XK_Linefeed: 0xff0a, /* Linefeed, LF */
    XK_Clear: 0xff0b,
    XK_Return: 0xff0d, /* Return, enter */
    XK_Pause: 0xff13, /* Pause, hold */
    XK_Scroll_Lock: 0xff14,
    XK_Sys_Req: 0xff15,
    XK_Escape: 0xff1b,
    XK_Delete: 0xffff, /* Delete, rubout */

    /* International & multi-key character composition */

    XK_Multi_key: 0xff20, /* Multi-key character compose */
    XK_Codeinput: 0xff37,
    XK_SingleCandidate: 0xff3c,
    XK_MultipleCandidate: 0xff3d,
    XK_PreviousCandidate: 0xff3e,

    /* Japanese keyboard support */

    XK_Kanji: 0xff21, /* Kanji, Kanji convert */
    XK_Muhenkan: 0xff22, /* Cancel Conversion */
    XK_Henkan_Mode: 0xff23, /* Start/Stop Conversion */
    XK_Henkan: 0xff23, /* Alias for Henkan_Mode */
    XK_Romaji: 0xff24, /* to Romaji */
    XK_Hiragana: 0xff25, /* to Hiragana */
    XK_Katakana: 0xff26, /* to Katakana */
    XK_Hiragana_Katakana: 0xff27, /* Hiragana/Katakana toggle */
    XK_Zenkaku: 0xff28, /* to Zenkaku */
    XK_Hankaku: 0xff29, /* to Hankaku */
    XK_Zenkaku_Hankaku: 0xff2a, /* Zenkaku/Hankaku toggle */
    XK_Touroku: 0xff2b, /* Add to Dictionary */
    XK_Massyo: 0xff2c, /* Delete from Dictionary */
    XK_Kana_Lock: 0xff2d, /* Kana Lock */
    XK_Kana_Shift: 0xff2e, /* Kana Shift */
    XK_Eisu_Shift: 0xff2f, /* Alphanumeric Shift */
    XK_Eisu_toggle: 0xff30, /* Alphanumeric toggle */
    XK_Kanji_Bangou: 0xff37, /* Codeinput */
    XK_Zen_Koho: 0xff3d, /* Multiple/All Candidate(s) */
    XK_Mae_Koho: 0xff3e, /* Previous Candidate */

    /* Cursor control & motion */

    XK_Home: 0xff50,
    XK_Left: 0xff51, /* Move left, left arrow */
    XK_Up: 0xff52, /* Move up, up arrow */
    XK_Right: 0xff53, /* Move right, right arrow */
    XK_Down: 0xff54, /* Move down, down arrow */
    XK_Prior: 0xff55, /* Prior, previous */
    XK_Page_Up: 0xff55,
    XK_Next: 0xff56, /* Next */
    XK_Page_Down: 0xff56,
    XK_End: 0xff57, /* EOL */
    XK_Begin: 0xff58, /* BOL */

    /* Misc functions */

    XK_Select: 0xff60, /* Select, mark */
    XK_Print: 0xff61,
    XK_Execute: 0xff62, /* Execute, run, do */
    XK_Insert: 0xff63, /* Insert, insert here */
    XK_Undo: 0xff65,
    XK_Redo: 0xff66, /* Redo, again */
    XK_Menu: 0xff67,
    XK_Find: 0xff68, /* Find, search */
    XK_Cancel: 0xff69, /* Cancel, stop, abort, exit */
    XK_Help: 0xff6a, /* Help */
    XK_Break: 0xff6b,
    XK_Mode_switch: 0xff7e, /* Character set switch */
    XK_script_switch: 0xff7e, /* Alias for mode_switch */
    XK_Num_Lock: 0xff7f,

    /* Keypad functions, keypad numbers cleverly chosen to map to ASCII */

    XK_KP_Space: 0xff80, /* Space */
    XK_KP_Tab: 0xff89,
    XK_KP_Enter: 0xff8d, /* Enter */
    XK_KP_F1: 0xff91, /* PF1, KP_A, ... */
    XK_KP_F2: 0xff92,
    XK_KP_F3: 0xff93,
    XK_KP_F4: 0xff94,
    XK_KP_Home: 0xff95,
    XK_KP_Left: 0xff96,
    XK_KP_Up: 0xff97,
    XK_KP_Right: 0xff98,
    XK_KP_Down: 0xff99,
    XK_KP_Prior: 0xff9a,
    XK_KP_Page_Up: 0xff9a,
    XK_KP_Next: 0xff9b,
    XK_KP_Page_Down: 0xff9b,
    XK_KP_End: 0xff9c,
    XK_KP_Begin: 0xff9d,
    XK_KP_Insert: 0xff9e,
    XK_KP_Delete: 0xff9f,
    XK_KP_Equal: 0xffbd, /* Equals */
    XK_KP_Multiply: 0xffaa,
    XK_KP_Add: 0xffab,
    XK_KP_Separator: 0xffac, /* Separator, often comma */
    XK_KP_Subtract: 0xffad,
    XK_KP_Decimal: 0xffae,
    XK_KP_Divide: 0xffaf,

    XK_KP_0: 0xffb0,
    XK_KP_1: 0xffb1,
    XK_KP_2: 0xffb2,
    XK_KP_3: 0xffb3,
    XK_KP_4: 0xffb4,
    XK_KP_5: 0xffb5,
    XK_KP_6: 0xffb6,
    XK_KP_7: 0xffb7,
    XK_KP_8: 0xffb8,
    XK_KP_9: 0xffb9,

    /*
     * Auxiliary functions; note the duplicate definitions for left and right
     * function keys;  Sun keyboards and a few other manufacturers have such
     * function key groups on the left and/or right sides of the keyboard.
     * We've not found a keyboard with more than 35 function keys total.
     */

    XK_F1: 0xffbe,
    XK_F2: 0xffbf,
    XK_F3: 0xffc0,
    XK_F4: 0xffc1,
    XK_F5: 0xffc2,
    XK_F6: 0xffc3,
    XK_F7: 0xffc4,
    XK_F8: 0xffc5,
    XK_F9: 0xffc6,
    XK_F10: 0xffc7,
    XK_F11: 0xffc8,
    XK_L1: 0xffc8,
    XK_F12: 0xffc9,
    XK_L2: 0xffc9,
    XK_F13: 0xffca,
    XK_L3: 0xffca,
    XK_F14: 0xffcb,
    XK_L4: 0xffcb,
    XK_F15: 0xffcc,
    XK_L5: 0xffcc,
    XK_F16: 0xffcd,
    XK_L6: 0xffcd,
    XK_F17: 0xffce,
    XK_L7: 0xffce,
    XK_F18: 0xffcf,
    XK_L8: 0xffcf,
    XK_F19: 0xffd0,
    XK_L9: 0xffd0,
    XK_F20: 0xffd1,
    XK_L10: 0xffd1,
    XK_F21: 0xffd2,
    XK_R1: 0xffd2,
    XK_F22: 0xffd3,
    XK_R2: 0xffd3,
    XK_F23: 0xffd4,
    XK_R3: 0xffd4,
    XK_F24: 0xffd5,
    XK_R4: 0xffd5,
    XK_F25: 0xffd6,
    XK_R5: 0xffd6,
    XK_F26: 0xffd7,
    XK_R6: 0xffd7,
    XK_F27: 0xffd8,
    XK_R7: 0xffd8,
    XK_F28: 0xffd9,
    XK_R8: 0xffd9,
    XK_F29: 0xffda,
    XK_R9: 0xffda,
    XK_F30: 0xffdb,
    XK_R10: 0xffdb,
    XK_F31: 0xffdc,
    XK_R11: 0xffdc,
    XK_F32: 0xffdd,
    XK_R12: 0xffdd,
    XK_F33: 0xffde,
    XK_R13: 0xffde,
    XK_F34: 0xffdf,
    XK_R14: 0xffdf,
    XK_F35: 0xffe0,
    XK_R15: 0xffe0,

    /* Modifiers */

    XK_Shift_L: 0xffe1, /* Left shift */
    XK_Shift_R: 0xffe2, /* Right shift */
    XK_Control_L: 0xffe3, /* Left control */
    XK_Control_R: 0xffe4, /* Right control */
    XK_Caps_Lock: 0xffe5, /* Caps lock */
    XK_Shift_Lock: 0xffe6, /* Shift lock */

    XK_Meta_L: 0xffe7, /* Left meta */
    XK_Meta_R: 0xffe8, /* Right meta */
    XK_Alt_L: 0xffe9, /* Left alt */
    XK_Alt_R: 0xffea, /* Right alt */
    XK_Super_L: 0xffeb, /* Left super */
    XK_Super_R: 0xffec, /* Right super */
    XK_Hyper_L: 0xffed, /* Left hyper */
    XK_Hyper_R: 0xffee, /* Right hyper */

    /*
     * Keyboard (XKB) Extension function and modifier keys
     * (from Appendix C of "The X Keyboard Extension: Protocol Specification")
     * Byte 3 = 0xfe
     */

    XK_ISO_Level3_Shift: 0xfe03, /* AltGr */
    XK_ISO_Next_Group: 0xfe08,
    XK_ISO_Prev_Group: 0xfe0a,
    XK_ISO_First_Group: 0xfe0c,
    XK_ISO_Last_Group: 0xfe0e,

    /*
     * Latin 1
     * (ISO/IEC 8859-1: Unicode U+0020..U+00FF)
     * Byte 3: 0
     */

    XK_space: 0x0020, /* U+0020 SPACE */
    XK_exclam: 0x0021, /* U+0021 EXCLAMATION MARK */
    XK_quotedbl: 0x0022, /* U+0022 QUOTATION MARK */
    XK_numbersign: 0x0023, /* U+0023 NUMBER SIGN */
    XK_dollar: 0x0024, /* U+0024 DOLLAR SIGN */
    XK_percent: 0x0025, /* U+0025 PERCENT SIGN */
    XK_ampersand: 0x0026, /* U+0026 AMPERSAND */
    XK_apostrophe: 0x0027, /* U+0027 APOSTROPHE */
    XK_quoteright: 0x0027, /* deprecated */
    XK_parenleft: 0x0028, /* U+0028 LEFT PARENTHESIS */
    XK_parenright: 0x0029, /* U+0029 RIGHT PARENTHESIS */
    XK_asterisk: 0x002a, /* U+002A ASTERISK */
    XK_plus: 0x002b, /* U+002B PLUS SIGN */
    XK_comma: 0x002c, /* U+002C COMMA */
    XK_minus: 0x002d, /* U+002D HYPHEN-MINUS */
    XK_period: 0x002e, /* U+002E FULL STOP */
    XK_slash: 0x002f, /* U+002F SOLIDUS */
    XK_0: 0x0030, /* U+0030 DIGIT ZERO */
    XK_1: 0x0031, /* U+0031 DIGIT ONE */
    XK_2: 0x0032, /* U+0032 DIGIT TWO */
    XK_3: 0x0033, /* U+0033 DIGIT THREE */
    XK_4: 0x0034, /* U+0034 DIGIT FOUR */
    XK_5: 0x0035, /* U+0035 DIGIT FIVE */
    XK_6: 0x0036, /* U+0036 DIGIT SIX */
    XK_7: 0x0037, /* U+0037 DIGIT SEVEN */
    XK_8: 0x0038, /* U+0038 DIGIT EIGHT */
    XK_9: 0x0039, /* U+0039 DIGIT NINE */
    XK_colon: 0x003a, /* U+003A COLON */
    XK_semicolon: 0x003b, /* U+003B SEMICOLON */
    XK_less: 0x003c, /* U+003C LESS-THAN SIGN */
    XK_equal: 0x003d, /* U+003D EQUALS SIGN */
    XK_greater: 0x003e, /* U+003E GREATER-THAN SIGN */
    XK_question: 0x003f, /* U+003F QUESTION MARK */
    XK_at: 0x0040, /* U+0040 COMMERCIAL AT */
    XK_A: 0x0041, /* U+0041 LATIN CAPITAL LETTER A */
    XK_B: 0x0042, /* U+0042 LATIN CAPITAL LETTER B */
    XK_C: 0x0043, /* U+0043 LATIN CAPITAL LETTER C */
    XK_D: 0x0044, /* U+0044 LATIN CAPITAL LETTER D */
    XK_E: 0x0045, /* U+0045 LATIN CAPITAL LETTER E */
    XK_F: 0x0046, /* U+0046 LATIN CAPITAL LETTER F */
    XK_G: 0x0047, /* U+0047 LATIN CAPITAL LETTER G */
    XK_H: 0x0048, /* U+0048 LATIN CAPITAL LETTER H */
    XK_I: 0x0049, /* U+0049 LATIN CAPITAL LETTER I */
    XK_J: 0x004a, /* U+004A LATIN CAPITAL LETTER J */
    XK_K: 0x004b, /* U+004B LATIN CAPITAL LETTER K */
    XK_L: 0x004c, /* U+004C LATIN CAPITAL LETTER L */
    XK_M: 0x004d, /* U+004D LATIN CAPITAL LETTER M */
    XK_N: 0x004e, /* U+004E LATIN CAPITAL LETTER N */
    XK_O: 0x004f, /* U+004F LATIN CAPITAL LETTER O */
    XK_P: 0x0050, /* U+0050 LATIN CAPITAL LETTER P */
    XK_Q: 0x0051, /* U+0051 LATIN CAPITAL LETTER Q */
    XK_R: 0x0052, /* U+0052 LATIN CAPITAL LETTER R */
    XK_S: 0x0053, /* U+0053 LATIN CAPITAL LETTER S */
    XK_T: 0x0054, /* U+0054 LATIN CAPITAL LETTER T */
    XK_U: 0x0055, /* U+0055 LATIN CAPITAL LETTER U */
    XK_V: 0x0056, /* U+0056 LATIN CAPITAL LETTER V */
    XK_W: 0x0057, /* U+0057 LATIN CAPITAL LETTER W */
    XK_X: 0x0058, /* U+0058 LATIN CAPITAL LETTER X */
    XK_Y: 0x0059, /* U+0059 LATIN CAPITAL LETTER Y */
    XK_Z: 0x005a, /* U+005A LATIN CAPITAL LETTER Z */
    XK_bracketleft: 0x005b, /* U+005B LEFT SQUARE BRACKET */
    XK_backslash: 0x005c, /* U+005C REVERSE SOLIDUS */
    XK_bracketright: 0x005d, /* U+005D RIGHT SQUARE BRACKET */
    XK_asciicircum: 0x005e, /* U+005E CIRCUMFLEX ACCENT */
    XK_underscore: 0x005f, /* U+005F LOW LINE */
    XK_grave: 0x0060, /* U+0060 GRAVE ACCENT */
    XK_quoteleft: 0x0060, /* deprecated */
    XK_a: 0x0061, /* U+0061 LATIN SMALL LETTER A */
    XK_b: 0x0062, /* U+0062 LATIN SMALL LETTER B */
    XK_c: 0x0063, /* U+0063 LATIN SMALL LETTER C */
    XK_d: 0x0064, /* U+0064 LATIN SMALL LETTER D */
    XK_e: 0x0065, /* U+0065 LATIN SMALL LETTER E */
    XK_f: 0x0066, /* U+0066 LATIN SMALL LETTER F */
    XK_g: 0x0067, /* U+0067 LATIN SMALL LETTER G */
    XK_h: 0x0068, /* U+0068 LATIN SMALL LETTER H */
    XK_i: 0x0069, /* U+0069 LATIN SMALL LETTER I */
    XK_j: 0x006a, /* U+006A LATIN SMALL LETTER J */
    XK_k: 0x006b, /* U+006B LATIN SMALL LETTER K */
    XK_l: 0x006c, /* U+006C LATIN SMALL LETTER L */
    XK_m: 0x006d, /* U+006D LATIN SMALL LETTER M */
    XK_n: 0x006e, /* U+006E LATIN SMALL LETTER N */
    XK_o: 0x006f, /* U+006F LATIN SMALL LETTER O */
    XK_p: 0x0070, /* U+0070 LATIN SMALL LETTER P */
    XK_q: 0x0071, /* U+0071 LATIN SMALL LETTER Q */
    XK_r: 0x0072, /* U+0072 LATIN SMALL LETTER R */
    XK_s: 0x0073, /* U+0073 LATIN SMALL LETTER S */
    XK_t: 0x0074, /* U+0074 LATIN SMALL LETTER T */
    XK_u: 0x0075, /* U+0075 LATIN SMALL LETTER U */
    XK_v: 0x0076, /* U+0076 LATIN SMALL LETTER V */
    XK_w: 0x0077, /* U+0077 LATIN SMALL LETTER W */
    XK_x: 0x0078, /* U+0078 LATIN SMALL LETTER X */
    XK_y: 0x0079, /* U+0079 LATIN SMALL LETTER Y */
    XK_z: 0x007a, /* U+007A LATIN SMALL LETTER Z */
    XK_braceleft: 0x007b, /* U+007B LEFT CURLY BRACKET */
    XK_bar: 0x007c, /* U+007C VERTICAL LINE */
    XK_braceright: 0x007d, /* U+007D RIGHT CURLY BRACKET */
    XK_asciitilde: 0x007e, /* U+007E TILDE */

    XK_nobreakspace: 0x00a0, /* U+00A0 NO-BREAK SPACE */
    XK_exclamdown: 0x00a1, /* U+00A1 INVERTED EXCLAMATION MARK */
    XK_cent: 0x00a2, /* U+00A2 CENT SIGN */
    XK_sterling: 0x00a3, /* U+00A3 POUND SIGN */
    XK_currency: 0x00a4, /* U+00A4 CURRENCY SIGN */
    XK_yen: 0x00a5, /* U+00A5 YEN SIGN */
    XK_brokenbar: 0x00a6, /* U+00A6 BROKEN BAR */
    XK_section: 0x00a7, /* U+00A7 SECTION SIGN */
    XK_diaeresis: 0x00a8, /* U+00A8 DIAERESIS */
    XK_copyright: 0x00a9, /* U+00A9 COPYRIGHT SIGN */
    XK_ordfeminine: 0x00aa, /* U+00AA FEMININE ORDINAL INDICATOR */
    XK_guillemotleft: 0x00ab, /* U+00AB LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
    XK_notsign: 0x00ac, /* U+00AC NOT SIGN */
    XK_hyphen: 0x00ad, /* U+00AD SOFT HYPHEN */
    XK_registered: 0x00ae, /* U+00AE REGISTERED SIGN */
    XK_macron: 0x00af, /* U+00AF MACRON */
    XK_degree: 0x00b0, /* U+00B0 DEGREE SIGN */
    XK_plusminus: 0x00b1, /* U+00B1 PLUS-MINUS SIGN */
    XK_twosuperior: 0x00b2, /* U+00B2 SUPERSCRIPT TWO */
    XK_threesuperior: 0x00b3, /* U+00B3 SUPERSCRIPT THREE */
    XK_acute: 0x00b4, /* U+00B4 ACUTE ACCENT */
    XK_mu: 0x00b5, /* U+00B5 MICRO SIGN */
    XK_paragraph: 0x00b6, /* U+00B6 PILCROW SIGN */
    XK_periodcentered: 0x00b7, /* U+00B7 MIDDLE DOT */
    XK_cedilla: 0x00b8, /* U+00B8 CEDILLA */
    XK_onesuperior: 0x00b9, /* U+00B9 SUPERSCRIPT ONE */
    XK_masculine: 0x00ba, /* U+00BA MASCULINE ORDINAL INDICATOR */
    XK_guillemotright: 0x00bb, /* U+00BB RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */
    XK_onequarter: 0x00bc, /* U+00BC VULGAR FRACTION ONE QUARTER */
    XK_onehalf: 0x00bd, /* U+00BD VULGAR FRACTION ONE HALF */
    XK_threequarters: 0x00be, /* U+00BE VULGAR FRACTION THREE QUARTERS */
    XK_questiondown: 0x00bf, /* U+00BF INVERTED QUESTION MARK */
    XK_Agrave: 0x00c0, /* U+00C0 LATIN CAPITAL LETTER A WITH GRAVE */
    XK_Aacute: 0x00c1, /* U+00C1 LATIN CAPITAL LETTER A WITH ACUTE */
    XK_Acircumflex: 0x00c2, /* U+00C2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
    XK_Atilde: 0x00c3, /* U+00C3 LATIN CAPITAL LETTER A WITH TILDE */
    XK_Adiaeresis: 0x00c4, /* U+00C4 LATIN CAPITAL LETTER A WITH DIAERESIS */
    XK_Aring: 0x00c5, /* U+00C5 LATIN CAPITAL LETTER A WITH RING ABOVE */
    XK_AE: 0x00c6, /* U+00C6 LATIN CAPITAL LETTER AE */
    XK_Ccedilla: 0x00c7, /* U+00C7 LATIN CAPITAL LETTER C WITH CEDILLA */
    XK_Egrave: 0x00c8, /* U+00C8 LATIN CAPITAL LETTER E WITH GRAVE */
    XK_Eacute: 0x00c9, /* U+00C9 LATIN CAPITAL LETTER E WITH ACUTE */
    XK_Ecircumflex: 0x00ca, /* U+00CA LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
    XK_Ediaeresis: 0x00cb, /* U+00CB LATIN CAPITAL LETTER E WITH DIAERESIS */
    XK_Igrave: 0x00cc, /* U+00CC LATIN CAPITAL LETTER I WITH GRAVE */
    XK_Iacute: 0x00cd, /* U+00CD LATIN CAPITAL LETTER I WITH ACUTE */
    XK_Icircumflex: 0x00ce, /* U+00CE LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
    XK_Idiaeresis: 0x00cf, /* U+00CF LATIN CAPITAL LETTER I WITH DIAERESIS */
    XK_ETH: 0x00d0, /* U+00D0 LATIN CAPITAL LETTER ETH */
    XK_Eth: 0x00d0, /* deprecated */
    XK_Ntilde: 0x00d1, /* U+00D1 LATIN CAPITAL LETTER N WITH TILDE */
    XK_Ograve: 0x00d2, /* U+00D2 LATIN CAPITAL LETTER O WITH GRAVE */
    XK_Oacute: 0x00d3, /* U+00D3 LATIN CAPITAL LETTER O WITH ACUTE */
    XK_Ocircumflex: 0x00d4, /* U+00D4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
    XK_Otilde: 0x00d5, /* U+00D5 LATIN CAPITAL LETTER O WITH TILDE */
    XK_Odiaeresis: 0x00d6, /* U+00D6 LATIN CAPITAL LETTER O WITH DIAERESIS */
    XK_multiply: 0x00d7, /* U+00D7 MULTIPLICATION SIGN */
    XK_Oslash: 0x00d8, /* U+00D8 LATIN CAPITAL LETTER O WITH STROKE */
    XK_Ooblique: 0x00d8, /* U+00D8 LATIN CAPITAL LETTER O WITH STROKE */
    XK_Ugrave: 0x00d9, /* U+00D9 LATIN CAPITAL LETTER U WITH GRAVE */
    XK_Uacute: 0x00da, /* U+00DA LATIN CAPITAL LETTER U WITH ACUTE */
    XK_Ucircumflex: 0x00db, /* U+00DB LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
    XK_Udiaeresis: 0x00dc, /* U+00DC LATIN CAPITAL LETTER U WITH DIAERESIS */
    XK_Yacute: 0x00dd, /* U+00DD LATIN CAPITAL LETTER Y WITH ACUTE */
    XK_THORN: 0x00de, /* U+00DE LATIN CAPITAL LETTER THORN */
    XK_Thorn: 0x00de, /* deprecated */
    XK_ssharp: 0x00df, /* U+00DF LATIN SMALL LETTER SHARP S */
    XK_agrave: 0x00e0, /* U+00E0 LATIN SMALL LETTER A WITH GRAVE */
    XK_aacute: 0x00e1, /* U+00E1 LATIN SMALL LETTER A WITH ACUTE */
    XK_acircumflex: 0x00e2, /* U+00E2 LATIN SMALL LETTER A WITH CIRCUMFLEX */
    XK_atilde: 0x00e3, /* U+00E3 LATIN SMALL LETTER A WITH TILDE */
    XK_adiaeresis: 0x00e4, /* U+00E4 LATIN SMALL LETTER A WITH DIAERESIS */
    XK_aring: 0x00e5, /* U+00E5 LATIN SMALL LETTER A WITH RING ABOVE */
    XK_ae: 0x00e6, /* U+00E6 LATIN SMALL LETTER AE */
    XK_ccedilla: 0x00e7, /* U+00E7 LATIN SMALL LETTER C WITH CEDILLA */
    XK_egrave: 0x00e8, /* U+00E8 LATIN SMALL LETTER E WITH GRAVE */
    XK_eacute: 0x00e9, /* U+00E9 LATIN SMALL LETTER E WITH ACUTE */
    XK_ecircumflex: 0x00ea, /* U+00EA LATIN SMALL LETTER E WITH CIRCUMFLEX */
    XK_ediaeresis: 0x00eb, /* U+00EB LATIN SMALL LETTER E WITH DIAERESIS */
    XK_igrave: 0x00ec, /* U+00EC LATIN SMALL LETTER I WITH GRAVE */
    XK_iacute: 0x00ed, /* U+00ED LATIN SMALL LETTER I WITH ACUTE */
    XK_icircumflex: 0x00ee, /* U+00EE LATIN SMALL LETTER I WITH CIRCUMFLEX */
    XK_idiaeresis: 0x00ef, /* U+00EF LATIN SMALL LETTER I WITH DIAERESIS */
    XK_eth: 0x00f0, /* U+00F0 LATIN SMALL LETTER ETH */
    XK_ntilde: 0x00f1, /* U+00F1 LATIN SMALL LETTER N WITH TILDE */
    XK_ograve: 0x00f2, /* U+00F2 LATIN SMALL LETTER O WITH GRAVE */
    XK_oacute: 0x00f3, /* U+00F3 LATIN SMALL LETTER O WITH ACUTE */
    XK_ocircumflex: 0x00f4, /* U+00F4 LATIN SMALL LETTER O WITH CIRCUMFLEX */
    XK_otilde: 0x00f5, /* U+00F5 LATIN SMALL LETTER O WITH TILDE */
    XK_odiaeresis: 0x00f6, /* U+00F6 LATIN SMALL LETTER O WITH DIAERESIS */
    XK_division: 0x00f7, /* U+00F7 DIVISION SIGN */
    XK_oslash: 0x00f8, /* U+00F8 LATIN SMALL LETTER O WITH STROKE */
    XK_ooblique: 0x00f8, /* U+00F8 LATIN SMALL LETTER O WITH STROKE */
    XK_ugrave: 0x00f9, /* U+00F9 LATIN SMALL LETTER U WITH GRAVE */
    XK_uacute: 0x00fa, /* U+00FA LATIN SMALL LETTER U WITH ACUTE */
    XK_ucircumflex: 0x00fb, /* U+00FB LATIN SMALL LETTER U WITH CIRCUMFLEX */
    XK_udiaeresis: 0x00fc, /* U+00FC LATIN SMALL LETTER U WITH DIAERESIS */
    XK_yacute: 0x00fd, /* U+00FD LATIN SMALL LETTER Y WITH ACUTE */
    XK_thorn: 0x00fe, /* U+00FE LATIN SMALL LETTER THORN */
    XK_ydiaeresis: 0x00ff, /* U+00FF LATIN SMALL LETTER Y WITH DIAERESIS */

    /*
     * Korean
     * Byte 3 = 0x0e
     */

    XK_Hangul: 0xff31, /* Hangul start/stop(toggle) */
    XK_Hangul_Hanja: 0xff34, /* Start Hangul->Hanja Conversion */
    XK_Hangul_Jeonja: 0xff38, /* Jeonja mode */

    /*
     * XFree86 vendor specific keysyms.
     *
     * The XFree86 keysym range is 0x10080001 - 0x1008FFFF.
     */

    XF86XK_ModeLock: 0x1008FF01,
    XF86XK_MonBrightnessUp: 0x1008FF02,
    XF86XK_MonBrightnessDown: 0x1008FF03,
    XF86XK_KbdLightOnOff: 0x1008FF04,
    XF86XK_KbdBrightnessUp: 0x1008FF05,
    XF86XK_KbdBrightnessDown: 0x1008FF06,
    XF86XK_Standby: 0x1008FF10,
    XF86XK_AudioLowerVolume: 0x1008FF11,
    XF86XK_AudioMute: 0x1008FF12,
    XF86XK_AudioRaiseVolume: 0x1008FF13,
    XF86XK_AudioPlay: 0x1008FF14,
    XF86XK_AudioStop: 0x1008FF15,
    XF86XK_AudioPrev: 0x1008FF16,
    XF86XK_AudioNext: 0x1008FF17,
    XF86XK_HomePage: 0x1008FF18,
    XF86XK_Mail: 0x1008FF19,
    XF86XK_Start: 0x1008FF1A,
    XF86XK_Search: 0x1008FF1B,
    XF86XK_AudioRecord: 0x1008FF1C,
    XF86XK_Calculator: 0x1008FF1D,
    XF86XK_Memo: 0x1008FF1E,
    XF86XK_ToDoList: 0x1008FF1F,
    XF86XK_Calendar: 0x1008FF20,
    XF86XK_PowerDown: 0x1008FF21,
    XF86XK_ContrastAdjust: 0x1008FF22,
    XF86XK_RockerUp: 0x1008FF23,
    XF86XK_RockerDown: 0x1008FF24,
    XF86XK_RockerEnter: 0x1008FF25,
    XF86XK_Back: 0x1008FF26,
    XF86XK_Forward: 0x1008FF27,
    XF86XK_Stop: 0x1008FF28,
    XF86XK_Refresh: 0x1008FF29,
    XF86XK_PowerOff: 0x1008FF2A,
    XF86XK_WakeUp: 0x1008FF2B,
    XF86XK_Eject: 0x1008FF2C,
    XF86XK_ScreenSaver: 0x1008FF2D,
    XF86XK_WWW: 0x1008FF2E,
    XF86XK_Sleep: 0x1008FF2F,
    XF86XK_Favorites: 0x1008FF30,
    XF86XK_AudioPause: 0x1008FF31,
    XF86XK_AudioMedia: 0x1008FF32,
    XF86XK_MyComputer: 0x1008FF33,
    XF86XK_VendorHome: 0x1008FF34,
    XF86XK_LightBulb: 0x1008FF35,
    XF86XK_Shop: 0x1008FF36,
    XF86XK_History: 0x1008FF37,
    XF86XK_OpenURL: 0x1008FF38,
    XF86XK_AddFavorite: 0x1008FF39,
    XF86XK_HotLinks: 0x1008FF3A,
    XF86XK_BrightnessAdjust: 0x1008FF3B,
    XF86XK_Finance: 0x1008FF3C,
    XF86XK_Community: 0x1008FF3D,
    XF86XK_AudioRewind: 0x1008FF3E,
    XF86XK_BackForward: 0x1008FF3F,
    XF86XK_Launch0: 0x1008FF40,
    XF86XK_Launch1: 0x1008FF41,
    XF86XK_Launch2: 0x1008FF42,
    XF86XK_Launch3: 0x1008FF43,
    XF86XK_Launch4: 0x1008FF44,
    XF86XK_Launch5: 0x1008FF45,
    XF86XK_Launch6: 0x1008FF46,
    XF86XK_Launch7: 0x1008FF47,
    XF86XK_Launch8: 0x1008FF48,
    XF86XK_Launch9: 0x1008FF49,
    XF86XK_LaunchA: 0x1008FF4A,
    XF86XK_LaunchB: 0x1008FF4B,
    XF86XK_LaunchC: 0x1008FF4C,
    XF86XK_LaunchD: 0x1008FF4D,
    XF86XK_LaunchE: 0x1008FF4E,
    XF86XK_LaunchF: 0x1008FF4F,
    XF86XK_ApplicationLeft: 0x1008FF50,
    XF86XK_ApplicationRight: 0x1008FF51,
    XF86XK_Book: 0x1008FF52,
    XF86XK_CD: 0x1008FF53,
    XF86XK_Calculater: 0x1008FF54,
    XF86XK_Clear: 0x1008FF55,
    XF86XK_Close: 0x1008FF56,
    XF86XK_Copy: 0x1008FF57,
    XF86XK_Cut: 0x1008FF58,
    XF86XK_Display: 0x1008FF59,
    XF86XK_DOS: 0x1008FF5A,
    XF86XK_Documents: 0x1008FF5B,
    XF86XK_Excel: 0x1008FF5C,
    XF86XK_Explorer: 0x1008FF5D,
    XF86XK_Game: 0x1008FF5E,
    XF86XK_Go: 0x1008FF5F,
    XF86XK_iTouch: 0x1008FF60,
    XF86XK_LogOff: 0x1008FF61,
    XF86XK_Market: 0x1008FF62,
    XF86XK_Meeting: 0x1008FF63,
    XF86XK_MenuKB: 0x1008FF65,
    XF86XK_MenuPB: 0x1008FF66,
    XF86XK_MySites: 0x1008FF67,
    XF86XK_New: 0x1008FF68,
    XF86XK_News: 0x1008FF69,
    XF86XK_OfficeHome: 0x1008FF6A,
    XF86XK_Open: 0x1008FF6B,
    XF86XK_Option: 0x1008FF6C,
    XF86XK_Paste: 0x1008FF6D,
    XF86XK_Phone: 0x1008FF6E,
    XF86XK_Q: 0x1008FF70,
    XF86XK_Reply: 0x1008FF72,
    XF86XK_Reload: 0x1008FF73,
    XF86XK_RotateWindows: 0x1008FF74,
    XF86XK_RotationPB: 0x1008FF75,
    XF86XK_RotationKB: 0x1008FF76,
    XF86XK_Save: 0x1008FF77,
    XF86XK_ScrollUp: 0x1008FF78,
    XF86XK_ScrollDown: 0x1008FF79,
    XF86XK_ScrollClick: 0x1008FF7A,
    XF86XK_Send: 0x1008FF7B,
    XF86XK_Spell: 0x1008FF7C,
    XF86XK_SplitScreen: 0x1008FF7D,
    XF86XK_Support: 0x1008FF7E,
    XF86XK_TaskPane: 0x1008FF7F,
    XF86XK_Terminal: 0x1008FF80,
    XF86XK_Tools: 0x1008FF81,
    XF86XK_Travel: 0x1008FF82,
    XF86XK_UserPB: 0x1008FF84,
    XF86XK_User1KB: 0x1008FF85,
    XF86XK_User2KB: 0x1008FF86,
    XF86XK_Video: 0x1008FF87,
    XF86XK_WheelButton: 0x1008FF88,
    XF86XK_Word: 0x1008FF89,
    XF86XK_Xfer: 0x1008FF8A,
    XF86XK_ZoomIn: 0x1008FF8B,
    XF86XK_ZoomOut: 0x1008FF8C,
    XF86XK_Away: 0x1008FF8D,
    XF86XK_Messenger: 0x1008FF8E,
    XF86XK_WebCam: 0x1008FF8F,
    XF86XK_MailForward: 0x1008FF90,
    XF86XK_Pictures: 0x1008FF91,
    XF86XK_Music: 0x1008FF92,
    XF86XK_Battery: 0x1008FF93,
    XF86XK_Bluetooth: 0x1008FF94,
    XF86XK_WLAN: 0x1008FF95,
    XF86XK_UWB: 0x1008FF96,
    XF86XK_AudioForward: 0x1008FF97,
    XF86XK_AudioRepeat: 0x1008FF98,
    XF86XK_AudioRandomPlay: 0x1008FF99,
    XF86XK_Subtitle: 0x1008FF9A,
    XF86XK_AudioCycleTrack: 0x1008FF9B,
    XF86XK_CycleAngle: 0x1008FF9C,
    XF86XK_FrameBack: 0x1008FF9D,
    XF86XK_FrameForward: 0x1008FF9E,
    XF86XK_Time: 0x1008FF9F,
    XF86XK_Select: 0x1008FFA0,
    XF86XK_View: 0x1008FFA1,
    XF86XK_TopMenu: 0x1008FFA2,
    XF86XK_Red: 0x1008FFA3,
    XF86XK_Green: 0x1008FFA4,
    XF86XK_Yellow: 0x1008FFA5,
    XF86XK_Blue: 0x1008FFA6,
    XF86XK_Suspend: 0x1008FFA7,
    XF86XK_Hibernate: 0x1008FFA8,
    XF86XK_TouchpadToggle: 0x1008FFA9,
    XF86XK_TouchpadOn: 0x1008FFB0,
    XF86XK_TouchpadOff: 0x1008FFB1,
    XF86XK_AudioMicMute: 0x1008FFB2,
    XF86XK_Switch_VT_1: 0x1008FE01,
    XF86XK_Switch_VT_2: 0x1008FE02,
    XF86XK_Switch_VT_3: 0x1008FE03,
    XF86XK_Switch_VT_4: 0x1008FE04,
    XF86XK_Switch_VT_5: 0x1008FE05,
    XF86XK_Switch_VT_6: 0x1008FE06,
    XF86XK_Switch_VT_7: 0x1008FE07,
    XF86XK_Switch_VT_8: 0x1008FE08,
    XF86XK_Switch_VT_9: 0x1008FE09,
    XF86XK_Switch_VT_10: 0x1008FE0A,
    XF86XK_Switch_VT_11: 0x1008FE0B,
    XF86XK_Switch_VT_12: 0x1008FE0C,
    XF86XK_Ungrab: 0x1008FE20,
    XF86XK_ClearGrab: 0x1008FE21,
    XF86XK_Next_VMode: 0x1008FE22,
    XF86XK_Prev_VMode: 0x1008FE23,
    XF86XK_LogWindowTree: 0x1008FE24,
    XF86XK_LogGrabInfo: 0x1008FE25
  };
});
define('../bower_components/no-vnc/lib/input/domkeytable.js',["exports", "./keysym.js"], function (exports, _keysym) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _keysym2 = _interopRequireDefault(_keysym);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /*
     * Mapping between HTML key values and VNC/X11 keysyms for "special"
     * keys that cannot be handled via their Unicode codepoint.
     *
     * See https://www.w3.org/TR/uievents-key/ for possible values.
     */

    var DOMKeyTable = {}; /*
                           * noVNC: HTML5 VNC client
                           * Copyright (C) 2018 The noVNC Authors
                           * Licensed under MPL 2.0 or any later version (see LICENSE.txt)
                           */

    function addStandard(key, standard) {
        if (standard === undefined) throw new Error("Undefined keysym for key \"" + key + "\"");
        if (key in DOMKeyTable) throw new Error("Duplicate entry for key \"" + key + "\"");
        DOMKeyTable[key] = [standard, standard, standard, standard];
    }

    function addLeftRight(key, left, right) {
        if (left === undefined) throw new Error("Undefined keysym for key \"" + key + "\"");
        if (right === undefined) throw new Error("Undefined keysym for key \"" + key + "\"");
        if (key in DOMKeyTable) throw new Error("Duplicate entry for key \"" + key + "\"");
        DOMKeyTable[key] = [left, left, right, left];
    }

    function addNumpad(key, standard, numpad) {
        if (standard === undefined) throw new Error("Undefined keysym for key \"" + key + "\"");
        if (numpad === undefined) throw new Error("Undefined keysym for key \"" + key + "\"");
        if (key in DOMKeyTable) throw new Error("Duplicate entry for key \"" + key + "\"");
        DOMKeyTable[key] = [standard, standard, standard, numpad];
    }

    // 2.2. Modifier Keys

    addLeftRight("Alt", _keysym2.default.XK_Alt_L, _keysym2.default.XK_Alt_R);
    addStandard("AltGraph", _keysym2.default.XK_ISO_Level3_Shift);
    addStandard("CapsLock", _keysym2.default.XK_Caps_Lock);
    addLeftRight("Control", _keysym2.default.XK_Control_L, _keysym2.default.XK_Control_R);
    // - Fn
    // - FnLock
    addLeftRight("Hyper", _keysym2.default.XK_Super_L, _keysym2.default.XK_Super_R);
    addLeftRight("Meta", _keysym2.default.XK_Super_L, _keysym2.default.XK_Super_R);
    addStandard("NumLock", _keysym2.default.XK_Num_Lock);
    addStandard("ScrollLock", _keysym2.default.XK_Scroll_Lock);
    addLeftRight("Shift", _keysym2.default.XK_Shift_L, _keysym2.default.XK_Shift_R);
    addLeftRight("Super", _keysym2.default.XK_Super_L, _keysym2.default.XK_Super_R);
    // - Symbol
    // - SymbolLock

    // 2.3. Whitespace Keys

    addNumpad("Enter", _keysym2.default.XK_Return, _keysym2.default.XK_KP_Enter);
    addStandard("Tab", _keysym2.default.XK_Tab);
    addNumpad(" ", _keysym2.default.XK_space, _keysym2.default.XK_KP_Space);

    // 2.4. Navigation Keys

    addNumpad("ArrowDown", _keysym2.default.XK_Down, _keysym2.default.XK_KP_Down);
    addNumpad("ArrowUp", _keysym2.default.XK_Up, _keysym2.default.XK_KP_Up);
    addNumpad("ArrowLeft", _keysym2.default.XK_Left, _keysym2.default.XK_KP_Left);
    addNumpad("ArrowRight", _keysym2.default.XK_Right, _keysym2.default.XK_KP_Right);
    addNumpad("End", _keysym2.default.XK_End, _keysym2.default.XK_KP_End);
    addNumpad("Home", _keysym2.default.XK_Home, _keysym2.default.XK_KP_Home);
    addNumpad("PageDown", _keysym2.default.XK_Next, _keysym2.default.XK_KP_Next);
    addNumpad("PageUp", _keysym2.default.XK_Prior, _keysym2.default.XK_KP_Prior);

    // 2.5. Editing Keys

    addStandard("Backspace", _keysym2.default.XK_BackSpace);
    addNumpad("Clear", _keysym2.default.XK_Clear, _keysym2.default.XK_KP_Begin);
    addStandard("Copy", _keysym2.default.XF86XK_Copy);
    // - CrSel
    addStandard("Cut", _keysym2.default.XF86XK_Cut);
    addNumpad("Delete", _keysym2.default.XK_Delete, _keysym2.default.XK_KP_Delete);
    // - EraseEof
    // - ExSel
    addNumpad("Insert", _keysym2.default.XK_Insert, _keysym2.default.XK_KP_Insert);
    addStandard("Paste", _keysym2.default.XF86XK_Paste);
    addStandard("Redo", _keysym2.default.XK_Redo);
    addStandard("Undo", _keysym2.default.XK_Undo);

    // 2.6. UI Keys

    // - Accept
    // - Again (could just be XK_Redo)
    // - Attn
    addStandard("Cancel", _keysym2.default.XK_Cancel);
    addStandard("ContextMenu", _keysym2.default.XK_Menu);
    addStandard("Escape", _keysym2.default.XK_Escape);
    addStandard("Execute", _keysym2.default.XK_Execute);
    addStandard("Find", _keysym2.default.XK_Find);
    addStandard("Help", _keysym2.default.XK_Help);
    addStandard("Pause", _keysym2.default.XK_Pause);
    // - Play
    // - Props
    addStandard("Select", _keysym2.default.XK_Select);
    addStandard("ZoomIn", _keysym2.default.XF86XK_ZoomIn);
    addStandard("ZoomOut", _keysym2.default.XF86XK_ZoomOut);

    // 2.7. Device Keys

    addStandard("BrightnessDown", _keysym2.default.XF86XK_MonBrightnessDown);
    addStandard("BrightnessUp", _keysym2.default.XF86XK_MonBrightnessUp);
    addStandard("Eject", _keysym2.default.XF86XK_Eject);
    addStandard("LogOff", _keysym2.default.XF86XK_LogOff);
    addStandard("Power", _keysym2.default.XF86XK_PowerOff);
    addStandard("PowerOff", _keysym2.default.XF86XK_PowerDown);
    addStandard("PrintScreen", _keysym2.default.XK_Print);
    addStandard("Hibernate", _keysym2.default.XF86XK_Hibernate);
    addStandard("Standby", _keysym2.default.XF86XK_Standby);
    addStandard("WakeUp", _keysym2.default.XF86XK_WakeUp);

    // 2.8. IME and Composition Keys

    addStandard("AllCandidates", _keysym2.default.XK_MultipleCandidate);
    addStandard("Alphanumeric", _keysym2.default.XK_Eisu_Shift); // could also be _Eisu_Toggle
    addStandard("CodeInput", _keysym2.default.XK_Codeinput);
    addStandard("Compose", _keysym2.default.XK_Multi_key);
    addStandard("Convert", _keysym2.default.XK_Henkan);
    // - Dead
    // - FinalMode
    addStandard("GroupFirst", _keysym2.default.XK_ISO_First_Group);
    addStandard("GroupLast", _keysym2.default.XK_ISO_Last_Group);
    addStandard("GroupNext", _keysym2.default.XK_ISO_Next_Group);
    addStandard("GroupPrevious", _keysym2.default.XK_ISO_Prev_Group);
    // - ModeChange (XK_Mode_switch is often used for AltGr)
    // - NextCandidate
    addStandard("NonConvert", _keysym2.default.XK_Muhenkan);
    addStandard("PreviousCandidate", _keysym2.default.XK_PreviousCandidate);
    // - Process
    addStandard("SingleCandidate", _keysym2.default.XK_SingleCandidate);
    addStandard("HangulMode", _keysym2.default.XK_Hangul);
    addStandard("HanjaMode", _keysym2.default.XK_Hangul_Hanja);
    addStandard("JunjuaMode", _keysym2.default.XK_Hangul_Jeonja);
    addStandard("Eisu", _keysym2.default.XK_Eisu_toggle);
    addStandard("Hankaku", _keysym2.default.XK_Hankaku);
    addStandard("Hiragana", _keysym2.default.XK_Hiragana);
    addStandard("HiraganaKatakana", _keysym2.default.XK_Hiragana_Katakana);
    addStandard("KanaMode", _keysym2.default.XK_Kana_Shift); // could also be _Kana_Lock
    addStandard("KanjiMode", _keysym2.default.XK_Kanji);
    addStandard("Katakana", _keysym2.default.XK_Katakana);
    addStandard("Romaji", _keysym2.default.XK_Romaji);
    addStandard("Zenkaku", _keysym2.default.XK_Zenkaku);
    addStandard("ZenkakuHanaku", _keysym2.default.XK_Zenkaku_Hankaku);

    // 2.9. General-Purpose Function Keys

    addStandard("F1", _keysym2.default.XK_F1);
    addStandard("F2", _keysym2.default.XK_F2);
    addStandard("F3", _keysym2.default.XK_F3);
    addStandard("F4", _keysym2.default.XK_F4);
    addStandard("F5", _keysym2.default.XK_F5);
    addStandard("F6", _keysym2.default.XK_F6);
    addStandard("F7", _keysym2.default.XK_F7);
    addStandard("F8", _keysym2.default.XK_F8);
    addStandard("F9", _keysym2.default.XK_F9);
    addStandard("F10", _keysym2.default.XK_F10);
    addStandard("F11", _keysym2.default.XK_F11);
    addStandard("F12", _keysym2.default.XK_F12);
    addStandard("F13", _keysym2.default.XK_F13);
    addStandard("F14", _keysym2.default.XK_F14);
    addStandard("F15", _keysym2.default.XK_F15);
    addStandard("F16", _keysym2.default.XK_F16);
    addStandard("F17", _keysym2.default.XK_F17);
    addStandard("F18", _keysym2.default.XK_F18);
    addStandard("F19", _keysym2.default.XK_F19);
    addStandard("F20", _keysym2.default.XK_F20);
    addStandard("F21", _keysym2.default.XK_F21);
    addStandard("F22", _keysym2.default.XK_F22);
    addStandard("F23", _keysym2.default.XK_F23);
    addStandard("F24", _keysym2.default.XK_F24);
    addStandard("F25", _keysym2.default.XK_F25);
    addStandard("F26", _keysym2.default.XK_F26);
    addStandard("F27", _keysym2.default.XK_F27);
    addStandard("F28", _keysym2.default.XK_F28);
    addStandard("F29", _keysym2.default.XK_F29);
    addStandard("F30", _keysym2.default.XK_F30);
    addStandard("F31", _keysym2.default.XK_F31);
    addStandard("F32", _keysym2.default.XK_F32);
    addStandard("F33", _keysym2.default.XK_F33);
    addStandard("F34", _keysym2.default.XK_F34);
    addStandard("F35", _keysym2.default.XK_F35);
    // - Soft1...

    // 2.10. Multimedia Keys

    // - ChannelDown
    // - ChannelUp
    addStandard("Close", _keysym2.default.XF86XK_Close);
    addStandard("MailForward", _keysym2.default.XF86XK_MailForward);
    addStandard("MailReply", _keysym2.default.XF86XK_Reply);
    addStandard("MainSend", _keysym2.default.XF86XK_Send);
    addStandard("MediaFastForward", _keysym2.default.XF86XK_AudioForward);
    addStandard("MediaPause", _keysym2.default.XF86XK_AudioPause);
    addStandard("MediaPlay", _keysym2.default.XF86XK_AudioPlay);
    addStandard("MediaRecord", _keysym2.default.XF86XK_AudioRecord);
    addStandard("MediaRewind", _keysym2.default.XF86XK_AudioRewind);
    addStandard("MediaStop", _keysym2.default.XF86XK_AudioStop);
    addStandard("MediaTrackNext", _keysym2.default.XF86XK_AudioNext);
    addStandard("MediaTrackPrevious", _keysym2.default.XF86XK_AudioPrev);
    addStandard("New", _keysym2.default.XF86XK_New);
    addStandard("Open", _keysym2.default.XF86XK_Open);
    addStandard("Print", _keysym2.default.XK_Print);
    addStandard("Save", _keysym2.default.XF86XK_Save);
    addStandard("SpellCheck", _keysym2.default.XF86XK_Spell);

    // 2.11. Multimedia Numpad Keys

    // - Key11
    // - Key12

    // 2.12. Audio Keys

    // - AudioBalanceLeft
    // - AudioBalanceRight
    // - AudioBassDown
    // - AudioBassBoostDown
    // - AudioBassBoostToggle
    // - AudioBassBoostUp
    // - AudioBassUp
    // - AudioFaderFront
    // - AudioFaderRear
    // - AudioSurroundModeNext
    // - AudioTrebleDown
    // - AudioTrebleUp
    addStandard("AudioVolumeDown", _keysym2.default.XF86XK_AudioLowerVolume);
    addStandard("AudioVolumeUp", _keysym2.default.XF86XK_AudioRaiseVolume);
    addStandard("AudioVolumeMute", _keysym2.default.XF86XK_AudioMute);
    // - MicrophoneToggle
    // - MicrophoneVolumeDown
    // - MicrophoneVolumeUp
    addStandard("MicrophoneVolumeMute", _keysym2.default.XF86XK_AudioMicMute);

    // 2.13. Speech Keys

    // - SpeechCorrectionList
    // - SpeechInputToggle

    // 2.14. Application Keys

    addStandard("LaunchCalculator", _keysym2.default.XF86XK_Calculator);
    addStandard("LaunchCalendar", _keysym2.default.XF86XK_Calendar);
    addStandard("LaunchMail", _keysym2.default.XF86XK_Mail);
    addStandard("LaunchMediaPlayer", _keysym2.default.XF86XK_AudioMedia);
    addStandard("LaunchMusicPlayer", _keysym2.default.XF86XK_Music);
    addStandard("LaunchMyComputer", _keysym2.default.XF86XK_MyComputer);
    addStandard("LaunchPhone", _keysym2.default.XF86XK_Phone);
    addStandard("LaunchScreenSaver", _keysym2.default.XF86XK_ScreenSaver);
    addStandard("LaunchSpreadsheet", _keysym2.default.XF86XK_Excel);
    addStandard("LaunchWebBrowser", _keysym2.default.XF86XK_WWW);
    addStandard("LaunchWebCam", _keysym2.default.XF86XK_WebCam);
    addStandard("LaunchWordProcessor", _keysym2.default.XF86XK_Word);

    // 2.15. Browser Keys

    addStandard("BrowserBack", _keysym2.default.XF86XK_Back);
    addStandard("BrowserFavorites", _keysym2.default.XF86XK_Favorites);
    addStandard("BrowserForward", _keysym2.default.XF86XK_Forward);
    addStandard("BrowserHome", _keysym2.default.XF86XK_HomePage);
    addStandard("BrowserRefresh", _keysym2.default.XF86XK_Refresh);
    addStandard("BrowserSearch", _keysym2.default.XF86XK_Search);
    addStandard("BrowserStop", _keysym2.default.XF86XK_Stop);

    // 2.16. Mobile Phone Keys

    // - A whole bunch...

    // 2.17. TV Keys

    // - A whole bunch...

    // 2.18. Media Controller Keys

    // - A whole bunch...
    addStandard("Dimmer", _keysym2.default.XF86XK_BrightnessAdjust);
    addStandard("MediaAudioTrack", _keysym2.default.XF86XK_AudioCycleTrack);
    addStandard("RandomToggle", _keysym2.default.XF86XK_AudioRandomPlay);
    addStandard("SplitScreenToggle", _keysym2.default.XF86XK_SplitScreen);
    addStandard("Subtitle", _keysym2.default.XF86XK_Subtitle);
    addStandard("VideoModeNext", _keysym2.default.XF86XK_Next_VMode);

    // Extra: Numpad

    addNumpad("=", _keysym2.default.XK_equal, _keysym2.default.XK_KP_Equal);
    addNumpad("+", _keysym2.default.XK_plus, _keysym2.default.XK_KP_Add);
    addNumpad("-", _keysym2.default.XK_minus, _keysym2.default.XK_KP_Subtract);
    addNumpad("*", _keysym2.default.XK_asterisk, _keysym2.default.XK_KP_Multiply);
    addNumpad("/", _keysym2.default.XK_slash, _keysym2.default.XK_KP_Divide);
    addNumpad(".", _keysym2.default.XK_period, _keysym2.default.XK_KP_Decimal);
    addNumpad(",", _keysym2.default.XK_comma, _keysym2.default.XK_KP_Separator);
    addNumpad("0", _keysym2.default.XK_0, _keysym2.default.XK_KP_0);
    addNumpad("1", _keysym2.default.XK_1, _keysym2.default.XK_KP_1);
    addNumpad("2", _keysym2.default.XK_2, _keysym2.default.XK_KP_2);
    addNumpad("3", _keysym2.default.XK_3, _keysym2.default.XK_KP_3);
    addNumpad("4", _keysym2.default.XK_4, _keysym2.default.XK_KP_4);
    addNumpad("5", _keysym2.default.XK_5, _keysym2.default.XK_KP_5);
    addNumpad("6", _keysym2.default.XK_6, _keysym2.default.XK_KP_6);
    addNumpad("7", _keysym2.default.XK_7, _keysym2.default.XK_KP_7);
    addNumpad("8", _keysym2.default.XK_8, _keysym2.default.XK_KP_8);
    addNumpad("9", _keysym2.default.XK_9, _keysym2.default.XK_KP_9);

    exports.default = DOMKeyTable;
});
define('../bower_components/no-vnc/lib/input/util.js',["exports", "./keysymdef.js", "./vkeys.js", "./fixedkeys.js", "./domkeytable.js", "../util/browser.js"], function (exports, _keysymdef, _vkeys, _fixedkeys, _domkeytable, _browser) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getKeycode = getKeycode;
    exports.getKey = getKey;
    exports.getKeysym = getKeysym;

    var _keysymdef2 = _interopRequireDefault(_keysymdef);

    var _vkeys2 = _interopRequireDefault(_vkeys);

    var _fixedkeys2 = _interopRequireDefault(_fixedkeys);

    var _domkeytable2 = _interopRequireDefault(_domkeytable);

    var browser = _interopRequireWildcard(_browser);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    // Get 'KeyboardEvent.code', handling legacy browsers
    function getKeycode(evt) {
        // Are we getting proper key identifiers?
        // (unfortunately Firefox and Chrome are crappy here and gives
        // us an empty string on some platforms, rather than leaving it
        // undefined)
        if (evt.code) {
            // Mozilla isn't fully in sync with the spec yet
            switch (evt.code) {
                case 'OSLeft':
                    return 'MetaLeft';
                case 'OSRight':
                    return 'MetaRight';
            }

            return evt.code;
        }

        // The de-facto standard is to use Windows Virtual-Key codes
        // in the 'keyCode' field for non-printable characters. However
        // Webkit sets it to the same as charCode in 'keypress' events.
        if (evt.type !== 'keypress' && evt.keyCode in _vkeys2.default) {
            var code = _vkeys2.default[evt.keyCode];

            // macOS has messed up this code for some reason
            if (browser.isMac() && code === 'ContextMenu') {
                code = 'MetaRight';
            }

            // The keyCode doesn't distinguish between left and right
            // for the standard modifiers
            if (evt.location === 2) {
                switch (code) {
                    case 'ShiftLeft':
                        return 'ShiftRight';
                    case 'ControlLeft':
                        return 'ControlRight';
                    case 'AltLeft':
                        return 'AltRight';
                }
            }

            // Nor a bunch of the numpad keys
            if (evt.location === 3) {
                switch (code) {
                    case 'Delete':
                        return 'NumpadDecimal';
                    case 'Insert':
                        return 'Numpad0';
                    case 'End':
                        return 'Numpad1';
                    case 'ArrowDown':
                        return 'Numpad2';
                    case 'PageDown':
                        return 'Numpad3';
                    case 'ArrowLeft':
                        return 'Numpad4';
                    case 'ArrowRight':
                        return 'Numpad6';
                    case 'Home':
                        return 'Numpad7';
                    case 'ArrowUp':
                        return 'Numpad8';
                    case 'PageUp':
                        return 'Numpad9';
                    case 'Enter':
                        return 'NumpadEnter';
                }
            }

            return code;
        }

        return 'Unidentified';
    }

    // Get 'KeyboardEvent.key', handling legacy browsers
    function getKey(evt) {
        // Are we getting a proper key value?
        if (evt.key !== undefined) {
            // IE and Edge use some ancient version of the spec
            // https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/8860571/
            switch (evt.key) {
                case 'Spacebar':
                    return ' ';
                case 'Esc':
                    return 'Escape';
                case 'Scroll':
                    return 'ScrollLock';
                case 'Win':
                    return 'Meta';
                case 'Apps':
                    return 'ContextMenu';
                case 'Up':
                    return 'ArrowUp';
                case 'Left':
                    return 'ArrowLeft';
                case 'Right':
                    return 'ArrowRight';
                case 'Down':
                    return 'ArrowDown';
                case 'Del':
                    return 'Delete';
                case 'Divide':
                    return '/';
                case 'Multiply':
                    return '*';
                case 'Subtract':
                    return '-';
                case 'Add':
                    return '+';
                case 'Decimal':
                    return evt.char;
            }

            // Mozilla isn't fully in sync with the spec yet
            switch (evt.key) {
                case 'OS':
                    return 'Meta';
            }

            // iOS leaks some OS names
            switch (evt.key) {
                case 'UIKeyInputUpArrow':
                    return 'ArrowUp';
                case 'UIKeyInputDownArrow':
                    return 'ArrowDown';
                case 'UIKeyInputLeftArrow':
                    return 'ArrowLeft';
                case 'UIKeyInputRightArrow':
                    return 'ArrowRight';
                case 'UIKeyInputEscape':
                    return 'Escape';
            }

            // IE and Edge have broken handling of AltGraph so we cannot
            // trust them for printable characters
            if (evt.key.length !== 1 || !browser.isIE() && !browser.isEdge()) {
                return evt.key;
            }
        }

        // Try to deduce it based on the physical key
        var code = getKeycode(evt);
        if (code in _fixedkeys2.default) {
            return _fixedkeys2.default[code];
        }

        // If that failed, then see if we have a printable character
        if (evt.charCode) {
            return String.fromCharCode(evt.charCode);
        }

        // At this point we have nothing left to go on
        return 'Unidentified';
    }

    // Get the most reliable keysym value we can get from a key event
    function getKeysym(evt) {
        var key = getKey(evt);

        if (key === 'Unidentified') {
            return null;
        }

        // First look up special keys
        if (key in _domkeytable2.default) {
            var location = evt.location;

            // Safari screws up location for the right cmd key
            if (key === 'Meta' && location === 0) {
                location = 2;
            }

            if (location === undefined || location > 3) {
                location = 0;
            }

            return _domkeytable2.default[key][location];
        }

        // Now we need to look at the Unicode symbol instead

        // Special key? (FIXME: Should have been caught earlier)
        if (key.length !== 1) {
            return null;
        }

        var codepoint = key.charCodeAt();
        if (codepoint) {
            return _keysymdef2.default.lookup(codepoint);
        }

        return null;
    }
});
define('../bower_components/no-vnc/lib/input/keyboard.js',['exports', '../util/logging.js', '../util/events.js', './util.js', './keysym.js', '../util/browser.js'], function (exports, _logging, _events, _util, _keysym, _browser) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    var KeyboardUtil = _interopRequireWildcard(_util);

    var _keysym2 = _interopRequireDefault(_keysym);

    var browser = _interopRequireWildcard(_browser);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var Keyboard = function () {
        function Keyboard(target) {
            _classCallCheck(this, Keyboard);

            this._target = target || null;

            this._keyDownList = {}; // List of depressed keys
            // (even if they are happy)
            this._pendingKey = null; // Key waiting for keypress
            this._altGrArmed = false; // Windows AltGr detection

            // keep these here so we can refer to them later
            this._eventHandlers = {
                'keyup': this._handleKeyUp.bind(this),
                'keydown': this._handleKeyDown.bind(this),
                'keypress': this._handleKeyPress.bind(this),
                'blur': this._allKeysUp.bind(this),
                'checkalt': this._checkAlt.bind(this)
            };

            // ===== EVENT HANDLERS =====

            this.onkeyevent = function () {}; // Handler for key press/release
        }

        // ===== PRIVATE METHODS =====

        _createClass(Keyboard, [{
            key: '_sendKeyEvent',
            value: function _sendKeyEvent(keysym, code, down) {
                if (down) {
                    this._keyDownList[code] = keysym;
                } else {
                    // Do we really think this key is down?
                    if (!(code in this._keyDownList)) {
                        return;
                    }
                    delete this._keyDownList[code];
                }

                Log.Debug("onkeyevent " + (down ? "down" : "up") + ", keysym: " + keysym, ", code: " + code);
                this.onkeyevent(keysym, code, down);
            }
        }, {
            key: '_getKeyCode',
            value: function _getKeyCode(e) {
                var code = KeyboardUtil.getKeycode(e);
                if (code !== 'Unidentified') {
                    return code;
                }

                // Unstable, but we don't have anything else to go on
                // (don't use it for 'keypress' events thought since
                // WebKit sets it to the same as charCode)
                if (e.keyCode && e.type !== 'keypress') {
                    // 229 is used for composition events
                    if (e.keyCode !== 229) {
                        return 'Platform' + e.keyCode;
                    }
                }

                // A precursor to the final DOM3 standard. Unfortunately it
                // is not layout independent, so it is as bad as using keyCode
                if (e.keyIdentifier) {
                    // Non-character key?
                    if (e.keyIdentifier.substr(0, 2) !== 'U+') {
                        return e.keyIdentifier;
                    }

                    var codepoint = parseInt(e.keyIdentifier.substr(2), 16);
                    var char = String.fromCharCode(codepoint).toUpperCase();

                    return 'Platform' + char.charCodeAt();
                }

                return 'Unidentified';
            }
        }, {
            key: '_handleKeyDown',
            value: function _handleKeyDown(e) {
                var code = this._getKeyCode(e);
                var keysym = KeyboardUtil.getKeysym(e);

                // Windows doesn't have a proper AltGr, but handles it using
                // fake Ctrl+Alt. However the remote end might not be Windows,
                // so we need to merge those in to a single AltGr event. We
                // detect this case by seeing the two key events directly after
                // each other with a very short time between them (<50ms).
                if (this._altGrArmed) {
                    this._altGrArmed = false;
                    clearTimeout(this._altGrTimeout);

                    if (code === "AltRight" && e.timeStamp - this._altGrCtrlTime < 50) {
                        // FIXME: We fail to detect this if either Ctrl key is
                        //        first manually pressed as Windows then no
                        //        longer sends the fake Ctrl down event. It
                        //        does however happily send real Ctrl events
                        //        even when AltGr is already down. Some
                        //        browsers detect this for us though and set the
                        //        key to "AltGraph".
                        keysym = _keysym2.default.XK_ISO_Level3_Shift;
                    } else {
                        this._sendKeyEvent(_keysym2.default.XK_Control_L, "ControlLeft", true);
                    }
                }

                // We cannot handle keys we cannot track, but we also need
                // to deal with virtual keyboards which omit key info
                // (iOS omits tracking info on keyup events, which forces us to
                // special treat that platform here)
                if (code === 'Unidentified' || browser.isIOS()) {
                    if (keysym) {
                        // If it's a virtual keyboard then it should be
                        // sufficient to just send press and release right
                        // after each other
                        this._sendKeyEvent(keysym, code, true);
                        this._sendKeyEvent(keysym, code, false);
                    }

                    (0, _events.stopEvent)(e);
                    return;
                }

                // Alt behaves more like AltGraph on macOS, so shuffle the
                // keys around a bit to make things more sane for the remote
                // server. This method is used by RealVNC and TigerVNC (and
                // possibly others).
                if (browser.isMac()) {
                    switch (keysym) {
                        case _keysym2.default.XK_Super_L:
                            keysym = _keysym2.default.XK_Alt_L;
                            break;
                        case _keysym2.default.XK_Super_R:
                            keysym = _keysym2.default.XK_Super_L;
                            break;
                        case _keysym2.default.XK_Alt_L:
                            keysym = _keysym2.default.XK_Mode_switch;
                            break;
                        case _keysym2.default.XK_Alt_R:
                            keysym = _keysym2.default.XK_ISO_Level3_Shift;
                            break;
                    }
                }

                // Is this key already pressed? If so, then we must use the
                // same keysym or we'll confuse the server
                if (code in this._keyDownList) {
                    keysym = this._keyDownList[code];
                }

                // macOS doesn't send proper key events for modifiers, only
                // state change events. That gets extra confusing for CapsLock
                // which toggles on each press, but not on release. So pretend
                // it was a quick press and release of the button.
                if (browser.isMac() && code === 'CapsLock') {
                    this._sendKeyEvent(_keysym2.default.XK_Caps_Lock, 'CapsLock', true);
                    this._sendKeyEvent(_keysym2.default.XK_Caps_Lock, 'CapsLock', false);
                    (0, _events.stopEvent)(e);
                    return;
                }

                // If this is a legacy browser then we'll need to wait for
                // a keypress event as well
                // (IE and Edge has a broken KeyboardEvent.key, so we can't
                // just check for the presence of that field)
                if (!keysym && (!e.key || browser.isIE() || browser.isEdge())) {
                    this._pendingKey = code;
                    // However we might not get a keypress event if the key
                    // is non-printable, which needs some special fallback
                    // handling
                    setTimeout(this._handleKeyPressTimeout.bind(this), 10, e);
                    return;
                }

                this._pendingKey = null;
                (0, _events.stopEvent)(e);

                // Possible start of AltGr sequence? (see above)
                if (code === "ControlLeft" && browser.isWindows() && !("ControlLeft" in this._keyDownList)) {
                    this._altGrArmed = true;
                    this._altGrTimeout = setTimeout(this._handleAltGrTimeout.bind(this), 100);
                    this._altGrCtrlTime = e.timeStamp;
                    return;
                }

                this._sendKeyEvent(keysym, code, true);
            }
        }, {
            key: '_handleKeyPress',
            value: function _handleKeyPress(e) {
                (0, _events.stopEvent)(e);

                // Are we expecting a keypress?
                if (this._pendingKey === null) {
                    return;
                }

                var code = this._getKeyCode(e);
                var keysym = KeyboardUtil.getKeysym(e);

                // The key we were waiting for?
                if (code !== 'Unidentified' && code != this._pendingKey) {
                    return;
                }

                code = this._pendingKey;
                this._pendingKey = null;

                if (!keysym) {
                    Log.Info('keypress with no keysym:', e);
                    return;
                }

                this._sendKeyEvent(keysym, code, true);
            }
        }, {
            key: '_handleKeyPressTimeout',
            value: function _handleKeyPressTimeout(e) {
                // Did someone manage to sort out the key already?
                if (this._pendingKey === null) {
                    return;
                }

                var keysym = void 0;

                var code = this._pendingKey;
                this._pendingKey = null;

                // We have no way of knowing the proper keysym with the
                // information given, but the following are true for most
                // layouts
                if (e.keyCode >= 0x30 && e.keyCode <= 0x39) {
                    // Digit
                    keysym = e.keyCode;
                } else if (e.keyCode >= 0x41 && e.keyCode <= 0x5a) {
                    // Character (A-Z)
                    var char = String.fromCharCode(e.keyCode);
                    // A feeble attempt at the correct case
                    if (e.shiftKey) {
                        char = char.toUpperCase();
                    } else {
                        char = char.toLowerCase();
                    }
                    keysym = char.charCodeAt();
                } else {
                    // Unknown, give up
                    keysym = 0;
                }

                this._sendKeyEvent(keysym, code, true);
            }
        }, {
            key: '_handleKeyUp',
            value: function _handleKeyUp(e) {
                (0, _events.stopEvent)(e);

                var code = this._getKeyCode(e);

                // We can't get a release in the middle of an AltGr sequence, so
                // abort that detection
                if (this._altGrArmed) {
                    this._altGrArmed = false;
                    clearTimeout(this._altGrTimeout);
                    this._sendKeyEvent(_keysym2.default.XK_Control_L, "ControlLeft", true);
                }

                // See comment in _handleKeyDown()
                if (browser.isMac() && code === 'CapsLock') {
                    this._sendKeyEvent(_keysym2.default.XK_Caps_Lock, 'CapsLock', true);
                    this._sendKeyEvent(_keysym2.default.XK_Caps_Lock, 'CapsLock', false);
                    return;
                }

                this._sendKeyEvent(this._keyDownList[code], code, false);
            }
        }, {
            key: '_handleAltGrTimeout',
            value: function _handleAltGrTimeout() {
                this._altGrArmed = false;
                clearTimeout(this._altGrTimeout);
                this._sendKeyEvent(_keysym2.default.XK_Control_L, "ControlLeft", true);
            }
        }, {
            key: '_allKeysUp',
            value: function _allKeysUp() {
                Log.Debug(">> Keyboard.allKeysUp");
                for (var code in this._keyDownList) {
                    this._sendKeyEvent(this._keyDownList[code], code, false);
                }
                Log.Debug("<< Keyboard.allKeysUp");
            }
        }, {
            key: '_checkAlt',
            value: function _checkAlt(e) {
                if (e.altKey) {
                    return;
                }

                var target = this._target;
                var downList = this._keyDownList;
                ['AltLeft', 'AltRight'].forEach(function (code) {
                    if (!(code in downList)) {
                        return;
                    }

                    var event = new KeyboardEvent('keyup', { key: downList[code],
                        code: code });
                    target.dispatchEvent(event);
                });
            }
        }, {
            key: 'grab',
            value: function grab() {
                //Log.Debug(">> Keyboard.grab");

                this._target.addEventListener('keydown', this._eventHandlers.keydown);
                this._target.addEventListener('keyup', this._eventHandlers.keyup);
                this._target.addEventListener('keypress', this._eventHandlers.keypress);

                // Release (key up) if window loses focus
                window.addEventListener('blur', this._eventHandlers.blur);

                // Firefox has broken handling of Alt, so we need to poll as
                // best we can for releases (still doesn't prevent the menu
                // from popping up though as we can't call preventDefault())
                if (browser.isWindows() && browser.isFirefox()) {
                    var handler = this._eventHandlers.checkalt;
                    ['mousedown', 'mouseup', 'mousemove', 'wheel', 'touchstart', 'touchend', 'touchmove', 'keydown', 'keyup'].forEach(function (type) {
                        return document.addEventListener(type, handler, { capture: true,
                            passive: true });
                    });
                }

                //Log.Debug("<< Keyboard.grab");
            }
        }, {
            key: 'ungrab',
            value: function ungrab() {
                //Log.Debug(">> Keyboard.ungrab");

                if (browser.isWindows() && browser.isFirefox()) {
                    var handler = this._eventHandlers.checkalt;
                    ['mousedown', 'mouseup', 'mousemove', 'wheel', 'touchstart', 'touchend', 'touchmove', 'keydown', 'keyup'].forEach(function (type) {
                        return document.removeEventListener(type, handler);
                    });
                }

                this._target.removeEventListener('keydown', this._eventHandlers.keydown);
                this._target.removeEventListener('keyup', this._eventHandlers.keyup);
                this._target.removeEventListener('keypress', this._eventHandlers.keypress);
                window.removeEventListener('blur', this._eventHandlers.blur);

                // Release (key up) all keys that are in a down state
                this._allKeysUp();

                //Log.Debug(">> Keyboard.ungrab");
            }
        }]);

        return Keyboard;
    }();

    exports.default = Keyboard;
});
define('../bower_components/no-vnc/lib/input/mouse.js',['exports', '../util/logging.js', '../util/browser.js', '../util/events.js'], function (exports, _logging, _browser, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var WHEEL_STEP = 10; // Delta threshold for a mouse wheel step
    var WHEEL_STEP_TIMEOUT = 50; // ms
    var WHEEL_LINE_HEIGHT = 19;

    var Mouse = function () {
        function Mouse(target) {
            _classCallCheck(this, Mouse);

            this._target = target || document;

            this._doubleClickTimer = null;
            this._lastTouchPos = null;

            this._pos = null;
            this._wheelStepXTimer = null;
            this._wheelStepYTimer = null;
            this._accumulatedWheelDeltaX = 0;
            this._accumulatedWheelDeltaY = 0;

            this._eventHandlers = {
                'mousedown': this._handleMouseDown.bind(this),
                'mouseup': this._handleMouseUp.bind(this),
                'mousemove': this._handleMouseMove.bind(this),
                'mousewheel': this._handleMouseWheel.bind(this),
                'mousedisable': this._handleMouseDisable.bind(this)
            };

            // ===== PROPERTIES =====

            this.touchButton = 1; // Button mask (1, 2, 4) for touch devices (0 means ignore clicks)

            // ===== EVENT HANDLERS =====

            this.onmousebutton = function () {}; // Handler for mouse button click/release
            this.onmousemove = function () {}; // Handler for mouse movement
        }

        // ===== PRIVATE METHODS =====

        _createClass(Mouse, [{
            key: '_resetDoubleClickTimer',
            value: function _resetDoubleClickTimer() {
                this._doubleClickTimer = null;
            }
        }, {
            key: '_handleMouseButton',
            value: function _handleMouseButton(e, down) {
                this._updateMousePosition(e);
                var pos = this._pos;

                var bmask = void 0;
                if (e.touches || e.changedTouches) {
                    // Touch device

                    // When two touches occur within 500 ms of each other and are
                    // close enough together a double click is triggered.
                    if (down == 1) {
                        if (this._doubleClickTimer === null) {
                            this._lastTouchPos = pos;
                        } else {
                            clearTimeout(this._doubleClickTimer);

                            // When the distance between the two touches is small enough
                            // force the position of the latter touch to the position of
                            // the first.

                            var xs = this._lastTouchPos.x - pos.x;
                            var ys = this._lastTouchPos.y - pos.y;
                            var d = Math.sqrt(xs * xs + ys * ys);

                            // The goal is to trigger on a certain physical width, the
                            // devicePixelRatio brings us a bit closer but is not optimal.
                            var threshold = 20 * (window.devicePixelRatio || 1);
                            if (d < threshold) {
                                pos = this._lastTouchPos;
                            }
                        }
                        this._doubleClickTimer = setTimeout(this._resetDoubleClickTimer.bind(this), 500);
                    }
                    bmask = this.touchButton;
                    // If bmask is set
                } else if (e.which) {
                    /* everything except IE */
                    bmask = 1 << e.button;
                } else {
                    /* IE including 9 */
                    bmask = (e.button & 0x1) + // Left
                    (e.button & 0x2) * 2 + // Right
                    (e.button & 0x4) / 2; // Middle
                }

                Log.Debug("onmousebutton " + (down ? "down" : "up") + ", x: " + pos.x + ", y: " + pos.y + ", bmask: " + bmask);
                this.onmousebutton(pos.x, pos.y, down, bmask);

                (0, _events.stopEvent)(e);
            }
        }, {
            key: '_handleMouseDown',
            value: function _handleMouseDown(e) {
                // Touch events have implicit capture
                if (e.type === "mousedown") {
                    (0, _events.setCapture)(this._target);
                }

                this._handleMouseButton(e, 1);
            }
        }, {
            key: '_handleMouseUp',
            value: function _handleMouseUp(e) {
                this._handleMouseButton(e, 0);
            }
        }, {
            key: '_generateWheelStepX',
            value: function _generateWheelStepX() {

                if (this._accumulatedWheelDeltaX < 0) {
                    this.onmousebutton(this._pos.x, this._pos.y, 1, 1 << 5);
                    this.onmousebutton(this._pos.x, this._pos.y, 0, 1 << 5);
                } else if (this._accumulatedWheelDeltaX > 0) {
                    this.onmousebutton(this._pos.x, this._pos.y, 1, 1 << 6);
                    this.onmousebutton(this._pos.x, this._pos.y, 0, 1 << 6);
                }

                this._accumulatedWheelDeltaX = 0;
            }
        }, {
            key: '_generateWheelStepY',
            value: function _generateWheelStepY() {

                if (this._accumulatedWheelDeltaY < 0) {
                    this.onmousebutton(this._pos.x, this._pos.y, 1, 1 << 3);
                    this.onmousebutton(this._pos.x, this._pos.y, 0, 1 << 3);
                } else if (this._accumulatedWheelDeltaY > 0) {
                    this.onmousebutton(this._pos.x, this._pos.y, 1, 1 << 4);
                    this.onmousebutton(this._pos.x, this._pos.y, 0, 1 << 4);
                }

                this._accumulatedWheelDeltaY = 0;
            }
        }, {
            key: '_resetWheelStepTimers',
            value: function _resetWheelStepTimers() {
                window.clearTimeout(this._wheelStepXTimer);
                window.clearTimeout(this._wheelStepYTimer);
                this._wheelStepXTimer = null;
                this._wheelStepYTimer = null;
            }
        }, {
            key: '_handleMouseWheel',
            value: function _handleMouseWheel(e) {
                this._resetWheelStepTimers();

                this._updateMousePosition(e);

                var dX = e.deltaX;
                var dY = e.deltaY;

                // Pixel units unless it's non-zero.
                // Note that if deltamode is line or page won't matter since we aren't
                // sending the mouse wheel delta to the server anyway.
                // The difference between pixel and line can be important however since
                // we have a threshold that can be smaller than the line height.
                if (e.deltaMode !== 0) {
                    dX *= WHEEL_LINE_HEIGHT;
                    dY *= WHEEL_LINE_HEIGHT;
                }

                this._accumulatedWheelDeltaX += dX;
                this._accumulatedWheelDeltaY += dY;

                // Generate a mouse wheel step event when the accumulated delta
                // for one of the axes is large enough.
                // Small delta events that do not pass the threshold get sent
                // after a timeout.
                if (Math.abs(this._accumulatedWheelDeltaX) > WHEEL_STEP) {
                    this._generateWheelStepX();
                } else {
                    this._wheelStepXTimer = window.setTimeout(this._generateWheelStepX.bind(this), WHEEL_STEP_TIMEOUT);
                }
                if (Math.abs(this._accumulatedWheelDeltaY) > WHEEL_STEP) {
                    this._generateWheelStepY();
                } else {
                    this._wheelStepYTimer = window.setTimeout(this._generateWheelStepY.bind(this), WHEEL_STEP_TIMEOUT);
                }

                (0, _events.stopEvent)(e);
            }
        }, {
            key: '_handleMouseMove',
            value: function _handleMouseMove(e) {
                this._updateMousePosition(e);
                this.onmousemove(this._pos.x, this._pos.y);
                (0, _events.stopEvent)(e);
            }
        }, {
            key: '_handleMouseDisable',
            value: function _handleMouseDisable(e) {
                /*
                 * Stop propagation if inside canvas area
                 * Note: This is only needed for the 'click' event as it fails
                 *       to fire properly for the target element so we have
                 *       to listen on the document element instead.
                 */
                if (e.target == this._target) {
                    (0, _events.stopEvent)(e);
                }
            }
        }, {
            key: '_updateMousePosition',
            value: function _updateMousePosition(e) {
                e = (0, _events.getPointerEvent)(e);
                var bounds = this._target.getBoundingClientRect();
                var x = void 0;
                var y = void 0;
                // Clip to target bounds
                if (e.clientX < bounds.left) {
                    x = 0;
                } else if (e.clientX >= bounds.right) {
                    x = bounds.width - 1;
                } else {
                    x = e.clientX - bounds.left;
                }
                if (e.clientY < bounds.top) {
                    y = 0;
                } else if (e.clientY >= bounds.bottom) {
                    y = bounds.height - 1;
                } else {
                    y = e.clientY - bounds.top;
                }
                this._pos = { x: x, y: y };
            }
        }, {
            key: 'grab',
            value: function grab() {
                if (_browser.isTouchDevice) {
                    this._target.addEventListener('touchstart', this._eventHandlers.mousedown);
                    this._target.addEventListener('touchend', this._eventHandlers.mouseup);
                    this._target.addEventListener('touchmove', this._eventHandlers.mousemove);
                }
                this._target.addEventListener('mousedown', this._eventHandlers.mousedown);
                this._target.addEventListener('mouseup', this._eventHandlers.mouseup);
                this._target.addEventListener('mousemove', this._eventHandlers.mousemove);
                this._target.addEventListener('wheel', this._eventHandlers.mousewheel);

                /* Prevent middle-click pasting (see above for why we bind to document) */
                document.addEventListener('click', this._eventHandlers.mousedisable);

                /* preventDefault() on mousedown doesn't stop this event for some
                   reason so we have to explicitly block it */
                this._target.addEventListener('contextmenu', this._eventHandlers.mousedisable);
            }
        }, {
            key: 'ungrab',
            value: function ungrab() {
                this._resetWheelStepTimers();

                if (_browser.isTouchDevice) {
                    this._target.removeEventListener('touchstart', this._eventHandlers.mousedown);
                    this._target.removeEventListener('touchend', this._eventHandlers.mouseup);
                    this._target.removeEventListener('touchmove', this._eventHandlers.mousemove);
                }
                this._target.removeEventListener('mousedown', this._eventHandlers.mousedown);
                this._target.removeEventListener('mouseup', this._eventHandlers.mouseup);
                this._target.removeEventListener('mousemove', this._eventHandlers.mousemove);
                this._target.removeEventListener('wheel', this._eventHandlers.mousewheel);

                document.removeEventListener('click', this._eventHandlers.mousedisable);

                this._target.removeEventListener('contextmenu', this._eventHandlers.mousedisable);
            }
        }]);

        return Mouse;
    }();

    exports.default = Mouse;
});
define('../bower_components/no-vnc/lib/util/cursor.js',['exports', './browser.js'], function (exports, _browser) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var useFallback = !_browser.supportsCursorURIs || _browser.isTouchDevice;

    var Cursor = function () {
        function Cursor() {
            _classCallCheck(this, Cursor);

            this._target = null;

            this._canvas = document.createElement('canvas');

            if (useFallback) {
                this._canvas.style.position = 'fixed';
                this._canvas.style.zIndex = '65535';
                this._canvas.style.pointerEvents = 'none';
                // Can't use "display" because of Firefox bug #1445997
                this._canvas.style.visibility = 'hidden';
                document.body.appendChild(this._canvas);
            }

            this._position = { x: 0, y: 0 };
            this._hotSpot = { x: 0, y: 0 };

            this._eventHandlers = {
                'mouseover': this._handleMouseOver.bind(this),
                'mouseleave': this._handleMouseLeave.bind(this),
                'mousemove': this._handleMouseMove.bind(this),
                'mouseup': this._handleMouseUp.bind(this),
                'touchstart': this._handleTouchStart.bind(this),
                'touchmove': this._handleTouchMove.bind(this),
                'touchend': this._handleTouchEnd.bind(this)
            };
        }

        _createClass(Cursor, [{
            key: 'attach',
            value: function attach(target) {
                if (this._target) {
                    this.detach();
                }

                this._target = target;

                if (useFallback) {
                    // FIXME: These don't fire properly except for mouse
                    ///       movement in IE. We want to also capture element
                    //        movement, size changes, visibility, etc.
                    var options = { capture: true, passive: true };
                    this._target.addEventListener('mouseover', this._eventHandlers.mouseover, options);
                    this._target.addEventListener('mouseleave', this._eventHandlers.mouseleave, options);
                    this._target.addEventListener('mousemove', this._eventHandlers.mousemove, options);
                    this._target.addEventListener('mouseup', this._eventHandlers.mouseup, options);

                    // There is no "touchleave" so we monitor touchstart globally
                    window.addEventListener('touchstart', this._eventHandlers.touchstart, options);
                    this._target.addEventListener('touchmove', this._eventHandlers.touchmove, options);
                    this._target.addEventListener('touchend', this._eventHandlers.touchend, options);
                }

                this.clear();
            }
        }, {
            key: 'detach',
            value: function detach() {
                if (useFallback) {
                    var options = { capture: true, passive: true };
                    this._target.removeEventListener('mouseover', this._eventHandlers.mouseover, options);
                    this._target.removeEventListener('mouseleave', this._eventHandlers.mouseleave, options);
                    this._target.removeEventListener('mousemove', this._eventHandlers.mousemove, options);
                    this._target.removeEventListener('mouseup', this._eventHandlers.mouseup, options);

                    window.removeEventListener('touchstart', this._eventHandlers.touchstart, options);
                    this._target.removeEventListener('touchmove', this._eventHandlers.touchmove, options);
                    this._target.removeEventListener('touchend', this._eventHandlers.touchend, options);
                }

                this._target = null;
            }
        }, {
            key: 'change',
            value: function change(rgba, hotx, hoty, w, h) {
                if (w === 0 || h === 0) {
                    this.clear();
                    return;
                }

                this._position.x = this._position.x + this._hotSpot.x - hotx;
                this._position.y = this._position.y + this._hotSpot.y - hoty;
                this._hotSpot.x = hotx;
                this._hotSpot.y = hoty;

                var ctx = this._canvas.getContext('2d');

                this._canvas.width = w;
                this._canvas.height = h;

                var img = void 0;
                try {
                    // IE doesn't support this
                    img = new ImageData(new Uint8ClampedArray(rgba), w, h);
                } catch (ex) {
                    img = ctx.createImageData(w, h);
                    img.data.set(new Uint8ClampedArray(rgba));
                }
                ctx.clearRect(0, 0, w, h);
                ctx.putImageData(img, 0, 0);

                if (useFallback) {
                    this._updatePosition();
                } else {
                    var url = this._canvas.toDataURL();
                    this._target.style.cursor = 'url(' + url + ')' + hotx + ' ' + hoty + ', default';
                }
            }
        }, {
            key: 'clear',
            value: function clear() {
                this._target.style.cursor = 'none';
                this._canvas.width = 0;
                this._canvas.height = 0;
                this._position.x = this._position.x + this._hotSpot.x;
                this._position.y = this._position.y + this._hotSpot.y;
                this._hotSpot.x = 0;
                this._hotSpot.y = 0;
            }
        }, {
            key: '_handleMouseOver',
            value: function _handleMouseOver(event) {
                // This event could be because we're entering the target, or
                // moving around amongst its sub elements. Let the move handler
                // sort things out.
                this._handleMouseMove(event);
            }
        }, {
            key: '_handleMouseLeave',
            value: function _handleMouseLeave(event) {
                this._hideCursor();
            }
        }, {
            key: '_handleMouseMove',
            value: function _handleMouseMove(event) {
                this._updateVisibility(event.target);

                this._position.x = event.clientX - this._hotSpot.x;
                this._position.y = event.clientY - this._hotSpot.y;

                this._updatePosition();
            }
        }, {
            key: '_handleMouseUp',
            value: function _handleMouseUp(event) {
                // We might get this event because of a drag operation that
                // moved outside of the target. Check what's under the cursor
                // now and adjust visibility based on that.
                var target = document.elementFromPoint(event.clientX, event.clientY);
                this._updateVisibility(target);
            }
        }, {
            key: '_handleTouchStart',
            value: function _handleTouchStart(event) {
                // Just as for mouseover, we let the move handler deal with it
                this._handleTouchMove(event);
            }
        }, {
            key: '_handleTouchMove',
            value: function _handleTouchMove(event) {
                this._updateVisibility(event.target);

                this._position.x = event.changedTouches[0].clientX - this._hotSpot.x;
                this._position.y = event.changedTouches[0].clientY - this._hotSpot.y;

                this._updatePosition();
            }
        }, {
            key: '_handleTouchEnd',
            value: function _handleTouchEnd(event) {
                // Same principle as for mouseup
                var target = document.elementFromPoint(event.changedTouches[0].clientX, event.changedTouches[0].clientY);
                this._updateVisibility(target);
            }
        }, {
            key: '_showCursor',
            value: function _showCursor() {
                if (this._canvas.style.visibility === 'hidden') {
                    this._canvas.style.visibility = '';
                }
            }
        }, {
            key: '_hideCursor',
            value: function _hideCursor() {
                if (this._canvas.style.visibility !== 'hidden') {
                    this._canvas.style.visibility = 'hidden';
                }
            }
        }, {
            key: '_shouldShowCursor',
            value: function _shouldShowCursor(target) {
                // Easy case
                if (target === this._target) {
                    return true;
                }
                // Other part of the DOM?
                if (!this._target.contains(target)) {
                    return false;
                }
                // Has the child its own cursor?
                // FIXME: How can we tell that a sub element has an
                //        explicit "cursor: none;"?
                if (window.getComputedStyle(target).cursor !== 'none') {
                    return false;
                }
                return true;
            }
        }, {
            key: '_updateVisibility',
            value: function _updateVisibility(target) {
                if (this._shouldShowCursor(target)) {
                    this._showCursor();
                } else {
                    this._hideCursor();
                }
            }
        }, {
            key: '_updatePosition',
            value: function _updatePosition() {
                this._canvas.style.left = this._position.x + "px";
                this._canvas.style.top = this._position.y + "px";
            }
        }]);

        return Cursor;
    }();

    exports.default = Cursor;
});
define('../bower_components/no-vnc/lib/websock.js',['exports', './util/logging.js'], function (exports, _logging) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    // this has performance issues in some versions Chromium, and
    // doesn't gain a tremendous amount of performance increase in Firefox
    // at the moment.  It may be valuable to turn it on in the future.
    var ENABLE_COPYWITHIN = false;
    var MAX_RQ_GROW_SIZE = 40 * 1024 * 1024; // 40 MiB

    var Websock = function () {
        function Websock() {
            _classCallCheck(this, Websock);

            this._websocket = null; // WebSocket object

            this._rQi = 0; // Receive queue index
            this._rQlen = 0; // Next write position in the receive queue
            this._rQbufferSize = 1024 * 1024 * 4; // Receive queue buffer size (4 MiB)
            this._rQmax = this._rQbufferSize / 8;
            // called in init: this._rQ = new Uint8Array(this._rQbufferSize);
            this._rQ = null; // Receive queue

            this._sQbufferSize = 1024 * 10; // 10 KiB
            // called in init: this._sQ = new Uint8Array(this._sQbufferSize);
            this._sQlen = 0;
            this._sQ = null; // Send queue

            this._eventHandlers = {
                message: function message() {},
                open: function open() {},
                close: function close() {},
                error: function error() {}
            };
        }

        // Getters and Setters


        _createClass(Websock, [{
            key: 'rQpeek8',
            value: function rQpeek8() {
                return this._rQ[this._rQi];
            }
        }, {
            key: 'rQskipBytes',
            value: function rQskipBytes(bytes) {
                this._rQi += bytes;
            }
        }, {
            key: 'rQshift8',
            value: function rQshift8() {
                return this._rQshift(1);
            }
        }, {
            key: 'rQshift16',
            value: function rQshift16() {
                return this._rQshift(2);
            }
        }, {
            key: 'rQshift32',
            value: function rQshift32() {
                return this._rQshift(4);
            }
        }, {
            key: '_rQshift',
            value: function _rQshift(bytes) {
                var res = 0;
                for (var byte = bytes - 1; byte >= 0; byte--) {
                    res += this._rQ[this._rQi++] << byte * 8;
                }
                return res;
            }
        }, {
            key: 'rQshiftStr',
            value: function rQshiftStr(len) {
                if (typeof len === 'undefined') {
                    len = this.rQlen;
                }
                var str = "";
                // Handle large arrays in steps to avoid long strings on the stack
                for (var i = 0; i < len; i += 4096) {
                    var part = this.rQshiftBytes(Math.min(4096, len - i));
                    str += String.fromCharCode.apply(null, part);
                }
                return str;
            }
        }, {
            key: 'rQshiftBytes',
            value: function rQshiftBytes(len) {
                if (typeof len === 'undefined') {
                    len = this.rQlen;
                }
                this._rQi += len;
                return new Uint8Array(this._rQ.buffer, this._rQi - len, len);
            }
        }, {
            key: 'rQshiftTo',
            value: function rQshiftTo(target, len) {
                if (len === undefined) {
                    len = this.rQlen;
                }
                // TODO: make this just use set with views when using a ArrayBuffer to store the rQ
                target.set(new Uint8Array(this._rQ.buffer, this._rQi, len));
                this._rQi += len;
            }
        }, {
            key: 'rQslice',
            value: function rQslice(start) {
                var end = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.rQlen;

                return new Uint8Array(this._rQ.buffer, this._rQi + start, end - start);
            }
        }, {
            key: 'rQwait',
            value: function rQwait(msg, num, goback) {
                if (this.rQlen < num) {
                    if (goback) {
                        if (this._rQi < goback) {
                            throw new Error("rQwait cannot backup " + goback + " bytes");
                        }
                        this._rQi -= goback;
                    }
                    return true; // true means need more data
                }
                return false;
            }
        }, {
            key: 'flush',
            value: function flush() {
                if (this._sQlen > 0 && this._websocket.readyState === WebSocket.OPEN) {
                    this._websocket.send(this._encode_message());
                    this._sQlen = 0;
                }
            }
        }, {
            key: 'send',
            value: function send(arr) {
                this._sQ.set(arr, this._sQlen);
                this._sQlen += arr.length;
                this.flush();
            }
        }, {
            key: 'send_string',
            value: function send_string(str) {
                this.send(str.split('').map(function (chr) {
                    return chr.charCodeAt(0);
                }));
            }
        }, {
            key: 'off',
            value: function off(evt) {
                this._eventHandlers[evt] = function () {};
            }
        }, {
            key: 'on',
            value: function on(evt, handler) {
                this._eventHandlers[evt] = handler;
            }
        }, {
            key: '_allocate_buffers',
            value: function _allocate_buffers() {
                this._rQ = new Uint8Array(this._rQbufferSize);
                this._sQ = new Uint8Array(this._sQbufferSize);
            }
        }, {
            key: 'init',
            value: function init() {
                this._allocate_buffers();
                this._rQi = 0;
                this._websocket = null;
            }
        }, {
            key: 'open',
            value: function open(uri, protocols) {
                var _this = this;

                this.init();

                this._websocket = new WebSocket(uri, protocols);
                this._websocket.binaryType = 'arraybuffer';

                this._websocket.onmessage = this._recv_message.bind(this);
                this._websocket.onopen = function () {
                    Log.Debug('>> WebSock.onopen');
                    if (_this._websocket.protocol) {
                        Log.Info("Server choose sub-protocol: " + _this._websocket.protocol);
                    }

                    _this._eventHandlers.open();
                    Log.Debug("<< WebSock.onopen");
                };
                this._websocket.onclose = function (e) {
                    Log.Debug(">> WebSock.onclose");
                    _this._eventHandlers.close(e);
                    Log.Debug("<< WebSock.onclose");
                };
                this._websocket.onerror = function (e) {
                    Log.Debug(">> WebSock.onerror: " + e);
                    _this._eventHandlers.error(e);
                    Log.Debug("<< WebSock.onerror: " + e);
                };
            }
        }, {
            key: 'close',
            value: function close() {
                if (this._websocket) {
                    if (this._websocket.readyState === WebSocket.OPEN || this._websocket.readyState === WebSocket.CONNECTING) {
                        Log.Info("Closing WebSocket connection");
                        this._websocket.close();
                    }

                    this._websocket.onmessage = function () {};
                }
            }
        }, {
            key: '_encode_message',
            value: function _encode_message() {
                // Put in a binary arraybuffer
                // according to the spec, you can send ArrayBufferViews with the send method
                return new Uint8Array(this._sQ.buffer, 0, this._sQlen);
            }
        }, {
            key: '_expand_compact_rQ',
            value: function _expand_compact_rQ(min_fit) {
                var resizeNeeded = min_fit || this.rQlen > this._rQbufferSize / 2;
                if (resizeNeeded) {
                    if (!min_fit) {
                        // just double the size if we need to do compaction
                        this._rQbufferSize *= 2;
                    } else {
                        // otherwise, make sure we satisy rQlen - rQi + min_fit < rQbufferSize / 8
                        this._rQbufferSize = (this.rQlen + min_fit) * 8;
                    }
                }

                // we don't want to grow unboundedly
                if (this._rQbufferSize > MAX_RQ_GROW_SIZE) {
                    this._rQbufferSize = MAX_RQ_GROW_SIZE;
                    if (this._rQbufferSize - this.rQlen < min_fit) {
                        throw new Error("Receive Queue buffer exceeded " + MAX_RQ_GROW_SIZE + " bytes, and the new message could not fit");
                    }
                }

                if (resizeNeeded) {
                    var old_rQbuffer = this._rQ.buffer;
                    this._rQmax = this._rQbufferSize / 8;
                    this._rQ = new Uint8Array(this._rQbufferSize);
                    this._rQ.set(new Uint8Array(old_rQbuffer, this._rQi));
                } else {
                    if (ENABLE_COPYWITHIN) {
                        this._rQ.copyWithin(0, this._rQi);
                    } else {
                        this._rQ.set(new Uint8Array(this._rQ.buffer, this._rQi));
                    }
                }

                this._rQlen = this._rQlen - this._rQi;
                this._rQi = 0;
            }
        }, {
            key: '_decode_message',
            value: function _decode_message(data) {
                // push arraybuffer values onto the end
                var u8 = new Uint8Array(data);
                if (u8.length > this._rQbufferSize - this._rQlen) {
                    this._expand_compact_rQ(u8.length);
                }
                this._rQ.set(u8, this._rQlen);
                this._rQlen += u8.length;
            }
        }, {
            key: '_recv_message',
            value: function _recv_message(e) {
                this._decode_message(e.data);
                if (this.rQlen > 0) {
                    this._eventHandlers.message();
                    // Compact the receive queue
                    if (this._rQlen == this._rQi) {
                        this._rQlen = 0;
                        this._rQi = 0;
                    } else if (this._rQlen > this._rQmax) {
                        this._expand_compact_rQ();
                    }
                } else {
                    Log.Debug("Ignoring empty message");
                }
            }
        }, {
            key: 'sQ',
            get: function get() {
                return this._sQ;
            }
        }, {
            key: 'rQ',
            get: function get() {
                return this._rQ;
            }
        }, {
            key: 'rQi',
            get: function get() {
                return this._rQi;
            },
            set: function set(val) {
                this._rQi = val;
            }
        }, {
            key: 'rQlen',
            get: function get() {
                return this._rQlen - this._rQi;
            }
        }]);

        return Websock;
    }();

    exports.default = Websock;
});
define('../bower_components/no-vnc/lib/des.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    /*
     * Ported from Flashlight VNC ActionScript implementation:
     *     http://www.wizhelp.com/flashlight-vnc/
     *
     * Full attribution follows:
     *
     * -------------------------------------------------------------------------
     *
     * This DES class has been extracted from package Acme.Crypto for use in VNC.
     * The unnecessary odd parity code has been removed.
     *
     * These changes are:
     *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
     *
     * This software is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
     *
    
     * DesCipher - the DES encryption method
     *
     * The meat of this code is by Dave Zimmerman <dzimm@widget.com>, and is:
     *
     * Copyright (c) 1996 Widget Workshop, Inc. All Rights Reserved.
     *
     * Permission to use, copy, modify, and distribute this software
     * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
     * without fee is hereby granted, provided that this copyright notice is kept
     * intact.
     *
     * WIDGET WORKSHOP MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
     * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
     * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
     * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. WIDGET WORKSHOP SHALL NOT BE LIABLE
     * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
     * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
     *
     * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
     * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
     * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
     * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
     * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
     * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
     * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  WIDGET WORKSHOP
     * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
     * HIGH RISK ACTIVITIES.
     *
     *
     * The rest is:
     *
     * Copyright (C) 1996 by Jef Poskanzer <jef@acme.com>.  All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions
     * are met:
     * 1. Redistributions of source code must retain the above copyright
     *    notice, this list of conditions and the following disclaimer.
     * 2. Redistributions in binary form must reproduce the above copyright
     *    notice, this list of conditions and the following disclaimer in the
     *    documentation and/or other materials provided with the distribution.
     *
     * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
     * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
     * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
     * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
     * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
     * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
     * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
     * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
     * SUCH DAMAGE.
     *
     * Visit the ACME Labs Java page for up-to-date versions of this and other
     * fine Java utilities: http://www.acme.com/java/
     */

    /* eslint-disable comma-spacing */

    // Tables, permutations, S-boxes, etc.
    var PC2 = [13, 16, 10, 23, 0, 4, 2, 27, 14, 5, 20, 9, 22, 18, 11, 3, 25, 7, 15, 6, 26, 19, 12, 1, 40, 51, 30, 36, 46, 54, 29, 39, 50, 44, 32, 47, 43, 48, 38, 55, 33, 52, 45, 41, 49, 35, 28, 31],
        totrot = [1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28];

    var z = 0x0;
    var a = void 0,
        b = void 0,
        c = void 0,
        d = void 0,
        e = void 0,
        f = void 0;
    a = 1 << 16;b = 1 << 24;c = a | b;d = 1 << 2;e = 1 << 10;f = d | e;
    var SP1 = [c | e, z | z, a | z, c | f, c | d, a | f, z | d, a | z, z | e, c | e, c | f, z | e, b | f, c | d, b | z, z | d, z | f, b | e, b | e, a | e, a | e, c | z, c | z, b | f, a | d, b | d, b | d, a | d, z | z, z | f, a | f, b | z, a | z, c | f, z | d, c | z, c | e, b | z, b | z, z | e, c | d, a | z, a | e, b | d, z | e, z | d, b | f, a | f, c | f, a | d, c | z, b | f, b | d, z | f, a | f, c | e, z | f, b | e, b | e, z | z, a | d, a | e, z | z, c | d];
    a = 1 << 20;b = 1 << 31;c = a | b;d = 1 << 5;e = 1 << 15;f = d | e;
    var SP2 = [c | f, b | e, z | e, a | f, a | z, z | d, c | d, b | f, b | d, c | f, c | e, b | z, b | e, a | z, z | d, c | d, a | e, a | d, b | f, z | z, b | z, z | e, a | f, c | z, a | d, b | d, z | z, a | e, z | f, c | e, c | z, z | f, z | z, a | f, c | d, a | z, b | f, c | z, c | e, z | e, c | z, b | e, z | d, c | f, a | f, z | d, z | e, b | z, z | f, c | e, a | z, b | d, a | d, b | f, b | d, a | d, a | e, z | z, b | e, z | f, b | z, c | d, c | f, a | e];
    a = 1 << 17;b = 1 << 27;c = a | b;d = 1 << 3;e = 1 << 9;f = d | e;
    var SP3 = [z | f, c | e, z | z, c | d, b | e, z | z, a | f, b | e, a | d, b | d, b | d, a | z, c | f, a | d, c | z, z | f, b | z, z | d, c | e, z | e, a | e, c | z, c | d, a | f, b | f, a | e, a | z, b | f, z | d, c | f, z | e, b | z, c | e, b | z, a | d, z | f, a | z, c | e, b | e, z | z, z | e, a | d, c | f, b | e, b | d, z | e, z | z, c | d, b | f, a | z, b | z, c | f, z | d, a | f, a | e, b | d, c | z, b | f, z | f, c | z, a | f, z | d, c | d, a | e];
    a = 1 << 13;b = 1 << 23;c = a | b;d = 1 << 0;e = 1 << 7;f = d | e;
    var SP4 = [c | d, a | f, a | f, z | e, c | e, b | f, b | d, a | d, z | z, c | z, c | z, c | f, z | f, z | z, b | e, b | d, z | d, a | z, b | z, c | d, z | e, b | z, a | d, a | e, b | f, z | d, a | e, b | e, a | z, c | e, c | f, z | f, b | e, b | d, c | z, c | f, z | f, z | z, z | z, c | z, a | e, b | e, b | f, z | d, c | d, a | f, a | f, z | e, c | f, z | f, z | d, a | z, b | d, a | d, c | e, b | f, a | d, a | e, b | z, c | d, z | e, b | z, a | z, c | e];
    a = 1 << 25;b = 1 << 30;c = a | b;d = 1 << 8;e = 1 << 19;f = d | e;
    var SP5 = [z | d, a | f, a | e, c | d, z | e, z | d, b | z, a | e, b | f, z | e, a | d, b | f, c | d, c | e, z | f, b | z, a | z, b | e, b | e, z | z, b | d, c | f, c | f, a | d, c | e, b | d, z | z, c | z, a | f, a | z, c | z, z | f, z | e, c | d, z | d, a | z, b | z, a | e, c | d, b | f, a | d, b | z, c | e, a | f, b | f, z | d, a | z, c | e, c | f, z | f, c | z, c | f, a | e, z | z, b | e, c | z, z | f, a | d, b | d, z | e, z | z, b | e, a | f, b | d];
    a = 1 << 22;b = 1 << 29;c = a | b;d = 1 << 4;e = 1 << 14;f = d | e;
    var SP6 = [b | d, c | z, z | e, c | f, c | z, z | d, c | f, a | z, b | e, a | f, a | z, b | d, a | d, b | e, b | z, z | f, z | z, a | d, b | f, z | e, a | e, b | f, z | d, c | d, c | d, z | z, a | f, c | e, z | f, a | e, c | e, b | z, b | e, z | d, c | d, a | e, c | f, a | z, z | f, b | d, a | z, b | e, b | z, z | f, b | d, c | f, a | e, c | z, a | f, c | e, z | z, c | d, z | d, z | e, c | z, a | f, z | e, a | d, b | f, z | z, c | e, b | z, a | d, b | f];
    a = 1 << 21;b = 1 << 26;c = a | b;d = 1 << 1;e = 1 << 11;f = d | e;
    var SP7 = [a | z, c | d, b | f, z | z, z | e, b | f, a | f, c | e, c | f, a | z, z | z, b | d, z | d, b | z, c | d, z | f, b | e, a | f, a | d, b | e, b | d, c | z, c | e, a | d, c | z, z | e, z | f, c | f, a | e, z | d, b | z, a | e, b | z, a | e, a | z, b | f, b | f, c | d, c | d, z | d, a | d, b | z, b | e, a | z, c | e, z | f, a | f, c | e, z | f, b | d, c | f, c | z, a | e, z | z, z | d, c | f, z | z, a | f, c | z, z | e, b | d, b | e, z | e, a | d];
    a = 1 << 18;b = 1 << 28;c = a | b;d = 1 << 6;e = 1 << 12;f = d | e;
    var SP8 = [b | f, z | e, a | z, c | f, b | z, b | f, z | d, b | z, a | d, c | z, c | f, a | e, c | e, a | f, z | e, z | d, c | z, b | d, b | e, z | f, a | e, a | d, c | d, c | e, z | f, z | z, z | z, c | d, b | d, b | e, a | f, a | z, a | f, a | z, c | e, z | e, z | d, c | d, z | e, a | f, b | e, z | d, b | d, c | z, c | d, b | z, a | z, b | f, z | z, c | f, a | d, b | d, c | z, b | e, b | f, z | z, c | f, a | e, a | e, z | f, z | f, a | d, b | z, c | e];

    /* eslint-enable comma-spacing */

    var DES = function () {
        function DES(password) {
            _classCallCheck(this, DES);

            this.keys = [];

            // Set the key.
            var pc1m = [],
                pcr = [],
                kn = [];

            for (var j = 0, l = 56; j < 56; ++j, l -= 8) {
                l += l < -5 ? 65 : l < -3 ? 31 : l < -1 ? 63 : l === 27 ? 35 : 0; // PC1
                var m = l & 0x7;
                pc1m[j] = (password[l >>> 3] & 1 << m) !== 0 ? 1 : 0;
            }

            for (var i = 0; i < 16; ++i) {
                var _m = i << 1;
                var n = _m + 1;
                kn[_m] = kn[n] = 0;
                for (var o = 28; o < 59; o += 28) {
                    for (var _j = o - 28; _j < o; ++_j) {
                        var _l = _j + totrot[i];
                        pcr[_j] = _l < o ? pc1m[_l] : pc1m[_l - 28];
                    }
                }
                for (var _j2 = 0; _j2 < 24; ++_j2) {
                    if (pcr[PC2[_j2]] !== 0) {
                        kn[_m] |= 1 << 23 - _j2;
                    }
                    if (pcr[PC2[_j2 + 24]] !== 0) {
                        kn[n] |= 1 << 23 - _j2;
                    }
                }
            }

            // cookey
            for (var _i = 0, rawi = 0, KnLi = 0; _i < 16; ++_i) {
                var raw0 = kn[rawi++];
                var raw1 = kn[rawi++];
                this.keys[KnLi] = (raw0 & 0x00fc0000) << 6;
                this.keys[KnLi] |= (raw0 & 0x00000fc0) << 10;
                this.keys[KnLi] |= (raw1 & 0x00fc0000) >>> 10;
                this.keys[KnLi] |= (raw1 & 0x00000fc0) >>> 6;
                ++KnLi;
                this.keys[KnLi] = (raw0 & 0x0003f000) << 12;
                this.keys[KnLi] |= (raw0 & 0x0000003f) << 16;
                this.keys[KnLi] |= (raw1 & 0x0003f000) >>> 4;
                this.keys[KnLi] |= raw1 & 0x0000003f;
                ++KnLi;
            }
        }

        // Encrypt 8 bytes of text


        _createClass(DES, [{
            key: "enc8",
            value: function enc8(text) {
                var b = text.slice();
                var i = 0,
                    l = void 0,
                    r = void 0,
                    x = void 0; // left, right, accumulator

                // Squash 8 bytes to 2 ints
                l = b[i++] << 24 | b[i++] << 16 | b[i++] << 8 | b[i++];
                r = b[i++] << 24 | b[i++] << 16 | b[i++] << 8 | b[i++];

                x = (l >>> 4 ^ r) & 0x0f0f0f0f;
                r ^= x;
                l ^= x << 4;
                x = (l >>> 16 ^ r) & 0x0000ffff;
                r ^= x;
                l ^= x << 16;
                x = (r >>> 2 ^ l) & 0x33333333;
                l ^= x;
                r ^= x << 2;
                x = (r >>> 8 ^ l) & 0x00ff00ff;
                l ^= x;
                r ^= x << 8;
                r = r << 1 | r >>> 31 & 1;
                x = (l ^ r) & 0xaaaaaaaa;
                l ^= x;
                r ^= x;
                l = l << 1 | l >>> 31 & 1;

                for (var _i2 = 0, keysi = 0; _i2 < 8; ++_i2) {
                    x = r << 28 | r >>> 4;
                    x ^= this.keys[keysi++];
                    var fval = SP7[x & 0x3f];
                    fval |= SP5[x >>> 8 & 0x3f];
                    fval |= SP3[x >>> 16 & 0x3f];
                    fval |= SP1[x >>> 24 & 0x3f];
                    x = r ^ this.keys[keysi++];
                    fval |= SP8[x & 0x3f];
                    fval |= SP6[x >>> 8 & 0x3f];
                    fval |= SP4[x >>> 16 & 0x3f];
                    fval |= SP2[x >>> 24 & 0x3f];
                    l ^= fval;
                    x = l << 28 | l >>> 4;
                    x ^= this.keys[keysi++];
                    fval = SP7[x & 0x3f];
                    fval |= SP5[x >>> 8 & 0x3f];
                    fval |= SP3[x >>> 16 & 0x3f];
                    fval |= SP1[x >>> 24 & 0x3f];
                    x = l ^ this.keys[keysi++];
                    fval |= SP8[x & 0x0000003f];
                    fval |= SP6[x >>> 8 & 0x3f];
                    fval |= SP4[x >>> 16 & 0x3f];
                    fval |= SP2[x >>> 24 & 0x3f];
                    r ^= fval;
                }

                r = r << 31 | r >>> 1;
                x = (l ^ r) & 0xaaaaaaaa;
                l ^= x;
                r ^= x;
                l = l << 31 | l >>> 1;
                x = (l >>> 8 ^ r) & 0x00ff00ff;
                r ^= x;
                l ^= x << 8;
                x = (l >>> 2 ^ r) & 0x33333333;
                r ^= x;
                l ^= x << 2;
                x = (r >>> 16 ^ l) & 0x0000ffff;
                l ^= x;
                r ^= x << 16;
                x = (r >>> 4 ^ l) & 0x0f0f0f0f;
                l ^= x;
                r ^= x << 4;

                // Spread ints to bytes
                x = [r, l];
                for (i = 0; i < 8; i++) {
                    b[i] = (x[i >>> 2] >>> 8 * (3 - i % 4)) % 256;
                    if (b[i] < 0) {
                        b[i] += 256;
                    } // unsigned
                }
                return b;
            }
        }, {
            key: "encrypt",
            value: function encrypt(t) {
                return this.enc8(t.slice(0, 8)).concat(this.enc8(t.slice(8, 16)));
            }
        }]);

        return DES;
    }();

    exports.default = DES;
});
define('../bower_components/no-vnc/lib/input/xtscancodes.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = {
    "Again": 0xe005, /* html:Again (Again) -> linux:129 (KEY_AGAIN) -> atset1:57349 */
    "AltLeft": 0x38, /* html:AltLeft (AltLeft) -> linux:56 (KEY_LEFTALT) -> atset1:56 */
    "AltRight": 0xe038, /* html:AltRight (AltRight) -> linux:100 (KEY_RIGHTALT) -> atset1:57400 */
    "ArrowDown": 0xe050, /* html:ArrowDown (ArrowDown) -> linux:108 (KEY_DOWN) -> atset1:57424 */
    "ArrowLeft": 0xe04b, /* html:ArrowLeft (ArrowLeft) -> linux:105 (KEY_LEFT) -> atset1:57419 */
    "ArrowRight": 0xe04d, /* html:ArrowRight (ArrowRight) -> linux:106 (KEY_RIGHT) -> atset1:57421 */
    "ArrowUp": 0xe048, /* html:ArrowUp (ArrowUp) -> linux:103 (KEY_UP) -> atset1:57416 */
    "AudioVolumeDown": 0xe02e, /* html:AudioVolumeDown (AudioVolumeDown) -> linux:114 (KEY_VOLUMEDOWN) -> atset1:57390 */
    "AudioVolumeMute": 0xe020, /* html:AudioVolumeMute (AudioVolumeMute) -> linux:113 (KEY_MUTE) -> atset1:57376 */
    "AudioVolumeUp": 0xe030, /* html:AudioVolumeUp (AudioVolumeUp) -> linux:115 (KEY_VOLUMEUP) -> atset1:57392 */
    "Backquote": 0x29, /* html:Backquote (Backquote) -> linux:41 (KEY_GRAVE) -> atset1:41 */
    "Backslash": 0x2b, /* html:Backslash (Backslash) -> linux:43 (KEY_BACKSLASH) -> atset1:43 */
    "Backspace": 0xe, /* html:Backspace (Backspace) -> linux:14 (KEY_BACKSPACE) -> atset1:14 */
    "BracketLeft": 0x1a, /* html:BracketLeft (BracketLeft) -> linux:26 (KEY_LEFTBRACE) -> atset1:26 */
    "BracketRight": 0x1b, /* html:BracketRight (BracketRight) -> linux:27 (KEY_RIGHTBRACE) -> atset1:27 */
    "BrowserBack": 0xe06a, /* html:BrowserBack (BrowserBack) -> linux:158 (KEY_BACK) -> atset1:57450 */
    "BrowserFavorites": 0xe066, /* html:BrowserFavorites (BrowserFavorites) -> linux:156 (KEY_BOOKMARKS) -> atset1:57446 */
    "BrowserForward": 0xe069, /* html:BrowserForward (BrowserForward) -> linux:159 (KEY_FORWARD) -> atset1:57449 */
    "BrowserHome": 0xe032, /* html:BrowserHome (BrowserHome) -> linux:172 (KEY_HOMEPAGE) -> atset1:57394 */
    "BrowserRefresh": 0xe067, /* html:BrowserRefresh (BrowserRefresh) -> linux:173 (KEY_REFRESH) -> atset1:57447 */
    "BrowserSearch": 0xe065, /* html:BrowserSearch (BrowserSearch) -> linux:217 (KEY_SEARCH) -> atset1:57445 */
    "BrowserStop": 0xe068, /* html:BrowserStop (BrowserStop) -> linux:128 (KEY_STOP) -> atset1:57448 */
    "CapsLock": 0x3a, /* html:CapsLock (CapsLock) -> linux:58 (KEY_CAPSLOCK) -> atset1:58 */
    "Comma": 0x33, /* html:Comma (Comma) -> linux:51 (KEY_COMMA) -> atset1:51 */
    "ContextMenu": 0xe05d, /* html:ContextMenu (ContextMenu) -> linux:127 (KEY_COMPOSE) -> atset1:57437 */
    "ControlLeft": 0x1d, /* html:ControlLeft (ControlLeft) -> linux:29 (KEY_LEFTCTRL) -> atset1:29 */
    "ControlRight": 0xe01d, /* html:ControlRight (ControlRight) -> linux:97 (KEY_RIGHTCTRL) -> atset1:57373 */
    "Convert": 0x79, /* html:Convert (Convert) -> linux:92 (KEY_HENKAN) -> atset1:121 */
    "Copy": 0xe078, /* html:Copy (Copy) -> linux:133 (KEY_COPY) -> atset1:57464 */
    "Cut": 0xe03c, /* html:Cut (Cut) -> linux:137 (KEY_CUT) -> atset1:57404 */
    "Delete": 0xe053, /* html:Delete (Delete) -> linux:111 (KEY_DELETE) -> atset1:57427 */
    "Digit0": 0xb, /* html:Digit0 (Digit0) -> linux:11 (KEY_0) -> atset1:11 */
    "Digit1": 0x2, /* html:Digit1 (Digit1) -> linux:2 (KEY_1) -> atset1:2 */
    "Digit2": 0x3, /* html:Digit2 (Digit2) -> linux:3 (KEY_2) -> atset1:3 */
    "Digit3": 0x4, /* html:Digit3 (Digit3) -> linux:4 (KEY_3) -> atset1:4 */
    "Digit4": 0x5, /* html:Digit4 (Digit4) -> linux:5 (KEY_4) -> atset1:5 */
    "Digit5": 0x6, /* html:Digit5 (Digit5) -> linux:6 (KEY_5) -> atset1:6 */
    "Digit6": 0x7, /* html:Digit6 (Digit6) -> linux:7 (KEY_6) -> atset1:7 */
    "Digit7": 0x8, /* html:Digit7 (Digit7) -> linux:8 (KEY_7) -> atset1:8 */
    "Digit8": 0x9, /* html:Digit8 (Digit8) -> linux:9 (KEY_8) -> atset1:9 */
    "Digit9": 0xa, /* html:Digit9 (Digit9) -> linux:10 (KEY_9) -> atset1:10 */
    "Eject": 0xe07d, /* html:Eject (Eject) -> linux:162 (KEY_EJECTCLOSECD) -> atset1:57469 */
    "End": 0xe04f, /* html:End (End) -> linux:107 (KEY_END) -> atset1:57423 */
    "Enter": 0x1c, /* html:Enter (Enter) -> linux:28 (KEY_ENTER) -> atset1:28 */
    "Equal": 0xd, /* html:Equal (Equal) -> linux:13 (KEY_EQUAL) -> atset1:13 */
    "Escape": 0x1, /* html:Escape (Escape) -> linux:1 (KEY_ESC) -> atset1:1 */
    "F1": 0x3b, /* html:F1 (F1) -> linux:59 (KEY_F1) -> atset1:59 */
    "F10": 0x44, /* html:F10 (F10) -> linux:68 (KEY_F10) -> atset1:68 */
    "F11": 0x57, /* html:F11 (F11) -> linux:87 (KEY_F11) -> atset1:87 */
    "F12": 0x58, /* html:F12 (F12) -> linux:88 (KEY_F12) -> atset1:88 */
    "F13": 0x5d, /* html:F13 (F13) -> linux:183 (KEY_F13) -> atset1:93 */
    "F14": 0x5e, /* html:F14 (F14) -> linux:184 (KEY_F14) -> atset1:94 */
    "F15": 0x5f, /* html:F15 (F15) -> linux:185 (KEY_F15) -> atset1:95 */
    "F16": 0x55, /* html:F16 (F16) -> linux:186 (KEY_F16) -> atset1:85 */
    "F17": 0xe003, /* html:F17 (F17) -> linux:187 (KEY_F17) -> atset1:57347 */
    "F18": 0xe077, /* html:F18 (F18) -> linux:188 (KEY_F18) -> atset1:57463 */
    "F19": 0xe004, /* html:F19 (F19) -> linux:189 (KEY_F19) -> atset1:57348 */
    "F2": 0x3c, /* html:F2 (F2) -> linux:60 (KEY_F2) -> atset1:60 */
    "F20": 0x5a, /* html:F20 (F20) -> linux:190 (KEY_F20) -> atset1:90 */
    "F21": 0x74, /* html:F21 (F21) -> linux:191 (KEY_F21) -> atset1:116 */
    "F22": 0xe079, /* html:F22 (F22) -> linux:192 (KEY_F22) -> atset1:57465 */
    "F23": 0x6d, /* html:F23 (F23) -> linux:193 (KEY_F23) -> atset1:109 */
    "F24": 0x6f, /* html:F24 (F24) -> linux:194 (KEY_F24) -> atset1:111 */
    "F3": 0x3d, /* html:F3 (F3) -> linux:61 (KEY_F3) -> atset1:61 */
    "F4": 0x3e, /* html:F4 (F4) -> linux:62 (KEY_F4) -> atset1:62 */
    "F5": 0x3f, /* html:F5 (F5) -> linux:63 (KEY_F5) -> atset1:63 */
    "F6": 0x40, /* html:F6 (F6) -> linux:64 (KEY_F6) -> atset1:64 */
    "F7": 0x41, /* html:F7 (F7) -> linux:65 (KEY_F7) -> atset1:65 */
    "F8": 0x42, /* html:F8 (F8) -> linux:66 (KEY_F8) -> atset1:66 */
    "F9": 0x43, /* html:F9 (F9) -> linux:67 (KEY_F9) -> atset1:67 */
    "Find": 0xe041, /* html:Find (Find) -> linux:136 (KEY_FIND) -> atset1:57409 */
    "Help": 0xe075, /* html:Help (Help) -> linux:138 (KEY_HELP) -> atset1:57461 */
    "Hiragana": 0x77, /* html:Hiragana (Lang4) -> linux:91 (KEY_HIRAGANA) -> atset1:119 */
    "Home": 0xe047, /* html:Home (Home) -> linux:102 (KEY_HOME) -> atset1:57415 */
    "Insert": 0xe052, /* html:Insert (Insert) -> linux:110 (KEY_INSERT) -> atset1:57426 */
    "IntlBackslash": 0x56, /* html:IntlBackslash (IntlBackslash) -> linux:86 (KEY_102ND) -> atset1:86 */
    "IntlRo": 0x73, /* html:IntlRo (IntlRo) -> linux:89 (KEY_RO) -> atset1:115 */
    "IntlYen": 0x7d, /* html:IntlYen (IntlYen) -> linux:124 (KEY_YEN) -> atset1:125 */
    "KanaMode": 0x70, /* html:KanaMode (KanaMode) -> linux:93 (KEY_KATAKANAHIRAGANA) -> atset1:112 */
    "Katakana": 0x78, /* html:Katakana (Lang3) -> linux:90 (KEY_KATAKANA) -> atset1:120 */
    "KeyA": 0x1e, /* html:KeyA (KeyA) -> linux:30 (KEY_A) -> atset1:30 */
    "KeyB": 0x30, /* html:KeyB (KeyB) -> linux:48 (KEY_B) -> atset1:48 */
    "KeyC": 0x2e, /* html:KeyC (KeyC) -> linux:46 (KEY_C) -> atset1:46 */
    "KeyD": 0x20, /* html:KeyD (KeyD) -> linux:32 (KEY_D) -> atset1:32 */
    "KeyE": 0x12, /* html:KeyE (KeyE) -> linux:18 (KEY_E) -> atset1:18 */
    "KeyF": 0x21, /* html:KeyF (KeyF) -> linux:33 (KEY_F) -> atset1:33 */
    "KeyG": 0x22, /* html:KeyG (KeyG) -> linux:34 (KEY_G) -> atset1:34 */
    "KeyH": 0x23, /* html:KeyH (KeyH) -> linux:35 (KEY_H) -> atset1:35 */
    "KeyI": 0x17, /* html:KeyI (KeyI) -> linux:23 (KEY_I) -> atset1:23 */
    "KeyJ": 0x24, /* html:KeyJ (KeyJ) -> linux:36 (KEY_J) -> atset1:36 */
    "KeyK": 0x25, /* html:KeyK (KeyK) -> linux:37 (KEY_K) -> atset1:37 */
    "KeyL": 0x26, /* html:KeyL (KeyL) -> linux:38 (KEY_L) -> atset1:38 */
    "KeyM": 0x32, /* html:KeyM (KeyM) -> linux:50 (KEY_M) -> atset1:50 */
    "KeyN": 0x31, /* html:KeyN (KeyN) -> linux:49 (KEY_N) -> atset1:49 */
    "KeyO": 0x18, /* html:KeyO (KeyO) -> linux:24 (KEY_O) -> atset1:24 */
    "KeyP": 0x19, /* html:KeyP (KeyP) -> linux:25 (KEY_P) -> atset1:25 */
    "KeyQ": 0x10, /* html:KeyQ (KeyQ) -> linux:16 (KEY_Q) -> atset1:16 */
    "KeyR": 0x13, /* html:KeyR (KeyR) -> linux:19 (KEY_R) -> atset1:19 */
    "KeyS": 0x1f, /* html:KeyS (KeyS) -> linux:31 (KEY_S) -> atset1:31 */
    "KeyT": 0x14, /* html:KeyT (KeyT) -> linux:20 (KEY_T) -> atset1:20 */
    "KeyU": 0x16, /* html:KeyU (KeyU) -> linux:22 (KEY_U) -> atset1:22 */
    "KeyV": 0x2f, /* html:KeyV (KeyV) -> linux:47 (KEY_V) -> atset1:47 */
    "KeyW": 0x11, /* html:KeyW (KeyW) -> linux:17 (KEY_W) -> atset1:17 */
    "KeyX": 0x2d, /* html:KeyX (KeyX) -> linux:45 (KEY_X) -> atset1:45 */
    "KeyY": 0x15, /* html:KeyY (KeyY) -> linux:21 (KEY_Y) -> atset1:21 */
    "KeyZ": 0x2c, /* html:KeyZ (KeyZ) -> linux:44 (KEY_Z) -> atset1:44 */
    "Lang3": 0x78, /* html:Lang3 (Lang3) -> linux:90 (KEY_KATAKANA) -> atset1:120 */
    "Lang4": 0x77, /* html:Lang4 (Lang4) -> linux:91 (KEY_HIRAGANA) -> atset1:119 */
    "Lang5": 0x76, /* html:Lang5 (Lang5) -> linux:85 (KEY_ZENKAKUHANKAKU) -> atset1:118 */
    "LaunchApp1": 0xe06b, /* html:LaunchApp1 (LaunchApp1) -> linux:157 (KEY_COMPUTER) -> atset1:57451 */
    "LaunchApp2": 0xe021, /* html:LaunchApp2 (LaunchApp2) -> linux:140 (KEY_CALC) -> atset1:57377 */
    "LaunchMail": 0xe06c, /* html:LaunchMail (LaunchMail) -> linux:155 (KEY_MAIL) -> atset1:57452 */
    "MediaPlayPause": 0xe022, /* html:MediaPlayPause (MediaPlayPause) -> linux:164 (KEY_PLAYPAUSE) -> atset1:57378 */
    "MediaSelect": 0xe06d, /* html:MediaSelect (MediaSelect) -> linux:226 (KEY_MEDIA) -> atset1:57453 */
    "MediaStop": 0xe024, /* html:MediaStop (MediaStop) -> linux:166 (KEY_STOPCD) -> atset1:57380 */
    "MediaTrackNext": 0xe019, /* html:MediaTrackNext (MediaTrackNext) -> linux:163 (KEY_NEXTSONG) -> atset1:57369 */
    "MediaTrackPrevious": 0xe010, /* html:MediaTrackPrevious (MediaTrackPrevious) -> linux:165 (KEY_PREVIOUSSONG) -> atset1:57360 */
    "MetaLeft": 0xe05b, /* html:MetaLeft (MetaLeft) -> linux:125 (KEY_LEFTMETA) -> atset1:57435 */
    "MetaRight": 0xe05c, /* html:MetaRight (MetaRight) -> linux:126 (KEY_RIGHTMETA) -> atset1:57436 */
    "Minus": 0xc, /* html:Minus (Minus) -> linux:12 (KEY_MINUS) -> atset1:12 */
    "NonConvert": 0x7b, /* html:NonConvert (NonConvert) -> linux:94 (KEY_MUHENKAN) -> atset1:123 */
    "NumLock": 0x45, /* html:NumLock (NumLock) -> linux:69 (KEY_NUMLOCK) -> atset1:69 */
    "Numpad0": 0x52, /* html:Numpad0 (Numpad0) -> linux:82 (KEY_KP0) -> atset1:82 */
    "Numpad1": 0x4f, /* html:Numpad1 (Numpad1) -> linux:79 (KEY_KP1) -> atset1:79 */
    "Numpad2": 0x50, /* html:Numpad2 (Numpad2) -> linux:80 (KEY_KP2) -> atset1:80 */
    "Numpad3": 0x51, /* html:Numpad3 (Numpad3) -> linux:81 (KEY_KP3) -> atset1:81 */
    "Numpad4": 0x4b, /* html:Numpad4 (Numpad4) -> linux:75 (KEY_KP4) -> atset1:75 */
    "Numpad5": 0x4c, /* html:Numpad5 (Numpad5) -> linux:76 (KEY_KP5) -> atset1:76 */
    "Numpad6": 0x4d, /* html:Numpad6 (Numpad6) -> linux:77 (KEY_KP6) -> atset1:77 */
    "Numpad7": 0x47, /* html:Numpad7 (Numpad7) -> linux:71 (KEY_KP7) -> atset1:71 */
    "Numpad8": 0x48, /* html:Numpad8 (Numpad8) -> linux:72 (KEY_KP8) -> atset1:72 */
    "Numpad9": 0x49, /* html:Numpad9 (Numpad9) -> linux:73 (KEY_KP9) -> atset1:73 */
    "NumpadAdd": 0x4e, /* html:NumpadAdd (NumpadAdd) -> linux:78 (KEY_KPPLUS) -> atset1:78 */
    "NumpadComma": 0x7e, /* html:NumpadComma (NumpadComma) -> linux:121 (KEY_KPCOMMA) -> atset1:126 */
    "NumpadDecimal": 0x53, /* html:NumpadDecimal (NumpadDecimal) -> linux:83 (KEY_KPDOT) -> atset1:83 */
    "NumpadDivide": 0xe035, /* html:NumpadDivide (NumpadDivide) -> linux:98 (KEY_KPSLASH) -> atset1:57397 */
    "NumpadEnter": 0xe01c, /* html:NumpadEnter (NumpadEnter) -> linux:96 (KEY_KPENTER) -> atset1:57372 */
    "NumpadEqual": 0x59, /* html:NumpadEqual (NumpadEqual) -> linux:117 (KEY_KPEQUAL) -> atset1:89 */
    "NumpadMultiply": 0x37, /* html:NumpadMultiply (NumpadMultiply) -> linux:55 (KEY_KPASTERISK) -> atset1:55 */
    "NumpadParenLeft": 0xe076, /* html:NumpadParenLeft (NumpadParenLeft) -> linux:179 (KEY_KPLEFTPAREN) -> atset1:57462 */
    "NumpadParenRight": 0xe07b, /* html:NumpadParenRight (NumpadParenRight) -> linux:180 (KEY_KPRIGHTPAREN) -> atset1:57467 */
    "NumpadSubtract": 0x4a, /* html:NumpadSubtract (NumpadSubtract) -> linux:74 (KEY_KPMINUS) -> atset1:74 */
    "Open": 0x64, /* html:Open (Open) -> linux:134 (KEY_OPEN) -> atset1:100 */
    "PageDown": 0xe051, /* html:PageDown (PageDown) -> linux:109 (KEY_PAGEDOWN) -> atset1:57425 */
    "PageUp": 0xe049, /* html:PageUp (PageUp) -> linux:104 (KEY_PAGEUP) -> atset1:57417 */
    "Paste": 0x65, /* html:Paste (Paste) -> linux:135 (KEY_PASTE) -> atset1:101 */
    "Pause": 0xe046, /* html:Pause (Pause) -> linux:119 (KEY_PAUSE) -> atset1:57414 */
    "Period": 0x34, /* html:Period (Period) -> linux:52 (KEY_DOT) -> atset1:52 */
    "Power": 0xe05e, /* html:Power (Power) -> linux:116 (KEY_POWER) -> atset1:57438 */
    "PrintScreen": 0x54, /* html:PrintScreen (PrintScreen) -> linux:99 (KEY_SYSRQ) -> atset1:84 */
    "Props": 0xe006, /* html:Props (Props) -> linux:130 (KEY_PROPS) -> atset1:57350 */
    "Quote": 0x28, /* html:Quote (Quote) -> linux:40 (KEY_APOSTROPHE) -> atset1:40 */
    "ScrollLock": 0x46, /* html:ScrollLock (ScrollLock) -> linux:70 (KEY_SCROLLLOCK) -> atset1:70 */
    "Semicolon": 0x27, /* html:Semicolon (Semicolon) -> linux:39 (KEY_SEMICOLON) -> atset1:39 */
    "ShiftLeft": 0x2a, /* html:ShiftLeft (ShiftLeft) -> linux:42 (KEY_LEFTSHIFT) -> atset1:42 */
    "ShiftRight": 0x36, /* html:ShiftRight (ShiftRight) -> linux:54 (KEY_RIGHTSHIFT) -> atset1:54 */
    "Slash": 0x35, /* html:Slash (Slash) -> linux:53 (KEY_SLASH) -> atset1:53 */
    "Sleep": 0xe05f, /* html:Sleep (Sleep) -> linux:142 (KEY_SLEEP) -> atset1:57439 */
    "Space": 0x39, /* html:Space (Space) -> linux:57 (KEY_SPACE) -> atset1:57 */
    "Suspend": 0xe025, /* html:Suspend (Suspend) -> linux:205 (KEY_SUSPEND) -> atset1:57381 */
    "Tab": 0xf, /* html:Tab (Tab) -> linux:15 (KEY_TAB) -> atset1:15 */
    "Undo": 0xe007, /* html:Undo (Undo) -> linux:131 (KEY_UNDO) -> atset1:57351 */
    "WakeUp": 0xe063 /* html:WakeUp (WakeUp) -> linux:143 (KEY_WAKEUP) -> atset1:57443 */
  };
});
define('../bower_components/no-vnc/lib/encodings.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.encodingName = encodingName;
    /*
     * noVNC: HTML5 VNC client
     * Copyright (C) 2018 The noVNC Authors
     * Licensed under MPL 2.0 (see LICENSE.txt)
     *
     * See README.md for usage and integration instructions.
     */

    var encodings = exports.encodings = {
        encodingRaw: 0,
        encodingCopyRect: 1,
        encodingRRE: 2,
        encodingHextile: 5,
        encodingTight: 7,
        encodingTightPNG: -260,

        pseudoEncodingQualityLevel9: -23,
        pseudoEncodingQualityLevel0: -32,
        pseudoEncodingDesktopSize: -223,
        pseudoEncodingLastRect: -224,
        pseudoEncodingCursor: -239,
        pseudoEncodingQEMUExtendedKeyEvent: -258,
        pseudoEncodingExtendedDesktopSize: -308,
        pseudoEncodingXvp: -309,
        pseudoEncodingFence: -312,
        pseudoEncodingContinuousUpdates: -313,
        pseudoEncodingCompressLevel9: -247,
        pseudoEncodingCompressLevel0: -256
    };

    function encodingName(num) {
        switch (num) {
            case encodings.encodingRaw:
                return "Raw";
            case encodings.encodingCopyRect:
                return "CopyRect";
            case encodings.encodingRRE:
                return "RRE";
            case encodings.encodingHextile:
                return "Hextile";
            case encodings.encodingTight:
                return "Tight";
            case encodings.encodingTightPNG:
                return "TightPNG";
            default:
                return "[unknown encoding " + num + "]";
        }
    }
});
define('../bower_components/no-vnc/lib/decoders/raw.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var RawDecoder = function () {
        function RawDecoder() {
            _classCallCheck(this, RawDecoder);

            this._lines = 0;
        }

        _createClass(RawDecoder, [{
            key: "decodeRect",
            value: function decodeRect(x, y, width, height, sock, display, depth) {
                if (this._lines === 0) {
                    this._lines = height;
                }

                var pixelSize = depth == 8 ? 1 : 4;
                var bytesPerLine = width * pixelSize;

                if (sock.rQwait("RAW", bytesPerLine)) {
                    return false;
                }

                var cur_y = y + (height - this._lines);
                var curr_height = Math.min(this._lines, Math.floor(sock.rQlen / bytesPerLine));
                var data = sock.rQ;
                var index = sock.rQi;

                // Convert data if needed
                if (depth == 8) {
                    var pixels = width * curr_height;
                    var newdata = new Uint8Array(pixels * 4);
                    for (var i = 0; i < pixels; i++) {
                        newdata[i * 4 + 0] = (data[index + i] >> 0 & 0x3) * 255 / 3;
                        newdata[i * 4 + 1] = (data[index + i] >> 2 & 0x3) * 255 / 3;
                        newdata[i * 4 + 2] = (data[index + i] >> 4 & 0x3) * 255 / 3;
                        newdata[i * 4 + 4] = 0;
                    }
                    data = newdata;
                    index = 0;
                }

                display.blitImage(x, cur_y, width, curr_height, data, index);
                sock.rQskipBytes(curr_height * bytesPerLine);
                this._lines -= curr_height;
                if (this._lines > 0) {
                    return false;
                }

                return true;
            }
        }]);

        return RawDecoder;
    }();

    exports.default = RawDecoder;
});
define('../bower_components/no-vnc/lib/decoders/copyrect.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var CopyRectDecoder = function () {
        function CopyRectDecoder() {
            _classCallCheck(this, CopyRectDecoder);
        }

        _createClass(CopyRectDecoder, [{
            key: "decodeRect",
            value: function decodeRect(x, y, width, height, sock, display, depth) {
                if (sock.rQwait("COPYRECT", 4)) {
                    return false;
                }

                var deltaX = sock.rQshift16();
                var deltaY = sock.rQshift16();
                display.copyImage(deltaX, deltaY, x, y, width, height);

                return true;
            }
        }]);

        return CopyRectDecoder;
    }();

    exports.default = CopyRectDecoder;
});
define('../bower_components/no-vnc/lib/decoders/rre.js',["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var RREDecoder = function () {
        function RREDecoder() {
            _classCallCheck(this, RREDecoder);

            this._subrects = 0;
        }

        _createClass(RREDecoder, [{
            key: "decodeRect",
            value: function decodeRect(x, y, width, height, sock, display, depth) {
                if (this._subrects === 0) {
                    if (sock.rQwait("RRE", 4 + 4)) {
                        return false;
                    }

                    this._subrects = sock.rQshift32();

                    var color = sock.rQshiftBytes(4); // Background
                    display.fillRect(x, y, width, height, color);
                }

                while (this._subrects > 0) {
                    if (sock.rQwait("RRE", 4 + 8)) {
                        return false;
                    }

                    var _color = sock.rQshiftBytes(4);
                    var sx = sock.rQshift16();
                    var sy = sock.rQshift16();
                    var swidth = sock.rQshift16();
                    var sheight = sock.rQshift16();
                    display.fillRect(x + sx, y + sy, swidth, sheight, _color);

                    this._subrects--;
                }

                return true;
            }
        }]);

        return RREDecoder;
    }();

    exports.default = RREDecoder;
});
define('../bower_components/no-vnc/lib/decoders/hextile.js',["exports", "../util/logging.js"], function (exports, _logging) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var HextileDecoder = function () {
        function HextileDecoder() {
            _classCallCheck(this, HextileDecoder);

            this._tiles = 0;
            this._lastsubencoding = 0;
        }

        _createClass(HextileDecoder, [{
            key: "decodeRect",
            value: function decodeRect(x, y, width, height, sock, display, depth) {
                if (this._tiles === 0) {
                    this._tiles_x = Math.ceil(width / 16);
                    this._tiles_y = Math.ceil(height / 16);
                    this._total_tiles = this._tiles_x * this._tiles_y;
                    this._tiles = this._total_tiles;
                }

                while (this._tiles > 0) {
                    var bytes = 1;

                    if (sock.rQwait("HEXTILE", bytes)) {
                        return false;
                    }

                    var rQ = sock.rQ;
                    var rQi = sock.rQi;

                    var subencoding = rQ[rQi]; // Peek
                    if (subencoding > 30) {
                        // Raw
                        throw new Error("Illegal hextile subencoding (subencoding: " + subencoding + ")");
                    }

                    var curr_tile = this._total_tiles - this._tiles;
                    var tile_x = curr_tile % this._tiles_x;
                    var tile_y = Math.floor(curr_tile / this._tiles_x);
                    var tx = x + tile_x * 16;
                    var ty = y + tile_y * 16;
                    var tw = Math.min(16, x + width - tx);
                    var th = Math.min(16, y + height - ty);

                    // Figure out how much we are expecting
                    if (subencoding & 0x01) {
                        // Raw
                        bytes += tw * th * 4;
                    } else {
                        if (subencoding & 0x02) {
                            // Background
                            bytes += 4;
                        }
                        if (subencoding & 0x04) {
                            // Foreground
                            bytes += 4;
                        }
                        if (subencoding & 0x08) {
                            // AnySubrects
                            bytes++; // Since we aren't shifting it off

                            if (sock.rQwait("HEXTILE", bytes)) {
                                return false;
                            }

                            var subrects = rQ[rQi + bytes - 1]; // Peek
                            if (subencoding & 0x10) {
                                // SubrectsColoured
                                bytes += subrects * (4 + 2);
                            } else {
                                bytes += subrects * 2;
                            }
                        }
                    }

                    if (sock.rQwait("HEXTILE", bytes)) {
                        return false;
                    }

                    // We know the encoding and have a whole tile
                    rQi++;
                    if (subencoding === 0) {
                        if (this._lastsubencoding & 0x01) {
                            // Weird: ignore blanks are RAW
                            Log.Debug("     Ignoring blank after RAW");
                        } else {
                            display.fillRect(tx, ty, tw, th, this._background);
                        }
                    } else if (subencoding & 0x01) {
                        // Raw
                        display.blitImage(tx, ty, tw, th, rQ, rQi);
                        rQi += bytes - 1;
                    } else {
                        if (subencoding & 0x02) {
                            // Background
                            this._background = [rQ[rQi], rQ[rQi + 1], rQ[rQi + 2], rQ[rQi + 3]];
                            rQi += 4;
                        }
                        if (subencoding & 0x04) {
                            // Foreground
                            this._foreground = [rQ[rQi], rQ[rQi + 1], rQ[rQi + 2], rQ[rQi + 3]];
                            rQi += 4;
                        }

                        display.startTile(tx, ty, tw, th, this._background);
                        if (subencoding & 0x08) {
                            // AnySubrects
                            var _subrects = rQ[rQi];
                            rQi++;

                            for (var s = 0; s < _subrects; s++) {
                                var color = void 0;
                                if (subencoding & 0x10) {
                                    // SubrectsColoured
                                    color = [rQ[rQi], rQ[rQi + 1], rQ[rQi + 2], rQ[rQi + 3]];
                                    rQi += 4;
                                } else {
                                    color = this._foreground;
                                }
                                var xy = rQ[rQi];
                                rQi++;
                                var sx = xy >> 4;
                                var sy = xy & 0x0f;

                                var wh = rQ[rQi];
                                rQi++;
                                var sw = (wh >> 4) + 1;
                                var sh = (wh & 0x0f) + 1;

                                display.subTile(sx, sy, sw, sh, color);
                            }
                        }
                        display.finishTile();
                    }
                    sock.rQi = rQi;
                    this._lastsubencoding = subencoding;
                    this._tiles--;
                }

                return true;
            }
        }]);

        return HextileDecoder;
    }();

    exports.default = HextileDecoder;
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/utils/common.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.shrinkBuf = shrinkBuf;
  exports.arraySet = arraySet;
  exports.flattenChunks = flattenChunks;
  // reduce buffer size, avoiding mem copy
  function shrinkBuf(buf, size) {
    if (buf.length === size) {
      return buf;
    }
    if (buf.subarray) {
      return buf.subarray(0, size);
    }
    buf.length = size;
    return buf;
  };

  function arraySet(dest, src, src_offs, len, dest_offs) {
    if (src.subarray && dest.subarray) {
      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
      return;
    }
    // Fallback to ordinary array
    for (var i = 0; i < len; i++) {
      dest[dest_offs + i] = src[src_offs + i];
    }
  }

  // Join array of chunks to single array.
  function flattenChunks(chunks) {
    var i, l, len, pos, chunk, result;

    // calculate data length
    len = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      len += chunks[i].length;
    }

    // join chunks
    result = new Uint8Array(len);
    pos = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      chunk = chunks[i];
      result.set(chunk, pos);
      pos += chunk.length;
    }

    return result;
  }

  var Buf8 = exports.Buf8 = Uint8Array;
  var Buf16 = exports.Buf16 = Uint16Array;
  var Buf32 = exports.Buf32 = Int32Array;
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/adler32.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = adler32;
  // Note: adler32 takes 12% for level 0 and 2% for level 6.
  // It doesn't worth to make additional optimizationa as in original.
  // Small size is preferable.

  function adler32(adler, buf, len, pos) {
    var s1 = adler & 0xffff | 0,
        s2 = adler >>> 16 & 0xffff | 0,
        n = 0;

    while (len !== 0) {
      // Set limit ~ twice less than 5552, to keep
      // s2 in 31-bits, because we force signed ints.
      // in other case %= will fail.
      n = len > 2000 ? 2000 : len;
      len -= n;

      do {
        s1 = s1 + buf[pos++] | 0;
        s2 = s2 + s1 | 0;
      } while (--n);

      s1 %= 65521;
      s2 %= 65521;
    }

    return s1 | s2 << 16 | 0;
  }
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/crc32.js',["exports"], function (exports) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = makeTable;
  // Note: we can't get significant speed boost here.
  // So write code to minimize size - no pregenerated tables
  // and array tools dependencies.


  // Use ordinary array, since untyped makes no boost here
  function makeTable() {
    var c,
        table = [];

    for (var n = 0; n < 256; n++) {
      c = n;
      for (var k = 0; k < 8; k++) {
        c = c & 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
      }
      table[n] = c;
    }

    return table;
  }

  // Create table on load. Just 255 signed longs. Not a problem.
  var crcTable = makeTable();

  function crc32(crc, buf, len, pos) {
    var t = crcTable,
        end = pos + len;

    crc ^= -1;

    for (var i = pos; i < end; i++) {
      crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 0xFF];
    }

    return crc ^ -1; // >>> 0;
  }
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/inffast.js',['exports'], function (exports) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = inflate_fast;
  // See state defs from inflate.js
  var BAD = 30; /* got a data error -- remain here until reset */
  var TYPE = 12; /* i: waiting for type bits, including last-flag bit */

  /*
     Decode literal, length, and distance codes and write out the resulting
     literal and match bytes until either not enough input or output is
     available, an end-of-block is encountered, or a data error is encountered.
     When large enough input and output buffers are supplied to inflate(), for
     example, a 16K input buffer and a 64K output buffer, more than 95% of the
     inflate execution time is spent in this routine.
  
     Entry assumptions:
  
          state.mode === LEN
          strm.avail_in >= 6
          strm.avail_out >= 258
          start >= strm.avail_out
          state.bits < 8
  
     On return, state.mode is one of:
  
          LEN -- ran out of enough output space or enough available input
          TYPE -- reached end of block code, inflate() to interpret next block
          BAD -- error in block data
  
     Notes:
  
      - The maximum input bits used by a length/distance pair is 15 bits for the
        length code, 5 bits for the length extra, 15 bits for the distance code,
        and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
        Therefore if strm.avail_in >= 6, then there is enough input to avoid
        checking for available input while decoding.
  
      - The maximum bytes that a single length/distance pair can output is 258
        bytes, which is the maximum length that can be coded.  inflate_fast()
        requires strm.avail_out >= 258 for each loop to avoid checking for
        output space.
   */
  function inflate_fast(strm, start) {
    var state;
    var _in; /* local strm.input */
    var last; /* have enough input while in < last */
    var _out; /* local strm.output */
    var beg; /* inflate()'s initial strm.output */
    var end; /* while out < end, enough space available */
    //#ifdef INFLATE_STRICT
    var dmax; /* maximum distance from zlib header */
    //#endif
    var wsize; /* window size or zero if not using window */
    var whave; /* valid bytes in the window */
    var wnext; /* window write index */
    // Use `s_window` instead `window`, avoid conflict with instrumentation tools
    var s_window; /* allocated sliding window, if wsize != 0 */
    var hold; /* local strm.hold */
    var bits; /* local strm.bits */
    var lcode; /* local strm.lencode */
    var dcode; /* local strm.distcode */
    var lmask; /* mask for first level of length codes */
    var dmask; /* mask for first level of distance codes */
    var here; /* retrieved table entry */
    var op; /* code bits, operation, extra bits, or */
    /*  window position, window bytes to copy */
    var len; /* match length, unused bytes */
    var dist; /* match distance */
    var from; /* where to copy match from */
    var from_source;

    var input, output; // JS specific, because we have no pointers

    /* copy state to local variables */
    state = strm.state;
    //here = state.here;
    _in = strm.next_in;
    input = strm.input;
    last = _in + (strm.avail_in - 5);
    _out = strm.next_out;
    output = strm.output;
    beg = _out - (start - strm.avail_out);
    end = _out + (strm.avail_out - 257);
    //#ifdef INFLATE_STRICT
    dmax = state.dmax;
    //#endif
    wsize = state.wsize;
    whave = state.whave;
    wnext = state.wnext;
    s_window = state.window;
    hold = state.hold;
    bits = state.bits;
    lcode = state.lencode;
    dcode = state.distcode;
    lmask = (1 << state.lenbits) - 1;
    dmask = (1 << state.distbits) - 1;

    /* decode literals and length/distances until end-of-block or not enough
       input data or output space */

    top: do {
      if (bits < 15) {
        hold += input[_in++] << bits;
        bits += 8;
        hold += input[_in++] << bits;
        bits += 8;
      }

      here = lcode[hold & lmask];

      dolen: for (;;) {
        // Goto emulation
        op = here >>> 24 /*here.bits*/;
        hold >>>= op;
        bits -= op;
        op = here >>> 16 & 0xff /*here.op*/;
        if (op === 0) {
          /* literal */
          //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
          //        "inflate:         literal '%c'\n" :
          //        "inflate:         literal 0x%02x\n", here.val));
          output[_out++] = here & 0xffff /*here.val*/;
        } else if (op & 16) {
          /* length base */
          len = here & 0xffff /*here.val*/;
          op &= 15; /* number of extra bits */
          if (op) {
            if (bits < op) {
              hold += input[_in++] << bits;
              bits += 8;
            }
            len += hold & (1 << op) - 1;
            hold >>>= op;
            bits -= op;
          }
          //Tracevv((stderr, "inflate:         length %u\n", len));
          if (bits < 15) {
            hold += input[_in++] << bits;
            bits += 8;
            hold += input[_in++] << bits;
            bits += 8;
          }
          here = dcode[hold & dmask];

          dodist: for (;;) {
            // goto emulation
            op = here >>> 24 /*here.bits*/;
            hold >>>= op;
            bits -= op;
            op = here >>> 16 & 0xff /*here.op*/;

            if (op & 16) {
              /* distance base */
              dist = here & 0xffff /*here.val*/;
              op &= 15; /* number of extra bits */
              if (bits < op) {
                hold += input[_in++] << bits;
                bits += 8;
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                }
              }
              dist += hold & (1 << op) - 1;
              //#ifdef INFLATE_STRICT
              if (dist > dmax) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD;
                break top;
              }
              //#endif
              hold >>>= op;
              bits -= op;
              //Tracevv((stderr, "inflate:         distance %u\n", dist));
              op = _out - beg; /* max distance in output */
              if (dist > op) {
                /* see if copy from window */
                op = dist - op; /* distance back in window */
                if (op > whave) {
                  if (state.sane) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD;
                    break top;
                  }

                  // (!) This block is disabled in zlib defailts,
                  // don't enable it for binary compatibility
                  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                  //                if (len <= op - whave) {
                  //                  do {
                  //                    output[_out++] = 0;
                  //                  } while (--len);
                  //                  continue top;
                  //                }
                  //                len -= op - whave;
                  //                do {
                  //                  output[_out++] = 0;
                  //                } while (--op > whave);
                  //                if (op === 0) {
                  //                  from = _out - dist;
                  //                  do {
                  //                    output[_out++] = output[from++];
                  //                  } while (--len);
                  //                  continue top;
                  //                }
                  //#endif
                }
                from = 0; // window index
                from_source = s_window;
                if (wnext === 0) {
                  /* very common case */
                  from += wsize - op;
                  if (op < len) {
                    /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist; /* rest from output */
                    from_source = output;
                  }
                } else if (wnext < op) {
                  /* wrap around window */
                  from += wsize + wnext - op;
                  op -= wnext;
                  if (op < len) {
                    /* some from end of window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = 0;
                    if (wnext < len) {
                      /* some from start of window */
                      op = wnext;
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = _out - dist; /* rest from output */
                      from_source = output;
                    }
                  }
                } else {
                  /* contiguous in window */
                  from += wnext - op;
                  if (op < len) {
                    /* some from window */
                    len -= op;
                    do {
                      output[_out++] = s_window[from++];
                    } while (--op);
                    from = _out - dist; /* rest from output */
                    from_source = output;
                  }
                }
                while (len > 2) {
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  output[_out++] = from_source[from++];
                  len -= 3;
                }
                if (len) {
                  output[_out++] = from_source[from++];
                  if (len > 1) {
                    output[_out++] = from_source[from++];
                  }
                }
              } else {
                from = _out - dist; /* copy direct from output */
                do {
                  /* minimum length is three */
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  output[_out++] = output[from++];
                  len -= 3;
                } while (len > 2);
                if (len) {
                  output[_out++] = output[from++];
                  if (len > 1) {
                    output[_out++] = output[from++];
                  }
                }
              }
            } else if ((op & 64) === 0) {
              /* 2nd level distance code */
              here = dcode[(here & 0xffff) + ( /*here.val*/hold & (1 << op) - 1)];
              continue dodist;
            } else {
              strm.msg = 'invalid distance code';
              state.mode = BAD;
              break top;
            }

            break; // need to emulate goto via "continue"
          }
        } else if ((op & 64) === 0) {
          /* 2nd level length code */
          here = lcode[(here & 0xffff) + ( /*here.val*/hold & (1 << op) - 1)];
          continue dolen;
        } else if (op & 32) {
          /* end-of-block */
          //Tracevv((stderr, "inflate:         end of block\n"));
          state.mode = TYPE;
          break top;
        } else {
          strm.msg = 'invalid literal/length code';
          state.mode = BAD;
          break top;
        }

        break; // need to emulate goto via "continue"
      }
    } while (_in < last && _out < end);

    /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
    len = bits >> 3;
    _in -= len;
    bits -= len << 3;
    hold &= (1 << bits) - 1;

    /* update state and return */
    strm.next_in = _in;
    strm.next_out = _out;
    strm.avail_in = _in < last ? 5 + (last - _in) : 5 - (_in - last);
    strm.avail_out = _out < end ? 257 + (end - _out) : 257 - (_out - end);
    state.hold = hold;
    state.bits = bits;
    return;
  };
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/inftrees.js',["exports", "../utils/common.js"], function (exports, _common) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = inflate_table;

  var utils = _interopRequireWildcard(_common);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  var MAXBITS = 15;
  var ENOUGH_LENS = 852;
  var ENOUGH_DISTS = 592;
  //var ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

  var CODES = 0;
  var LENS = 1;
  var DISTS = 2;

  var lbase = [/* Length codes 257..285 base */
  3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0];

  var lext = [/* Length codes 257..285 extra */
  16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78];

  var dbase = [/* Distance codes 0..29 base */
  1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0];

  var dext = [/* Distance codes 0..29 extra */
  16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64];

  function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts) {
    var bits = opts.bits;
    //here = opts.here; /* table entry for duplication */

    var len = 0; /* a code's length in bits */
    var sym = 0; /* index of code symbols */
    var min = 0,
        max = 0; /* minimum and maximum code lengths */
    var root = 0; /* number of index bits for root table */
    var curr = 0; /* number of index bits for current table */
    var drop = 0; /* code bits to drop for sub-table */
    var left = 0; /* number of prefix codes available */
    var used = 0; /* code entries in table used */
    var huff = 0; /* Huffman code */
    var incr; /* for incrementing code, index */
    var fill; /* index for replicating entries */
    var low; /* low bits for current root entry */
    var mask; /* mask for low root bits */
    var next; /* next available space in table */
    var base = null; /* base value table to use */
    var base_index = 0;
    //  var shoextra;    /* extra bits table to use */
    var end; /* use base and extra for symbol > end */
    var count = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
    var offs = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
    var extra = null;
    var extra_index = 0;

    var here_bits, here_op, here_val;

    /*
     Process a set of code lengths to create a canonical Huffman code.  The
     code lengths are lens[0..codes-1].  Each length corresponds to the
     symbols 0..codes-1.  The Huffman code is generated by first sorting the
     symbols by length from short to long, and retaining the symbol order
     for codes with equal lengths.  Then the code starts with all zero bits
     for the first code of the shortest length, and the codes are integer
     increments for the same length, and zeros are appended as the length
     increases.  For the deflate format, these bits are stored backwards
     from their more natural integer increment ordering, and so when the
     decoding tables are built in the large loop below, the integer codes
     are incremented backwards.
      This routine assumes, but does not check, that all of the entries in
     lens[] are in the range 0..MAXBITS.  The caller must assure this.
     1..MAXBITS is interpreted as that code length.  zero means that that
     symbol does not occur in this code.
      The codes are sorted by computing a count of codes for each length,
     creating from that a table of starting indices for each length in the
     sorted table, and then entering the symbols in order in the sorted
     table.  The sorted table is work[], with that space being provided by
     the caller.
      The length counts are used for other purposes as well, i.e. finding
     the minimum and maximum length codes, determining if there are any
     codes at all, checking for a valid set of lengths, and looking ahead
     at length counts to determine sub-table sizes when building the
     decoding tables.
     */

    /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
    for (len = 0; len <= MAXBITS; len++) {
      count[len] = 0;
    }
    for (sym = 0; sym < codes; sym++) {
      count[lens[lens_index + sym]]++;
    }

    /* bound code lengths, force root to be within code lengths */
    root = bits;
    for (max = MAXBITS; max >= 1; max--) {
      if (count[max] !== 0) {
        break;
      }
    }
    if (root > max) {
      root = max;
    }
    if (max === 0) {
      /* no symbols to code at all */
      //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
      //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
      //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
      table[table_index++] = 1 << 24 | 64 << 16 | 0;

      //table.op[opts.table_index] = 64;
      //table.bits[opts.table_index] = 1;
      //table.val[opts.table_index++] = 0;
      table[table_index++] = 1 << 24 | 64 << 16 | 0;

      opts.bits = 1;
      return 0; /* no symbols, but wait for decoding to report error */
    }
    for (min = 1; min < max; min++) {
      if (count[min] !== 0) {
        break;
      }
    }
    if (root < min) {
      root = min;
    }

    /* check for an over-subscribed or incomplete set of lengths */
    left = 1;
    for (len = 1; len <= MAXBITS; len++) {
      left <<= 1;
      left -= count[len];
      if (left < 0) {
        return -1;
      } /* over-subscribed */
    }
    if (left > 0 && (type === CODES || max !== 1)) {
      return -1; /* incomplete set */
    }

    /* generate offsets into symbol table for each length for sorting */
    offs[1] = 0;
    for (len = 1; len < MAXBITS; len++) {
      offs[len + 1] = offs[len] + count[len];
    }

    /* sort symbols by length, by symbol order within each length */
    for (sym = 0; sym < codes; sym++) {
      if (lens[lens_index + sym] !== 0) {
        work[offs[lens[lens_index + sym]]++] = sym;
      }
    }

    /*
     Create and fill in decoding tables.  In this loop, the table being
     filled is at next and has curr index bits.  The code being used is huff
     with length len.  That code is converted to an index by dropping drop
     bits off of the bottom.  For codes where len is less than drop + curr,
     those top drop + curr - len bits are incremented through all values to
     fill the table with replicated entries.
      root is the number of index bits for the root table.  When len exceeds
     root, sub-tables are created pointed to by the root entry with an index
     of the low root bits of huff.  This is saved in low to check for when a
     new sub-table should be started.  drop is zero when the root table is
     being filled, and drop is root when sub-tables are being filled.
      When a new sub-table is needed, it is necessary to look ahead in the
     code lengths to determine what size sub-table is needed.  The length
     counts are used for this, and so count[] is decremented as codes are
     entered in the tables.
      used keeps track of how many table entries have been allocated from the
     provided *table space.  It is checked for LENS and DIST tables against
     the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
     the initial root table size constants.  See the comments in inftrees.h
     for more information.
      sym increments through all symbols, and the loop terminates when
     all codes of length max, i.e. all codes, have been processed.  This
     routine permits incomplete codes, so another loop after this one fills
     in the rest of the decoding tables with invalid code markers.
     */

    /* set up for code type */
    // poor man optimization - use if-else instead of switch,
    // to avoid deopts in old v8
    if (type === CODES) {
      base = extra = work; /* dummy value--not used */
      end = 19;
    } else if (type === LENS) {
      base = lbase;
      base_index -= 257;
      extra = lext;
      extra_index -= 257;
      end = 256;
    } else {
      /* DISTS */
      base = dbase;
      extra = dext;
      end = -1;
    }

    /* initialize opts for loop */
    huff = 0; /* starting code */
    sym = 0; /* starting code symbol */
    len = min; /* starting code length */
    next = table_index; /* current table to fill in */
    curr = root; /* current table index bits */
    drop = 0; /* current bits to drop from code for index */
    low = -1; /* trigger new sub-table when len > root */
    used = 1 << root; /* use root table entries */
    mask = used - 1; /* mask for comparing low */

    /* check available table space */
    if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
      return 1;
    }

    /* process all codes and make table entries */
    for (;;) {
      /* create table entry */
      here_bits = len - drop;
      if (work[sym] < end) {
        here_op = 0;
        here_val = work[sym];
      } else if (work[sym] > end) {
        here_op = extra[extra_index + work[sym]];
        here_val = base[base_index + work[sym]];
      } else {
        here_op = 32 + 64; /* end of block */
        here_val = 0;
      }

      /* replicate for those indices with low len bits equal to huff */
      incr = 1 << len - drop;
      fill = 1 << curr;
      min = fill; /* save offset to next table */
      do {
        fill -= incr;
        table[next + (huff >> drop) + fill] = here_bits << 24 | here_op << 16 | here_val | 0;
      } while (fill !== 0);

      /* backwards increment the len-bit code huff */
      incr = 1 << len - 1;
      while (huff & incr) {
        incr >>= 1;
      }
      if (incr !== 0) {
        huff &= incr - 1;
        huff += incr;
      } else {
        huff = 0;
      }

      /* go to next symbol, update count, len */
      sym++;
      if (--count[len] === 0) {
        if (len === max) {
          break;
        }
        len = lens[lens_index + work[sym]];
      }

      /* create new sub-table if needed */
      if (len > root && (huff & mask) !== low) {
        /* if first time, transition to sub-tables */
        if (drop === 0) {
          drop = root;
        }

        /* increment past last table */
        next += min; /* here min is 1 << curr */

        /* determine length of next table */
        curr = len - drop;
        left = 1 << curr;
        while (curr + drop < max) {
          left -= count[curr + drop];
          if (left <= 0) {
            break;
          }
          curr++;
          left <<= 1;
        }

        /* check for enough space */
        used += 1 << curr;
        if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
          return 1;
        }

        /* point entry in root table to sub-table */
        low = huff & mask;
        /*table.op[low] = curr;
        table.bits[low] = root;
        table.val[low] = next - opts.table_index;*/
        table[low] = root << 24 | curr << 16 | next - table_index | 0;
      }
    }

    /* fill in remaining table entry if code is incomplete (guaranteed to have
     at most one remaining entry, since if the code is incomplete, the
     maximum code length that was allowed to get this far is one bit) */
    if (huff !== 0) {
      //table.op[next + huff] = 64;            /* invalid code marker */
      //table.bits[next + huff] = len - drop;
      //table.val[next + huff] = 0;
      table[next + huff] = len - drop << 24 | 64 << 16 | 0;
    }

    /* set return parameters */
    //opts.table_index += used;
    opts.bits = root;
    return 0;
  };
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/inflate.js',["exports", "../utils/common.js", "./adler32.js", "./crc32.js", "./inffast.js", "./inftrees.js"], function (exports, _common, _adler, _crc, _inffast, _inftrees) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.inflateInfo = exports.inflateSetDictionary = exports.inflateGetHeader = exports.inflateEnd = exports.inflate = exports.inflateInit2 = exports.inflateInit = exports.inflateResetKeep = exports.inflateReset2 = exports.inflateReset = undefined;

  var utils = _interopRequireWildcard(_common);

  var _adler2 = _interopRequireDefault(_adler);

  var _crc2 = _interopRequireDefault(_crc);

  var _inffast2 = _interopRequireDefault(_inffast);

  var _inftrees2 = _interopRequireDefault(_inftrees);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  var CODES = 0;
  var LENS = 1;
  var DISTS = 2;

  /* Public constants ==========================================================*/
  /* ===========================================================================*/

  /* Allowed flush values; see deflate() and inflate() below for details */
  //var Z_NO_FLUSH      = 0;
  //var Z_PARTIAL_FLUSH = 1;
  //var Z_SYNC_FLUSH    = 2;
  //var Z_FULL_FLUSH    = 3;
  var Z_FINISH = 4;
  var Z_BLOCK = 5;
  var Z_TREES = 6;

  /* Return codes for the compression/decompression functions. Negative values
   * are errors, positive values are used for special but normal events.
   */
  var Z_OK = 0;
  var Z_STREAM_END = 1;
  var Z_NEED_DICT = 2;
  //var Z_ERRNO         = -1;
  var Z_STREAM_ERROR = -2;
  var Z_DATA_ERROR = -3;
  var Z_MEM_ERROR = -4;
  var Z_BUF_ERROR = -5;
  //var Z_VERSION_ERROR = -6;

  /* The deflate compression method */
  var Z_DEFLATED = 8;

  /* STATES ====================================================================*/
  /* ===========================================================================*/

  var HEAD = 1; /* i: waiting for magic header */
  var FLAGS = 2; /* i: waiting for method and flags (gzip) */
  var TIME = 3; /* i: waiting for modification time (gzip) */
  var OS = 4; /* i: waiting for extra flags and operating system (gzip) */
  var EXLEN = 5; /* i: waiting for extra length (gzip) */
  var EXTRA = 6; /* i: waiting for extra bytes (gzip) */
  var NAME = 7; /* i: waiting for end of file name (gzip) */
  var COMMENT = 8; /* i: waiting for end of comment (gzip) */
  var HCRC = 9; /* i: waiting for header crc (gzip) */
  var DICTID = 10; /* i: waiting for dictionary check value */
  var DICT = 11; /* waiting for inflateSetDictionary() call */
  var TYPE = 12; /* i: waiting for type bits, including last-flag bit */
  var TYPEDO = 13; /* i: same, but skip check to exit inflate on new block */
  var STORED = 14; /* i: waiting for stored size (length and complement) */
  var COPY_ = 15; /* i/o: same as COPY below, but only first time in */
  var COPY = 16; /* i/o: waiting for input or output to copy stored block */
  var TABLE = 17; /* i: waiting for dynamic block table lengths */
  var LENLENS = 18; /* i: waiting for code length code lengths */
  var CODELENS = 19; /* i: waiting for length/lit and distance code lengths */
  var LEN_ = 20; /* i: same as LEN below, but only first time in */
  var LEN = 21; /* i: waiting for length/lit/eob code */
  var LENEXT = 22; /* i: waiting for length extra bits */
  var DIST = 23; /* i: waiting for distance code */
  var DISTEXT = 24; /* i: waiting for distance extra bits */
  var MATCH = 25; /* o: waiting for output space to copy string */
  var LIT = 26; /* o: waiting for output space to write literal */
  var CHECK = 27; /* i: waiting for 32-bit check value */
  var LENGTH = 28; /* i: waiting for 32-bit length (gzip) */
  var DONE = 29; /* finished check, done -- remain here until reset */
  var BAD = 30; /* got a data error -- remain here until reset */
  var MEM = 31; /* got an inflate() memory error -- remain here until reset */
  var SYNC = 32; /* looking for synchronization bytes to restart inflate() */

  /* ===========================================================================*/

  var ENOUGH_LENS = 852;
  var ENOUGH_DISTS = 592;
  //var ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);

  var MAX_WBITS = 15;
  /* 32K LZ77 window */
  var DEF_WBITS = MAX_WBITS;

  function zswap32(q) {
    return (q >>> 24 & 0xff) + (q >>> 8 & 0xff00) + ((q & 0xff00) << 8) + ((q & 0xff) << 24);
  }

  function InflateState() {
    this.mode = 0; /* current inflate mode */
    this.last = false; /* true if processing last block */
    this.wrap = 0; /* bit 0 true for zlib, bit 1 true for gzip */
    this.havedict = false; /* true if dictionary provided */
    this.flags = 0; /* gzip header method and flags (0 if zlib) */
    this.dmax = 0; /* zlib header max distance (INFLATE_STRICT) */
    this.check = 0; /* protected copy of check value */
    this.total = 0; /* protected copy of output count */
    // TODO: may be {}
    this.head = null; /* where to save gzip header information */

    /* sliding window */
    this.wbits = 0; /* log base 2 of requested window size */
    this.wsize = 0; /* window size or zero if not using window */
    this.whave = 0; /* valid bytes in the window */
    this.wnext = 0; /* window write index */
    this.window = null; /* allocated sliding window, if needed */

    /* bit accumulator */
    this.hold = 0; /* input bit accumulator */
    this.bits = 0; /* number of bits in "in" */

    /* for string and stored block copying */
    this.length = 0; /* literal or length of data to copy */
    this.offset = 0; /* distance back to copy string from */

    /* for table and code decoding */
    this.extra = 0; /* extra bits needed */

    /* fixed and dynamic code tables */
    this.lencode = null; /* starting table for length/literal codes */
    this.distcode = null; /* starting table for distance codes */
    this.lenbits = 0; /* index bits for lencode */
    this.distbits = 0; /* index bits for distcode */

    /* dynamic table building */
    this.ncode = 0; /* number of code length code lengths */
    this.nlen = 0; /* number of length code lengths */
    this.ndist = 0; /* number of distance code lengths */
    this.have = 0; /* number of code lengths in lens[] */
    this.next = null; /* next available space in codes[] */

    this.lens = new utils.Buf16(320); /* temporary storage for code lengths */
    this.work = new utils.Buf16(288); /* work area for code table building */

    /*
     because we don't have pointers in js, we use lencode and distcode directly
     as buffers so we don't need codes
    */
    //this.codes = new utils.Buf32(ENOUGH);       /* space for code tables */
    this.lendyn = null; /* dynamic table for length/literal codes (JS specific) */
    this.distdyn = null; /* dynamic table for distance codes (JS specific) */
    this.sane = 0; /* if false, allow invalid distance too far */
    this.back = 0; /* bits back of last unprocessed length/lit */
    this.was = 0; /* initial length of match */
  }

  function inflateResetKeep(strm) {
    var state;

    if (!strm || !strm.state) {
      return Z_STREAM_ERROR;
    }
    state = strm.state;
    strm.total_in = strm.total_out = state.total = 0;
    strm.msg = ''; /*Z_NULL*/
    if (state.wrap) {
      /* to support ill-conceived Java test suite */
      strm.adler = state.wrap & 1;
    }
    state.mode = HEAD;
    state.last = 0;
    state.havedict = 0;
    state.dmax = 32768;
    state.head = null /*Z_NULL*/;
    state.hold = 0;
    state.bits = 0;
    //state.lencode = state.distcode = state.next = state.codes;
    state.lencode = state.lendyn = new utils.Buf32(ENOUGH_LENS);
    state.distcode = state.distdyn = new utils.Buf32(ENOUGH_DISTS);

    state.sane = 1;
    state.back = -1;
    //Tracev((stderr, "inflate: reset\n"));
    return Z_OK;
  }

  function inflateReset(strm) {
    var state;

    if (!strm || !strm.state) {
      return Z_STREAM_ERROR;
    }
    state = strm.state;
    state.wsize = 0;
    state.whave = 0;
    state.wnext = 0;
    return inflateResetKeep(strm);
  }

  function inflateReset2(strm, windowBits) {
    var wrap;
    var state;

    /* get the state */
    if (!strm || !strm.state) {
      return Z_STREAM_ERROR;
    }
    state = strm.state;

    /* extract wrap request from windowBits parameter */
    if (windowBits < 0) {
      wrap = 0;
      windowBits = -windowBits;
    } else {
      wrap = (windowBits >> 4) + 1;
      if (windowBits < 48) {
        windowBits &= 15;
      }
    }

    /* set number of window bits, free window if different */
    if (windowBits && (windowBits < 8 || windowBits > 15)) {
      return Z_STREAM_ERROR;
    }
    if (state.window !== null && state.wbits !== windowBits) {
      state.window = null;
    }

    /* update state and reset the rest of it */
    state.wrap = wrap;
    state.wbits = windowBits;
    return inflateReset(strm);
  }

  function inflateInit2(strm, windowBits) {
    var ret;
    var state;

    if (!strm) {
      return Z_STREAM_ERROR;
    }
    //strm.msg = Z_NULL;                 /* in case we return an error */

    state = new InflateState();

    //if (state === Z_NULL) return Z_MEM_ERROR;
    //Tracev((stderr, "inflate: allocated\n"));
    strm.state = state;
    state.window = null /*Z_NULL*/;
    ret = inflateReset2(strm, windowBits);
    if (ret !== Z_OK) {
      strm.state = null /*Z_NULL*/;
    }
    return ret;
  }

  function inflateInit(strm) {
    return inflateInit2(strm, DEF_WBITS);
  }

  /*
   Return state with length and distance decoding tables and index sizes set to
   fixed code decoding.  Normally this returns fixed tables from inffixed.h.
   If BUILDFIXED is defined, then instead this routine builds the tables the
   first time it's called, and returns those tables the first time and
   thereafter.  This reduces the size of the code by about 2K bytes, in
   exchange for a little execution time.  However, BUILDFIXED should not be
   used for threaded applications, since the rewriting of the tables and virgin
   may not be thread-safe.
   */
  var virgin = true;

  var lenfix, distfix; // We have no pointers in JS, so keep tables separate

  function fixedtables(state) {
    /* build fixed huffman tables if first call (may not be thread safe) */
    if (virgin) {
      var sym;

      lenfix = new utils.Buf32(512);
      distfix = new utils.Buf32(32);

      /* literal/length table */
      sym = 0;
      while (sym < 144) {
        state.lens[sym++] = 8;
      }
      while (sym < 256) {
        state.lens[sym++] = 9;
      }
      while (sym < 280) {
        state.lens[sym++] = 7;
      }
      while (sym < 288) {
        state.lens[sym++] = 8;
      }

      (0, _inftrees2.default)(LENS, state.lens, 0, 288, lenfix, 0, state.work, { bits: 9 });

      /* distance table */
      sym = 0;
      while (sym < 32) {
        state.lens[sym++] = 5;
      }

      (0, _inftrees2.default)(DISTS, state.lens, 0, 32, distfix, 0, state.work, { bits: 5 });

      /* do this just once */
      virgin = false;
    }

    state.lencode = lenfix;
    state.lenbits = 9;
    state.distcode = distfix;
    state.distbits = 5;
  }

  /*
   Update the window with the last wsize (normally 32K) bytes written before
   returning.  If window does not exist yet, create it.  This is only called
   when a window is already in use, or when output has been written during this
   inflate call, but the end of the deflate stream has not been reached yet.
   It is also called to create a window for dictionary data when a dictionary
   is loaded.
  
   Providing output buffers larger than 32K to inflate() should provide a speed
   advantage, since only the last 32K of output is copied to the sliding window
   upon return from inflate(), and since all distances after the first 32K of
   output will fall in the output data, making match copies simpler and faster.
   The advantage may be dependent on the size of the processor's data caches.
   */
  function updatewindow(strm, src, end, copy) {
    var dist;
    var state = strm.state;

    /* if it hasn't been done already, allocate space for the window */
    if (state.window === null) {
      state.wsize = 1 << state.wbits;
      state.wnext = 0;
      state.whave = 0;

      state.window = new utils.Buf8(state.wsize);
    }

    /* copy state->wsize or less output bytes into the circular window */
    if (copy >= state.wsize) {
      utils.arraySet(state.window, src, end - state.wsize, state.wsize, 0);
      state.wnext = 0;
      state.whave = state.wsize;
    } else {
      dist = state.wsize - state.wnext;
      if (dist > copy) {
        dist = copy;
      }
      //zmemcpy(state->window + state->wnext, end - copy, dist);
      utils.arraySet(state.window, src, end - copy, dist, state.wnext);
      copy -= dist;
      if (copy) {
        //zmemcpy(state->window, end - copy, copy);
        utils.arraySet(state.window, src, end - copy, copy, 0);
        state.wnext = copy;
        state.whave = state.wsize;
      } else {
        state.wnext += dist;
        if (state.wnext === state.wsize) {
          state.wnext = 0;
        }
        if (state.whave < state.wsize) {
          state.whave += dist;
        }
      }
    }
    return 0;
  }

  function inflate(strm, flush) {
    var state;
    var input, output; // input/output buffers
    var next; /* next input INDEX */
    var put; /* next output INDEX */
    var have, left; /* available input and output */
    var hold; /* bit buffer */
    var bits; /* bits in bit buffer */
    var _in, _out; /* save starting available input and output */
    var copy; /* number of stored or match bytes to copy */
    var from; /* where to copy match bytes from */
    var from_source;
    var here = 0; /* current decoding table entry */
    var here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
    //var last;                   /* parent table entry */
    var last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
    var len; /* length to copy for repeats, bits to drop */
    var ret; /* return code */
    var hbuf = new utils.Buf8(4); /* buffer for gzip header crc calculation */
    var opts;

    var n; // temporary var for NEED_BITS

    var order = /* permutation of code lengths */
    [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];

    if (!strm || !strm.state || !strm.output || !strm.input && strm.avail_in !== 0) {
      return Z_STREAM_ERROR;
    }

    state = strm.state;
    if (state.mode === TYPE) {
      state.mode = TYPEDO;
    } /* skip check */

    //--- LOAD() ---
    put = strm.next_out;
    output = strm.output;
    left = strm.avail_out;
    next = strm.next_in;
    input = strm.input;
    have = strm.avail_in;
    hold = state.hold;
    bits = state.bits;
    //---

    _in = have;
    _out = left;
    ret = Z_OK;

    inf_leave: // goto emulation
    for (;;) {
      switch (state.mode) {
        case HEAD:
          if (state.wrap === 0) {
            state.mode = TYPEDO;
            break;
          }
          //=== NEEDBITS(16);
          while (bits < 16) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.wrap & 2 && hold === 0x8b1f) {
            /* gzip header */
            state.check = 0 /*crc32(0L, Z_NULL, 0)*/;
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = hold >>> 8 & 0xff;
            state.check = (0, _crc2.default)(state.check, hbuf, 2, 0);
            //===//

            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = FLAGS;
            break;
          }
          state.flags = 0; /* expect zlib header */
          if (state.head) {
            state.head.done = false;
          }
          if (!(state.wrap & 1) || /* check if zlib header allowed */
          (((hold & 0xff) << /*BITS(8)*/8) + (hold >> 8)) % 31) {
            strm.msg = 'incorrect header check';
            state.mode = BAD;
            break;
          }
          if ((hold & 0x0f) !== /*BITS(4)*/Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
          len = (hold & 0x0f) + /*BITS(4)*/8;
          if (state.wbits === 0) {
            state.wbits = len;
          } else if (len > state.wbits) {
            strm.msg = 'invalid window size';
            state.mode = BAD;
            break;
          }
          state.dmax = 1 << len;
          //Tracev((stderr, "inflate:   zlib header ok\n"));
          strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/;
          state.mode = hold & 0x200 ? DICTID : TYPE;
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          break;
        case FLAGS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.flags = hold;
          if ((state.flags & 0xff) !== Z_DEFLATED) {
            strm.msg = 'unknown compression method';
            state.mode = BAD;
            break;
          }
          if (state.flags & 0xe000) {
            strm.msg = 'unknown header flags set';
            state.mode = BAD;
            break;
          }
          if (state.head) {
            state.head.text = hold >> 8 & 1;
          }
          if (state.flags & 0x0200) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = hold >>> 8 & 0xff;
            state.check = (0, _crc2.default)(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = TIME;
        /* falls through */
        case TIME:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.time = hold;
          }
          if (state.flags & 0x0200) {
            //=== CRC4(state.check, hold)
            hbuf[0] = hold & 0xff;
            hbuf[1] = hold >>> 8 & 0xff;
            hbuf[2] = hold >>> 16 & 0xff;
            hbuf[3] = hold >>> 24 & 0xff;
            state.check = (0, _crc2.default)(state.check, hbuf, 4, 0);
            //===
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = OS;
        /* falls through */
        case OS:
          //=== NEEDBITS(16); */
          while (bits < 16) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if (state.head) {
            state.head.xflags = hold & 0xff;
            state.head.os = hold >> 8;
          }
          if (state.flags & 0x0200) {
            //=== CRC2(state.check, hold);
            hbuf[0] = hold & 0xff;
            hbuf[1] = hold >>> 8 & 0xff;
            state.check = (0, _crc2.default)(state.check, hbuf, 2, 0);
            //===//
          }
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = EXLEN;
        /* falls through */
        case EXLEN:
          if (state.flags & 0x0400) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length = hold;
            if (state.head) {
              state.head.extra_len = hold;
            }
            if (state.flags & 0x0200) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = hold >>> 8 & 0xff;
              state.check = (0, _crc2.default)(state.check, hbuf, 2, 0);
              //===//
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          } else if (state.head) {
            state.head.extra = null /*Z_NULL*/;
          }
          state.mode = EXTRA;
        /* falls through */
        case EXTRA:
          if (state.flags & 0x0400) {
            copy = state.length;
            if (copy > have) {
              copy = have;
            }
            if (copy) {
              if (state.head) {
                len = state.head.extra_len - state.length;
                if (!state.head.extra) {
                  // Use untyped array for more conveniend processing later
                  state.head.extra = new Array(state.head.extra_len);
                }
                utils.arraySet(state.head.extra, input, next,
                // extra field is limited to 65536 bytes
                // - no need for additional size check
                copy,
                /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                len);
                //zmemcpy(state.head.extra + len, next,
                //        len + copy > state.head.extra_max ?
                //        state.head.extra_max - len : copy);
              }
              if (state.flags & 0x0200) {
                state.check = (0, _crc2.default)(state.check, input, copy, next);
              }
              have -= copy;
              next += copy;
              state.length -= copy;
            }
            if (state.length) {
              break inf_leave;
            }
          }
          state.length = 0;
          state.mode = NAME;
        /* falls through */
        case NAME:
          if (state.flags & 0x0800) {
            if (have === 0) {
              break inf_leave;
            }
            copy = 0;
            do {
              // TODO: 2 or 1 bytes?
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len && state.length < 65536 /*state.head.name_max*/) {
                state.head.name += String.fromCharCode(len);
              }
            } while (len && copy < have);

            if (state.flags & 0x0200) {
              state.check = (0, _crc2.default)(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) {
              break inf_leave;
            }
          } else if (state.head) {
            state.head.name = null;
          }
          state.length = 0;
          state.mode = COMMENT;
        /* falls through */
        case COMMENT:
          if (state.flags & 0x1000) {
            if (have === 0) {
              break inf_leave;
            }
            copy = 0;
            do {
              len = input[next + copy++];
              /* use constant limit because in js we should not preallocate memory */
              if (state.head && len && state.length < 65536 /*state.head.comm_max*/) {
                state.head.comment += String.fromCharCode(len);
              }
            } while (len && copy < have);
            if (state.flags & 0x0200) {
              state.check = (0, _crc2.default)(state.check, input, copy, next);
            }
            have -= copy;
            next += copy;
            if (len) {
              break inf_leave;
            }
          } else if (state.head) {
            state.head.comment = null;
          }
          state.mode = HCRC;
        /* falls through */
        case HCRC:
          if (state.flags & 0x0200) {
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if (hold !== (state.check & 0xffff)) {
              strm.msg = 'header crc mismatch';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
          }
          if (state.head) {
            state.head.hcrc = state.flags >> 9 & 1;
            state.head.done = true;
          }
          strm.adler = state.check = 0;
          state.mode = TYPE;
          break;
        case DICTID:
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          strm.adler = state.check = zswap32(hold);
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = DICT;
        /* falls through */
        case DICT:
          if (state.havedict === 0) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            return Z_NEED_DICT;
          }
          strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/;
          state.mode = TYPE;
        /* falls through */
        case TYPE:
          if (flush === Z_BLOCK || flush === Z_TREES) {
            break inf_leave;
          }
        /* falls through */
        case TYPEDO:
          if (state.last) {
            //--- BYTEBITS() ---//
            hold >>>= bits & 7;
            bits -= bits & 7;
            //---//
            state.mode = CHECK;
            break;
          }
          //=== NEEDBITS(3); */
          while (bits < 3) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.last = hold & 0x01 /*BITS(1)*/;
          //--- DROPBITS(1) ---//
          hold >>>= 1;
          bits -= 1;
          //---//

          switch (hold & 0x03) {/*BITS(2)*/case 0:
              /* stored block */
              //Tracev((stderr, "inflate:     stored block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = STORED;
              break;
            case 1:
              /* fixed block */
              fixedtables(state);
              //Tracev((stderr, "inflate:     fixed codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = LEN_; /* decode codes */
              if (flush === Z_TREES) {
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
                break inf_leave;
              }
              break;
            case 2:
              /* dynamic block */
              //Tracev((stderr, "inflate:     dynamic codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = TABLE;
              break;
            case 3:
              strm.msg = 'invalid block type';
              state.mode = BAD;
          }
          //--- DROPBITS(2) ---//
          hold >>>= 2;
          bits -= 2;
          //---//
          break;
        case STORED:
          //--- BYTEBITS() ---// /* go to byte boundary */
          hold >>>= bits & 7;
          bits -= bits & 7;
          //---//
          //=== NEEDBITS(32); */
          while (bits < 32) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          if ((hold & 0xffff) !== (hold >>> 16 ^ 0xffff)) {
            strm.msg = 'invalid stored block lengths';
            state.mode = BAD;
            break;
          }
          state.length = hold & 0xffff;
          //Tracev((stderr, "inflate:       stored length %u\n",
          //        state.length));
          //=== INITBITS();
          hold = 0;
          bits = 0;
          //===//
          state.mode = COPY_;
          if (flush === Z_TREES) {
            break inf_leave;
          }
        /* falls through */
        case COPY_:
          state.mode = COPY;
        /* falls through */
        case COPY:
          copy = state.length;
          if (copy) {
            if (copy > have) {
              copy = have;
            }
            if (copy > left) {
              copy = left;
            }
            if (copy === 0) {
              break inf_leave;
            }
            //--- zmemcpy(put, next, copy); ---
            utils.arraySet(output, input, next, copy, put);
            //---//
            have -= copy;
            next += copy;
            left -= copy;
            put += copy;
            state.length -= copy;
            break;
          }
          //Tracev((stderr, "inflate:       stored end\n"));
          state.mode = TYPE;
          break;
        case TABLE:
          //=== NEEDBITS(14); */
          while (bits < 14) {
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
          }
          //===//
          state.nlen = (hold & 0x1f) + /*BITS(5)*/257;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ndist = (hold & 0x1f) + /*BITS(5)*/1;
          //--- DROPBITS(5) ---//
          hold >>>= 5;
          bits -= 5;
          //---//
          state.ncode = (hold & 0x0f) + /*BITS(4)*/4;
          //--- DROPBITS(4) ---//
          hold >>>= 4;
          bits -= 4;
          //---//
          //#ifndef PKZIP_BUG_WORKAROUND
          if (state.nlen > 286 || state.ndist > 30) {
            strm.msg = 'too many length or distance symbols';
            state.mode = BAD;
            break;
          }
          //#endif
          //Tracev((stderr, "inflate:       table sizes ok\n"));
          state.have = 0;
          state.mode = LENLENS;
        /* falls through */
        case LENLENS:
          while (state.have < state.ncode) {
            //=== NEEDBITS(3);
            while (bits < 3) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.lens[order[state.have++]] = hold & 0x07; //BITS(3);
            //--- DROPBITS(3) ---//
            hold >>>= 3;
            bits -= 3;
            //---//
          }
          while (state.have < 19) {
            state.lens[order[state.have++]] = 0;
          }
          // We have separate tables & no pointers. 2 commented lines below not needed.
          //state.next = state.codes;
          //state.lencode = state.next;
          // Switch to use dynamic table
          state.lencode = state.lendyn;
          state.lenbits = 7;

          opts = { bits: state.lenbits };
          ret = (0, _inftrees2.default)(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
          state.lenbits = opts.bits;

          if (ret) {
            strm.msg = 'invalid code lengths set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, "inflate:       code lengths ok\n"));
          state.have = 0;
          state.mode = CODELENS;
        /* falls through */
        case CODELENS:
          while (state.have < state.nlen + state.ndist) {
            for (;;) {
              here = state.lencode[hold & (1 << state.lenbits) - 1]; /*BITS(state.lenbits)*/
              here_bits = here >>> 24;
              here_op = here >>> 16 & 0xff;
              here_val = here & 0xffff;

              if (here_bits <= bits) {
                break;
              }
              //--- PULLBYTE() ---//
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            if (here_val < 16) {
              //--- DROPBITS(here.bits) ---//
              hold >>>= here_bits;
              bits -= here_bits;
              //---//
              state.lens[state.have++] = here_val;
            } else {
              if (here_val === 16) {
                //=== NEEDBITS(here.bits + 2);
                n = here_bits + 2;
                while (bits < n) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                if (state.have === 0) {
                  strm.msg = 'invalid bit length repeat';
                  state.mode = BAD;
                  break;
                }
                len = state.lens[state.have - 1];
                copy = 3 + (hold & 0x03); //BITS(2);
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
              } else if (here_val === 17) {
                //=== NEEDBITS(here.bits + 3);
                n = here_bits + 3;
                while (bits < n) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 3 + (hold & 0x07); //BITS(3);
                //--- DROPBITS(3) ---//
                hold >>>= 3;
                bits -= 3;
                //---//
              } else {
                //=== NEEDBITS(here.bits + 7);
                n = here_bits + 7;
                while (bits < n) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                }
                //===//
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                len = 0;
                copy = 11 + (hold & 0x7f); //BITS(7);
                //--- DROPBITS(7) ---//
                hold >>>= 7;
                bits -= 7;
                //---//
              }
              if (state.have + copy > state.nlen + state.ndist) {
                strm.msg = 'invalid bit length repeat';
                state.mode = BAD;
                break;
              }
              while (copy--) {
                state.lens[state.have++] = len;
              }
            }
          }

          /* handle error breaks in while */
          if (state.mode === BAD) {
            break;
          }

          /* check for end-of-block code (better have one) */
          if (state.lens[256] === 0) {
            strm.msg = 'invalid code -- missing end-of-block';
            state.mode = BAD;
            break;
          }

          /* build code tables -- note: do not change the lenbits or distbits
             values here (9 and 6) without reading the comments in inftrees.h
             concerning the ENOUGH constants, which depend on those values */
          state.lenbits = 9;

          opts = { bits: state.lenbits };
          ret = (0, _inftrees2.default)(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.lenbits = opts.bits;
          // state.lencode = state.next;

          if (ret) {
            strm.msg = 'invalid literal/lengths set';
            state.mode = BAD;
            break;
          }

          state.distbits = 6;
          //state.distcode.copy(state.codes);
          // Switch to use dynamic table
          state.distcode = state.distdyn;
          opts = { bits: state.distbits };
          ret = (0, _inftrees2.default)(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
          // We have separate tables & no pointers. 2 commented lines below not needed.
          // state.next_index = opts.table_index;
          state.distbits = opts.bits;
          // state.distcode = state.next;

          if (ret) {
            strm.msg = 'invalid distances set';
            state.mode = BAD;
            break;
          }
          //Tracev((stderr, 'inflate:       codes ok\n'));
          state.mode = LEN_;
          if (flush === Z_TREES) {
            break inf_leave;
          }
        /* falls through */
        case LEN_:
          state.mode = LEN;
        /* falls through */
        case LEN:
          if (have >= 6 && left >= 258) {
            //--- RESTORE() ---
            strm.next_out = put;
            strm.avail_out = left;
            strm.next_in = next;
            strm.avail_in = have;
            state.hold = hold;
            state.bits = bits;
            //---
            (0, _inffast2.default)(strm, _out);
            //--- LOAD() ---
            put = strm.next_out;
            output = strm.output;
            left = strm.avail_out;
            next = strm.next_in;
            input = strm.input;
            have = strm.avail_in;
            hold = state.hold;
            bits = state.bits;
            //---

            if (state.mode === TYPE) {
              state.back = -1;
            }
            break;
          }
          state.back = 0;
          for (;;) {
            here = state.lencode[hold & (1 << state.lenbits) - 1]; /*BITS(state.lenbits)*/
            here_bits = here >>> 24;
            here_op = here >>> 16 & 0xff;
            here_val = here & 0xffff;

            if (here_bits <= bits) {
              break;
            }
            //--- PULLBYTE() ---//
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if (here_op && (here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.lencode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> /*BITS(last.bits + last.op)*/last_bits)];
              here_bits = here >>> 24;
              here_op = here >>> 16 & 0xff;
              here_val = here & 0xffff;

              if (last_bits + here_bits <= bits) {
                break;
              }
              //--- PULLBYTE() ---//
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          state.length = here_val;
          if (here_op === 0) {
            //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
            //        "inflate:         literal '%c'\n" :
            //        "inflate:         literal 0x%02x\n", here.val));
            state.mode = LIT;
            break;
          }
          if (here_op & 32) {
            //Tracevv((stderr, "inflate:         end of block\n"));
            state.back = -1;
            state.mode = TYPE;
            break;
          }
          if (here_op & 64) {
            strm.msg = 'invalid literal/length code';
            state.mode = BAD;
            break;
          }
          state.extra = here_op & 15;
          state.mode = LENEXT;
        /* falls through */
        case LENEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.length += hold & (1 << state.extra) - 1 /*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
          //Tracevv((stderr, "inflate:         length %u\n", state.length));
          state.was = state.length;
          state.mode = DIST;
        /* falls through */
        case DIST:
          for (;;) {
            here = state.distcode[hold & (1 << state.distbits) - 1]; /*BITS(state.distbits)*/
            here_bits = here >>> 24;
            here_op = here >>> 16 & 0xff;
            here_val = here & 0xffff;

            if (here_bits <= bits) {
              break;
            }
            //--- PULLBYTE() ---//
            if (have === 0) {
              break inf_leave;
            }
            have--;
            hold += input[next++] << bits;
            bits += 8;
            //---//
          }
          if ((here_op & 0xf0) === 0) {
            last_bits = here_bits;
            last_op = here_op;
            last_val = here_val;
            for (;;) {
              here = state.distcode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> /*BITS(last.bits + last.op)*/last_bits)];
              here_bits = here >>> 24;
              here_op = here >>> 16 & 0xff;
              here_val = here & 0xffff;

              if (last_bits + here_bits <= bits) {
                break;
              }
              //--- PULLBYTE() ---//
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            //--- DROPBITS(last.bits) ---//
            hold >>>= last_bits;
            bits -= last_bits;
            //---//
            state.back += last_bits;
          }
          //--- DROPBITS(here.bits) ---//
          hold >>>= here_bits;
          bits -= here_bits;
          //---//
          state.back += here_bits;
          if (here_op & 64) {
            strm.msg = 'invalid distance code';
            state.mode = BAD;
            break;
          }
          state.offset = here_val;
          state.extra = here_op & 15;
          state.mode = DISTEXT;
        /* falls through */
        case DISTEXT:
          if (state.extra) {
            //=== NEEDBITS(state.extra);
            n = state.extra;
            while (bits < n) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.offset += hold & (1 << state.extra) - 1 /*BITS(state.extra)*/;
            //--- DROPBITS(state.extra) ---//
            hold >>>= state.extra;
            bits -= state.extra;
            //---//
            state.back += state.extra;
          }
          //#ifdef INFLATE_STRICT
          if (state.offset > state.dmax) {
            strm.msg = 'invalid distance too far back';
            state.mode = BAD;
            break;
          }
          //#endif
          //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
          state.mode = MATCH;
        /* falls through */
        case MATCH:
          if (left === 0) {
            break inf_leave;
          }
          copy = _out - left;
          if (state.offset > copy) {
            /* copy from window */
            copy = state.offset - copy;
            if (copy > state.whave) {
              if (state.sane) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD;
                break;
              }
              // (!) This block is disabled in zlib defailts,
              // don't enable it for binary compatibility
              //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
              //          Trace((stderr, "inflate.c too far\n"));
              //          copy -= state.whave;
              //          if (copy > state.length) { copy = state.length; }
              //          if (copy > left) { copy = left; }
              //          left -= copy;
              //          state.length -= copy;
              //          do {
              //            output[put++] = 0;
              //          } while (--copy);
              //          if (state.length === 0) { state.mode = LEN; }
              //          break;
              //#endif
            }
            if (copy > state.wnext) {
              copy -= state.wnext;
              from = state.wsize - copy;
            } else {
              from = state.wnext - copy;
            }
            if (copy > state.length) {
              copy = state.length;
            }
            from_source = state.window;
          } else {
            /* copy from output */
            from_source = output;
            from = put - state.offset;
            copy = state.length;
          }
          if (copy > left) {
            copy = left;
          }
          left -= copy;
          state.length -= copy;
          do {
            output[put++] = from_source[from++];
          } while (--copy);
          if (state.length === 0) {
            state.mode = LEN;
          }
          break;
        case LIT:
          if (left === 0) {
            break inf_leave;
          }
          output[put++] = state.length;
          left--;
          state.mode = LEN;
          break;
        case CHECK:
          if (state.wrap) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              // Use '|' insdead of '+' to make sure that result is signed
              hold |= input[next++] << bits;
              bits += 8;
            }
            //===//
            _out -= left;
            strm.total_out += _out;
            state.total += _out;
            if (_out) {
              strm.adler = state.check =
              /*UPDATE(state.check, put - _out, _out);*/
              state.flags ? (0, _crc2.default)(state.check, output, _out, put - _out) : (0, _adler2.default)(state.check, output, _out, put - _out);
            }
            _out = left;
            // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
            if ((state.flags ? hold : zswap32(hold)) !== state.check) {
              strm.msg = 'incorrect data check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   check matches trailer\n"));
          }
          state.mode = LENGTH;
        /* falls through */
        case LENGTH:
          if (state.wrap && state.flags) {
            //=== NEEDBITS(32);
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if (hold !== (state.total & 0xffffffff)) {
              strm.msg = 'incorrect length check';
              state.mode = BAD;
              break;
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            //Tracev((stderr, "inflate:   length matches trailer\n"));
          }
          state.mode = DONE;
        /* falls through */
        case DONE:
          ret = Z_STREAM_END;
          break inf_leave;
        case BAD:
          ret = Z_DATA_ERROR;
          break inf_leave;
        case MEM:
          return Z_MEM_ERROR;
        case SYNC:
        /* falls through */
        default:
          return Z_STREAM_ERROR;
      }
    }

    // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

    /*
       Return from inflate(), updating the total counts and the check value.
       If there was no progress during the inflate() call, return a buffer
       error.  Call updatewindow() to create and/or update the window state.
       Note: a memory error from inflate() is non-recoverable.
     */

    //--- RESTORE() ---
    strm.next_out = put;
    strm.avail_out = left;
    strm.next_in = next;
    strm.avail_in = have;
    state.hold = hold;
    state.bits = bits;
    //---

    if (state.wsize || _out !== strm.avail_out && state.mode < BAD && (state.mode < CHECK || flush !== Z_FINISH)) {
      if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) {
        state.mode = MEM;
        return Z_MEM_ERROR;
      }
    }
    _in -= strm.avail_in;
    _out -= strm.avail_out;
    strm.total_in += _in;
    strm.total_out += _out;
    state.total += _out;
    if (state.wrap && _out) {
      strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/
      state.flags ? (0, _crc2.default)(state.check, output, _out, strm.next_out - _out) : (0, _adler2.default)(state.check, output, _out, strm.next_out - _out);
    }
    strm.data_type = state.bits + (state.last ? 64 : 0) + (state.mode === TYPE ? 128 : 0) + (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
    if ((_in === 0 && _out === 0 || flush === Z_FINISH) && ret === Z_OK) {
      ret = Z_BUF_ERROR;
    }
    return ret;
  }

  function inflateEnd(strm) {

    if (!strm || !strm.state /*|| strm->zfree == (free_func)0*/) {
        return Z_STREAM_ERROR;
      }

    var state = strm.state;
    if (state.window) {
      state.window = null;
    }
    strm.state = null;
    return Z_OK;
  }

  function inflateGetHeader(strm, head) {
    var state;

    /* check state */
    if (!strm || !strm.state) {
      return Z_STREAM_ERROR;
    }
    state = strm.state;
    if ((state.wrap & 2) === 0) {
      return Z_STREAM_ERROR;
    }

    /* save header structure */
    state.head = head;
    head.done = false;
    return Z_OK;
  }

  function inflateSetDictionary(strm, dictionary) {
    var dictLength = dictionary.length;

    var state;
    var dictid;
    var ret;

    /* check state */
    if (!strm /* == Z_NULL */ || !strm.state /* == Z_NULL */) {
        return Z_STREAM_ERROR;
      }
    state = strm.state;

    if (state.wrap !== 0 && state.mode !== DICT) {
      return Z_STREAM_ERROR;
    }

    /* check for correct dictionary identifier */
    if (state.mode === DICT) {
      dictid = 1; /* adler32(0, null, 0)*/
      /* dictid = adler32(dictid, dictionary, dictLength); */
      dictid = (0, _adler2.default)(dictid, dictionary, dictLength, 0);
      if (dictid !== state.check) {
        return Z_DATA_ERROR;
      }
    }
    /* copy dictionary to window using updatewindow(), which will amend the
     existing dictionary if appropriate */
    ret = updatewindow(strm, dictionary, dictLength, dictLength);
    if (ret) {
      state.mode = MEM;
      return Z_MEM_ERROR;
    }
    state.havedict = 1;
    // Tracev((stderr, "inflate:   dictionary set\n"));
    return Z_OK;
  }

  exports.inflateReset = inflateReset;
  exports.inflateReset2 = inflateReset2;
  exports.inflateResetKeep = inflateResetKeep;
  exports.inflateInit = inflateInit;
  exports.inflateInit2 = inflateInit2;
  exports.inflate = inflate;
  exports.inflateEnd = inflateEnd;
  exports.inflateGetHeader = inflateGetHeader;
  exports.inflateSetDictionary = inflateSetDictionary;
  var inflateInfo = exports.inflateInfo = 'pako inflate (from Nodeca project)';

  /* Not implemented
  exports.inflateCopy = inflateCopy;
  exports.inflateGetDictionary = inflateGetDictionary;
  exports.inflateMark = inflateMark;
  exports.inflatePrime = inflatePrime;
  exports.inflateSync = inflateSync;
  exports.inflateSyncPoint = inflateSyncPoint;
  exports.inflateUndermine = inflateUndermine;
  */
});
define('../bower_components/no-vnc/lib/vendor/pako/lib/zlib/zstream.js',['exports'], function (exports) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = ZStream;
  function ZStream() {
    /* next input byte */
    this.input = null; // JS specific, because we have no pointers
    this.next_in = 0;
    /* number of bytes available at input */
    this.avail_in = 0;
    /* total number of input bytes read so far */
    this.total_in = 0;
    /* next output byte should be put there */
    this.output = null; // JS specific, because we have no pointers
    this.next_out = 0;
    /* remaining free space at output */
    this.avail_out = 0;
    /* total number of bytes output so far */
    this.total_out = 0;
    /* last error message, NULL if no error */
    this.msg = '' /*Z_NULL*/;
    /* not visible by applications */
    this.state = null;
    /* best guess about the data type: binary or text */
    this.data_type = 2 /*Z_UNKNOWN*/;
    /* adler32 value of the uncompressed data */
    this.adler = 0;
  }
});
define('../bower_components/no-vnc/lib/inflator.js',["exports", "../lib/vendor/pako/lib/zlib/inflate.js", "../lib/vendor/pako/lib/zlib/zstream.js"], function (exports, _inflate2, _zstream) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _zstream2 = _interopRequireDefault(_zstream);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var Inflate = function () {
        function Inflate() {
            _classCallCheck(this, Inflate);

            this.strm = new _zstream2.default();
            this.chunkSize = 1024 * 10 * 10;
            this.strm.output = new Uint8Array(this.chunkSize);
            this.windowBits = 5;

            (0, _inflate2.inflateInit)(this.strm, this.windowBits);
        }

        _createClass(Inflate, [{
            key: "inflate",
            value: function inflate(data, flush, expected) {
                this.strm.input = data;
                this.strm.avail_in = this.strm.input.length;
                this.strm.next_in = 0;
                this.strm.next_out = 0;

                // resize our output buffer if it's too small
                // (we could just use multiple chunks, but that would cause an extra
                // allocation each time to flatten the chunks)
                if (expected > this.chunkSize) {
                    this.chunkSize = expected;
                    this.strm.output = new Uint8Array(this.chunkSize);
                }

                this.strm.avail_out = this.chunkSize;

                (0, _inflate2.inflate)(this.strm, flush);

                return new Uint8Array(this.strm.output.buffer, 0, this.strm.next_out);
            }
        }, {
            key: "reset",
            value: function reset() {
                (0, _inflate2.inflateReset)(this.strm);
            }
        }]);

        return Inflate;
    }();

    exports.default = Inflate;
});
define('../bower_components/no-vnc/lib/decoders/tight.js',["exports", "../util/logging.js", "../inflator.js"], function (exports, _logging, _inflator) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    var _inflator2 = _interopRequireDefault(_inflator);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var TightDecoder = function () {
        function TightDecoder() {
            _classCallCheck(this, TightDecoder);

            this._ctl = null;
            this._filter = null;
            this._numColors = 0;
            this._palette = new Uint8Array(1024); // 256 * 4 (max palette size * max bytes-per-pixel)
            this._len = 0;

            this._zlibs = [];
            for (var i = 0; i < 4; i++) {
                this._zlibs[i] = new _inflator2.default();
            }
        }

        _createClass(TightDecoder, [{
            key: "decodeRect",
            value: function decodeRect(x, y, width, height, sock, display, depth) {
                if (this._ctl === null) {
                    if (sock.rQwait("TIGHT compression-control", 1)) {
                        return false;
                    }

                    this._ctl = sock.rQshift8();

                    // Reset streams if the server requests it
                    for (var i = 0; i < 4; i++) {
                        if (this._ctl >> i & 1) {
                            this._zlibs[i].reset();
                            Log.Info("Reset zlib stream " + i);
                        }
                    }

                    // Figure out filter
                    this._ctl = this._ctl >> 4;
                }

                var ret = void 0;

                if (this._ctl === 0x08) {
                    ret = this._fillRect(x, y, width, height, sock, display, depth);
                } else if (this._ctl === 0x09) {
                    ret = this._jpegRect(x, y, width, height, sock, display, depth);
                } else if (this._ctl === 0x0A) {
                    ret = this._pngRect(x, y, width, height, sock, display, depth);
                } else if ((this._ctl & 0x80) == 0) {
                    ret = this._basicRect(this._ctl, x, y, width, height, sock, display, depth);
                } else {
                    throw new Error("Illegal tight compression received (ctl: " + this._ctl + ")");
                }

                if (ret) {
                    this._ctl = null;
                }

                return ret;
            }
        }, {
            key: "_fillRect",
            value: function _fillRect(x, y, width, height, sock, display, depth) {
                if (sock.rQwait("TIGHT", 3)) {
                    return false;
                }

                var rQi = sock.rQi;
                var rQ = sock.rQ;

                display.fillRect(x, y, width, height, [rQ[rQi + 2], rQ[rQi + 1], rQ[rQi]], false);
                sock.rQskipBytes(3);

                return true;
            }
        }, {
            key: "_jpegRect",
            value: function _jpegRect(x, y, width, height, sock, display, depth) {
                var data = this._readData(sock);
                if (data === null) {
                    return false;
                }

                display.imageRect(x, y, "image/jpeg", data);

                return true;
            }
        }, {
            key: "_pngRect",
            value: function _pngRect(x, y, width, height, sock, display, depth) {
                throw new Error("PNG received in standard Tight rect");
            }
        }, {
            key: "_basicRect",
            value: function _basicRect(ctl, x, y, width, height, sock, display, depth) {
                if (this._filter === null) {
                    if (ctl & 0x4) {
                        if (sock.rQwait("TIGHT", 1)) {
                            return false;
                        }

                        this._filter = sock.rQshift8();
                    } else {
                        // Implicit CopyFilter
                        this._filter = 0;
                    }
                }

                var streamId = ctl & 0x3;

                var ret = void 0;

                switch (this._filter) {
                    case 0:
                        // CopyFilter
                        ret = this._copyFilter(streamId, x, y, width, height, sock, display, depth);
                        break;
                    case 1:
                        // PaletteFilter
                        ret = this._paletteFilter(streamId, x, y, width, height, sock, display, depth);
                        break;
                    case 2:
                        // GradientFilter
                        ret = this._gradientFilter(streamId, x, y, width, height, sock, display, depth);
                        break;
                    default:
                        throw new Error("Illegal tight filter received (ctl: " + this._filter + ")");
                }

                if (ret) {
                    this._filter = null;
                }

                return ret;
            }
        }, {
            key: "_copyFilter",
            value: function _copyFilter(streamId, x, y, width, height, sock, display, depth) {
                var uncompressedSize = width * height * 3;
                var data = void 0;

                if (uncompressedSize < 12) {
                    if (sock.rQwait("TIGHT", uncompressedSize)) {
                        return false;
                    }

                    data = sock.rQshiftBytes(uncompressedSize);
                } else {
                    data = this._readData(sock);
                    if (data === null) {
                        return false;
                    }

                    data = this._zlibs[streamId].inflate(data, true, uncompressedSize);
                    if (data.length != uncompressedSize) {
                        throw new Error("Incomplete zlib block");
                    }
                }

                display.blitRgbImage(x, y, width, height, data, 0, false);

                return true;
            }
        }, {
            key: "_paletteFilter",
            value: function _paletteFilter(streamId, x, y, width, height, sock, display, depth) {
                if (this._numColors === 0) {
                    if (sock.rQwait("TIGHT palette", 1)) {
                        return false;
                    }

                    var numColors = sock.rQpeek8() + 1;
                    var paletteSize = numColors * 3;

                    if (sock.rQwait("TIGHT palette", 1 + paletteSize)) {
                        return false;
                    }

                    this._numColors = numColors;
                    sock.rQskipBytes(1);

                    sock.rQshiftTo(this._palette, paletteSize);
                }

                var bpp = this._numColors <= 2 ? 1 : 8;
                var rowSize = Math.floor((width * bpp + 7) / 8);
                var uncompressedSize = rowSize * height;

                var data = void 0;

                if (uncompressedSize < 12) {
                    if (sock.rQwait("TIGHT", uncompressedSize)) {
                        return false;
                    }

                    data = sock.rQshiftBytes(uncompressedSize);
                } else {
                    data = this._readData(sock);
                    if (data === null) {
                        return false;
                    }

                    data = this._zlibs[streamId].inflate(data, true, uncompressedSize);
                    if (data.length != uncompressedSize) {
                        throw new Error("Incomplete zlib block");
                    }
                }

                // Convert indexed (palette based) image data to RGB
                if (this._numColors == 2) {
                    this._monoRect(x, y, width, height, data, this._palette, display);
                } else {
                    this._paletteRect(x, y, width, height, data, this._palette, display);
                }

                this._numColors = 0;

                return true;
            }
        }, {
            key: "_monoRect",
            value: function _monoRect(x, y, width, height, data, palette, display) {
                // Convert indexed (palette based) image data to RGB
                // TODO: reduce number of calculations inside loop
                var dest = this._getScratchBuffer(width * height * 4);
                var w = Math.floor((width + 7) / 8);
                var w1 = Math.floor(width / 8);

                for (var _y = 0; _y < height; _y++) {
                    var dp = void 0,
                        sp = void 0,
                        _x = void 0;
                    for (_x = 0; _x < w1; _x++) {
                        for (var b = 7; b >= 0; b--) {
                            dp = (_y * width + _x * 8 + 7 - b) * 4;
                            sp = (data[_y * w + _x] >> b & 1) * 3;
                            dest[dp] = palette[sp];
                            dest[dp + 1] = palette[sp + 1];
                            dest[dp + 2] = palette[sp + 2];
                            dest[dp + 3] = 255;
                        }
                    }

                    for (var _b = 7; _b >= 8 - width % 8; _b--) {
                        dp = (_y * width + _x * 8 + 7 - _b) * 4;
                        sp = (data[_y * w + _x] >> _b & 1) * 3;
                        dest[dp] = palette[sp];
                        dest[dp + 1] = palette[sp + 1];
                        dest[dp + 2] = palette[sp + 2];
                        dest[dp + 3] = 255;
                    }
                }

                display.blitRgbxImage(x, y, width, height, dest, 0, false);
            }
        }, {
            key: "_paletteRect",
            value: function _paletteRect(x, y, width, height, data, palette, display) {
                // Convert indexed (palette based) image data to RGB
                var dest = this._getScratchBuffer(width * height * 4);
                var total = width * height * 4;
                for (var i = 0, j = 0; i < total; i += 4, j++) {
                    var sp = data[j] * 3;
                    dest[i] = palette[sp];
                    dest[i + 1] = palette[sp + 1];
                    dest[i + 2] = palette[sp + 2];
                    dest[i + 3] = 255;
                }

                display.blitRgbxImage(x, y, width, height, dest, 0, false);
            }
        }, {
            key: "_gradientFilter",
            value: function _gradientFilter(streamId, x, y, width, height, sock, display, depth) {
                throw new Error("Gradient filter not implemented");
            }
        }, {
            key: "_readData",
            value: function _readData(sock) {
                if (this._len === 0) {
                    if (sock.rQwait("TIGHT", 3)) {
                        return null;
                    }

                    var byte = void 0;

                    byte = sock.rQshift8();
                    this._len = byte & 0x7f;
                    if (byte & 0x80) {
                        byte = sock.rQshift8();
                        this._len |= (byte & 0x7f) << 7;
                        if (byte & 0x80) {
                            byte = sock.rQshift8();
                            this._len |= byte << 14;
                        }
                    }
                }

                if (sock.rQwait("TIGHT", this._len)) {
                    return null;
                }

                var data = sock.rQshiftBytes(this._len);
                this._len = 0;

                return data;
            }
        }, {
            key: "_getScratchBuffer",
            value: function _getScratchBuffer(size) {
                if (!this._scratchBuffer || this._scratchBuffer.length < size) {
                    this._scratchBuffer = new Uint8Array(size);
                }
                return this._scratchBuffer;
            }
        }]);

        return TightDecoder;
    }();

    exports.default = TightDecoder;
});
define('../bower_components/no-vnc/lib/decoders/tightpng.js',["exports", "./tight.js"], function (exports, _tight) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _tight2 = _interopRequireDefault(_tight);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var TightPNGDecoder = function (_TightDecoder) {
        _inherits(TightPNGDecoder, _TightDecoder);

        function TightPNGDecoder() {
            _classCallCheck(this, TightPNGDecoder);

            return _possibleConstructorReturn(this, (TightPNGDecoder.__proto__ || Object.getPrototypeOf(TightPNGDecoder)).apply(this, arguments));
        }

        _createClass(TightPNGDecoder, [{
            key: "_pngRect",
            value: function _pngRect(x, y, width, height, sock, display, depth) {
                var data = this._readData(sock);
                if (data === null) {
                    return false;
                }

                display.imageRect(x, y, "image/png", data);

                return true;
            }
        }, {
            key: "_basicRect",
            value: function _basicRect(ctl, x, y, width, height, sock, display, depth) {
                throw new Error("BasicCompression received in TightPNG rect");
            }
        }]);

        return TightPNGDecoder;
    }(_tight2.default);

    exports.default = TightPNGDecoder;
});
define('../bower_components/no-vnc/lib/util/polyfill.js',[], function () {
    'use strict';

    /*
     * noVNC: HTML5 VNC client
     * Copyright (C) 2018 The noVNC Authors
     * Licensed under MPL 2.0 or any later version (see LICENSE.txt)
     */

    /* Polyfills to provide new APIs in old browsers */

    /* Object.assign() (taken from MDN) */
    if (typeof Object.assign != 'function') {
        // Must be writable: true, enumerable: false, configurable: true
        Object.defineProperty(Object, "assign", {
            value: function assign(target, varArgs) {
                // .length of function is 2
                'use strict';

                if (target == null) {
                    // TypeError if undefined or null
                    throw new TypeError('Cannot convert undefined or null to object');
                }

                var to = Object(target);

                for (var index = 1; index < arguments.length; index++) {
                    var nextSource = arguments[index];

                    if (nextSource != null) {
                        // Skip over if undefined or null
                        for (var nextKey in nextSource) {
                            // Avoid bugs when hasOwnProperty is shadowed
                            if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                                to[nextKey] = nextSource[nextKey];
                            }
                        }
                    }
                }
                return to;
            },
            writable: true,
            configurable: true
        });
    }

    /* CustomEvent constructor (taken from MDN) */
    (function () {
        function CustomEvent(event, params) {
            params = params || { bubbles: false, cancelable: false, detail: undefined };
            var evt = document.createEvent('CustomEvent');
            evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);
            return evt;
        }

        CustomEvent.prototype = window.Event.prototype;

        if (typeof window.CustomEvent !== "function") {
            window.CustomEvent = CustomEvent;
        }
    })();
});
define('vnc-rfb',['exports', '../bower_components/no-vnc/lib/util/logging.js', '../bower_components/no-vnc/lib/util/strings.js', '../bower_components/no-vnc/lib/util/browser.js', '../bower_components/no-vnc/lib/util/eventtarget.js', '../bower_components/no-vnc/lib/display.js', '../bower_components/no-vnc/lib/input/keyboard.js', '../bower_components/no-vnc/lib/input/mouse.js', '../bower_components/no-vnc/lib/util/cursor.js', '../bower_components/no-vnc/lib/websock.js', '../bower_components/no-vnc/lib/des.js', '../bower_components/no-vnc/lib/input/keysym.js', '../bower_components/no-vnc/lib/input/xtscancodes.js', '../bower_components/no-vnc/lib/encodings.js', '../bower_components/no-vnc/lib/decoders/raw.js', '../bower_components/no-vnc/lib/decoders/copyrect.js', '../bower_components/no-vnc/lib/decoders/rre.js', '../bower_components/no-vnc/lib/decoders/hextile.js', '../bower_components/no-vnc/lib/decoders/tight.js', '../bower_components/no-vnc/lib/decoders/tightpng.js', '../bower_components/no-vnc/lib/util/polyfill.js'], function (exports, _logging, _strings, _browser, _eventtarget, _display, _keyboard, _mouse, _cursor, _websock, _des, _keysym, _xtscancodes, _encodings, _raw, _copyrect, _rre, _hextile, _tight, _tightpng) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var Log = _interopRequireWildcard(_logging);

    var _eventtarget2 = _interopRequireDefault(_eventtarget);

    var _display2 = _interopRequireDefault(_display);

    var _keyboard2 = _interopRequireDefault(_keyboard);

    var _mouse2 = _interopRequireDefault(_mouse);

    var _cursor2 = _interopRequireDefault(_cursor);

    var _websock2 = _interopRequireDefault(_websock);

    var _des2 = _interopRequireDefault(_des);

    var _keysym2 = _interopRequireDefault(_keysym);

    var _xtscancodes2 = _interopRequireDefault(_xtscancodes);

    var _raw2 = _interopRequireDefault(_raw);

    var _copyrect2 = _interopRequireDefault(_copyrect);

    var _rre2 = _interopRequireDefault(_rre);

    var _hextile2 = _interopRequireDefault(_hextile);

    var _tight2 = _interopRequireDefault(_tight);

    var _tightpng2 = _interopRequireDefault(_tightpng);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    // How many seconds to wait for a disconnect to finish
    var DISCONNECT_TIMEOUT = 3;
    var DEFAULT_BACKGROUND = 'rgb(40, 40, 40)';

    var RFB = function (_EventTargetMixin) {
        _inherits(RFB, _EventTargetMixin);

        function RFB(target, url, options) {
            _classCallCheck(this, RFB);

            if (!target) {
                throw new Error("Must specify target");
            }
            if (!url) {
                throw new Error("Must specify URL");
            }

            var _this = _possibleConstructorReturn(this, (RFB.__proto__ || Object.getPrototypeOf(RFB)).call(this));

            _this._target = target;
            _this._url = url;

            // Connection details
            options = options || {};
            _this._rfb_credentials = options.credentials || {};
            _this._shared = 'shared' in options ? !!options.shared : true;
            _this._repeaterID = options.repeaterID || '';
            _this._showDotCursor = options.showDotCursor || false;

            // Internal state
            _this._rfb_connection_state = '';
            _this._rfb_init_state = '';
            _this._rfb_auth_scheme = -1;
            _this._rfb_clean_disconnect = true;

            // Server capabilities
            _this._rfb_version = 0;
            _this._rfb_max_version = 3.8;
            _this._rfb_tightvnc = false;
            _this._rfb_xvp_ver = 0;

            _this._fb_width = 0;
            _this._fb_height = 0;

            _this._fb_name = "";

            _this._capabilities = { power: false };

            _this._supportsFence = false;

            _this._supportsContinuousUpdates = false;
            _this._enabledContinuousUpdates = false;

            _this._supportsSetDesktopSize = false;
            _this._screen_id = 0;
            _this._screen_flags = 0;

            _this._qemuExtKeyEventSupported = false;

            // Internal objects
            _this._sock = null; // Websock object
            _this._display = null; // Display object
            _this._flushing = false; // Display flushing state
            _this._keyboard = null; // Keyboard input handler object
            _this._mouse = null; // Mouse input handler object

            // Timers
            _this._disconnTimer = null; // disconnection timer
            _this._resizeTimeout = null; // resize rate limiting

            // Decoder states
            _this._decoders = {};

            _this._FBU = {
                rects: 0,
                x: 0,
                y: 0,
                width: 0,
                height: 0,
                encoding: null
            };

            // Mouse state
            _this._mouse_buttonMask = 0;
            _this._mouse_arr = [];
            _this._viewportDragging = false;
            _this._viewportDragPos = {};
            _this._viewportHasMoved = false;

            // Bound event handlers
            _this._eventHandlers = {
                focusCanvas: _this._focusCanvas.bind(_this),
                windowResize: _this._windowResize.bind(_this)
            };

            // main setup
            Log.Debug(">> RFB.constructor");

            // Create DOM elements
            _this._screen = document.createElement('div');
            _this._screen.style.display = 'flex';
            _this._screen.style.width = '100%';
            _this._screen.style.height = '100%';
            _this._screen.style.overflow = 'auto';
            _this._screen.style.background = DEFAULT_BACKGROUND;
            _this._canvas = document.createElement('canvas');
            _this._canvas.style.margin = 'auto';
            // Some browsers add an outline on focus
            _this._canvas.style.outline = 'none';
            // IE miscalculates width without this :(
            _this._canvas.style.flexShrink = '0';
            _this._canvas.width = 0;
            _this._canvas.height = 0;
            _this._canvas.tabIndex = -1;
            _this._screen.appendChild(_this._canvas);

            // Cursor
            _this._cursor = new _cursor2.default();

            // XXX: TightVNC 2.8.11 sends no cursor at all until Windows changes
            // it. Result: no cursor at all until a window border or an edit field
            // is hit blindly. But there are also VNC servers that draw the cursor
            // in the framebuffer and don't send the empty local cursor. There is
            // no way to satisfy both sides.
            //
            // The spec is unclear on this "initial cursor" issue. Many other
            // viewers (TigerVNC, RealVNC, Remmina) display an arrow as the
            // initial cursor instead.
            _this._cursorImage = RFB.cursors.none;

            // populate decoder array with objects
            _this._decoders[_encodings.encodings.encodingRaw] = new _raw2.default();
            _this._decoders[_encodings.encodings.encodingCopyRect] = new _copyrect2.default();
            _this._decoders[_encodings.encodings.encodingRRE] = new _rre2.default();
            _this._decoders[_encodings.encodings.encodingHextile] = new _hextile2.default();
            _this._decoders[_encodings.encodings.encodingTight] = new _tight2.default();
            _this._decoders[_encodings.encodings.encodingTightPNG] = new _tightpng2.default();

            // NB: nothing that needs explicit teardown should be done
            // before this point, since this can throw an exception
            try {
                _this._display = new _display2.default(_this._canvas);
            } catch (exc) {
                Log.Error("Display exception: " + exc);
                throw exc;
            }
            _this._display.onflush = _this._onFlush.bind(_this);
            _this._display.clear();

            _this._keyboard = new _keyboard2.default(_this._canvas);
            _this._keyboard.onkeyevent = _this._handleKeyEvent.bind(_this);

            _this._mouse = new _mouse2.default(_this._canvas);
            _this._mouse.onmousebutton = _this._handleMouseButton.bind(_this);
            _this._mouse.onmousemove = _this._handleMouseMove.bind(_this);

            _this._sock = new _websock2.default();
            _this._sock.on('message', function () {
                _this._handle_message();
            });
            _this._sock.on('open', function () {
                if (_this._rfb_connection_state === 'connecting' && _this._rfb_init_state === '') {
                    _this._rfb_init_state = 'ProtocolVersion';
                    Log.Debug("Starting VNC handshake");
                } else {
                    _this._fail("Unexpected server connection while " + _this._rfb_connection_state);
                }
            });
            _this._sock.on('close', function (e) {
                Log.Debug("WebSocket on-close event");
                var msg = "";
                if (e.code) {
                    msg = "(code: " + e.code;
                    if (e.reason) {
                        msg += ", reason: " + e.reason;
                    }
                    msg += ")";
                }
                switch (_this._rfb_connection_state) {
                    case 'connecting':
                        _this._fail("Connection closed " + msg);
                        break;
                    case 'connected':
                        // Handle disconnects that were initiated server-side
                        _this._updateConnectionState('disconnecting');
                        _this._updateConnectionState('disconnected');
                        break;
                    case 'disconnecting':
                        // Normal disconnection path
                        _this._updateConnectionState('disconnected');
                        break;
                    case 'disconnected':
                        _this._fail("Unexpected server disconnect " + "when already disconnected " + msg);
                        break;
                    default:
                        _this._fail("Unexpected server disconnect before connecting " + msg);
                        break;
                }
                _this._sock.off('close');
            });
            _this._sock.on('error', function (e) {
                return Log.Warn("WebSocket on-error event");
            });

            // Slight delay of the actual connection so that the caller has
            // time to set up callbacks
            setTimeout(_this._updateConnectionState.bind(_this, 'connecting'));

            Log.Debug("<< RFB.constructor");

            // ===== PROPERTIES =====

            _this.dragViewport = false;
            _this.focusOnClick = true;

            _this._viewOnly = false;
            _this._clipViewport = false;
            _this._scaleViewport = false;
            _this._resizeSession = false;
            return _this;
        }

        // ===== PROPERTIES =====

        _createClass(RFB, [{
            key: 'disconnect',
            value: function disconnect() {
                this._updateConnectionState('disconnecting');
                this._sock.off('error');
                this._sock.off('message');
                this._sock.off('open');
            }
        }, {
            key: 'sendCredentials',
            value: function sendCredentials(creds) {
                this._rfb_credentials = creds;
                setTimeout(this._init_msg.bind(this), 0);
            }
        }, {
            key: 'sendCtrlAltDel',
            value: function sendCtrlAltDel() {
                if (this._rfb_connection_state !== 'connected' || this._viewOnly) {
                    return;
                }
                Log.Info("Sending Ctrl-Alt-Del");

                this.sendKey(_keysym2.default.XK_Control_L, "ControlLeft", true);
                this.sendKey(_keysym2.default.XK_Alt_L, "AltLeft", true);
                this.sendKey(_keysym2.default.XK_Delete, "Delete", true);
                this.sendKey(_keysym2.default.XK_Delete, "Delete", false);
                this.sendKey(_keysym2.default.XK_Alt_L, "AltLeft", false);
                this.sendKey(_keysym2.default.XK_Control_L, "ControlLeft", false);
            }
        }, {
            key: 'machineShutdown',
            value: function machineShutdown() {
                this._xvpOp(1, 2);
            }
        }, {
            key: 'machineReboot',
            value: function machineReboot() {
                this._xvpOp(1, 3);
            }
        }, {
            key: 'machineReset',
            value: function machineReset() {
                this._xvpOp(1, 4);
            }
        }, {
            key: 'sendKey',
            value: function sendKey(keysym, code, down) {
                if (this._rfb_connection_state !== 'connected' || this._viewOnly) {
                    return;
                }

                if (down === undefined) {
                    this.sendKey(keysym, code, true);
                    this.sendKey(keysym, code, false);
                    return;
                }

                var scancode = _xtscancodes2.default[code];

                if (this._qemuExtKeyEventSupported && scancode) {
                    // 0 is NoSymbol
                    keysym = keysym || 0;

                    Log.Info("Sending key (" + (down ? "down" : "up") + "): keysym " + keysym + ", scancode " + scancode);

                    RFB.messages.QEMUExtendedKeyEvent(this._sock, keysym, down, scancode);
                } else {
                    if (!keysym) {
                        return;
                    }
                    Log.Info("Sending keysym (" + (down ? "down" : "up") + "): " + keysym);
                    RFB.messages.keyEvent(this._sock, keysym, down ? 1 : 0);
                }
            }
        }, {
            key: 'focus',
            value: function focus() {
                this._canvas.focus();
            }
        }, {
            key: 'blur',
            value: function blur() {
                this._canvas.blur();
            }
        }, {
            key: 'clipboardPasteFrom',
            value: function clipboardPasteFrom(text) {
                if (this._rfb_connection_state !== 'connected' || this._viewOnly) {
                    return;
                }
                RFB.messages.clientCutText(this._sock, text);
            }
        }, {
            key: '_connect',
            value: function _connect() {
                Log.Debug(">> RFB.connect");

                Log.Info("connecting to " + this._url);

                try {
                    // WebSocket.onopen transitions to the RFB init states
                    this._sock.open(this._url, ['binary']);
                } catch (e) {
                    if (e.name === 'SyntaxError') {
                        this._fail("Invalid host or port (" + e + ")");
                    } else {
                        this._fail("Error when opening socket (" + e + ")");
                    }
                }

                // Make our elements part of the page
                this._target.appendChild(this._screen);

                this._cursor.attach(this._canvas);
                this._refreshCursor();

                // Monitor size changes of the screen
                // FIXME: Use ResizeObserver, or hidden overflow
                window.addEventListener('resize', this._eventHandlers.windowResize);

                // Always grab focus on some kind of click event
                this._canvas.addEventListener("mousedown", this._eventHandlers.focusCanvas);
                this._canvas.addEventListener("touchstart", this._eventHandlers.focusCanvas);

                Log.Debug("<< RFB.connect");
            }
        }, {
            key: '_disconnect',
            value: function _disconnect() {
                Log.Debug(">> RFB.disconnect");
                this._cursor.detach();
                this._canvas.removeEventListener("mousedown", this._eventHandlers.focusCanvas);
                this._canvas.removeEventListener("touchstart", this._eventHandlers.focusCanvas);
                window.removeEventListener('resize', this._eventHandlers.windowResize);
                this._keyboard.ungrab();
                this._mouse.ungrab();
                this._sock.close();
                try {
                    this._target.removeChild(this._screen);
                } catch (e) {
                    if (e.name === 'NotFoundError') {
                        // Some cases where the initial connection fails
                        // can disconnect before the _screen is created
                    } else {
                        throw e;
                    }
                }
                clearTimeout(this._resizeTimeout);
                Log.Debug("<< RFB.disconnect");
            }
        }, {
            key: '_focusCanvas',
            value: function _focusCanvas(event) {
                // Respect earlier handlers' request to not do side-effects
                if (event.defaultPrevented) {
                    return;
                }

                if (!this.focusOnClick) {
                    return;
                }

                this.focus();
            }
        }, {
            key: '_windowResize',
            value: function _windowResize(event) {
                var _this2 = this;

                // If the window resized then our screen element might have
                // as well. Update the viewport dimensions.
                window.requestAnimationFrame(function () {
                    _this2._updateClip();
                    _this2._updateScale();
                });

                if (this._resizeSession) {
                    // Request changing the resolution of the remote display to
                    // the size of the local browser viewport.

                    // In order to not send multiple requests before the browser-resize
                    // is finished we wait 0.5 seconds before sending the request.
                    clearTimeout(this._resizeTimeout);
                    this._resizeTimeout = setTimeout(this._requestRemoteResize.bind(this), 500);
                }
            }
        }, {
            key: '_updateClip',
            value: function _updateClip() {
                var cur_clip = this._display.clipViewport;
                var new_clip = this._clipViewport;

                if (this._scaleViewport) {
                    // Disable viewport clipping if we are scaling
                    new_clip = false;
                }

                if (cur_clip !== new_clip) {
                    this._display.clipViewport = new_clip;
                }

                if (new_clip) {
                    // When clipping is enabled, the screen is limited to
                    // the size of the container.
                    var size = this._screenSize();
                    this._display.viewportChangeSize(size.w, size.h);
                    this._fixScrollbars();
                }
            }
        }, {
            key: '_updateScale',
            value: function _updateScale() {
                if (!this._scaleViewport) {
                    this._display.scale = 1.0;
                } else {
                    var size = this._screenSize();
                    this._display.autoscale(size.w, size.h);
                }
                this._fixScrollbars();
            }
        }, {
            key: '_requestRemoteResize',
            value: function _requestRemoteResize() {
                clearTimeout(this._resizeTimeout);
                this._resizeTimeout = null;

                if (!this._resizeSession || this._viewOnly || !this._supportsSetDesktopSize) {
                    return;
                }

                var size = this._screenSize();
                RFB.messages.setDesktopSize(this._sock, Math.floor(size.w), Math.floor(size.h), this._screen_id, this._screen_flags);

                Log.Debug('Requested new desktop size: ' + size.w + 'x' + size.h);
            }
        }, {
            key: '_screenSize',
            value: function _screenSize() {
                var r = this._screen.getBoundingClientRect();
                return { w: r.width, h: r.height };
            }
        }, {
            key: '_fixScrollbars',
            value: function _fixScrollbars() {
                // This is a hack because Chrome screws up the calculation
                // for when scrollbars are needed. So to fix it we temporarily
                // toggle them off and on.
                var orig = this._screen.style.overflow;
                this._screen.style.overflow = 'hidden';
                // Force Chrome to recalculate the layout by asking for
                // an element's dimensions
                this._screen.getBoundingClientRect();
                this._screen.style.overflow = orig;
            }
        }, {
            key: '_updateConnectionState',
            value: function _updateConnectionState(state) {
                var _this3 = this;

                var oldstate = this._rfb_connection_state;

                if (state === oldstate) {
                    Log.Debug("Already in state '" + state + "', ignoring");
                    return;
                }

                // The 'disconnected' state is permanent for each RFB object
                if (oldstate === 'disconnected') {
                    Log.Error("Tried changing state of a disconnected RFB object");
                    return;
                }

                // Ensure proper transitions before doing anything
                switch (state) {
                    case 'connected':
                        if (oldstate !== 'connecting') {
                            Log.Error("Bad transition to connected state, " + "previous connection state: " + oldstate);
                            return;
                        }
                        break;

                    case 'disconnected':
                        if (oldstate !== 'disconnecting') {
                            Log.Error("Bad transition to disconnected state, " + "previous connection state: " + oldstate);
                            return;
                        }
                        break;

                    case 'connecting':
                        if (oldstate !== '') {
                            Log.Error("Bad transition to connecting state, " + "previous connection state: " + oldstate);
                            return;
                        }
                        break;

                    case 'disconnecting':
                        if (oldstate !== 'connected' && oldstate !== 'connecting') {
                            Log.Error("Bad transition to disconnecting state, " + "previous connection state: " + oldstate);
                            return;
                        }
                        break;

                    default:
                        Log.Error("Unknown connection state: " + state);
                        return;
                }

                // State change actions

                this._rfb_connection_state = state;

                Log.Debug("New state '" + state + "', was '" + oldstate + "'.");

                if (this._disconnTimer && state !== 'disconnecting') {
                    Log.Debug("Clearing disconnect timer");
                    clearTimeout(this._disconnTimer);
                    this._disconnTimer = null;

                    // make sure we don't get a double event
                    this._sock.off('close');
                }

                switch (state) {
                    case 'connecting':
                        this._connect();
                        break;

                    case 'connected':
                        this.dispatchEvent(new CustomEvent("connect", { detail: {} }));
                        break;

                    case 'disconnecting':
                        this._disconnect();

                        this._disconnTimer = setTimeout(function () {
                            Log.Error("Disconnection timed out.");
                            _this3._updateConnectionState('disconnected');
                        }, DISCONNECT_TIMEOUT * 1000);
                        break;

                    case 'disconnected':
                        this.dispatchEvent(new CustomEvent("disconnect", { detail: { clean: this._rfb_clean_disconnect } }));
                        break;
                }
            }
        }, {
            key: '_fail',
            value: function _fail(details) {
                switch (this._rfb_connection_state) {
                    case 'disconnecting':
                        Log.Error("Failed when disconnecting: " + details);
                        break;
                    case 'connected':
                        Log.Error("Failed while connected: " + details);
                        break;
                    case 'connecting':
                        Log.Error("Failed when connecting: " + details);
                        break;
                    default:
                        Log.Error("RFB failure: " + details);
                        break;
                }
                this._rfb_clean_disconnect = false; //This is sent to the UI

                // Transition to disconnected without waiting for socket to close
                this._updateConnectionState('disconnecting');
                this._updateConnectionState('disconnected');

                return false;
            }
        }, {
            key: '_setCapability',
            value: function _setCapability(cap, val) {
                this._capabilities[cap] = val;
                this.dispatchEvent(new CustomEvent("capabilities", { detail: { capabilities: this._capabilities } }));
            }
        }, {
            key: '_handle_message',
            value: function _handle_message() {
                if (this._sock.rQlen === 0) {
                    Log.Warn("handle_message called on an empty receive queue");
                    return;
                }

                switch (this._rfb_connection_state) {
                    case 'disconnected':
                        Log.Error("Got data while disconnected");
                        break;
                    case 'connected':
                        while (true) {
                            if (this._flushing) {
                                break;
                            }
                            if (!this._normal_msg()) {
                                break;
                            }
                            if (this._sock.rQlen === 0) {
                                break;
                            }
                        }
                        break;
                    default:
                        this._init_msg();
                        break;
                }
            }
        }, {
            key: '_handleKeyEvent',
            value: function _handleKeyEvent(keysym, code, down) {
                this.sendKey(keysym, code, down);
            }
        }, {
            key: '_handleMouseButton',
            value: function _handleMouseButton(x, y, down, bmask) {
                if (down) {
                    this._mouse_buttonMask |= bmask;
                } else {
                    this._mouse_buttonMask &= ~bmask;
                }

                if (this.dragViewport) {
                    if (down && !this._viewportDragging) {
                        this._viewportDragging = true;
                        this._viewportDragPos = { 'x': x, 'y': y };
                        this._viewportHasMoved = false;

                        // Skip sending mouse events
                        return;
                    } else {
                        this._viewportDragging = false;

                        // If we actually performed a drag then we are done
                        // here and should not send any mouse events
                        if (this._viewportHasMoved) {
                            return;
                        }

                        // Otherwise we treat this as a mouse click event.
                        // Send the button down event here, as the button up
                        // event is sent at the end of this function.
                        RFB.messages.pointerEvent(this._sock, this._display.absX(x), this._display.absY(y), bmask);
                    }
                }

                if (this._viewOnly) {
                    return;
                } // View only, skip mouse events

                if (this._rfb_connection_state !== 'connected') {
                    return;
                }
                RFB.messages.pointerEvent(this._sock, this._display.absX(x), this._display.absY(y), this._mouse_buttonMask);
            }
        }, {
            key: '_handleMouseMove',
            value: function _handleMouseMove(x, y) {
                if (this._viewportDragging) {
                    var deltaX = this._viewportDragPos.x - x;
                    var deltaY = this._viewportDragPos.y - y;

                    if (this._viewportHasMoved || Math.abs(deltaX) > _browser.dragThreshold || Math.abs(deltaY) > _browser.dragThreshold) {
                        this._viewportHasMoved = true;

                        this._viewportDragPos = { 'x': x, 'y': y };
                        this._display.viewportChangePos(deltaX, deltaY);
                    }

                    // Skip sending mouse events
                    return;
                }

                if (this._viewOnly) {
                    return;
                } // View only, skip mouse events

                if (this._rfb_connection_state !== 'connected') {
                    return;
                }
                RFB.messages.pointerEvent(this._sock, this._display.absX(x), this._display.absY(y), this._mouse_buttonMask);
            }
        }, {
            key: '_negotiate_protocol_version',
            value: function _negotiate_protocol_version() {
                if (this._sock.rQwait("version", 12)) {
                    return false;
                }

                var sversion = this._sock.rQshiftStr(12).substr(4, 7);
                Log.Info("Server ProtocolVersion: " + sversion);
                var is_repeater = 0;
                switch (sversion) {
                    case "000.000":
                        // UltraVNC repeater
                        is_repeater = 1;
                        break;
                    case "003.003":
                    case "003.006": // UltraVNC
                    case "003.889":
                        // Apple Remote Desktop
                        this._rfb_version = 3.3;
                        break;
                    case "003.007":
                        this._rfb_version = 3.7;
                        break;
                    case "003.008":
                    case "004.000": // Intel AMT KVM
                    case "004.001": // RealVNC 4.6
                    case "005.000":
                        // RealVNC 5.3
                        this._rfb_version = 3.8;
                        break;
                    default:
                        return this._fail("Invalid server version " + sversion);
                }

                if (is_repeater) {
                    var repeaterID = "ID:" + this._repeaterID;
                    while (repeaterID.length < 250) {
                        repeaterID += "\0";
                    }
                    this._sock.send_string(repeaterID);
                    return true;
                }

                if (this._rfb_version > this._rfb_max_version) {
                    this._rfb_version = this._rfb_max_version;
                }

                var cversion = "00" + parseInt(this._rfb_version, 10) + ".00" + this._rfb_version * 10 % 10;
                this._sock.send_string("RFB " + cversion + "\n");
                Log.Debug('Sent ProtocolVersion: ' + cversion);

                this._rfb_init_state = 'Security';
            }
        }, {
            key: '_negotiate_security',
            value: function _negotiate_security() {
                // Polyfill since IE and PhantomJS doesn't have
                // TypedArray.includes()
                function includes(item, array) {
                    for (var i = 0; i < array.length; i++) {
                        if (array[i] === item) {
                            return true;
                        }
                    }
                    return false;
                }

                if (this._rfb_version >= 3.7) {
                    // Server sends supported list, client decides
                    var num_types = this._sock.rQshift8();
                    if (this._sock.rQwait("security type", num_types, 1)) {
                        return false;
                    }

                    if (num_types === 0) {
                        this._rfb_init_state = "SecurityReason";
                        this._security_context = "no security types";
                        this._security_status = 1;
                        return this._init_msg();
                    }

                    var types = this._sock.rQshiftBytes(num_types);
                    Log.Debug("Server security types: " + types);

                    // Look for each auth in preferred order
                    if (includes(1, types)) {
                        this._rfb_auth_scheme = 1; // None
                    } else if (includes(22, types)) {
                        this._rfb_auth_scheme = 22; // XVP
                    } else if (includes(16, types)) {
                        this._rfb_auth_scheme = 16; // Tight
                    } else if (includes(2, types)) {
                        this._rfb_auth_scheme = 2; // VNC Auth
                    } else {
                        return this._fail("Unsupported security types (types: " + types + ")");
                    }

                    this._sock.send([this._rfb_auth_scheme]);
                } else {
                    // Server decides
                    if (this._sock.rQwait("security scheme", 4)) {
                        return false;
                    }
                    this._rfb_auth_scheme = this._sock.rQshift32();

                    if (this._rfb_auth_scheme == 0) {
                        this._rfb_init_state = "SecurityReason";
                        this._security_context = "authentication scheme";
                        this._security_status = 1;
                        return this._init_msg();
                    }
                }

                this._rfb_init_state = 'Authentication';
                Log.Debug('Authenticating using scheme: ' + this._rfb_auth_scheme);

                return this._init_msg(); // jump to authentication
            }
        }, {
            key: '_handle_security_reason',
            value: function _handle_security_reason() {
                if (this._sock.rQwait("reason length", 4)) {
                    return false;
                }
                var strlen = this._sock.rQshift32();
                var reason = "";

                if (strlen > 0) {
                    if (this._sock.rQwait("reason", strlen, 4)) {
                        return false;
                    }
                    reason = this._sock.rQshiftStr(strlen);
                }

                if (reason !== "") {
                    this.dispatchEvent(new CustomEvent("securityfailure", { detail: { status: this._security_status,
                            reason: reason } }));

                    return this._fail("Security negotiation failed on " + this._security_context + " (reason: " + reason + ")");
                } else {
                    this.dispatchEvent(new CustomEvent("securityfailure", { detail: { status: this._security_status } }));

                    return this._fail("Security negotiation failed on " + this._security_context);
                }
            }
        }, {
            key: '_negotiate_xvp_auth',
            value: function _negotiate_xvp_auth() {
                if (!this._rfb_credentials.username || !this._rfb_credentials.password || !this._rfb_credentials.target) {
                    this.dispatchEvent(new CustomEvent("credentialsrequired", { detail: { types: ["username", "password", "target"] } }));
                    return false;
                }

                var xvp_auth_str = String.fromCharCode(this._rfb_credentials.username.length) + String.fromCharCode(this._rfb_credentials.target.length) + this._rfb_credentials.username + this._rfb_credentials.target;
                this._sock.send_string(xvp_auth_str);
                this._rfb_auth_scheme = 2;
                return this._negotiate_authentication();
            }
        }, {
            key: '_negotiate_std_vnc_auth',
            value: function _negotiate_std_vnc_auth() {
                if (this._sock.rQwait("auth challenge", 16)) {
                    return false;
                }

                if (!this._rfb_credentials.password) {
                    this.dispatchEvent(new CustomEvent("credentialsrequired", { detail: { types: ["password"] } }));
                    return false;
                }

                // TODO(directxman12): make genDES not require an Array
                var challenge = Array.prototype.slice.call(this._sock.rQshiftBytes(16));
                var response = RFB.genDES(this._rfb_credentials.password, challenge);
                this._sock.send(response);
                this._rfb_init_state = "SecurityResult";
                return true;
            }
        }, {
            key: '_negotiate_tight_tunnels',
            value: function _negotiate_tight_tunnels(numTunnels) {
                var clientSupportedTunnelTypes = {
                    0: { vendor: 'TGHT', signature: 'NOTUNNEL' }
                };
                var serverSupportedTunnelTypes = {};
                // receive tunnel capabilities
                for (var i = 0; i < numTunnels; i++) {
                    var cap_code = this._sock.rQshift32();
                    var cap_vendor = this._sock.rQshiftStr(4);
                    var cap_signature = this._sock.rQshiftStr(8);
                    serverSupportedTunnelTypes[cap_code] = { vendor: cap_vendor, signature: cap_signature };
                }

                Log.Debug("Server Tight tunnel types: " + serverSupportedTunnelTypes);

                // Siemens touch panels have a VNC server that supports NOTUNNEL,
                // but forgets to advertise it. Try to detect such servers by
                // looking for their custom tunnel type.
                if (serverSupportedTunnelTypes[1] && serverSupportedTunnelTypes[1].vendor === "SICR" && serverSupportedTunnelTypes[1].signature === "SCHANNEL") {
                    Log.Debug("Detected Siemens server. Assuming NOTUNNEL support.");
                    serverSupportedTunnelTypes[0] = { vendor: 'TGHT', signature: 'NOTUNNEL' };
                }

                // choose the notunnel type
                if (serverSupportedTunnelTypes[0]) {
                    if (serverSupportedTunnelTypes[0].vendor != clientSupportedTunnelTypes[0].vendor || serverSupportedTunnelTypes[0].signature != clientSupportedTunnelTypes[0].signature) {
                        return this._fail("Client's tunnel type had the incorrect " + "vendor or signature");
                    }
                    Log.Debug("Selected tunnel type: " + clientSupportedTunnelTypes[0]);
                    this._sock.send([0, 0, 0, 0]); // use NOTUNNEL
                    return false; // wait until we receive the sub auth count to continue
                } else {
                    return this._fail("Server wanted tunnels, but doesn't support " + "the notunnel type");
                }
            }
        }, {
            key: '_negotiate_tight_auth',
            value: function _negotiate_tight_auth() {
                if (!this._rfb_tightvnc) {
                    // first pass, do the tunnel negotiation
                    if (this._sock.rQwait("num tunnels", 4)) {
                        return false;
                    }
                    var numTunnels = this._sock.rQshift32();
                    if (numTunnels > 0 && this._sock.rQwait("tunnel capabilities", 16 * numTunnels, 4)) {
                        return false;
                    }

                    this._rfb_tightvnc = true;

                    if (numTunnels > 0) {
                        this._negotiate_tight_tunnels(numTunnels);
                        return false; // wait until we receive the sub auth to continue
                    }
                }

                // second pass, do the sub-auth negotiation
                if (this._sock.rQwait("sub auth count", 4)) {
                    return false;
                }
                var subAuthCount = this._sock.rQshift32();
                if (subAuthCount === 0) {
                    // empty sub-auth list received means 'no auth' subtype selected
                    this._rfb_init_state = 'SecurityResult';
                    return true;
                }

                if (this._sock.rQwait("sub auth capabilities", 16 * subAuthCount, 4)) {
                    return false;
                }

                var clientSupportedTypes = {
                    'STDVNOAUTH__': 1,
                    'STDVVNCAUTH_': 2
                };

                var serverSupportedTypes = [];

                for (var i = 0; i < subAuthCount; i++) {
                    this._sock.rQshift32(); // capNum
                    var capabilities = this._sock.rQshiftStr(12);
                    serverSupportedTypes.push(capabilities);
                }

                Log.Debug("Server Tight authentication types: " + serverSupportedTypes);

                for (var authType in clientSupportedTypes) {
                    if (serverSupportedTypes.indexOf(authType) != -1) {
                        this._sock.send([0, 0, 0, clientSupportedTypes[authType]]);
                        Log.Debug("Selected authentication type: " + authType);

                        switch (authType) {
                            case 'STDVNOAUTH__':
                                // no auth
                                this._rfb_init_state = 'SecurityResult';
                                return true;
                            case 'STDVVNCAUTH_':
                                // VNC auth
                                this._rfb_auth_scheme = 2;
                                return this._init_msg();
                            default:
                                return this._fail("Unsupported tiny auth scheme " + "(scheme: " + authType + ")");
                        }
                    }
                }

                return this._fail("No supported sub-auth types!");
            }
        }, {
            key: '_negotiate_authentication',
            value: function _negotiate_authentication() {
                switch (this._rfb_auth_scheme) {
                    case 1:
                        // no auth
                        if (this._rfb_version >= 3.8) {
                            this._rfb_init_state = 'SecurityResult';
                            return true;
                        }
                        this._rfb_init_state = 'ClientInitialisation';
                        return this._init_msg();

                    case 22:
                        // XVP auth
                        return this._negotiate_xvp_auth();

                    case 2:
                        // VNC authentication
                        return this._negotiate_std_vnc_auth();

                    case 16:
                        // TightVNC Security Type
                        return this._negotiate_tight_auth();

                    default:
                        return this._fail("Unsupported auth scheme (scheme: " + this._rfb_auth_scheme + ")");
                }
            }
        }, {
            key: '_handle_security_result',
            value: function _handle_security_result() {
                if (this._sock.rQwait('VNC auth response ', 4)) {
                    return false;
                }

                var status = this._sock.rQshift32();

                if (status === 0) {
                    // OK
                    this._rfb_init_state = 'ClientInitialisation';
                    Log.Debug('Authentication OK');
                    return this._init_msg();
                } else {
                    if (this._rfb_version >= 3.8) {
                        this._rfb_init_state = "SecurityReason";
                        this._security_context = "security result";
                        this._security_status = status;
                        return this._init_msg();
                    } else {
                        this.dispatchEvent(new CustomEvent("securityfailure", { detail: { status: status } }));

                        return this._fail("Security handshake failed");
                    }
                }
            }
        }, {
            key: '_negotiate_server_init',
            value: function _negotiate_server_init() {
                if (this._sock.rQwait("server initialization", 24)) {
                    return false;
                }

                /* Screen size */
                var width = this._sock.rQshift16();
                var height = this._sock.rQshift16();

                /* PIXEL_FORMAT */
                var bpp = this._sock.rQshift8();
                var depth = this._sock.rQshift8();
                var big_endian = this._sock.rQshift8();
                var true_color = this._sock.rQshift8();

                var red_max = this._sock.rQshift16();
                var green_max = this._sock.rQshift16();
                var blue_max = this._sock.rQshift16();
                var red_shift = this._sock.rQshift8();
                var green_shift = this._sock.rQshift8();
                var blue_shift = this._sock.rQshift8();
                this._sock.rQskipBytes(3); // padding

                // NB(directxman12): we don't want to call any callbacks or print messages until
                //                   *after* we're past the point where we could backtrack

                /* Connection name/title */
                var name_length = this._sock.rQshift32();
                if (this._sock.rQwait('server init name', name_length, 24)) {
                    return false;
                }
                this._fb_name = (0, _strings.decodeUTF8)(this._sock.rQshiftStr(name_length));

                if (this._rfb_tightvnc) {
                    if (this._sock.rQwait('TightVNC extended server init header', 8, 24 + name_length)) {
                        return false;
                    }
                    // In TightVNC mode, ServerInit message is extended
                    var numServerMessages = this._sock.rQshift16();
                    var numClientMessages = this._sock.rQshift16();
                    var numEncodings = this._sock.rQshift16();
                    this._sock.rQskipBytes(2); // padding

                    var totalMessagesLength = (numServerMessages + numClientMessages + numEncodings) * 16;
                    if (this._sock.rQwait('TightVNC extended server init header', totalMessagesLength, 32 + name_length)) {
                        return false;
                    }

                    // we don't actually do anything with the capability information that TIGHT sends,
                    // so we just skip the all of this.

                    // TIGHT server message capabilities
                    this._sock.rQskipBytes(16 * numServerMessages);

                    // TIGHT client message capabilities
                    this._sock.rQskipBytes(16 * numClientMessages);

                    // TIGHT encoding capabilities
                    this._sock.rQskipBytes(16 * numEncodings);
                }

                // NB(directxman12): these are down here so that we don't run them multiple times
                //                   if we backtrack
                Log.Info("Screen: " + width + "x" + height + ", bpp: " + bpp + ", depth: " + depth + ", big_endian: " + big_endian + ", true_color: " + true_color + ", red_max: " + red_max + ", green_max: " + green_max + ", blue_max: " + blue_max + ", red_shift: " + red_shift + ", green_shift: " + green_shift + ", blue_shift: " + blue_shift);

                if (big_endian !== 0) {
                    Log.Warn("Server native endian is not little endian");
                }

                if (red_shift !== 16) {
                    Log.Warn("Server native red-shift is not 16");
                }

                if (blue_shift !== 0) {
                    Log.Warn("Server native blue-shift is not 0");
                }

                // we're past the point where we could backtrack, so it's safe to call this
                this.dispatchEvent(new CustomEvent("desktopname", { detail: { name: this._fb_name } }));

                this._resize(width, height);

                if (!this._viewOnly) {
                    this._keyboard.grab();
                }
                if (!this._viewOnly) {
                    this._mouse.grab();
                }

                this._fb_depth = 24;

                if (this._fb_name === "Intel(r) AMT KVM") {
                    Log.Warn("Intel AMT KVM only supports 8/16 bit depths. Using low color mode.");
                    this._fb_depth = 8;
                }

                RFB.messages.pixelFormat(this._sock, this._fb_depth, true);
                this._sendEncodings();
                RFB.messages.fbUpdateRequest(this._sock, false, 0, 0, this._fb_width, this._fb_height);

                this._updateConnectionState('connected');
                return true;
            }
        }, {
            key: '_sendEncodings',
            value: function _sendEncodings() {
                var encs = [];

                // In preference order
                encs.push(_encodings.encodings.encodingCopyRect);
                // Only supported with full depth support
                if (this._fb_depth == 24) {
                    encs.push(_encodings.encodings.encodingTight);
                    encs.push(_encodings.encodings.encodingTightPNG);
                    encs.push(_encodings.encodings.encodingHextile);
                    encs.push(_encodings.encodings.encodingRRE);
                }
                encs.push(_encodings.encodings.encodingRaw);

                // Psuedo-encoding settings
                encs.push(_encodings.encodings.pseudoEncodingQualityLevel0 + 6);
                encs.push(_encodings.encodings.pseudoEncodingCompressLevel0 + 2);

                encs.push(_encodings.encodings.pseudoEncodingDesktopSize);
                encs.push(_encodings.encodings.pseudoEncodingLastRect);
                encs.push(_encodings.encodings.pseudoEncodingQEMUExtendedKeyEvent);
                encs.push(_encodings.encodings.pseudoEncodingExtendedDesktopSize);
                encs.push(_encodings.encodings.pseudoEncodingXvp);
                encs.push(_encodings.encodings.pseudoEncodingFence);
                encs.push(_encodings.encodings.pseudoEncodingContinuousUpdates);

                if (this._fb_depth == 24) {
                    encs.push(_encodings.encodings.pseudoEncodingCursor);
                }

                RFB.messages.clientEncodings(this._sock, encs);
            }
        }, {
            key: '_init_msg',
            value: function _init_msg() {
                switch (this._rfb_init_state) {
                    case 'ProtocolVersion':
                        return this._negotiate_protocol_version();

                    case 'Security':
                        return this._negotiate_security();

                    case 'Authentication':
                        return this._negotiate_authentication();

                    case 'SecurityResult':
                        return this._handle_security_result();

                    case 'SecurityReason':
                        return this._handle_security_reason();

                    case 'ClientInitialisation':
                        this._sock.send([this._shared ? 1 : 0]); // ClientInitialisation
                        this._rfb_init_state = 'ServerInitialisation';
                        return true;

                    case 'ServerInitialisation':
                        return this._negotiate_server_init();

                    default:
                        return this._fail("Unknown init state (state: " + this._rfb_init_state + ")");
                }
            }
        }, {
            key: '_handle_set_colour_map_msg',
            value: function _handle_set_colour_map_msg() {
                Log.Debug("SetColorMapEntries");

                return this._fail("Unexpected SetColorMapEntries message");
            }
        }, {
            key: '_handle_server_cut_text',
            value: function _handle_server_cut_text() {
                Log.Debug("ServerCutText");

                if (this._sock.rQwait("ServerCutText header", 7, 1)) {
                    return false;
                }
                this._sock.rQskipBytes(3); // Padding
                var length = this._sock.rQshift32();
                if (this._sock.rQwait("ServerCutText", length, 8)) {
                    return false;
                }

                var text = this._sock.rQshiftStr(length);

                if (this._viewOnly) {
                    return true;
                }

                this.dispatchEvent(new CustomEvent("clipboard", { detail: { text: text } }));

                return true;
            }
        }, {
            key: '_handle_server_fence_msg',
            value: function _handle_server_fence_msg() {
                if (this._sock.rQwait("ServerFence header", 8, 1)) {
                    return false;
                }
                this._sock.rQskipBytes(3); // Padding
                var flags = this._sock.rQshift32();
                var length = this._sock.rQshift8();

                if (this._sock.rQwait("ServerFence payload", length, 9)) {
                    return false;
                }

                if (length > 64) {
                    Log.Warn("Bad payload length (" + length + ") in fence response");
                    length = 64;
                }

                var payload = this._sock.rQshiftStr(length);

                this._supportsFence = true;

                /*
                 * Fence flags
                 *
                 *  (1<<0)  - BlockBefore
                 *  (1<<1)  - BlockAfter
                 *  (1<<2)  - SyncNext
                 *  (1<<31) - Request
                 */

                if (!(flags & 1 << 31)) {
                    return this._fail("Unexpected fence response");
                }

                // Filter out unsupported flags
                // FIXME: support syncNext
                flags &= 1 << 0 | 1 << 1;

                // BlockBefore and BlockAfter are automatically handled by
                // the fact that we process each incoming message
                // synchronuosly.
                RFB.messages.clientFence(this._sock, flags, payload);

                return true;
            }
        }, {
            key: '_handle_xvp_msg',
            value: function _handle_xvp_msg() {
                if (this._sock.rQwait("XVP version and message", 3, 1)) {
                    return false;
                }
                this._sock.rQskipBytes(1); // Padding
                var xvp_ver = this._sock.rQshift8();
                var xvp_msg = this._sock.rQshift8();

                switch (xvp_msg) {
                    case 0:
                        // XVP_FAIL
                        Log.Error("XVP Operation Failed");
                        break;
                    case 1:
                        // XVP_INIT
                        this._rfb_xvp_ver = xvp_ver;
                        Log.Info("XVP extensions enabled (version " + this._rfb_xvp_ver + ")");
                        this._setCapability("power", true);
                        break;
                    default:
                        this._fail("Illegal server XVP message (msg: " + xvp_msg + ")");
                        break;
                }

                return true;
            }
        }, {
            key: '_normal_msg',
            value: function _normal_msg() {
                var msg_type = void 0;
                if (this._FBU.rects > 0) {
                    msg_type = 0;
                } else {
                    msg_type = this._sock.rQshift8();
                }

                var first = void 0,
                    ret = void 0;
                switch (msg_type) {
                    case 0:
                        // FramebufferUpdate
                        ret = this._framebufferUpdate();
                        if (ret && !this._enabledContinuousUpdates) {
                            RFB.messages.fbUpdateRequest(this._sock, true, 0, 0, this._fb_width, this._fb_height);
                        }
                        return ret;

                    case 1:
                        // SetColorMapEntries
                        return this._handle_set_colour_map_msg();

                    case 2:
                        // Bell
                        Log.Debug("Bell");
                        this.dispatchEvent(new CustomEvent("bell", { detail: {} }));
                        return true;

                    case 3:
                        // ServerCutText
                        return this._handle_server_cut_text();

                    case 150:
                        // EndOfContinuousUpdates
                        first = !this._supportsContinuousUpdates;
                        this._supportsContinuousUpdates = true;
                        this._enabledContinuousUpdates = false;
                        if (first) {
                            this._enabledContinuousUpdates = true;
                            this._updateContinuousUpdates();
                            Log.Info("Enabling continuous updates.");
                        } else {
                            // FIXME: We need to send a framebufferupdaterequest here
                            // if we add support for turning off continuous updates
                        }
                        return true;

                    case 248:
                        // ServerFence
                        return this._handle_server_fence_msg();

                    case 250:
                        // XVP
                        return this._handle_xvp_msg();

                    default:
                        this._fail("Unexpected server message (type " + msg_type + ")");
                        Log.Debug("sock.rQslice(0, 30): " + this._sock.rQslice(0, 30));
                        return true;
                }
            }
        }, {
            key: '_onFlush',
            value: function _onFlush() {
                this._flushing = false;
                // Resume processing
                if (this._sock.rQlen > 0) {
                    this._handle_message();
                }
            }
        }, {
            key: '_framebufferUpdate',
            value: function _framebufferUpdate() {
                if (this._FBU.rects === 0) {
                    if (this._sock.rQwait("FBU header", 3, 1)) {
                        return false;
                    }
                    this._sock.rQskipBytes(1); // Padding
                    this._FBU.rects = this._sock.rQshift16();

                    // Make sure the previous frame is fully rendered first
                    // to avoid building up an excessive queue
                    if (this._display.pending()) {
                        this._flushing = true;
                        this._display.flush();
                        return false;
                    }
                }

                while (this._FBU.rects > 0) {
                    if (this._FBU.encoding === null) {
                        if (this._sock.rQwait("rect header", 12)) {
                            return false;
                        }
                        /* New FramebufferUpdate */

                        var hdr = this._sock.rQshiftBytes(12);
                        this._FBU.x = (hdr[0] << 8) + hdr[1];
                        this._FBU.y = (hdr[2] << 8) + hdr[3];
                        this._FBU.width = (hdr[4] << 8) + hdr[5];
                        this._FBU.height = (hdr[6] << 8) + hdr[7];
                        this._FBU.encoding = parseInt((hdr[8] << 24) + (hdr[9] << 16) + (hdr[10] << 8) + hdr[11], 10);
                    }

                    if (!this._handleRect()) {
                        return false;
                    }

                    this._FBU.rects--;
                    this._FBU.encoding = null;
                }

                this._display.flip();

                return true; // We finished this FBU
            }
        }, {
            key: '_handleRect',
            value: function _handleRect() {
                switch (this._FBU.encoding) {
                    case _encodings.encodings.pseudoEncodingLastRect:
                        this._FBU.rects = 1; // Will be decreased when we return
                        return true;

                    case _encodings.encodings.pseudoEncodingCursor:
                        return this._handleCursor();

                    case _encodings.encodings.pseudoEncodingQEMUExtendedKeyEvent:
                        // Old Safari doesn't support creating keyboard events
                        try {
                            var keyboardEvent = document.createEvent("keyboardEvent");
                            if (keyboardEvent.code !== undefined) {
                                this._qemuExtKeyEventSupported = true;
                            }
                        } catch (err) {
                            // Do nothing
                        }
                        return true;

                    case _encodings.encodings.pseudoEncodingDesktopSize:
                        this._resize(this._FBU.width, this._FBU.height);
                        return true;

                    case _encodings.encodings.pseudoEncodingExtendedDesktopSize:
                        return this._handleExtendedDesktopSize();

                    default:
                        return this._handleDataRect();
                }
            }
        }, {
            key: '_handleCursor',
            value: function _handleCursor() {
                var hotx = this._FBU.x; // hotspot-x
                var hoty = this._FBU.y; // hotspot-y
                var w = this._FBU.width;
                var h = this._FBU.height;

                var pixelslength = w * h * 4;
                var masklength = Math.ceil(w / 8) * h;

                var bytes = pixelslength + masklength;
                if (this._sock.rQwait("cursor encoding", bytes)) {
                    return false;
                }

                // Decode from BGRX pixels + bit mask to RGBA
                var pixels = this._sock.rQshiftBytes(pixelslength);
                var mask = this._sock.rQshiftBytes(masklength);
                var rgba = new Uint8Array(w * h * 4);

                var pix_idx = 0;
                for (var y = 0; y < h; y++) {
                    for (var x = 0; x < w; x++) {
                        var mask_idx = y * Math.ceil(w / 8) + Math.floor(x / 8);
                        var alpha = mask[mask_idx] << x % 8 & 0x80 ? 255 : 0;
                        rgba[pix_idx] = pixels[pix_idx + 2];
                        rgba[pix_idx + 1] = pixels[pix_idx + 1];
                        rgba[pix_idx + 2] = pixels[pix_idx];
                        rgba[pix_idx + 3] = alpha;
                        pix_idx += 4;
                    }
                }

                this._updateCursor(rgba, hotx, hoty, w, h);

                return true;
            }
        }, {
            key: '_handleExtendedDesktopSize',
            value: function _handleExtendedDesktopSize() {
                if (this._sock.rQwait("ExtendedDesktopSize", 4)) {
                    return false;
                }

                var number_of_screens = this._sock.rQpeek8();

                var bytes = 4 + number_of_screens * 16;
                if (this._sock.rQwait("ExtendedDesktopSize", bytes)) {
                    return false;
                }

                var firstUpdate = !this._supportsSetDesktopSize;
                this._supportsSetDesktopSize = true;

                // Normally we only apply the current resize mode after a
                // window resize event. However there is no such trigger on the
                // initial connect. And we don't know if the server supports
                // resizing until we've gotten here.
                if (firstUpdate) {
                    this._requestRemoteResize();
                }

                this._sock.rQskipBytes(1); // number-of-screens
                this._sock.rQskipBytes(3); // padding

                for (var i = 0; i < number_of_screens; i += 1) {
                    // Save the id and flags of the first screen
                    if (i === 0) {
                        this._screen_id = this._sock.rQshiftBytes(4); // id
                        this._sock.rQskipBytes(2); // x-position
                        this._sock.rQskipBytes(2); // y-position
                        this._sock.rQskipBytes(2); // width
                        this._sock.rQskipBytes(2); // height
                        this._screen_flags = this._sock.rQshiftBytes(4); // flags
                    } else {
                        this._sock.rQskipBytes(16);
                    }
                }

                /*
                 * The x-position indicates the reason for the change:
                 *
                 *  0 - server resized on its own
                 *  1 - this client requested the resize
                 *  2 - another client requested the resize
                 */

                // We need to handle errors when we requested the resize.
                if (this._FBU.x === 1 && this._FBU.y !== 0) {
                    var msg = "";
                    // The y-position indicates the status code from the server
                    switch (this._FBU.y) {
                        case 1:
                            msg = "Resize is administratively prohibited";
                            break;
                        case 2:
                            msg = "Out of resources";
                            break;
                        case 3:
                            msg = "Invalid screen layout";
                            break;
                        default:
                            msg = "Unknown reason";
                            break;
                    }
                    Log.Warn("Server did not accept the resize request: " + msg);
                } else {
                    this._resize(this._FBU.width, this._FBU.height);
                }

                return true;
            }
        }, {
            key: '_handleDataRect',
            value: function _handleDataRect() {
                var decoder = this._decoders[this._FBU.encoding];
                if (!decoder) {
                    this._fail("Unsupported encoding (encoding: " + this._FBU.encoding + ")");
                    return false;
                }

                try {
                    return decoder.decodeRect(this._FBU.x, this._FBU.y, this._FBU.width, this._FBU.height, this._sock, this._display, this._fb_depth);
                } catch (err) {
                    this._fail("Error decoding rect: " + err);
                    return false;
                }
            }
        }, {
            key: '_updateContinuousUpdates',
            value: function _updateContinuousUpdates() {
                if (!this._enabledContinuousUpdates) {
                    return;
                }

                RFB.messages.enableContinuousUpdates(this._sock, true, 0, 0, this._fb_width, this._fb_height);
            }
        }, {
            key: '_resize',
            value: function _resize(width, height) {
                this._fb_width = width;
                this._fb_height = height;

                this._display.resize(this._fb_width, this._fb_height);

                // Adjust the visible viewport based on the new dimensions
                this._updateClip();
                this._updateScale();

                this._updateContinuousUpdates();
            }
        }, {
            key: '_xvpOp',
            value: function _xvpOp(ver, op) {
                if (this._rfb_xvp_ver < ver) {
                    return;
                }
                Log.Info("Sending XVP operation " + op + " (version " + ver + ")");
                RFB.messages.xvpOp(this._sock, ver, op);
            }
        }, {
            key: '_updateCursor',
            value: function _updateCursor(rgba, hotx, hoty, w, h) {
                this._cursorImage = {
                    rgbaPixels: rgba,
                    hotx: hotx, hoty: hoty, w: w, h: h
                };
                this._refreshCursor();
            }
        }, {
            key: '_shouldShowDotCursor',
            value: function _shouldShowDotCursor() {
                // Called when this._cursorImage is updated
                if (!this._showDotCursor) {
                    // User does not want to see the dot, so...
                    return false;
                }

                // The dot should not be shown if the cursor is already visible,
                // i.e. contains at least one not-fully-transparent pixel.
                // So iterate through all alpha bytes in rgba and stop at the
                // first non-zero.
                for (var i = 3; i < this._cursorImage.rgbaPixels.length; i += 4) {
                    if (this._cursorImage.rgbaPixels[i]) {
                        return false;
                    }
                }

                // At this point, we know that the cursor is fully transparent, and
                // the user wants to see the dot instead of this.
                return true;
            }
        }, {
            key: '_refreshCursor',
            value: function _refreshCursor() {
                var image = this._shouldShowDotCursor() ? RFB.cursors.dot : this._cursorImage;
                this._cursor.change(image.rgbaPixels, image.hotx, image.hoty, image.w, image.h);
            }
        }, {
            key: 'viewOnly',
            get: function get() {
                return this._viewOnly;
            },
            set: function set(viewOnly) {
                this._viewOnly = viewOnly;

                if (this._rfb_connection_state === "connecting" || this._rfb_connection_state === "connected") {
                    if (viewOnly) {
                        this._keyboard.ungrab();
                        this._mouse.ungrab();
                    } else {
                        this._keyboard.grab();
                        this._mouse.grab();
                    }
                }
            }
        }, {
            key: 'capabilities',
            get: function get() {
                return this._capabilities;
            }
        }, {
            key: 'touchButton',
            get: function get() {
                return this._mouse.touchButton;
            },
            set: function set(button) {
                this._mouse.touchButton = button;
            }
        }, {
            key: 'clipViewport',
            get: function get() {
                return this._clipViewport;
            },
            set: function set(viewport) {
                this._clipViewport = viewport;
                this._updateClip();
            }
        }, {
            key: 'scaleViewport',
            get: function get() {
                return this._scaleViewport;
            },
            set: function set(scale) {
                this._scaleViewport = scale;
                // Scaling trumps clipping, so we may need to adjust
                // clipping when enabling or disabling scaling
                if (scale && this._clipViewport) {
                    this._updateClip();
                }
                this._updateScale();
                if (!scale && this._clipViewport) {
                    this._updateClip();
                }
            }
        }, {
            key: 'resizeSession',
            get: function get() {
                return this._resizeSession;
            },
            set: function set(resize) {
                this._resizeSession = resize;
                if (resize) {
                    this._requestRemoteResize();
                }
            }
        }, {
            key: 'showDotCursor',
            get: function get() {
                return this._showDotCursor;
            },
            set: function set(show) {
                this._showDotCursor = show;
                this._refreshCursor();
            }
        }, {
            key: 'background',
            get: function get() {
                return this._screen.style.background;
            },
            set: function set(cssValue) {
                this._screen.style.background = cssValue;
            }
        }], [{
            key: 'genDES',
            value: function genDES(password, challenge) {
                var passwordChars = password.split('').map(function (c) {
                    return c.charCodeAt(0);
                });
                return new _des2.default(passwordChars).encrypt(challenge);
            }
        }]);

        return RFB;
    }(_eventtarget2.default);

    exports.default = RFB;


    // Class Methods
    RFB.messages = {
        keyEvent: function keyEvent(sock, keysym, down) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 4; // msg-type
            buff[offset + 1] = down;

            buff[offset + 2] = 0;
            buff[offset + 3] = 0;

            buff[offset + 4] = keysym >> 24;
            buff[offset + 5] = keysym >> 16;
            buff[offset + 6] = keysym >> 8;
            buff[offset + 7] = keysym;

            sock._sQlen += 8;
            sock.flush();
        },
        QEMUExtendedKeyEvent: function QEMUExtendedKeyEvent(sock, keysym, down, keycode) {
            function getRFBkeycode(xt_scancode) {
                var upperByte = keycode >> 8;
                var lowerByte = keycode & 0x00ff;
                if (upperByte === 0xe0 && lowerByte < 0x7f) {
                    return lowerByte | 0x80;
                }
                return xt_scancode;
            }

            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 255; // msg-type
            buff[offset + 1] = 0; // sub msg-type

            buff[offset + 2] = down >> 8;
            buff[offset + 3] = down;

            buff[offset + 4] = keysym >> 24;
            buff[offset + 5] = keysym >> 16;
            buff[offset + 6] = keysym >> 8;
            buff[offset + 7] = keysym;

            var RFBkeycode = getRFBkeycode(keycode);

            buff[offset + 8] = RFBkeycode >> 24;
            buff[offset + 9] = RFBkeycode >> 16;
            buff[offset + 10] = RFBkeycode >> 8;
            buff[offset + 11] = RFBkeycode;

            sock._sQlen += 12;
            sock.flush();
        },
        pointerEvent: function pointerEvent(sock, x, y, mask) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 5; // msg-type

            buff[offset + 1] = mask;

            buff[offset + 2] = x >> 8;
            buff[offset + 3] = x;

            buff[offset + 4] = y >> 8;
            buff[offset + 5] = y;

            sock._sQlen += 6;
            sock.flush();
        },
        clientCutText: function clientCutText(sock, text) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 6; // msg-type

            buff[offset + 1] = 0; // padding
            buff[offset + 2] = 0; // padding
            buff[offset + 3] = 0; // padding

            var length = text.length;

            buff[offset + 4] = length >> 24;
            buff[offset + 5] = length >> 16;
            buff[offset + 6] = length >> 8;
            buff[offset + 7] = length;

            sock._sQlen += 8;

            // We have to keep track of from where in the text we begin creating the
            // buffer for the flush in the next iteration.
            var textOffset = 0;

            var remaining = length;
            while (remaining > 0) {

                var flushSize = Math.min(remaining, sock._sQbufferSize - sock._sQlen);
                for (var i = 0; i < flushSize; i++) {
                    buff[sock._sQlen + i] = text.charCodeAt(textOffset + i);
                }

                sock._sQlen += flushSize;
                sock.flush();

                remaining -= flushSize;
                textOffset += flushSize;
            }
        },
        setDesktopSize: function setDesktopSize(sock, width, height, id, flags) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 251; // msg-type
            buff[offset + 1] = 0; // padding
            buff[offset + 2] = width >> 8; // width
            buff[offset + 3] = width;
            buff[offset + 4] = height >> 8; // height
            buff[offset + 5] = height;

            buff[offset + 6] = 1; // number-of-screens
            buff[offset + 7] = 0; // padding

            // screen array
            buff[offset + 8] = id >> 24; // id
            buff[offset + 9] = id >> 16;
            buff[offset + 10] = id >> 8;
            buff[offset + 11] = id;
            buff[offset + 12] = 0; // x-position
            buff[offset + 13] = 0;
            buff[offset + 14] = 0; // y-position
            buff[offset + 15] = 0;
            buff[offset + 16] = width >> 8; // width
            buff[offset + 17] = width;
            buff[offset + 18] = height >> 8; // height
            buff[offset + 19] = height;
            buff[offset + 20] = flags >> 24; // flags
            buff[offset + 21] = flags >> 16;
            buff[offset + 22] = flags >> 8;
            buff[offset + 23] = flags;

            sock._sQlen += 24;
            sock.flush();
        },
        clientFence: function clientFence(sock, flags, payload) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 248; // msg-type

            buff[offset + 1] = 0; // padding
            buff[offset + 2] = 0; // padding
            buff[offset + 3] = 0; // padding

            buff[offset + 4] = flags >> 24; // flags
            buff[offset + 5] = flags >> 16;
            buff[offset + 6] = flags >> 8;
            buff[offset + 7] = flags;

            var n = payload.length;

            buff[offset + 8] = n; // length

            for (var i = 0; i < n; i++) {
                buff[offset + 9 + i] = payload.charCodeAt(i);
            }

            sock._sQlen += 9 + n;
            sock.flush();
        },
        enableContinuousUpdates: function enableContinuousUpdates(sock, enable, x, y, width, height) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 150; // msg-type
            buff[offset + 1] = enable; // enable-flag

            buff[offset + 2] = x >> 8; // x
            buff[offset + 3] = x;
            buff[offset + 4] = y >> 8; // y
            buff[offset + 5] = y;
            buff[offset + 6] = width >> 8; // width
            buff[offset + 7] = width;
            buff[offset + 8] = height >> 8; // height
            buff[offset + 9] = height;

            sock._sQlen += 10;
            sock.flush();
        },
        pixelFormat: function pixelFormat(sock, depth, true_color) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            var bpp = void 0;

            if (depth > 16) {
                bpp = 32;
            } else if (depth > 8) {
                bpp = 16;
            } else {
                bpp = 8;
            }

            var bits = Math.floor(depth / 3);

            buff[offset] = 0; // msg-type

            buff[offset + 1] = 0; // padding
            buff[offset + 2] = 0; // padding
            buff[offset + 3] = 0; // padding

            buff[offset + 4] = bpp; // bits-per-pixel
            buff[offset + 5] = depth; // depth
            buff[offset + 6] = 0; // little-endian
            buff[offset + 7] = true_color ? 1 : 0; // true-color

            buff[offset + 8] = 0; // red-max
            buff[offset + 9] = (1 << bits) - 1; // red-max

            buff[offset + 10] = 0; // green-max
            buff[offset + 11] = (1 << bits) - 1; // green-max

            buff[offset + 12] = 0; // blue-max
            buff[offset + 13] = (1 << bits) - 1; // blue-max

            buff[offset + 14] = bits * 2; // red-shift
            buff[offset + 15] = bits * 1; // green-shift
            buff[offset + 16] = bits * 0; // blue-shift

            buff[offset + 17] = 0; // padding
            buff[offset + 18] = 0; // padding
            buff[offset + 19] = 0; // padding

            sock._sQlen += 20;
            sock.flush();
        },
        clientEncodings: function clientEncodings(sock, encodings) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 2; // msg-type
            buff[offset + 1] = 0; // padding

            buff[offset + 2] = encodings.length >> 8;
            buff[offset + 3] = encodings.length;

            var j = offset + 4;
            for (var i = 0; i < encodings.length; i++) {
                var enc = encodings[i];
                buff[j] = enc >> 24;
                buff[j + 1] = enc >> 16;
                buff[j + 2] = enc >> 8;
                buff[j + 3] = enc;

                j += 4;
            }

            sock._sQlen += j - offset;
            sock.flush();
        },
        fbUpdateRequest: function fbUpdateRequest(sock, incremental, x, y, w, h) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            if (typeof x === "undefined") {
                x = 0;
            }
            if (typeof y === "undefined") {
                y = 0;
            }

            buff[offset] = 3; // msg-type
            buff[offset + 1] = incremental ? 1 : 0;

            buff[offset + 2] = x >> 8 & 0xFF;
            buff[offset + 3] = x & 0xFF;

            buff[offset + 4] = y >> 8 & 0xFF;
            buff[offset + 5] = y & 0xFF;

            buff[offset + 6] = w >> 8 & 0xFF;
            buff[offset + 7] = w & 0xFF;

            buff[offset + 8] = h >> 8 & 0xFF;
            buff[offset + 9] = h & 0xFF;

            sock._sQlen += 10;
            sock.flush();
        },
        xvpOp: function xvpOp(sock, ver, op) {
            var buff = sock._sQ;
            var offset = sock._sQlen;

            buff[offset] = 250; // msg-type
            buff[offset + 1] = 0; // padding

            buff[offset + 2] = ver;
            buff[offset + 3] = op;

            sock._sQlen += 4;
            sock.flush();
        }
    };

    RFB.cursors = {
        none: {
            rgbaPixels: new Uint8Array(),
            w: 0, h: 0,
            hotx: 0, hoty: 0
        },

        dot: {
            /* eslint-disable indent */
            rgbaPixels: new Uint8Array([255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 255, 255, 255]),
            /* eslint-enable indent */
            w: 3, h: 3,
            hotx: 1, hoty: 1
        }
    };
});
/* -------------------------------------------------------------------------- */
/* Copyright 2002-2019, OpenNebula Project, OpenNebula Systems                */
/*                                                                            */
/* Licensed under the Apache License, Version 2.0 (the "License"); you may    */
/* not use this file except in compliance with the License. You may obtain    */
/* a copy of the License at                                                   */
/*                                                                            */
/* http://www.apache.org/licenses/LICENSE-2.0                                 */
/*                                                                            */
/* Unless required by applicable law or agreed to in writing, software        */
/* distributed under the License is distributed on an "AS IS" BASIS,          */
/* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   */
/* See the License for the specific language governing permissions and        */
/* limitations under the License.                                             */
/* -------------------------------------------------------------------------- */

define('console/vnc',['require','vnc-rfb','sunstone-config'],function(require) {
  var RFB = require("vnc-rfb").default;
  var Config = require("sunstone-config");
  var rfb;

  function passwordRequired(rfb) {
    var msg;
    msg = "<form id=\"setPasswordForm\"";
    msg += "  style=\"margin-bottom: 0px\">";
    msg += "Password Required: ";
    msg += "<input type=password size=10 id=\"password_input\" class=\"noVNC_status\">";
    msg += "<\/form>";
    document.querySelector("#noVNC_status_bar").setAttribute("class", "noVNC_status_warn");
    document.querySelector("#noVNC_status").innerHTML = msg;
    document.querySelector("#setPasswordForm").addEventListener("submit", setPassword);
  }
  function setPassword(event) {
    rfb.sendPassword(document.querySelector("#password_input").value);
    event.preventDefault();
    return false;
  }
  function sendCtrlAltDel() {
    rfb.sendCtrlAltDel();
    return false;
  }
  function xvpShutdown() {
    rfb.xvpShutdown();
    return false;
  }
  function xvpReboot() {
    rfb.xvpReboot();
    return false;
  }
  function xvpReset() {
    rfb.xvpReset();
    return false;
  }
  function updateState(rfb, state, oldstate, msg) {
    var s, sb, cad, level;
    s = document.querySelector("#noVNC_status");
    sb = document.querySelector("#noVNC_status_bar");
    cad = document.querySelector("#sendCtrlAltDelButton");
    switch (state) {
      case "failed":       level = "error";  break;
      case "fatal":        level = "error";  break;
      case "normal":       level = "normal"; break;
      case "disconnected": level = "normal"; break;
      case "loaded":       level = "normal"; break;
      default:             level = "warn";   break;
    }

    if (state === "normal") {
      cad.disabled = false;
    } else {
      cad.disabled = true;
      xvpInit(0);
    }

    if (typeof(msg) !== "undefined") {
      sb.setAttribute("class", "noVNC_status_" + level);
      s.innerHTML = msg;
    }
  }

  function xvpInit(ver) {
    var xvpbuttons;
    xvpbuttons = document.querySelector("#noVNC_xvp_buttons");
    if (ver >= 1) {
      xvpbuttons.style.display = "inline";
    } else {
      xvpbuttons.style.display = "none";
    }
  }

  function getQueryVariable(variable)
  {
         var query = window.location.search.substring(1);
         var vars = query.split("&");
         for (var i=0;i<vars.length;i++) {
                 var pair = vars[i].split("=");
                 if(pair[0] == variable){return pair[1];}
         }
         return(false);
  }
  token = window.token;
  var URL = "";
  var proxy_host = window.location.hostname;
  var proxy_port = Config.vncProxyPort;
  var token = getQueryVariable("token");
  var password = getQueryVariable("password");

  var rfbConfig = password? { "credentials": { "password": password } } : {};

  if (window.location.protocol === "https:") {
    URL = "wss";
  } else {
    URL = "ws";
  }
  URL += "://" + window.location.hostname;
  URL += ":" + proxy_port;
  URL += "?host=" + proxy_host;
  URL += "&port=" + proxy_port;
  if(token){
    URL += "&token=" + token;
  }
  URL += "&encrypt=" + Config.vncWSS;

  document.querySelector("#sendCtrlAltDelButton").style.display = "inline";
  document.querySelector("#sendCtrlAltDelButton").onclick = sendCtrlAltDel;
  document.querySelector("#xvpShutdownButton").onclick = xvpShutdown;
  document.querySelector("#xvpRebootButton").onclick = xvpReboot;
  document.querySelector("#xvpResetButton").onclick = xvpReset;

  if ((!proxy_host) || (!proxy_port)) {
    updateState("failed",
        "Must specify host and port in URL");
    return;
  }
  try{
    rfb = new RFB(document.querySelector("#VNC_canvas"), URL, rfbConfig);
  }catch(err){
    console.log("error start NOVNC ", err);
  }
});


require(["console/vnc"]);

//# sourceMappingURL=vnc.js.map