/* ------------------------------------------------------------------------- *
 * Copyright 2002-2025, OpenNebula Project, OpenNebula Systems               *
 *                                                                           *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may   *
 * not use this file except in compliance with the License. You may obtain   *
 * a copy of the License at                                                  *
 *                                                                           *
 * http://www.apache.org/licenses/LICENSE-2.0                                *
 *                                                                           *
 * Unless required by applicable law or agreed to in writing, software       *
 * distributed under the License is distributed on an "AS IS" BASIS,         *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
 * See the License for the specific language governing permissions and       *
 * limitations under the License.                                            *
 * ------------------------------------------------------------------------- */
import { VrsTable } from '@modules/components/Tables'
import { ReactElement } from 'react'
import { Redirect, useParams } from 'react-router-dom'

import { TranslateProvider, VrTabs } from '@ComponentsModule'

/**
 * Displays the detail information about a Service Template.
 *
 * @returns {ReactElement} Service Template detail component.
 */
export function VirtualRouterDetail() {
  const { id } = useParams()

  if (Number.isNaN(+id)) {
    return <Redirect to="/" />
  }

  return (
    <TranslateProvider>
      <VrTabs id={id} singleActions={VrsTable.Actions} />
    </TranslateProvider>
  )
}
